/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.config;

import java.util.Properties;
import java.util.Set;
import org.wso2.carbon.identity.mgt.IdentityMgtConfigException;
import org.wso2.carbon.identity.mgt.config.Config;
import org.wso2.carbon.identity.mgt.config.ConfigManager;
import org.wso2.carbon.identity.mgt.config.ConfigReader;
import org.wso2.carbon.identity.mgt.config.ConfigWriter;

public class ConfigManagerImpl
implements ConfigManager {
    private ConfigReader reader;
    private ConfigWriter writer;
    private Config config;
    private String resourcePath;

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public void setReader(ConfigReader reader) {
        this.reader = reader;
    }

    @Override
    public void setWriter(ConfigWriter writer) {
        this.writer = writer;
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public Config loadConfig(int tenantId) throws IdentityMgtConfigException {
        Properties props = this.reader.read(tenantId, this.resourcePath);
        if (!props.isEmpty()) {
            Set<String> keySet = props.stringPropertyNames();
            for (String key : keySet) {
                this.config.setProperty(key, props.getProperty(key));
            }
        } else {
            return null;
        }
        return this.config;
    }

    @Override
    public void saveConfig(Config config, int tenantId) throws IdentityMgtConfigException {
        Properties props = config.getProperties();
        this.writer.write(tenantId, props, this.resourcePath);
    }
}

