/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.IdentityMgtConfigException;
import org.wso2.carbon.identity.mgt.config.Config;
import org.wso2.carbon.identity.mgt.config.ConfigManager;
import org.wso2.carbon.identity.mgt.config.ConfigManagerImpl;
import org.wso2.carbon.identity.mgt.config.ConfigType;
import org.wso2.carbon.identity.mgt.config.EmailNotificationConfig;
import org.wso2.carbon.identity.mgt.config.RegistryConfigReader;
import org.wso2.carbon.identity.mgt.config.RegistryConfigWriter;
import org.wso2.carbon.identity.mgt.config.StorageType;
import org.wso2.carbon.utils.CarbonUtils;

public class ConfigBuilder {
    private static final String EMAIL_TEMPLATE_PATH = "identity/config/emailTemplate";
    private static final Log log = LogFactory.getLog(ConfigBuilder.class);
    private static ConfigBuilder instance = null;
    private ConfigManager cm = new ConfigManagerImpl();

    private ConfigBuilder() {
    }

    public static ConfigBuilder getInstance() {
        if (instance == null) {
            instance = new ConfigBuilder();
        }
        return instance;
    }

    public Config loadConfiguration(ConfigType configType, StorageType stype, int tenantId) throws IdentityMgtConfigException {
        Config config = null;
        block0 : switch (stype) {
            case REGISTRY: {
                this.cm.setReader(new RegistryConfigReader());
                switch (configType) {
                    case EMAIL: {
                        this.cm.setConfig(new EmailNotificationConfig());
                        this.cm.setResourcePath(EMAIL_TEMPLATE_PATH);
                        config = this.cm.loadConfig(tenantId);
                        if (config != null) break block0;
                        config = this.loadEmailConfigFile();
                        break block0;
                    }
                    case CREDENTIALMGT: {
                        break block0;
                    }
                    default: {
                        throw new IdentityMgtConfigException("Configuration type not supported");
                    }
                }
            }
            case DB: {
                break;
            }
            case FILE: {
                break;
            }
            default: {
                throw new IdentityMgtConfigException("Configuration storage type not supported");
            }
        }
        return config;
    }

    public void saveConfiguration(StorageType stype, int tenantId, Config config) throws IdentityMgtConfigException {
        switch (stype) {
            case REGISTRY: {
                this.cm.setWriter(new RegistryConfigWriter());
                if (config instanceof EmailNotificationConfig) {
                    this.cm.setConfig(new EmailNotificationConfig());
                    this.cm.setResourcePath(EMAIL_TEMPLATE_PATH);
                    this.cm.saveConfig(config, tenantId);
                    break;
                }
                throw new IdentityMgtConfigException("Configuration type not supported");
            }
            case DB: {
                break;
            }
            case FILE: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config loadEmailConfigFile() {
        String confXml = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-admin-config.xml";
        EmailNotificationConfig emailConfig = new EmailNotificationConfig();
        File configfile = new File(confXml);
        if (!configfile.exists()) {
            log.warn((Object)("Email Configuration File is not present at: " + confXml));
        }
        XMLStreamReader parser = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configfile);
            parser = XMLInputFactory.newInstance().createXMLStreamReader(stream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator iterator = documentElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement omElement = (OMElement)iterator.next();
                String configType = omElement.getAttributeValue(new QName("type"));
                if (configType == null || configType.trim().length() <= 0) continue;
                emailConfig.setProperty(configType, this.loadEmailConfig(omElement));
            }
        }
        catch (FileNotFoundException | XMLStreamException e) {
            log.warn((Object)"Error while loading email config. using default configuration", (Throwable)e);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error while closing XML stream", (Throwable)e);
            }
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing input stream", (Throwable)e);
            }
        }
        return emailConfig;
    }

    private String loadEmailConfig(OMElement configElement) {
        StringBuilder emailTemplate = new StringBuilder();
        Iterator it = configElement.getChildElements();
        while (it.hasNext()) {
            OMElement element = (OMElement)it.next();
            if ("subject".equals(element.getLocalName())) {
                emailTemplate.append(element.getText());
                continue;
            }
            if ("body".equals(element.getLocalName())) {
                emailTemplate.append("|");
                emailTemplate.append(element.getText());
                continue;
            }
            if (!"footer".equals(element.getLocalName())) continue;
            emailTemplate.append("|");
            emailTemplate.append(element.getText());
        }
        return emailTemplate.toString();
    }
}

