/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.ChallengeQuestionProcessor;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.NotificationSender;
import org.wso2.carbon.identity.mgt.NotificationSendingModule;
import org.wso2.carbon.identity.mgt.beans.VerificationBean;
import org.wso2.carbon.identity.mgt.config.Config;
import org.wso2.carbon.identity.mgt.config.ConfigBuilder;
import org.wso2.carbon.identity.mgt.config.ConfigType;
import org.wso2.carbon.identity.mgt.config.StorageType;
import org.wso2.carbon.identity.mgt.dto.NotificationDataDTO;
import org.wso2.carbon.identity.mgt.dto.UserDTO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDTO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDataDO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.mail.Notification;
import org.wso2.carbon.identity.mgt.mail.NotificationBuilder;
import org.wso2.carbon.identity.mgt.mail.NotificationData;
import org.wso2.carbon.identity.mgt.mail.TransportHeader;
import org.wso2.carbon.identity.mgt.store.RegistryRecoveryDataStore;
import org.wso2.carbon.identity.mgt.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.mgt.util.Utils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class RecoveryProcessor {
    private static final Log log = LogFactory.getLog(RecoveryProcessor.class);
    private static final String USER_STORE_DOMAIN = "userstore-domain";
    private static final String USER_NAME = "user-name";
    private static final String TENANT_DOMAIN = "tenant-domain";
    private static final String FIRST_NAME = "first-name";
    private static final String CONFIRMATION_CODE = "confirmation-code";
    private static final String TEMPORARY_PASSWORD = "temporary-password";
    private static final String USE_HASHED_USERNAME_PROPERTY = "UserInfoRecovery.UseHashedUserNames";
    private static final String USERNAME_HASH_ALG_PROPERTY = "UserInfoRecovery.UsernameHashAlg";
    private final String REG_DELIMITER = "___";
    private Map<String, NotificationSendingModule> modules = new HashMap<String, NotificationSendingModule>();
    private NotificationSendingModule defaultModule;
    private UserRecoveryDataStore dataStore;
    private NotificationSender notificationSender;
    private ChallengeQuestionProcessor questionProcessor;

    public RecoveryProcessor() {
        List<NotificationSendingModule> notificationSendingModules = IdentityMgtConfig.getInstance().getNotificationSendingModules();
        this.defaultModule = notificationSendingModules.get(0);
        for (NotificationSendingModule module : notificationSendingModules) {
            this.modules.put(module.getNotificationType(), module);
        }
        this.dataStore = IdentityMgtConfig.getInstance().getRecoveryDataStore();
        this.notificationSender = new NotificationSender();
        this.questionProcessor = new ChallengeQuestionProcessor();
    }

    public NotificationDataDTO recoverWithNotification(UserRecoveryDTO recoveryDTO) throws IdentityException {
        Map transportHeaderMap;
        String userName;
        String userStore;
        int tenantId;
        String domainName;
        String userId;
        boolean persistData;
        NotificationSendingModule module;
        String confirmationKey;
        String secretKey;
        block39: {
            secretKey = null;
            confirmationKey = null;
            module = null;
            persistData = true;
            userId = recoveryDTO.getUserId();
            domainName = recoveryDTO.getTenantDomain();
            tenantId = recoveryDTO.getTenantId();
            userStore = IdentityUtil.extractDomainFromName((String)userId);
            userName = UserCoreUtil.removeDomainFromName((String)userId);
            TenantManager tenantManager = IdentityMgtServiceComponent.getRealmService().getTenantManager();
            try {
                Tenant tenant = tenantManager.getTenant(tenantId);
                if (tenant != null) {
                    domainName = tenant.getDomain();
                }
            }
            catch (UserStoreException e) {
                if (!log.isDebugEnabled()) break block39;
                log.debug((Object)("No Tenant domain for tenant id " + tenantId), (Throwable)e);
            }
        }
        NotificationDataDTO notificationData = new NotificationDataDTO();
        if (MessageContext.getCurrentMessageContext() != null && MessageContext.getCurrentMessageContext().getProperty("TRANSPORT_HEADERS") != null && MapUtils.isNotEmpty((Map)(transportHeaderMap = (Map)MessageContext.getCurrentMessageContext().getProperty("TRANSPORT_HEADERS")))) {
            TransportHeader[] transportHeadersArray = new TransportHeader[transportHeaderMap.size()];
            int i = 0;
            for (Map.Entry entry : transportHeaderMap.entrySet()) {
                TransportHeader transportHeader = new TransportHeader();
                transportHeader.setHeaderName((String)entry.getKey());
                transportHeader.setHeaderValue((String)entry.getValue());
                transportHeadersArray[i] = transportHeader;
                ++i;
            }
            notificationData.setTransportHeaders(transportHeadersArray);
        }
        String internalCode = null;
        String type = recoveryDTO.getNotificationType();
        if (type != null) {
            module = this.modules.get(type);
        }
        if (module == null) {
            module = this.defaultModule;
        }
        NotificationData emailNotificationData = new NotificationData();
        String emailTemplate = null;
        String notificationAddress = Utils.getEmailAddressForUser(userId, tenantId);
        String firstName = Utils.getClaimFromUserStoreManager(userId, tenantId, "http://wso2.org/claims/givenname");
        emailNotificationData.setTagData(FIRST_NAME, firstName);
        emailNotificationData.setTagData(USER_STORE_DOMAIN, userStore);
        emailNotificationData.setTagData(USER_NAME, userName);
        emailNotificationData.setTagData(TENANT_DOMAIN, domainName);
        if (notificationAddress == null || notificationAddress.trim().length() < 0) {
            throw IdentityException.error((String)("Notification sending failure. Notification address is not defined for user : " + userId));
        }
        emailNotificationData.setSendTo(notificationAddress);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building notification with data - First name: " + firstName + " User name: " + userId + " Send To: " + notificationAddress));
        }
        Config config = null;
        ConfigBuilder configBuilder = ConfigBuilder.getInstance();
        try {
            config = configBuilder.loadConfiguration(ConfigType.EMAIL, StorageType.REGISTRY, tenantId);
        }
        catch (Exception e1) {
            throw IdentityException.error((String)("Error while loading email templates for user : " + userId), (Throwable)e1);
        }
        if (recoveryDTO.getNotification() != null) {
            emailTemplate = config.getProperty(recoveryDTO.getNotification().trim());
            String notification = recoveryDTO.getNotification().trim();
            notificationData.setNotification(notification);
            if ("passwordReset".equals(notification) || "resendNotification".equals(notification)) {
                internalCode = this.generateUserCode(2, userId);
                try {
                    confirmationKey = this.getUserExternalCodeStr(internalCode);
                }
                catch (Exception e) {
                    throw IdentityException.error((String)"Error while getting user's external code string.", (Throwable)e);
                }
                secretKey = UUIDGenerator.generateUUID();
                emailNotificationData.setTagData(CONFIRMATION_CODE, confirmationKey);
                emailTemplate = config.getProperty(notification);
            } else if ("accountConfirmation".equals(notification)) {
                confirmationKey = UUIDGenerator.generateUUID();
                secretKey = UUIDGenerator.generateUUID();
                emailNotificationData.setTagData(CONFIRMATION_CODE, confirmationKey);
                emailTemplate = config.getProperty("accountConfirmation");
            } else if ("temporaryPassword".equals(notification)) {
                String temporaryPassword = recoveryDTO.getTemporaryPassword();
                if (temporaryPassword == null || temporaryPassword.trim().length() < 1) {
                    char[] chars = IdentityMgtConfig.getInstance().getPasswordGenerator().generatePassword();
                    temporaryPassword = new String(chars);
                }
                Utils.updatePassword(userId, tenantId, temporaryPassword);
                emailNotificationData.setTagData(TEMPORARY_PASSWORD, temporaryPassword);
                emailTemplate = config.getProperty("temporaryPassword");
                persistData = false;
            } else if ("accountUnLock".equals(notification)) {
                emailTemplate = config.getProperty("accountUnLock");
                persistData = false;
            } else if ("accountEnable".equals(notification)) {
                emailTemplate = config.getProperty("accountEnable");
                persistData = false;
            } else if ("accountDisable".equals(notification)) {
                emailTemplate = config.getProperty("accountDisable");
                persistData = false;
            } else if ("accountIdRecovery".equals(notification)) {
                emailTemplate = config.getProperty("accountIdRecovery");
                persistData = false;
            } else if ("askPassword".equals(notification)) {
                if (firstName == null || firstName.isEmpty()) {
                    emailNotificationData.setTagData(FIRST_NAME, userId);
                }
                internalCode = this.generateUserCode(2, userId);
                try {
                    confirmationKey = this.getUserExternalCodeStr(internalCode);
                }
                catch (Exception e) {
                    throw IdentityException.error((String)"Error while with recovering with password.", (Throwable)e);
                }
                secretKey = UUIDGenerator.generateUUID();
                emailNotificationData.setTagData(CONFIRMATION_CODE, confirmationKey);
                emailTemplate = config.getProperty("askPassword");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notification type: " + notification));
            }
        }
        Notification emailNotification = null;
        try {
            emailNotification = NotificationBuilder.createNotification("EMAIL", emailTemplate, emailNotificationData);
        }
        catch (Exception e) {
            throw IdentityException.error((String)("Error when creating notification for user : " + userId), (Throwable)e);
        }
        notificationData.setNotificationAddress(notificationAddress);
        notificationData.setUserId(userId);
        notificationData.setDomainName(domainName);
        notificationData.setNotificationType(recoveryDTO.getNotificationType());
        if (persistData) {
            UserRecoveryDataDO recoveryDataDO = new UserRecoveryDataDO(userId, tenantId, internalCode, secretKey);
            this.dataStore.invalidate(userId, tenantId);
            this.dataStore.store(recoveryDataDO);
        }
        if (IdentityMgtConfig.getInstance().isNotificationInternallyManaged()) {
            module.setNotificationData(notificationData);
            module.setNotification(emailNotification);
            this.notificationSender.sendNotification(module);
            notificationData.setNotificationSent(true);
        } else {
            notificationData.setNotificationSent(false);
            notificationData.setNotificationCode(confirmationKey);
        }
        return notificationData;
    }

    public VerificationBean verifyConfirmationKey(String confirmationKey) {
        UserRecoveryDataDO dataDO = null;
        try {
            dataDO = this.dataStore.load(confirmationKey);
            this.dataStore.invalidate(dataDO);
        }
        catch (IdentityException e) {
            log.error((Object)"Invalid User for confirmation code", (Throwable)e);
            return new VerificationBean("18003");
        }
        if (dataDO == null) {
            return new VerificationBean("18001");
        }
        if (!dataDO.isValid()) {
            return new VerificationBean("18002");
        }
        return new VerificationBean(true);
    }

    public VerificationBean verifyConfirmationCode(int sequence, String username, String code) throws IdentityException {
        UserRecoveryDataDO dataDO = null;
        String internalCode = this.getUserInternalCodeStr(sequence, username, code);
        try {
            dataDO = this.dataStore.load(internalCode);
            if (dataDO != null && sequence != 2 && sequence != 40) {
                if (this.dataStore instanceof RegistryRecoveryDataStore) {
                    this.dataStore.invalidate(internalCode);
                } else {
                    this.dataStore.invalidate(dataDO);
                }
            }
        }
        catch (IdentityException e) {
            throw IdentityException.error((String)("Error loading recovery data for user : " + username), (Throwable)e);
        }
        if (dataDO == null && (sequence == 30 || sequence == 20)) {
            return new VerificationBean(false);
        }
        if (dataDO == null) {
            throw IdentityException.error((String)"Invalid confirmation code");
        }
        if (!dataDO.isValid()) {
            throw IdentityException.error((String)"Expired code");
        }
        return new VerificationBean(true);
    }

    public VerificationBean updateConfirmationCode(int sequence, String username, int tenantId) throws IdentityException {
        String confirmationKey = this.generateUserCode(sequence, username);
        String secretKey = UUIDGenerator.generateUUID();
        UserRecoveryDataDO recoveryDataDO = new UserRecoveryDataDO(username, tenantId, confirmationKey, secretKey);
        if (sequence != 3 && sequence != 30) {
            this.dataStore.invalidate(username, tenantId);
        }
        this.dataStore.store(recoveryDataDO);
        String externalCode = null;
        try {
            externalCode = this.getUserExternalCodeStr(confirmationKey);
        }
        catch (Exception e) {
            throw IdentityException.error((String)("Error occurred while getting external code for user : " + username), (Throwable)e);
        }
        return new VerificationBean(username, externalCode);
    }

    public VerificationBean verifyUserForRecovery(int sequence, UserDTO userDTO) {
        String userId = userDTO.getUserId();
        int tenantId = userDTO.getTenantId();
        boolean success = false;
        VerificationBean bean = null;
        try {
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            if (userStoreManager.isExistingUser(userId)) {
                if (IdentityMgtConfig.getInstance().isAuthPolicyAccountLockCheck()) {
                    String accountLock = Utils.getClaimFromUserStoreManager(userId, tenantId, "http://wso2.org/claims/identity/accountLocked");
                    if (!Boolean.parseBoolean(accountLock)) {
                        success = true;
                    }
                } else if (IdentityMgtConfig.getInstance().isAuthPolicyAccountDisableCheck()) {
                    String accountDisable = Utils.getClaimFromUserStoreManager(userId, tenantId, "http://wso2.org/claims/identity/accountDisabled");
                    if (!Boolean.parseBoolean(accountDisable)) {
                        success = true;
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Account is disabled. Can not allow to recover.");
                        }
                        bean = new VerificationBean("17003");
                    }
                } else {
                    success = true;
                }
            } else {
                log.error((Object)("User with user name : " + userId + " does not exists in tenant domain : " + userDTO.getTenantDomain()));
                bean = new VerificationBean("18003 User does not exists");
            }
            if (success) {
                String internalCode = this.generateUserCode(sequence, userId);
                String key = UUID.randomUUID().toString();
                UserRecoveryDataDO dataDO = new UserRecoveryDataDO(userId, tenantId, internalCode, key);
                if (sequence != 3) {
                    this.dataStore.invalidate(userId, tenantId);
                }
                this.dataStore.store(dataDO);
                log.info((Object)("User verification successful for user : " + userId + " from tenant domain :" + userDTO.getTenantDomain()));
                bean = new VerificationBean(userId, this.getUserExternalCodeStr(internalCode));
            }
        }
        catch (Exception e) {
            String errorMessage = "Error verifying user : " + userId;
            log.error((Object)errorMessage, (Throwable)e);
            bean = new VerificationBean("18013 " + errorMessage);
        }
        if (bean == null) {
            bean = new VerificationBean("18013");
        }
        return bean;
    }

    public void createConfirmationCode(UserDTO userDTO, String code) throws IdentityException {
        String key = UUID.randomUUID().toString();
        UserRecoveryDataDO dataDO = new UserRecoveryDataDO(userDTO.getUserId(), userDTO.getTenantId(), key, code);
        this.dataStore.invalidate(userDTO.getUserId(), userDTO.getTenantId());
        this.dataStore.store(dataDO);
    }

    public ChallengeQuestionProcessor getQuestionProcessor() {
        return this.questionProcessor;
    }

    public NotificationDataDTO notifyWithEmail(UserRecoveryDTO notificationBean) throws IdentityException {
        String type;
        Map transportHeaderMap;
        String confirmationKey = null;
        NotificationSendingModule module = null;
        String userId = notificationBean.getUserId();
        String domainName = notificationBean.getTenantDomain();
        int tenantId = notificationBean.getTenantId();
        confirmationKey = notificationBean.getConfirmationCode();
        String userStore = IdentityUtil.extractDomainFromName((String)userId);
        String userName = UserCoreUtil.removeDomainFromName((String)userId);
        NotificationDataDTO notificationData = new NotificationDataDTO();
        if (MessageContext.getCurrentMessageContext() != null && MessageContext.getCurrentMessageContext().getProperty("TRANSPORT_HEADERS") != null && MapUtils.isNotEmpty((Map)(transportHeaderMap = (Map)MessageContext.getCurrentMessageContext().getProperty("TRANSPORT_HEADERS")))) {
            TransportHeader[] transportHeadersArray = new TransportHeader[transportHeaderMap.size()];
            int i = 0;
            for (Map.Entry entry : transportHeaderMap.entrySet()) {
                TransportHeader transportHeader = new TransportHeader();
                transportHeader.setHeaderName((String)entry.getKey());
                transportHeader.setHeaderValue((String)entry.getValue());
                transportHeadersArray[i] = transportHeader;
                ++i;
            }
            notificationData.setTransportHeaders(transportHeadersArray);
        }
        if ((type = notificationBean.getNotificationType()) != null) {
            module = this.modules.get(type);
        }
        if (module == null) {
            module = this.defaultModule;
        }
        NotificationData emailNotificationData = new NotificationData();
        String emailTemplate = null;
        String notificationAddress = module.getNotificationAddress(userId, tenantId);
        if (notificationAddress == null || notificationAddress.trim().length() < 0) {
            log.warn((Object)("Notification address is not defined for user " + userId));
        }
        String firstName = Utils.getClaimFromUserStoreManager(userId, tenantId, "http://wso2.org/claims/givenname");
        emailNotificationData.setTagData(FIRST_NAME, firstName);
        emailNotificationData.setTagData(USER_STORE_DOMAIN, userStore);
        emailNotificationData.setTagData(USER_NAME, userName);
        emailNotificationData.setTagData(TENANT_DOMAIN, domainName);
        emailNotificationData.setSendTo(notificationAddress);
        Config config = null;
        ConfigBuilder configBuilder = ConfigBuilder.getInstance();
        try {
            config = configBuilder.loadConfiguration(ConfigType.EMAIL, StorageType.REGISTRY, tenantId);
        }
        catch (Exception e1) {
            throw IdentityException.error((String)("Error occurred while loading email templates for user : " + userId), (Throwable)e1);
        }
        if (notificationBean.getNotification() != null) {
            emailTemplate = config.getProperty(notificationBean.getNotification().trim());
            String notification = notificationBean.getNotification().trim();
            notificationData.setNotification(notification);
            if ("passwordReset".equals(notification)) {
                notificationData.setNotificationCode(confirmationKey);
                emailNotificationData.setTagData(CONFIRMATION_CODE, confirmationKey);
                emailTemplate = config.getProperty("passwordReset");
            } else if ("accountConfirmation".equals(notification)) {
                notificationData.setNotificationCode(confirmationKey);
                emailNotificationData.setTagData(CONFIRMATION_CODE, confirmationKey);
                emailTemplate = config.getProperty("accountConfirmation");
            } else if ("temporaryPassword".equals(notification)) {
                String temporaryPassword = notificationBean.getTemporaryPassword();
                notificationData.setNotificationCode(temporaryPassword);
                emailNotificationData.setTagData(TEMPORARY_PASSWORD, temporaryPassword);
                emailTemplate = config.getProperty("temporaryPassword");
            } else if ("accountUnLock".equals(notification)) {
                emailTemplate = config.getProperty("accountUnLock");
                notificationData.setNotificationCode(userId);
            } else if ("accountIdRecovery".equals(notification)) {
                emailTemplate = config.getProperty("accountIdRecovery");
                notificationData.setNotificationCode(userId);
            } else if ("askPassword".equals(notification)) {
                notificationData.setNotificationCode(confirmationKey);
                emailTemplate = config.getProperty("askPassword");
                emailNotificationData.setTagData(CONFIRMATION_CODE, confirmationKey);
            } else if ("accountEnable".equals(notification)) {
                emailTemplate = config.getProperty("accountEnable");
                notificationData.setNotificationCode(userId);
            } else if ("accountDisable".equals(notification)) {
                emailTemplate = config.getProperty("accountDisable");
                notificationData.setNotificationCode(userId);
            }
        }
        Notification emailNotification = null;
        try {
            emailNotification = NotificationBuilder.createNotification("EMAIL", emailTemplate, emailNotificationData);
        }
        catch (Exception e) {
            throw IdentityException.error((String)("Error occurred while creating notification from email template : " + emailTemplate), (Throwable)e);
        }
        notificationData.setNotificationAddress(notificationAddress);
        notificationData.setUserId(userId);
        notificationData.setDomainName(domainName);
        notificationData.setNotificationType(notificationBean.getNotificationType());
        if (IdentityMgtConfig.getInstance().isNotificationInternallyManaged()) {
            module.setNotificationData(notificationData);
            module.setNotification(emailNotification);
            this.notificationSender.sendNotification(module);
            notificationData.setNotificationSent(true);
        } else {
            notificationData.setNotificationSent(false);
            notificationData.setNotificationCode(confirmationKey);
        }
        return notificationData;
    }

    private String generateUserCode(int sequence, String username) throws IdentityException {
        String genCode = null;
        if (username != null) {
            StringBuilder userCode = new StringBuilder();
            userCode.append(sequence);
            userCode.append("___");
            String useHashedUserName = IdentityMgtConfig.getInstance().getProperty(USE_HASHED_USERNAME_PROPERTY);
            if (Boolean.parseBoolean(useHashedUserName)) {
                String hashAlg = IdentityMgtConfig.getInstance().getProperty(USERNAME_HASH_ALG_PROPERTY);
                try {
                    userCode.append(this.hashString(username, hashAlg));
                }
                catch (NoSuchAlgorithmException e) {
                    throw IdentityException.error((String)("Invalid hash algorithm " + hashAlg), (Throwable)e);
                }
            } else {
                userCode.append(this.stripSpecialChars(username));
            }
            userCode.append("___");
            userCode.append(UUID.randomUUID().toString());
            genCode = userCode.toString();
        }
        return genCode;
    }

    private String getUserInternalCodeStr(int sequence, String username, String code) throws IdentityException {
        String searchCode = null;
        if (username != null && code != null) {
            StringBuilder userCode = new StringBuilder();
            userCode.append(sequence);
            userCode.append("___");
            String useHashedUserName = IdentityMgtConfig.getInstance().getProperty(USE_HASHED_USERNAME_PROPERTY);
            if (Boolean.parseBoolean(useHashedUserName)) {
                String hashAlg = IdentityMgtConfig.getInstance().getProperty(USERNAME_HASH_ALG_PROPERTY);
                try {
                    userCode.append(this.hashString(username, hashAlg));
                }
                catch (NoSuchAlgorithmException e) {
                    throw IdentityException.error((String)("Invalid hash algorithm " + hashAlg), (Throwable)e);
                }
            } else {
                userCode.append(this.stripSpecialChars(username));
            }
            userCode.append("___");
            userCode.append(code);
            searchCode = userCode.toString();
        }
        return searchCode;
    }

    private String getUserExternalCodeStr(String internalCode) throws IdentityMgtServiceException {
        String[] codeParts;
        String userCode = null;
        if (internalCode != null) {
            codeParts = internalCode.split("_{3}", 3);
            if (codeParts.length != 3) {
                throw new IdentityMgtServiceException("Invalid code");
            }
        } else {
            throw new IdentityMgtServiceException("Code not found");
        }
        userCode = codeParts[2];
        return userCode;
    }

    private String stripSpecialChars(String input) {
        StringBuilder output = new StringBuilder();
        if (input != null) {
            char[] inputArr;
            block3: for (char c : inputArr = input.toCharArray()) {
                switch (c) {
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '$': 
                    case '%': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        output.append('z');
                        continue block3;
                    }
                    default: {
                        output.append(c);
                    }
                }
            }
        }
        return output.toString();
    }

    private String hashString(String userName, String alg) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(alg);
        byte[] in = messageDigest.digest(userName.getBytes());
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }
}

