/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.NotificationSendingModule;

public class NotificationSender {
    private static ExecutorService threadPool = null;
    NotificationSendingModule module;
    private static final Log log = LogFactory.getLog(NotificationSender.class);

    public void sendNotification(NotificationSendingModule module) {
        threadPool.submit(module);
    }

    public NotificationSendingModule getModule() {
        return this.module;
    }

    static {
        IdentityMgtConfig identityMgtConfig = IdentityMgtConfig.getInstance();
        if (identityMgtConfig != null) {
            int threadPoolSize = identityMgtConfig.getNotificationSendingThreadPoolSize();
            int notificationSendingTimeout = identityMgtConfig.getNotificationSendingTimeout();
            if (threadPoolSize <= 0) {
                threadPoolSize = 5;
            }
            threadPool = Executors.newFixedThreadPool(threadPoolSize);
            if (notificationSendingTimeout > 0) {
                try {
                    threadPool.awaitTermination(notificationSendingTimeout * 1000, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Interruption occurred while waiting for termination", (Throwable)e);
                }
            }
        }
    }
}

