/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.NotificationSender;
import org.wso2.carbon.identity.mgt.NotificationSendingModule;
import org.wso2.carbon.identity.mgt.RecoveryProcessor;
import org.wso2.carbon.identity.mgt.beans.UserIdentityMgtBean;
import org.wso2.carbon.identity.mgt.config.Config;
import org.wso2.carbon.identity.mgt.config.ConfigBuilder;
import org.wso2.carbon.identity.mgt.config.ConfigType;
import org.wso2.carbon.identity.mgt.config.StorageType;
import org.wso2.carbon.identity.mgt.constants.IdentityMgtConstants;
import org.wso2.carbon.identity.mgt.dto.NotificationDataDTO;
import org.wso2.carbon.identity.mgt.dto.UserDTO;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimsDO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDTO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDataDO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.mail.Notification;
import org.wso2.carbon.identity.mgt.mail.NotificationBuilder;
import org.wso2.carbon.identity.mgt.mail.NotificationData;
import org.wso2.carbon.identity.mgt.mail.TransportHeader;
import org.wso2.carbon.identity.mgt.policy.PolicyRegistry;
import org.wso2.carbon.identity.mgt.policy.PolicyViolationException;
import org.wso2.carbon.identity.mgt.store.UserIdentityDataStore;
import org.wso2.carbon.identity.mgt.util.UserIdentityManagementUtil;
import org.wso2.carbon.identity.mgt.util.Utils;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class IdentityMgtEventListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(IdentityMgtEventListener.class);
    private static final String EMPTY_PASSWORD_USED = "EmptyPasswordUsed";
    private static final String USER_IDENTITY_DO = "UserIdentityDO";
    private static final String EMAIL_NOTIFICATION_TYPE = "EMAIL";
    private static final String UNLOCK_ADMIN_SYS_PROP = "unlockAdmin";
    private static final String PASSWORD_INVALID = "PasswordInvalid";
    PolicyRegistry policyRegistry = null;
    private UserIdentityDataStore module;
    private IdentityMgtConfig identityMgtConfig = IdentityMgtConfig.getInstance();
    private static final String DO_PRE_AUTHENTICATE = "doPreAuthenticate";
    private static final String DO_POST_AUTHENTICATE = "doPostAuthenticate";
    private static final String DO_POST_ADD_USER = "doPostAddUser";
    private static final String DO_PRE_SET_USER_CLAIM_VALUES = "doPreSetUserClaimValues";
    private static final String DO_PRE_UPDATE_CREDENTIAL_BY_ADMIN = "doPreUpdateCredentialByAdmin";
    private static final String DO_PRE_UPDATE_CREDENTIAL = "doPreUpdateCredential";
    private static final String DO_POST_UPDATE_CREDENTIAL = "doPostUpdateCredential";
    private static final String ASK_PASSWORD_FEATURE_IS_DISABLED = "Ask Password Feature is disabled";
    private static final String INVALID_OPERATION = "InvalidOperation";

    public IdentityMgtEventListener() {
        this.policyRegistry = this.identityMgtConfig.getPolicyRegistry();
        this.module = IdentityMgtConfig.getInstance().getIdentityDataStore();
        String isAdminUnlockSysProp = System.getProperty(UNLOCK_ADMIN_SYS_PROP);
        if (StringUtils.isNotBlank((String)isAdminUnlockSysProp) && Boolean.parseBoolean(isAdminUnlockSysProp)) {
            log.info((Object)"unlockAdmin system property is defined. Hence unlocking admin account");
            this.unlockAdmin();
        }
    }

    private void unlockAdmin() {
        String adminUserName = IdentityMgtServiceComponent.getRealmService().getBootstrapRealmConfiguration().getAdminUserName();
        try {
            if (this.isEnable()) {
                org.wso2.carbon.user.core.UserStoreManager userStoreMng = IdentityMgtServiceComponent.getRealmService().getBootstrapRealm().getUserStoreManager();
                HashMap<String, String> claimMap = new HashMap<String, String>();
                claimMap.put("http://wso2.org/claims/identity/accountLocked", Boolean.toString(false));
                claimMap.put("http://wso2.org/claims/identity/accountDisabled", Boolean.toString(false));
                this.doPreSetUserClaimValues(adminUserName, claimMap, null, userStoreMng);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while unlocking admin account", (Throwable)e);
        }
    }

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPreAuthenticate(String userName, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        try {
            if (!((Map)IdentityUtil.threadLocalProperties.get()).containsKey(DO_PRE_AUTHENTICATE)) {
                ((Map)IdentityUtil.threadLocalProperties.get()).put(DO_PRE_AUTHENTICATE, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Pre authenticator is called in IdentityMgtEventListener");
                }
                IdentityUtil.clearIdentityErrorMsg();
                IdentityMgtConfig config = IdentityMgtConfig.getInstance();
                if (!config.isEnableAuthPolicy()) {
                    boolean bl = true;
                    return bl;
                }
                String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
                String usernameWithDomain = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
                boolean isUserExistInCurrentDomain = userStoreManager.isExistingUser(usernameWithDomain);
                if (!isUserExistInCurrentDomain) {
                    IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17001");
                    IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Username :" + userName + "does not exists in the system, ErrorCode :" + "17001"));
                    }
                    if (config.isAuthPolicyAccountExistCheck()) {
                        throw new UserStoreException("17001");
                    }
                } else {
                    UserIdentityClaimsDO userIdentityDTO = this.module.load(userName, (UserStoreManager)userStoreManager);
                    if (userIdentityDTO == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (userIdentityDTO.getIsAccountDisabled().booleanValue()) {
                        IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext(" User account is disabled");
                        IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                        String errorMsg = "User account is disabled for user : " + userName;
                        log.warn((Object)errorMsg);
                        throw new UserStoreException("17004 " + errorMsg);
                    }
                    if (userIdentityDTO.isAccountLocked()) {
                        if (userIdentityDTO.getUnlockTime() != 0L && System.currentTimeMillis() >= userIdentityDTO.getUnlockTime()) {
                            userIdentityDTO.getUserDataMap().put("http://wso2.org/claims/identity/lockedReason", "");
                            userIdentityDTO.setAccountLock(false);
                            userIdentityDTO.setUnlockTime(0L);
                            try {
                                this.module.store(userIdentityDTO, (UserStoreManager)userStoreManager);
                            }
                            catch (IdentityException e) {
                                throw new UserStoreException("Error while saving user store data for user : " + userName, (Throwable)e);
                            }
                        } else {
                            IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17003:" + userIdentityDTO.getUserDataMap().get("http://wso2.org/claims/identity/lockedReason"), userIdentityDTO.getFailAttempts(), config.getAuthPolicyMaxLoginAttempts());
                            if (IdentityMgtConstants.LockedReason.MAX_ATTEMTS_EXCEEDED.toString().equals(userIdentityDTO.getUserDataMap().get("http://wso2.org/claims/identity/lockedReason"))) {
                                customErrorMessageContext.setFailedLoginAttempts(config.getAuthPolicyMaxLoginAttempts());
                            }
                            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                            String errorMsg = "User account is locked for user : " + userName + ". cannot login until the account is unlocked ";
                            log.warn((Object)errorMsg);
                            throw new UserStoreException("17003 " + errorMsg);
                        }
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(DO_PRE_AUTHENTICATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPostAuthenticate(String userName, boolean authenticated, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        ((Map)IdentityUtil.threadLocalProperties.get()).remove("UserAccountState");
        String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        String usernameWithDomain = IdentityUtil.addDomainToName((String)userName, (String)domainName);
        boolean isUserExistInCurrentDomain = userStoreManager.isExistingUser(usernameWithDomain);
        if (authenticated && isUserExistInCurrentDomain && isUserExistInCurrentDomain) {
            UserIdentityClaimsDO userIdentityDTO = this.module.load(userName, (UserStoreManager)userStoreManager);
            userIdentityDTO.setLastLogonTime(System.currentTimeMillis());
            try {
                this.module.store(userIdentityDTO, (UserStoreManager)userStoreManager);
            }
            catch (IdentityException e) {
                throw new UserStoreException(String.format("Error while saving user store data : %s for user : %s.", "http://wso2.org/claims/identity/lastLogonTime", userName), (Throwable)e);
            }
        }
        try {
            if (!((Map)IdentityUtil.threadLocalProperties.get()).containsKey(DO_POST_AUTHENTICATE)) {
                IdentityMgtConfig config;
                ((Map)IdentityUtil.threadLocalProperties.get()).put(DO_POST_AUTHENTICATE, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Post authenticator is called in IdentityMgtEventListener");
                }
                if (!(config = IdentityMgtConfig.getInstance()).isEnableAuthPolicy()) {
                    boolean e = true;
                    return e;
                }
                UserIdentityClaimsDO userIdentityDTO = this.module.load(userName, (UserStoreManager)userStoreManager);
                if (userIdentityDTO == null) {
                    userIdentityDTO = new UserIdentityClaimsDO(userName);
                    userIdentityDTO.setTenantId(userStoreManager.getTenantId());
                }
                boolean userOTPEnabled = userIdentityDTO.getOneTimeLogin();
                if (authenticated && config.isAuthPolicyOneTimePasswordCheck() && !userStoreManager.isReadOnly() && userOTPEnabled) {
                    String password = new String(UserIdentityManagementUtil.generateTemporaryPassword());
                    userStoreManager.updateCredentialByAdmin(userName, (Object)password);
                    String email = userStoreManager.getUserClaimValue(userName, "http://wso2.org/claims/emailaddress", null);
                    if (StringUtils.isBlank((String)email)) {
                        throw new UserStoreException("No user email provided for user : " + userName);
                    }
                    List<NotificationSendingModule> notificationModules = config.getNotificationSendingModules();
                    if (notificationModules != null) {
                        Map transportHeaderMap;
                        NotificationDataDTO notificationData = new NotificationDataDTO();
                        if (MessageContext.getCurrentMessageContext() != null && MessageContext.getCurrentMessageContext().getProperty("TRANSPORT_HEADERS") != null && MapUtils.isNotEmpty((Map)(transportHeaderMap = (Map)MessageContext.getCurrentMessageContext().getProperty("TRANSPORT_HEADERS")))) {
                            TransportHeader[] transportHeadersArray = new TransportHeader[transportHeaderMap.size()];
                            int i = 0;
                            for (Map.Entry entry : transportHeaderMap.entrySet()) {
                                TransportHeader transportHeader = new TransportHeader();
                                transportHeader.setHeaderName((String)entry.getKey());
                                transportHeader.setHeaderValue((String)entry.getValue());
                                transportHeadersArray[i] = transportHeader;
                                ++i;
                            }
                            notificationData.setTransportHeaders(transportHeadersArray);
                        }
                        NotificationData emailNotificationData = new NotificationData();
                        String emailTemplate = null;
                        int tenantId = userStoreManager.getTenantId();
                        String firstName = null;
                        String userStoreDomain = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
                        String domainSpecificUserName = UserCoreUtil.addDomainToName((String)userName, (String)userStoreDomain);
                        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId());
                        try {
                            firstName = Utils.getClaimFromUserStoreManager(domainSpecificUserName, tenantId, "http://wso2.org/claims/givenname");
                        }
                        catch (IdentityException e2) {
                            throw new UserStoreException("Could not load user given name", (Throwable)e2);
                        }
                        emailNotificationData.setTagData("first-name", firstName);
                        emailNotificationData.setTagData("user-name", userName);
                        emailNotificationData.setTagData("otp-password", password);
                        emailNotificationData.setTagData("userstore-domain", userStoreDomain);
                        emailNotificationData.setTagData("tenant-domain", tenantDomain);
                        emailNotificationData.setSendTo(email);
                        Config emailConfig = null;
                        ConfigBuilder configBuilder = ConfigBuilder.getInstance();
                        try {
                            emailConfig = configBuilder.loadConfiguration(ConfigType.EMAIL, StorageType.REGISTRY, tenantId);
                        }
                        catch (Exception e1) {
                            throw new UserStoreException("Could not load the email template configuration for user : " + userName, (Throwable)e1);
                        }
                        emailTemplate = emailConfig.getProperty("otp");
                        Notification emailNotification = null;
                        try {
                            emailNotification = NotificationBuilder.createNotification(EMAIL_NOTIFICATION_TYPE, emailTemplate, emailNotificationData);
                        }
                        catch (Exception e) {
                            throw new UserStoreException("Could not create the email notification for template: " + emailTemplate, (Throwable)e);
                        }
                        NotificationSender sender = new NotificationSender();
                        for (NotificationSendingModule notificationSendingModule : notificationModules) {
                            if (!IdentityMgtConfig.getInstance().isNotificationInternallyManaged()) continue;
                            notificationSendingModule.setNotificationData(notificationData);
                            notificationSendingModule.setNotification(emailNotification);
                            sender.sendNotification(notificationSendingModule);
                            notificationData.setNotificationSent(true);
                        }
                    } else {
                        throw new UserStoreException("No notification modules configured");
                    }
                }
                if (!authenticated || !config.isAuthPolicyExpirePasswordCheck() || userOTPEnabled || !userStoreManager.isReadOnly()) {
                    // empty if block
                }
                if (!authenticated && config.isAuthPolicyAccountLockOnFailure()) {
                    if (isUserExistInCurrentDomain) {
                        IdentityErrorMsgContext customErrorMessageContext;
                        userIdentityDTO.setFailAttempts();
                        if (userIdentityDTO.getFailAttempts() >= config.getAuthPolicyMaxLoginAttempts()) {
                            log.info((Object)("User, " + userName + " has exceed the max failed login attempts. User account would be locked"));
                            customErrorMessageContext = new IdentityErrorMsgContext("17003:" + IdentityMgtConstants.LockedReason.MAX_ATTEMTS_EXCEEDED.toString(), userIdentityDTO.getFailAttempts(), config.getAuthPolicyMaxLoginAttempts());
                            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                            ((Map)IdentityUtil.threadLocalProperties.get()).put("UserAccountState", "17003");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Username :" + userName + "Exceeded the maximum login attempts. User locked, ErrorCode :" + "17003"));
                            }
                            userIdentityDTO.getUserDataMap().put("http://wso2.org/claims/identity/lockedReason", IdentityMgtConstants.LockedReason.MAX_ATTEMTS_EXCEEDED.toString());
                            userIdentityDTO.setAccountLock(true);
                            userIdentityDTO.setFailAttempts(0);
                            int lockTime = IdentityMgtConfig.getInstance().getAuthPolicyLockingTime();
                            if (lockTime != 0) {
                                userIdentityDTO.setUnlockTime(System.currentTimeMillis() + (long)(lockTime * 60) * 1000L);
                            }
                        } else {
                            customErrorMessageContext = new IdentityErrorMsgContext("17002", userIdentityDTO.getFailAttempts(), config.getAuthPolicyMaxLoginAttempts());
                            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Username :" + userName + "Invalid Credential, ErrorCode :" + "17002"));
                            }
                        }
                        try {
                            this.module.store(userIdentityDTO, (UserStoreManager)userStoreManager);
                        }
                        catch (IdentityException e) {
                            throw new UserStoreException("Error while saving user store data for user : " + userName, (Throwable)e);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("User, " + userName + " is not exists in " + domainName));
                    }
                } else if (userIdentityDTO.isAccountLocked() || userIdentityDTO.getFailAttempts() > 0 || userIdentityDTO.getAccountLock()) {
                    userIdentityDTO.getUserDataMap().put("http://wso2.org/claims/identity/lockedReason", "");
                    userIdentityDTO.setAccountLock(false);
                    userIdentityDTO.setFailAttempts(0);
                    userIdentityDTO.setUnlockTime(0L);
                    try {
                        this.module.store(userIdentityDTO, (UserStoreManager)userStoreManager);
                    }
                    catch (IdentityException e) {
                        throw new UserStoreException("Error while saving user store data for user : " + userName, (Throwable)e);
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(DO_POST_AUTHENTICATE);
        }
    }

    public boolean doPreAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            if (credential == null || StringUtils.isBlank((String)credential.toString())) {
                log.error((Object)"Identity Management listener is disabled");
                throw new UserStoreException("PasswordInvalidAsk Password Feature is disabled");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre add user is called in IdentityMgtEventListener");
        }
        ((Map)IdentityUtil.threadLocalProperties.get()).remove(EMPTY_PASSWORD_USED);
        ((Map)IdentityUtil.threadLocalProperties.get()).remove(USER_IDENTITY_DO);
        IdentityMgtConfig config = IdentityMgtConfig.getInstance();
        try {
            if (credential != null && credential instanceof StringBuffer && credential.toString().trim().length() > 0) {
                this.policyRegistry.enforcePasswordPolicies(credential.toString(), userName);
            }
        }
        catch (PolicyViolationException pe) {
            throw new UserStoreException(pe.getMessage(), (Throwable)((Object)pe));
        }
        if (credential == null || credential instanceof StringBuffer && credential.toString().trim().length() < 1) {
            if (!config.isEnableTemporaryPassword()) {
                log.error((Object)"Temporary password property is disabled");
                throw new UserStoreException(ASK_PASSWORD_FEATURE_IS_DISABLED);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Credentials are null. Using a temporary password as credentials");
            }
            ((Map)IdentityUtil.threadLocalProperties.get()).put(EMPTY_PASSWORD_USED, true);
            char[] temporaryPassword = null;
            temporaryPassword = UserIdentityManagementUtil.generateTemporaryPassword();
            ((StringBuffer)credential).replace(0, temporaryPassword.length, new String(temporaryPassword));
        }
        HashMap<String, String> userDataMap = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = claims.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> claim = it.next();
            if (!claim.getKey().contains("http://wso2.org/claims/identity/challengeQuestion") && !claim.getKey().contains("http://wso2.org/claims/identity")) continue;
            userDataMap.put(claim.getKey(), claim.getValue());
            it.remove();
        }
        UserIdentityClaimsDO identityDTO = new UserIdentityClaimsDO(userName, userDataMap);
        identityDTO.setTenantId(userStoreManager.getTenantId());
        ((Map)IdentityUtil.threadLocalProperties.get()).put(USER_IDENTITY_DO, identityDTO);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPostAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        try {
            if (!((Map)IdentityUtil.threadLocalProperties.get()).containsKey(DO_POST_ADD_USER)) {
                ((Map)IdentityUtil.threadLocalProperties.get()).put(DO_POST_ADD_USER, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Post add user is called in IdentityMgtEventListener");
                }
                IdentityMgtConfig config = IdentityMgtConfig.getInstance();
                UserIdentityClaimsDO userIdentityClaimsDO = (UserIdentityClaimsDO)((Map)IdentityUtil.threadLocalProperties.get()).get(USER_IDENTITY_DO);
                if (config.isEnableUserAccountVerification() && ((Map)IdentityUtil.threadLocalProperties.get()).containsKey(EMPTY_PASSWORD_USED)) {
                    String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
                    if (!"PRIMARY".equals(domainName)) {
                        userName = domainName + UserCoreConstants.DOMAIN_SEPARATOR + userName;
                    }
                    userIdentityClaimsDO.getUserDataMap().put("http://wso2.org/claims/identity/lockedReason", "");
                    userIdentityClaimsDO.setAccountLock(false);
                    try {
                        this.module.store(userIdentityClaimsDO, (UserStoreManager)userStoreManager);
                    }
                    catch (IdentityException e) {
                        userStoreManager.deleteUser(userName);
                        throw new UserStoreException("Error while saving user store for user : " + userName, (Throwable)e);
                    }
                    UserRecoveryDataDO metadataDO = new UserRecoveryDataDO();
                    metadataDO.setUserName(userName).setTenantId(userStoreManager.getTenantId()).setCode((String)credential);
                    RecoveryProcessor processor = new RecoveryProcessor();
                    UserRecoveryDTO recoveryDto = new UserRecoveryDTO(userName);
                    recoveryDto.setNotification("askPassword");
                    recoveryDto.setNotificationType(EMAIL_NOTIFICATION_TYPE);
                    recoveryDto.setTenantId(userStoreManager.getTenantId());
                    NotificationDataDTO notificationDto = null;
                    try {
                        notificationDto = processor.recoverWithNotification(recoveryDto);
                    }
                    catch (IdentityException e) {
                        userStoreManager.deleteUser(userName);
                        throw new UserStoreException("Error while sending notification for user : " + userName, (Throwable)e);
                    }
                    boolean bl = notificationDto != null && notificationDto.isNotificationSent();
                    return bl;
                }
                if (config.isAuthPolicyAccountLockOnCreation()) {
                    userIdentityClaimsDO.getUserDataMap().put("http://wso2.org/claims/identity/lockedReason", IdentityMgtConstants.LockedReason.UNVERIFIED.toString());
                    userIdentityClaimsDO.setAccountLock(true);
                    try {
                        config.getIdentityDataStore().store(userIdentityClaimsDO, (UserStoreManager)userStoreManager);
                    }
                    catch (IdentityException e) {
                        userStoreManager.deleteUser(userName);
                        throw new UserStoreException("Error while saving user store data for user : " + userName, (Throwable)e);
                    }
                }
                if (!config.isEnableUserAccountVerification() && !config.isAuthPolicyAccountLockOnCreation() && userIdentityClaimsDO != null) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Storing identity-mgt claims since they are available in the addUser request");
                        }
                        this.module.store(userIdentityClaimsDO, (UserStoreManager)userStoreManager);
                    }
                    catch (IdentityException e) {
                        userStoreManager.deleteUser(userName);
                        throw new UserStoreException("Error while saving user store data for user : " + userName, (Throwable)e);
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(DO_POST_ADD_USER);
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(EMPTY_PASSWORD_USED);
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(USER_IDENTITY_DO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPreUpdateCredential(String userName, Object newCredential, Object oldCredential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre update credential is called in IdentityMgtEventListener");
        }
        try {
            if (!((Map)IdentityUtil.threadLocalProperties.get()).containsKey(DO_PRE_UPDATE_CREDENTIAL)) {
                ((Map)IdentityUtil.threadLocalProperties.get()).put(DO_PRE_UPDATE_CREDENTIAL, true);
                IdentityMgtConfig config = IdentityMgtConfig.getInstance();
                UserIdentityDataStore identityDataStore = IdentityMgtConfig.getInstance().getIdentityDataStore();
                UserIdentityClaimsDO identityDTO = identityDataStore.load(userName, (UserStoreManager)userStoreManager);
                boolean isAccountDisabled = false;
                if (identityDTO == null) {
                    throw new UserStoreException("Cannot get the user account active status.");
                }
                isAccountDisabled = identityDTO.getIsAccountDisabled();
                if (isAccountDisabled) {
                    IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17004");
                    IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                    log.warn((Object)"Trying to update credential of a disabled user account. This is not permitted.");
                    throw new UserStoreException("User account is disabled, can't update credential without enabling.");
                }
                try {
                    if (newCredential != null && newCredential instanceof String && newCredential.toString().trim().length() > 0) {
                        this.policyRegistry.enforcePasswordPolicies(newCredential.toString(), userName);
                    }
                }
                catch (PolicyViolationException pe) {
                    throw new UserStoreException(pe.getMessage(), (Throwable)((Object)pe));
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(DO_PRE_UPDATE_CREDENTIAL);
        }
    }

    public boolean doPostUpdateCredentialByAdmin(String userName, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<String, String> userClaims = new HashMap<String, String>();
        userClaims.put("http://wso2.org/claims/identity/lastPasswordUpdateTime", Long.toString(System.currentTimeMillis()));
        userStoreManager.setUserClaimValues(userName, userClaims, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPreUpdateCredentialByAdmin(String userName, Object newCredential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre update credential by admin is called in IdentityMgtEventListener");
        }
        try {
            if (!((Map)IdentityUtil.threadLocalProperties.get()).containsKey(DO_PRE_UPDATE_CREDENTIAL_BY_ADMIN)) {
                ((Map)IdentityUtil.threadLocalProperties.get()).put(DO_PRE_UPDATE_CREDENTIAL_BY_ADMIN, true);
                IdentityMgtConfig config = IdentityMgtConfig.getInstance();
                UserIdentityDataStore identityDataStore = IdentityMgtConfig.getInstance().getIdentityDataStore();
                UserIdentityClaimsDO identityDTO = identityDataStore.load(userName, (UserStoreManager)userStoreManager);
                boolean isAccountDisabled = false;
                if (identityDTO == null) {
                    throw new UserStoreException("Cannot get the user account active status.");
                }
                isAccountDisabled = identityDTO.getIsAccountDisabled();
                if (isAccountDisabled) {
                    IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17004");
                    IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                    log.warn((Object)"Trying to update credential of a disabled user account. This is not permitted.");
                    throw new UserStoreException("User account is disabled, can't update credential without enabling.");
                }
                try {
                    if (newCredential != null && newCredential instanceof StringBuffer && newCredential.toString().trim().length() > 0) {
                        this.policyRegistry.enforcePasswordPolicies(newCredential.toString(), userName);
                    }
                }
                catch (PolicyViolationException pe) {
                    throw new UserStoreException(pe.getMessage(), (Throwable)((Object)pe));
                }
                if (newCredential == null || newCredential instanceof StringBuffer && ((StringBuffer)newCredential).toString().trim().length() < 1) {
                    if (!config.isEnableTemporaryPassword()) {
                        log.error((Object)"Empty passwords are not allowed");
                        boolean pe = false;
                        return pe;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Credentials are null. Using a temporary password as credentials");
                    }
                    char[] temporaryPassword = UserIdentityManagementUtil.generateTemporaryPassword();
                    ((StringBuffer)newCredential).replace(0, temporaryPassword.length, new String(temporaryPassword));
                    UserIdentityMgtBean bean = new UserIdentityMgtBean();
                    bean.setUserId(userName);
                    bean.setConfirmationCode(newCredential.toString());
                    bean.setRecoveryType("temporaryPassword");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending the temporary password to the user " + userName));
                    }
                    UserIdentityManagementUtil.notifyViaEmail(bean);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating credentials of user " + userName + " by admin with a non-empty password"));
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(DO_PRE_UPDATE_CREDENTIAL_BY_ADMIN);
        }
    }

    public boolean doPreSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (StringUtils.isNotBlank((String)claimURI) && claimURI.contains("http://wso2.org/claims/identity")) {
            throw new UserStoreException("InvalidOperation This operation is not supported for Identity claims");
        }
        return true;
    }

    public boolean doPreGetUserClaimValue(String userName, String claim, String profileName, org.wso2.carbon.user.core.UserStoreManager storeManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (StringUtils.isNotBlank((String)claim) && claim.contains("http://wso2.org/claims/identity")) {
            throw new UserStoreException("InvalidOperation This operation is not supported for Identity claims");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPreSetUserClaimValues(String userName, Map<String, String> claims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        ((Map)IdentityUtil.threadLocalProperties.get()).remove("UserAccountState");
        String accountLocked = claims.get("http://wso2.org/claims/identity/accountLocked");
        boolean isAccountLocked = false;
        if (StringUtils.isNotEmpty((String)accountLocked)) {
            isAccountLocked = Boolean.parseBoolean(accountLocked);
        }
        try {
            if (!((Map)IdentityUtil.threadLocalProperties.get()).containsKey(DO_PRE_SET_USER_CLAIM_VALUES)) {
                ((Map)IdentityUtil.threadLocalProperties.get()).put(DO_PRE_SET_USER_CLAIM_VALUES, true);
                IdentityMgtConfig config = IdentityMgtConfig.getInstance();
                UserIdentityDataStore identityDataStore = IdentityMgtConfig.getInstance().getIdentityDataStore();
                UserIdentityClaimsDO identityDTO = identityDataStore.load(userName, (UserStoreManager)userStoreManager);
                if (identityDTO == null) {
                    identityDTO = new UserIdentityClaimsDO(userName);
                    identityDTO.setTenantId(userStoreManager.getTenantId());
                }
                Boolean wasAccountDisabled = identityDTO.getIsAccountDisabled();
                String accountDisabled = claims.get("http://wso2.org/claims/identity/accountDisabled");
                boolean isAccountDisabled = false;
                isAccountDisabled = StringUtils.isNotEmpty((String)accountDisabled) ? Boolean.parseBoolean(accountDisabled) : wasAccountDisabled;
                if (isAccountLocked) {
                    ((Map)IdentityUtil.threadLocalProperties.get()).put("UserAccountState", "17003");
                } else if (isAccountDisabled) {
                    ((Map)IdentityUtil.threadLocalProperties.get()).put("UserAccountState", "17004");
                }
                if (wasAccountDisabled.booleanValue() && isAccountDisabled) {
                    claims.clear();
                    log.warn((Object)"Trying to update claims of a disabled user account. This is not permitted.");
                    throw new UserStoreException("User account is disabled, can't update claims without enabling.");
                }
                Iterator<Map.Entry<String, String>> it = claims.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> claim = it.next();
                    if (!claim.getKey().contains("http://wso2.org/claims/identity/challengeQuestion") && !claim.getKey().contains("http://wso2.org/claims/identity")) continue;
                    String key = claim.getKey();
                    String value = claim.getValue();
                    if ("http://wso2.org/claims/identity/accountLocked".equals(key) && Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                        identityDTO.getUserDataMap().put("http://wso2.org/claims/identity/lockedReason", IdentityMgtConstants.LockedReason.ADMIN_INITIATED.toString());
                    }
                    identityDTO.setUserIdentityDataClaim(key, value);
                    it.remove();
                }
                try {
                    identityDataStore.store(identityDTO, (UserStoreManager)userStoreManager);
                    int tenantId = userStoreManager.getTenantId();
                    String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
                    String usernameWithDomain = IdentityUtil.addDomainToName((String)userName, (String)domainName);
                    if (wasAccountDisabled.booleanValue() && !isAccountDisabled && IdentityMgtConfig.getInstance().isAccountEnableNotificationSending()) {
                        this.sendEmail(usernameWithDomain, tenantId, "accountEnable");
                    } else if (!wasAccountDisabled.booleanValue() && isAccountDisabled && IdentityMgtConfig.getInstance().isAccountDisableNotificationSending()) {
                        this.sendEmail(usernameWithDomain, tenantId, "accountDisable");
                    }
                }
                catch (IdentityException e) {
                    throw new UserStoreException("Error while saving user store data for user : " + userName, (Throwable)e);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(DO_PRE_SET_USER_CLAIM_VALUES);
        }
    }

    public boolean doPostDeleteUser(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        try {
            IdentityMgtConfig.getInstance().getIdentityDataStore().remove(userName, (UserStoreManager)userStoreManager);
        }
        catch (IdentityException e) {
            throw new UserStoreException("Error while removing user: " + userName + " from identity data store", (Throwable)e);
        }
        UserRegistry registry = null;
        try {
            registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(userStoreManager.getTenantId());
            String identityKeyMgtPath = "/repository/components/org.wso2.carbon.identity.mgt/keys/" + userStoreManager.getTenantId() + "/" + userName;
            if (registry.resourceExists(identityKeyMgtPath)) {
                registry.delete(identityKeyMgtPath);
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Error while deleting recovery data for user : " + userName + " in tenant : " + userStoreManager.getTenantId()), (Throwable)e);
        }
        return true;
    }

    public boolean doPostGetUserClaimValues(String userName, String[] claims, String profileName, Map<String, String> claimMap, org.wso2.carbon.user.core.UserStoreManager storeManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (claimMap == null) {
            claimMap = new HashMap<String, String>();
        }
        UserIdentityDataStore identityDataStore = IdentityMgtConfig.getInstance().getIdentityDataStore();
        boolean containsIdentityClaims = false;
        for (String claim : claims) {
            if (!claim.contains("http://wso2.org/claims/identity/challengeQuestion") && !claim.contains("http://wso2.org/claims/identity")) continue;
            containsIdentityClaims = true;
            break;
        }
        if (!containsIdentityClaims) {
            return true;
        }
        UserIdentityClaimsDO identityDTO = identityDataStore.load(userName, (UserStoreManager)storeManager);
        if (identityDTO == null) {
            return true;
        }
        for (String claim : claims) {
            if (!identityDTO.getUserDataMap().containsKey(claim)) continue;
            claimMap.put(claim, identityDTO.getUserDataMap().get(claim));
        }
        return true;
    }

    public boolean doPostGetUserClaimValue(String userName, String claim, List<String> claimValue, String profileName, org.wso2.carbon.user.core.UserStoreManager storeManager) throws UserStoreException {
        return true;
    }

    public boolean doPostUpdateCredential(String userName, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        HashMap<String, String> userClaims = new HashMap<String, String>();
        userClaims.put("http://wso2.org/claims/identity/lastPasswordUpdateTime", Long.toString(System.currentTimeMillis()));
        userStoreManager.setUserClaimValues(userName, userClaims, null);
        return true;
    }

    private void sendEmail(String userName, int tenantId, String notification) {
        UserRecoveryDTO dto;
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantId);
        if ("carbon.super".equals(tenantDomain)) {
            dto = new UserRecoveryDTO(userName);
        } else {
            UserDTO userDTO = new UserDTO(UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain));
            userDTO.setTenantId(tenantId);
            dto = new UserRecoveryDTO(userDTO);
        }
        dto.setNotification(notification);
        dto.setNotificationType(EMAIL_NOTIFICATION_TYPE);
        try {
            IdentityMgtServiceComponent.getRecoveryProcessor().recoverWithNotification(dto);
        }
        catch (IdentityException e) {
            log.error((Object)("Email notification sending failed for user:" + userName + " for " + notification));
        }
    }
}

