/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.NotificationSendingModule;
import org.wso2.carbon.identity.mgt.mail.DefaultEmailSendingModule;
import org.wso2.carbon.identity.mgt.password.DefaultPasswordGenerator;
import org.wso2.carbon.identity.mgt.password.RandomPasswordGenerator;
import org.wso2.carbon.identity.mgt.policy.PolicyEnforcer;
import org.wso2.carbon.identity.mgt.policy.PolicyRegistry;
import org.wso2.carbon.identity.mgt.store.RegistryRecoveryDataStore;
import org.wso2.carbon.identity.mgt.store.UserIdentityDataStore;
import org.wso2.carbon.identity.mgt.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.mgt.store.UserStoreBasedIdentityDataStore;
import org.wso2.carbon.user.api.RealmConfiguration;

public class IdentityMgtConfig {
    private static final Log log = LogFactory.getLog(IdentityMgtConfig.class);
    private static IdentityMgtConfig identityMgtConfig;
    private boolean saasEnable;
    private boolean listenerEnable;
    private int noOfUserChallenges;
    private boolean notificationInternallyManaged;
    private boolean captchaVerificationInternallyManaged;
    private String challengeQuestionSeparator;
    private int authPolicyMaxLoginAttempts;
    private int temporaryPasswordExpireTime;
    private boolean enableTemporaryPassword;
    private boolean enableAuthPolicy;
    private boolean authPolicyOneTimePasswordCheck;
    private boolean authPolicyExpirePasswordCheck;
    private int authPolicyLockingTime;
    private int authPolicyPasswordExpireTime;
    private int notificationExpireTime;
    private int notificationSendingThreadPoolSize;
    private int notificationSendingTimeout;
    private boolean authPolicyAccountLockCheck;
    private boolean authPolicyAccountDisableCheck;
    private boolean authPolicyAccountExistCheck;
    private boolean authPolicyAccountLockOnFailure;
    private boolean authPolicyAccountLockOnCreation;
    private boolean enableUserAccountVerification;
    private boolean userAccountVerificationByUser;
    private boolean temporaryPasswordOneTime;
    private String userAccountVerificationRole;
    private boolean notificationSending;
    private boolean disableNotificationSending;
    private boolean enableNotificationSending;
    private String digsestFunction;
    private RandomPasswordGenerator passwordGenerator;
    private UserIdentityDataStore identityDataStore;
    private UserRecoveryDataStore recoveryDataStore;
    private List<NotificationSendingModule> sendingModules = new ArrayList<NotificationSendingModule>();
    private List<String> notificationTypes = new ArrayList<String>();
    private String recoveryClaim;
    private PolicyRegistry policyRegistry = new PolicyRegistry();
    protected Properties properties = new Properties();
    private long registryCleanUpPeriod;
    private int poolSize = 0;
    private ExecutorService executors = null;
    private Pattern propertyPattern = Pattern.compile("(\\.\\d\\.)");

    public ExecutorService getExecutors() {
        return this.executors;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityMgtConfig(RealmConfiguration configuration) {
        String strPoolSize;
        FileInputStream inStream = null;
        File pipConfigXml = new File(IdentityUtil.getIdentityConfigDirPath(), "identity-mgt.properties");
        if (pipConfigXml.exists()) {
            try {
                inStream = new FileInputStream(pipConfigXml);
                this.properties.load(inStream);
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Can not load identity-mgt properties file ", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Can not load identity-mgt properties file ", (Throwable)e);
            }
            finally {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing stream ", (Throwable)e);
                    }
                }
            }
        }
        if (NumberUtils.isNumber((String)(strPoolSize = this.properties.getProperty("UserInfoRecovery.Artifact.Delete.ThreadPoolSize")))) {
            this.poolSize = Integer.parseInt(strPoolSize);
            if (this.poolSize > 0) {
                this.executors = Executors.newFixedThreadPool(this.poolSize);
            }
        }
        try {
            Object module;
            String tempNotificationSendingTimeout;
            String tempNotificationSendingThreadPoolSize;
            String registryCleanUpPeriod;
            String dataPersistModule;
            String challengeQuestionSeparatorProperty;
            String digsestFunctionProperty;
            String authPolicyAccountLockOnCreationProperty;
            String authPolicyAccountLockOnFailureProperty;
            String authPolicyAccountExistCheckProperty;
            String authPolicyAccountDisableCheckProperty;
            String authPolicyAccountLockCheckProperty;
            String notificationExpireTimeProperty;
            String authPolicyPasswordExpireTimeProperty;
            String authPolicyLockingTimeProperty;
            String expirePasswordCheck;
            String maxLoginAttemptProperty;
            String oneTimePasswordCheck;
            String enableAuthPolicyProperty;
            String temporaryPasswordOneTimeProperty;
            String temporaryPasswordExpireTimeProperty;
            String userAccountVerificationRoleProperty;
            String enableUserAccountVerificationProperty;
            String captchaVerificationInternallyManagedProperty;
            String recoveryClaimProperty;
            String enableNotificationSendingProperty;
            String disableNotificationSendingProperty;
            String notificationSendingProperty;
            String listenerEnableProperty;
            String saasEnableProperty;
            String notificationInternallyManagedProperty = this.properties.getProperty("Notification.Sending.Internally.Managed");
            if (notificationInternallyManagedProperty != null) {
                this.notificationInternallyManaged = Boolean.parseBoolean(notificationInternallyManagedProperty.trim());
            }
            if ((saasEnableProperty = this.properties.getProperty("UserInfoRecovery.SaaSEnable")) != null) {
                this.saasEnable = Boolean.parseBoolean(saasEnableProperty.trim());
            }
            if ((listenerEnableProperty = this.properties.getProperty("Identity.Listener.Enable")) != null) {
                this.listenerEnable = Boolean.parseBoolean(listenerEnableProperty.trim());
            }
            if ((notificationSendingProperty = this.properties.getProperty("Notification.Sending.Enable")) != null) {
                this.notificationSending = Boolean.parseBoolean(notificationSendingProperty.trim());
            }
            if ((disableNotificationSendingProperty = this.properties.getProperty("Notification.Sending.Enable.Account.Disable")) != null) {
                this.disableNotificationSending = Boolean.parseBoolean(disableNotificationSendingProperty.trim());
            }
            if ((enableNotificationSendingProperty = this.properties.getProperty("Notification.Sending.Enable.Account.Enable")) != null) {
                this.enableNotificationSending = Boolean.parseBoolean(enableNotificationSendingProperty.trim());
            }
            if ((recoveryClaimProperty = this.properties.getProperty("Recovery.Claim")) != null) {
                this.recoveryClaim = recoveryClaimProperty.trim();
            }
            if ((captchaVerificationInternallyManagedProperty = this.properties.getProperty("Captcha.Verification.Internally.Managed")) != null) {
                this.captchaVerificationInternallyManaged = Boolean.parseBoolean(captchaVerificationInternallyManagedProperty.trim());
            }
            if ((enableUserAccountVerificationProperty = this.properties.getProperty("UserAccount.Verification.Enable")) != null) {
                this.enableUserAccountVerification = Boolean.parseBoolean(enableUserAccountVerificationProperty.trim());
            }
            if ((userAccountVerificationRoleProperty = this.properties.getProperty("UserAccount.Verification.Role")) != null && userAccountVerificationRoleProperty.trim().length() > 0) {
                this.userAccountVerificationRole = userAccountVerificationRoleProperty;
            } else {
                this.userAccountVerificationByUser = true;
            }
            String allowTemporaryPasswordProperty = this.properties.getProperty("Temporary.Password.Enable");
            if (allowTemporaryPasswordProperty != null) {
                this.enableTemporaryPassword = Boolean.parseBoolean(allowTemporaryPasswordProperty.trim());
            }
            if ((temporaryPasswordExpireTimeProperty = this.properties.getProperty("Temporary.Password.Expire.Time")) != null) {
                this.temporaryPasswordExpireTime = Integer.parseInt(temporaryPasswordExpireTimeProperty.trim());
            }
            if ((temporaryPasswordOneTimeProperty = this.properties.getProperty("Temporary.Password.OneTime")) != null) {
                this.temporaryPasswordOneTime = Boolean.parseBoolean(temporaryPasswordOneTimeProperty.trim());
            }
            if ((enableAuthPolicyProperty = this.properties.getProperty("Authentication.Policy.Enable")) != null) {
                this.enableAuthPolicy = Boolean.parseBoolean(enableAuthPolicyProperty.trim());
            }
            if ((oneTimePasswordCheck = this.properties.getProperty("Authentication.Policy.Check.OneTime.Password")) != null) {
                this.authPolicyOneTimePasswordCheck = Boolean.parseBoolean(oneTimePasswordCheck.trim());
            }
            if ((maxLoginAttemptProperty = this.properties.getProperty("Authentication.Policy.Account.Lock.On.Failure.Max.Attempts")) != null) {
                this.authPolicyMaxLoginAttempts = Integer.parseInt(maxLoginAttemptProperty.trim());
            }
            if (this.authPolicyMaxLoginAttempts == 0) {
                this.authPolicyMaxLoginAttempts = 10;
            }
            if ((expirePasswordCheck = this.properties.getProperty("Authentication.Policy.Check.Password.Expire")) != null) {
                this.authPolicyExpirePasswordCheck = Boolean.parseBoolean(expirePasswordCheck.trim());
            }
            if ((authPolicyLockingTimeProperty = this.properties.getProperty("Authentication.Policy.Account.Lock.Time")) != null) {
                this.authPolicyLockingTime = Integer.parseInt(authPolicyLockingTimeProperty.trim());
            }
            if ((authPolicyPasswordExpireTimeProperty = this.properties.getProperty("Authentication.Policy.Password.Expire.Time")) != null) {
                this.authPolicyPasswordExpireTime = Integer.parseInt(authPolicyPasswordExpireTimeProperty.trim());
            }
            if ((notificationExpireTimeProperty = this.properties.getProperty("Notification.Expire.Time")) != null) {
                this.notificationExpireTime = Integer.parseInt(notificationExpireTimeProperty.trim());
            }
            if ((authPolicyAccountLockCheckProperty = this.properties.getProperty("Authentication.Policy.Check.Account.Lock")) != null) {
                this.authPolicyAccountLockCheck = Boolean.parseBoolean(authPolicyAccountLockCheckProperty.trim());
            }
            if ((authPolicyAccountDisableCheckProperty = this.properties.getProperty("Authentication.Policy.Check.Account.Disable")) != null) {
                this.authPolicyAccountDisableCheck = Boolean.parseBoolean(authPolicyAccountDisableCheckProperty.trim());
            }
            if ((authPolicyAccountExistCheckProperty = this.properties.getProperty("Authentication.Policy.Check.Account.Exist")) != null) {
                this.authPolicyAccountExistCheck = Boolean.parseBoolean(authPolicyAccountExistCheckProperty.trim());
            }
            if ((authPolicyAccountLockOnFailureProperty = this.properties.getProperty("Authentication.Policy.Account.Lock.On.Failure")) != null) {
                this.authPolicyAccountLockOnFailure = Boolean.parseBoolean(authPolicyAccountLockOnFailureProperty.trim());
            }
            if ((authPolicyAccountLockOnCreationProperty = this.properties.getProperty("Authentication.Policy.Account.Lock.On.Creation")) != null) {
                this.authPolicyAccountLockOnCreation = Boolean.parseBoolean(authPolicyAccountLockOnCreationProperty.trim());
            }
            if ((digsestFunctionProperty = (String)configuration.getUserStoreProperties().get("PasswordDigest")) != null && digsestFunctionProperty.trim().length() > 0) {
                this.digsestFunction = digsestFunctionProperty;
            }
            this.challengeQuestionSeparator = (challengeQuestionSeparatorProperty = this.properties.getProperty("Challenge.Question.Separator")) != null && challengeQuestionSeparatorProperty.trim().length() == 1 ? challengeQuestionSeparatorProperty.trim() : "!";
            String passwordGeneratorProperty = this.properties.getProperty("Identity.Mgt.Random.Password.Generator");
            if (passwordGeneratorProperty != null && passwordGeneratorProperty.trim().length() > 0) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(passwordGeneratorProperty);
                    this.passwordGenerator = (RandomPasswordGenerator)clazz.newInstance();
                }
                catch (Exception e) {
                    log.error((Object)"Error while loading random password generator class. Default random password generator would be used", (Throwable)e);
                }
            }
            if ((dataPersistModule = this.properties.getProperty("Identity.Mgt.User.Data.Store")) != null && dataPersistModule.trim().length() > 0) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(dataPersistModule);
                    this.identityDataStore = (UserIdentityDataStore)clazz.newInstance();
                }
                catch (Exception e) {
                    log.error((Object)("Error while loading user identity data persist class. " + dataPersistModule + " Default module would be used"), (Throwable)e);
                }
            }
            String recoveryPersistModule = this.properties.getProperty("Identity.Mgt.User.Recovery.Data.Store");
            if (dataPersistModule != null && dataPersistModule.trim().length() > 0) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(recoveryPersistModule);
                    this.recoveryDataStore = (UserRecoveryDataStore)clazz.newInstance();
                }
                catch (Exception e) {
                    log.error((Object)("Error while loading user recovery data persist class. " + dataPersistModule + " Default module would be used"), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)(registryCleanUpPeriod = this.properties.getProperty("Identity.Mgt.Registry.CleanUpPeriod")))) {
                this.registryCleanUpPeriod = Long.parseLong(registryCleanUpPeriod);
            }
            if (org.apache.commons.lang.math.NumberUtils.isNumber((String)(tempNotificationSendingThreadPoolSize = this.properties.getProperty("Notification.Sending.Thread.Pool.Size")))) {
                this.notificationSendingThreadPoolSize = Integer.parseInt(tempNotificationSendingThreadPoolSize);
            }
            if (org.apache.commons.lang.math.NumberUtils.isNumber((String)(tempNotificationSendingTimeout = this.properties.getProperty("Notification.Sending.Timeout")))) {
                this.notificationSendingTimeout = Integer.parseInt(tempNotificationSendingTimeout);
            }
            int i = 1;
            while ((module = this.properties.getProperty("Identity.Mgt.Notification.Sending.Module." + i)) != null) {
                if (((String)module).trim().length() > 0) {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass((String)module);
                        NotificationSendingModule sendingModule = (NotificationSendingModule)clazz.newInstance();
                        String type = sendingModule.getNotificationType();
                        if (type == null || type.trim().length() == 0) {
                            log.error((Object)("Notification type can not be null. Module " + (String)module + "  is not loaded."));
                        } else if (this.notificationTypes.contains(type)) {
                            log.error((Object)("Same Notification type can not be supported by more than one module. Module " + (String)module + "  is not loaded."));
                        } else {
                            this.notificationTypes.add(type);
                            sendingModule.init();
                            this.sendingModules.add(sendingModule);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while loading notification sending class  " + (String)module), (Throwable)e);
                    }
                }
                ++i;
            }
            this.loadPolicyExtensions(this.properties, "Password.policy.extensions");
            if (this.passwordGenerator == null) {
                this.passwordGenerator = new DefaultPasswordGenerator();
            }
            if (this.identityDataStore == null) {
                this.identityDataStore = new UserStoreBasedIdentityDataStore();
            }
            if (this.recoveryDataStore == null) {
                this.recoveryDataStore = new RegistryRecoveryDataStore();
            }
            if (this.sendingModules.isEmpty()) {
                module = new DefaultEmailSendingModule();
                ((NotificationSendingModule)module).init();
                this.sendingModules.add((NotificationSendingModule)module);
                this.notificationTypes.add(((NotificationSendingModule)module).getNotificationType());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while loading identity mgt configurations", (Throwable)e);
        }
    }

    public static IdentityMgtConfig getInstance(RealmConfiguration configuration) {
        identityMgtConfig = new IdentityMgtConfig(configuration);
        return identityMgtConfig;
    }

    public static IdentityMgtConfig getInstance() {
        return identityMgtConfig;
    }

    public int getNoOfUserChallenges() {
        return this.noOfUserChallenges;
    }

    public boolean isSaasEnabled() {
        return this.saasEnable;
    }

    public boolean isNotificationInternallyManaged() {
        return this.notificationInternallyManaged;
    }

    public boolean isCaptchaVerificationInternallyManaged() {
        return this.captchaVerificationInternallyManaged;
    }

    public boolean isEnableUserAccountVerification() {
        return this.enableUserAccountVerification;
    }

    public int getAuthPolicyMaxLoginAttempts() {
        return this.authPolicyMaxLoginAttempts;
    }

    public int getTemporaryPasswordExpireTime() {
        return this.temporaryPasswordExpireTime;
    }

    public boolean isEnableTemporaryPassword() {
        return this.enableTemporaryPassword;
    }

    public boolean isEnableAuthPolicy() {
        return this.enableAuthPolicy;
    }

    public boolean isAuthPolicyExpirePasswordCheck() {
        return this.authPolicyExpirePasswordCheck;
    }

    public boolean isAuthPolicyOneTimePasswordCheck() {
        return this.authPolicyOneTimePasswordCheck;
    }

    public int getAuthPolicyLockingTime() {
        return this.authPolicyLockingTime;
    }

    public boolean isAuthPolicyAccountLockCheck() {
        return this.authPolicyAccountLockCheck;
    }

    public boolean isAuthPolicyAccountDisableCheck() {
        return this.authPolicyAccountDisableCheck;
    }

    public boolean isUserAccountVerificationByUser() {
        return this.userAccountVerificationByUser;
    }

    public boolean isTemporaryPasswordOneTime() {
        return this.temporaryPasswordOneTime;
    }

    public String getUserAccountVerificationRole() {
        return this.userAccountVerificationRole;
    }

    public String getChallengeQuestionSeparator() {
        return this.challengeQuestionSeparator;
    }

    public String getDigsestFunction() {
        return this.digsestFunction;
    }

    public RandomPasswordGenerator getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public UserIdentityDataStore getIdentityDataStore() {
        return this.identityDataStore;
    }

    public boolean isNotificationSending() {
        return this.notificationSending;
    }

    public boolean isAccountDisableNotificationSending() {
        return this.disableNotificationSending;
    }

    public boolean isAccountEnableNotificationSending() {
        return this.enableNotificationSending;
    }

    public boolean isAuthPolicyAccountExistCheck() {
        return this.authPolicyAccountExistCheck;
    }

    public boolean isAuthPolicyAccountLockOnFailure() {
        return this.authPolicyAccountLockOnFailure;
    }

    public int getAuthPolicyPasswordExpireTime() {
        return this.authPolicyPasswordExpireTime;
    }

    public boolean isAuthPolicyAccountLockOnCreation() {
        return this.authPolicyAccountLockOnCreation;
    }

    public int getNotificationExpireTime() {
        return this.notificationExpireTime;
    }

    public int getNotificationSendingThreadPoolSize() {
        return this.notificationSendingThreadPoolSize;
    }

    public int getNotificationSendingTimeout() {
        return this.notificationSendingTimeout;
    }

    public boolean isListenerEnable() {
        return this.listenerEnable;
    }

    public List<NotificationSendingModule> getNotificationSendingModules() {
        return this.sendingModules;
    }

    public String getAccountRecoveryClaim() {
        return this.recoveryClaim;
    }

    public List<String> getNotificationTypes() {
        return this.notificationTypes;
    }

    public UserRecoveryDataStore getRecoveryDataStore() {
        return this.recoveryDataStore;
    }

    public PolicyRegistry getPolicyRegistry() {
        return this.policyRegistry;
    }

    public long getRegistryCleanUpPeriod() {
        return this.registryCleanUpPeriod;
    }

    private void loadPolicyExtensions(Properties properties, String extensionType) {
        HashSet<Integer> count = new HashSet<Integer>();
        for (String currentProp : properties.stringPropertyNames()) {
            String extensionNumber;
            if (!currentProp.startsWith(extensionType) || !StringUtils.isNumeric((String)(extensionNumber = currentProp.replaceFirst(extensionType + ".", "")))) continue;
            count.add(Integer.parseInt(extensionNumber));
        }
        for (Integer extensionIndex : count) {
            String className = properties.getProperty(extensionType + "." + extensionIndex);
            if (className == null) continue;
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                PolicyEnforcer policy = (PolicyEnforcer)clazz.newInstance();
                policy.init(this.getParameters(properties, extensionType, extensionIndex));
                this.policyRegistry.addPolicy(policy);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException e) {
                log.error((Object)("Error while loading password policies " + className), (Throwable)e);
            }
        }
    }

    private Map<String, String> getParameters(Properties prop, String extensionKey, int sequence) {
        Set<String> keys = prop.stringPropertyNames();
        HashMap<String, String> keyValues = new HashMap<String, String>();
        for (String key : keys) {
            Matcher m;
            if (!key.contains(extensionKey + "." + String.valueOf(sequence)) || !(m = this.propertyPattern.matcher(key)).find()) continue;
            int searchIndex = m.end();
            if (key.length() <= searchIndex) continue;
            String propKey = key.substring(searchIndex);
            String propValue = prop.getProperty(key);
            keyValues.put(propKey, propValue);
        }
        return keyValues;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }
}

