/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.dto.ChallengeQuestionDTO;
import org.wso2.carbon.identity.mgt.dto.ChallengeQuestionIdsDTO;
import org.wso2.carbon.identity.mgt.dto.UserChallengesDTO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.util.Utils;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class ChallengeQuestionProcessor {
    private static final Log log = LogFactory.getLog(ChallengeQuestionProcessor.class);

    public List<ChallengeQuestionDTO> getAllChallengeQuestions() throws IdentityException {
        ArrayList<ChallengeQuestionDTO> questionDTOs = new ArrayList<ChallengeQuestionDTO>();
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            UserRegistry registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(tenantId);
            if (registry.resourceExists("/repository/components/org.wso2.carbon.identity.mgt/questionCollection")) {
                String[] children;
                Collection collection = (Collection)registry.get("/repository/components/org.wso2.carbon.identity.mgt/questionCollection");
                for (String child : children = collection.getChildren()) {
                    Resource resource = registry.get(child);
                    String question = resource.getProperty("question");
                    String isPromoteQuestion = resource.getProperty("isPromoteQuestion");
                    String questionSetId = resource.getProperty("questionSetId");
                    if (question == null) continue;
                    ChallengeQuestionDTO questionDTO = new ChallengeQuestionDTO();
                    questionDTO.setQuestion(question);
                    if (isPromoteQuestion != null) {
                        questionDTO.setPromoteQuestion(Boolean.parseBoolean(isPromoteQuestion));
                    }
                    if (questionSetId != null) {
                        questionDTO.setQuestionSetId(questionSetId);
                    }
                    questionDTO.setPromoteQuestion(false);
                    questionDTOs.add(questionDTO);
                }
            }
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)e.getMessage(), (Throwable)e);
        }
        return questionDTOs;
    }

    public void setChallengeQuestions(ChallengeQuestionDTO[] questionDTOs) throws IdentityException {
        UserRegistry registry = null;
        try {
            Resource identityMgtResource;
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(tenantId);
            if (!registry.resourceExists("/repository/components/org.wso2.carbon.identity.mgt")) {
                Collection securityQuestionResource = registry.newCollection();
                registry.put("/repository/components/org.wso2.carbon.identity.mgt", (Resource)securityQuestionResource);
            }
            if ((identityMgtResource = registry.get("/repository/components/org.wso2.carbon.identity.mgt")) != null) {
                String questionCollectionPath = "/repository/components/org.wso2.carbon.identity.mgt/questionCollection";
                if (registry.resourceExists(questionCollectionPath)) {
                    registry.delete(questionCollectionPath);
                }
                Collection questionCollection = registry.newCollection();
                registry.put(questionCollectionPath, (Resource)questionCollection);
                for (int i = 0; i < questionDTOs.length; ++i) {
                    Resource resource = registry.newResource();
                    resource.addProperty("question", questionDTOs[i].getQuestion());
                    resource.addProperty("isPromoteQuestion", String.valueOf(questionDTOs[i].isPromoteQuestion()));
                    resource.addProperty("questionSetId", questionDTOs[i].getQuestionSetId());
                    registry.put("/repository/components/org.wso2.carbon.identity.mgt/questionCollection/question" + i + "/", resource);
                }
            }
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)"Error while setting challenge question.", (Throwable)e);
        }
    }

    public UserChallengesDTO[] getChallengeQuestionsOfUser(String userName, int tenantId, boolean adminService) {
        ArrayList<UserChallengesDTO> challengesDTOs;
        block6: {
            challengesDTOs = new ArrayList<UserChallengesDTO>();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Retrieving Challenge question from the user profile.");
                }
                List<String> challengesUris = this.getChallengeQuestionUris(userName, tenantId);
                for (int i = 0; i < challengesUris.size(); ++i) {
                    String challengesUri = challengesUris.get(i).trim();
                    String challengeValue = Utils.getClaimFromUserStoreManager(userName, tenantId, challengesUri);
                    String[] challengeValues = challengeValue.split(IdentityMgtConfig.getInstance().getChallengeQuestionSeparator());
                    if (challengeValues == null || challengeValues.length != 2) continue;
                    UserChallengesDTO dto = new UserChallengesDTO();
                    dto.setId(challengesUri);
                    dto.setQuestion(challengeValues[0].trim());
                    if (adminService) {
                        dto.setAnswer(challengeValues[1].trim());
                    }
                    dto.setOrder(i);
                    dto.setPrimary(false);
                    challengesDTOs.add(dto);
                }
            }
            catch (Exception e) {
                String msg = "No associated challenge question found for the user";
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)msg, (Throwable)e);
            }
        }
        if (!challengesDTOs.isEmpty()) {
            return challengesDTOs.toArray(new UserChallengesDTO[challengesDTOs.size()]);
        }
        return new UserChallengesDTO[0];
    }

    public UserChallengesDTO[] getUserChallengeQuestions(String userName, int tenantId) throws IdentityException {
        ArrayList<UserChallengesDTO> userChallengesDTOList = new ArrayList<UserChallengesDTO>();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrieving Challenge questions from the user profile.");
            }
            List<String> challengeQuestionUris = this.getChallengeQuestionUris(userName, tenantId);
            String[] challengeQuestionUriArray = new String[challengeQuestionUris.size()];
            Map<String, String> challengeQuestionClaimValues = Utils.getClaimsFromUserStoreManager(userName, tenantId, challengeQuestionUris.toArray(challengeQuestionUriArray));
            for (Map.Entry<String, String> challengeQuestionClaimValue : challengeQuestionClaimValues.entrySet()) {
                String[] challengeQuestionItems = challengeQuestionClaimValue.getValue().split(IdentityMgtConfig.getInstance().getChallengeQuestionSeparator());
                UserChallengesDTO dto = new UserChallengesDTO();
                dto.setId(challengeQuestionClaimValue.getKey());
                dto.setQuestion(challengeQuestionItems[0]);
                userChallengesDTOList.add(dto);
            }
        }
        catch (Exception e) {
            throw IdentityException.error((String)"No associated challenge questions found for the user.", (Throwable)e);
        }
        UserChallengesDTO[] userChallengesDTOs = new UserChallengesDTO[userChallengesDTOList.size()];
        return userChallengesDTOList.toArray(userChallengesDTOs);
    }

    public UserChallengesDTO getUserChallengeQuestion(String userName, int tenantId, boolean adminService) throws IdentityMgtServiceException {
        UserChallengesDTO dto;
        block5: {
            dto = null;
            ArrayList<UserChallengesDTO> challengesDTOs = new ArrayList<UserChallengesDTO>();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Retrieving Challenge question from the user profile.");
                }
                List<String> challengesUris = this.getChallengeQuestionUris(userName, tenantId);
                for (int i = 0; i < challengesUris.size(); ++i) {
                    String challengesUri = challengesUris.get(i).trim();
                    String challengeValue = Utils.getClaimFromUserStoreManager(userName, tenantId, challengesUri);
                    String[] challengeValues = challengeValue.split(IdentityMgtConfig.getInstance().getChallengeQuestionSeparator());
                    if (challengeValues == null || challengeValues.length != 2) continue;
                    dto = new UserChallengesDTO();
                    dto.setId(challengesUri);
                    dto.setQuestion(challengeValues[0].trim());
                    if (adminService) {
                        dto.setAnswer(challengeValues[1].trim());
                    }
                    dto.setOrder(i);
                    dto.setPrimary(false);
                    challengesDTOs.add(dto);
                }
            }
            catch (Exception e) {
                String msg = "No associated challenge question found for the user";
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)msg, (Throwable)e);
            }
        }
        return dto;
    }

    public UserChallengesDTO getUserChallengeQuestion(String userName, int tenantId, String challengesUri) throws IdentityMgtServiceException {
        UserChallengesDTO dto = null;
        try {
            String challengeValue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrieving Challenge question from the user profile.");
            }
            if ((challengeValue = Utils.getClaimFromUserStoreManager(userName, tenantId, challengesUri)) != null) {
                String[] challengeValues = challengeValue.split(IdentityMgtConfig.getInstance().getChallengeQuestionSeparator());
                if (challengeValues != null && challengeValues.length == 2) {
                    dto = new UserChallengesDTO();
                    dto.setId(challengesUri);
                    dto.setQuestion(challengeValues[0].trim());
                }
            } else {
                dto = new UserChallengesDTO();
                dto.setError("Challenge questions have not been answered by the user: " + userName);
            }
        }
        catch (Exception e) {
            String errorMsg = "Error while getting the challenge questions for the user: " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMsg, (Throwable)e);
            }
            dto = new UserChallengesDTO();
            dto.setError(errorMsg);
            throw new IdentityMgtServiceException(errorMsg, e);
        }
        return dto;
    }

    public ChallengeQuestionIdsDTO getUserChallengeQuestionIds(String userName, int tenantId) throws IdentityMgtServiceException {
        List<String> challengesUris;
        ChallengeQuestionIdsDTO dto = new ChallengeQuestionIdsDTO();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving Challenge question ids from the user profile.");
        }
        if ((challengesUris = this.getChallengeQuestionUris(userName, tenantId)).isEmpty()) {
            String msg = "No associated challenge question found for the user";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            throw new IdentityMgtServiceException(msg);
        }
        String[] ids = new String[challengesUris.size()];
        for (int i = 0; i < challengesUris.size(); ++i) {
            ids[i] = challengesUris.get(i).trim();
        }
        dto.setIds(ids);
        return dto;
    }

    public List<String> getChallengeQuestionUris(String userName, int tenantId) throws IdentityMgtServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Challenge Question from the user profile.");
        }
        ArrayList<String> challenges = new ArrayList<String>();
        String claimValue = null;
        try {
            claimValue = Utils.getClaimFromUserStoreManager(userName, tenantId, "http://wso2.org/claims/challengeQuestionUris");
        }
        catch (IdentityException e) {
            throw new IdentityMgtServiceException("Error while getting cliams.", e);
        }
        if (claimValue != null) {
            String[] challengesUris = claimValue.contains(IdentityMgtConfig.getInstance().getChallengeQuestionSeparator()) ? claimValue.split(IdentityMgtConfig.getInstance().getChallengeQuestionSeparator()) : new String[]{claimValue.trim()};
            for (String challengesUri : challengesUris) {
                if (!StringUtils.isNotBlank((String)challengesUri)) continue;
                challenges.add(challengesUri.trim());
            }
        }
        return challenges;
    }

    public int getNoOfChallengeQuestions(String userName, int tenantId) throws IdentityMgtServiceException {
        List<String> questions = this.getChallengeQuestionUris(userName, tenantId);
        return questions.size();
    }

    public void setChallengesOfUser(String userName, int tenantId, UserChallengesDTO[] challengesDTOs) throws IdentityException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Challenge Question from the user profile.");
            }
            ArrayList<String> challengesUris = new ArrayList<String>();
            String challengesUrisValue = "";
            String separator = IdentityMgtConfig.getInstance().getChallengeQuestionSeparator();
            Map oldClaims = new HashMap();
            HashMap<String, String> newClaims = new HashMap<String, String>();
            String[] requestclaims = new String[challengesDTOs.length];
            int x = 0;
            for (UserChallengesDTO claimDto : challengesDTOs) {
                requestclaims[x++] = claimDto.getId();
            }
            UserStoreManager userStoreManager = null;
            RealmService realmService = IdentityMgtServiceComponent.getRealmService();
            try {
                if (realmService.getTenantUserRealm(tenantId) != null) {
                    userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
                }
            }
            catch (Exception e) {
                String msg = "Error retrieving the user store manager for the tenant";
                log.error((Object)msg, (Throwable)e);
                throw IdentityException.error((String)msg, (Throwable)e);
            }
            if (userStoreManager != null) {
                oldClaims = userStoreManager.getUserClaimValues(userName, requestclaims, null);
            }
            if (!ArrayUtils.isEmpty((Object[])challengesDTOs)) {
                for (UserChallengesDTO dto : challengesDTOs) {
                    if (dto.getId() == null || dto.getQuestion() == null || dto.getAnswer() == null) continue;
                    String oldClaimValue = (String)oldClaims.get(dto.getId());
                    if (oldClaimValue != null && oldClaimValue.contains(separator)) {
                        String claimValue;
                        String oldAnswer = oldClaimValue.split(separator)[1];
                        if (!oldAnswer.trim().equals(dto.getAnswer().trim()) && !oldClaimValue.equals(claimValue = dto.getQuestion().trim() + separator + Utils.doHash(dto.getAnswer().trim().toLowerCase()))) {
                            newClaims.put(dto.getId().trim(), claimValue);
                        }
                    } else {
                        String claimValue = dto.getQuestion().trim() + separator + Utils.doHash(dto.getAnswer().trim().toLowerCase());
                        newClaims.put(dto.getId().trim(), claimValue);
                    }
                    challengesUris.add(dto.getId().trim());
                }
                for (String challengesUri : challengesUris) {
                    if ("".equals(challengesUrisValue)) {
                        challengesUrisValue = challengesUri;
                        continue;
                    }
                    challengesUrisValue = challengesUrisValue + IdentityMgtConfig.getInstance().getChallengeQuestionSeparator() + challengesUri;
                }
                newClaims.put("http://wso2.org/claims/challengeQuestionUris", challengesUrisValue);
                userStoreManager.setUserClaimValues(userName, newClaims, "default");
            }
        }
        catch (UserStoreException e) {
            String msg = "No associated challenge question found for the user";
            throw IdentityException.error((String)msg, (Throwable)e);
        }
    }

    public boolean verifyChallengeQuestion(String userName, int tenantId, UserChallengesDTO[] challengesDTOs) {
        boolean verification = false;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Challenge Question from the user profile.");
            }
            UserChallengesDTO[] storedDto = this.getChallengeQuestionsOfUser(userName, tenantId, true);
            for (UserChallengesDTO challengesDTO : challengesDTOs) {
                if (challengesDTO.getAnswer() == null || challengesDTO.getAnswer().trim().length() < 1) {
                    return false;
                }
                for (UserChallengesDTO dto : storedDto) {
                    if ((challengesDTO.getId() == null || !challengesDTO.getId().trim().equals(dto.getId())) && (challengesDTO.getQuestion() == null || !challengesDTO.getQuestion().trim().equals(dto.getQuestion()))) continue;
                    String hashedAnswer = Utils.doHash(challengesDTO.getAnswer().trim().toLowerCase());
                    if (hashedAnswer.equals(dto.getAnswer())) {
                        verification = true;
                        continue;
                    }
                    return false;
                }
            }
        }
        catch (Exception e) {
            String msg = "No associated challenge question found for the user";
            log.debug((Object)msg, (Throwable)e);
        }
        return verification;
    }

    public boolean verifyUserChallengeAnswer(String userName, int tenantId, UserChallengesDTO challengesDTO) {
        boolean verification = false;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Challenge Question from the user profile.");
            }
            UserChallengesDTO[] storedDto = this.getChallengeQuestionsOfUser(userName, tenantId, true);
            if (challengesDTO.getAnswer() == null || challengesDTO.getAnswer().trim().length() < 1) {
                return false;
            }
            for (UserChallengesDTO dto : storedDto) {
                if (!dto.getId().equals(challengesDTO.getId())) continue;
                String hashedAnswer = Utils.doHash(challengesDTO.getAnswer().trim().toLowerCase());
                if (hashedAnswer.equals(dto.getAnswer())) {
                    verification = true;
                    continue;
                }
                return false;
            }
        }
        catch (Exception e) {
            String msg = "No associated challenge question found for the user";
            log.debug((Object)msg, (Throwable)e);
        }
        return verification;
    }

    public boolean verifyUserChallengeAnswers(String userName, int tenantId, UserChallengesDTO[] userChallengesDTOs) {
        boolean verification = true;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"verifying challenge question answers");
            }
            UserChallengesDTO[] storedUserChallengeDTOs = this.getChallengeQuestionsOfUser(userName, tenantId, true);
            int count = 0;
            block2: for (UserChallengesDTO storedUserChallengesDTO : storedUserChallengeDTOs) {
                for (UserChallengesDTO receivedUserChallengesDTO : userChallengesDTOs) {
                    if (!storedUserChallengesDTO.getId().equals(receivedUserChallengesDTO.getId())) continue;
                    ++count;
                    String hashedAnswer = Utils.doHash(receivedUserChallengesDTO.getAnswer().trim().toLowerCase());
                    if (hashedAnswer.equals(storedUserChallengesDTO.getAnswer())) continue;
                    verification = false;
                    continue block2;
                }
            }
            if (verification) {
                verification = storedUserChallengeDTOs.length == count;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while verifying challenge question answers", (Throwable)e);
            verification = false;
        }
        return verification;
    }

    public UserChallengesDTO[] getPrimaryChallengeQuestionsOfUser(String userName, int tenantId) {
        ArrayList<UserChallengesDTO> challengesDTOs = new ArrayList<UserChallengesDTO>();
        try {
            String[] challenges;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Challenge Question from the user profile.");
            }
            String claimValue = Utils.getClaimFromUserStoreManager(userName, tenantId, "http://wso2.org/claims/primaryChallengeQuestion");
            for (String challenge : challenges = claimValue.split(IdentityMgtConfig.getInstance().getChallengeQuestionSeparator())) {
                UserChallengesDTO dto = new UserChallengesDTO();
                String question = challenge.substring(0, challenge.indexOf("="));
                dto.setQuestion(question);
                dto.setPrimary(true);
                challengesDTOs.add(dto);
            }
        }
        catch (Exception e) {
            String msg = "No associated challenge question found for the user";
            log.debug((Object)msg, (Throwable)e);
        }
        if (!challengesDTOs.isEmpty()) {
            return challengesDTOs.toArray(new UserChallengesDTO[challengesDTOs.size()]);
        }
        return new UserChallengesDTO[0];
    }

    public boolean verifyPrimaryChallengeQuestion(String userName, int tenantId, UserChallengesDTO[] userChallengesDTOs) {
        boolean verification = false;
        try {
            String claimValue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Challenge Question from the user profile for user " + userName));
            }
            if ((claimValue = Utils.getClaimFromUserStoreManager(userName, tenantId, "http://wso2.org/claims/primaryChallengeQuestion")) == null) {
                log.debug((Object)("No associated challenge question found for the user " + userName));
                return false;
            }
            String[] challenges = claimValue.split(IdentityMgtConfig.getInstance().getChallengeQuestionSeparator());
            HashMap<String, String> challengeMap = new HashMap<String, String>();
            for (int i = 0; i < challenges.length; i += 2) {
                challengeMap.put(challenges[i], challenges[i + 1]);
            }
            for (UserChallengesDTO userChallengesDTO : userChallengesDTOs) {
                for (Map.Entry entry : challengeMap.entrySet()) {
                    String challengeQuestion = (String)entry.getKey();
                    if (!challengeQuestion.equals(userChallengesDTO.getQuestion().trim())) continue;
                    String challengeAnswer = (String)entry.getValue();
                    if (challengeAnswer.equals(Utils.doHash(userChallengesDTO.getAnswer().trim().toLowerCase()))) {
                        verification = true;
                        continue;
                    }
                    return false;
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)("No associated challenge question found for the user " + userName), (Throwable)e);
        }
        return verification;
    }
}

