/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.ntask;

import com.hazelcast.core.IExecutorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskManager;
import org.apache.synapse.task.TaskManagerObserver;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.ServerStartupHandler;
import org.wso2.carbon.mediation.ntask.NTaskAdapter;
import org.wso2.carbon.mediation.ntask.TaskBuilder;
import org.wso2.carbon.mediation.ntask.TaskServiceObserver;
import org.wso2.carbon.mediation.ntask.internal.NtaskService;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.impl.LocalTaskActionListener;
import org.wso2.carbon.ntask.core.impl.clustered.ClusteredTaskManager;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.utils.CarbonUtils;

public class NTaskTaskManager
implements TaskManager,
TaskServiceObserver,
ServerStartupHandler {
    private final Object lock = new Object();
    private static final Log logger = LogFactory.getLog((String)NTaskTaskManager.class.getName());
    private static final String NTASK_P2P_COMM_EXECUTOR = "__NTASK_P2P_COMM_EXECUTOR__";
    private String name;
    private boolean initialized = false;
    private org.wso2.carbon.ntask.core.TaskManager taskManager;
    private final Map<String, Object> properties = new HashMap<String, Object>(5);
    protected final Properties configProperties = new Properties();
    private final List<TaskManagerObserver> observers = new ArrayList<TaskManagerObserver>();
    private final List<TaskDescription> taskQueue = new ArrayList<TaskDescription>();
    private final Object taskQueueLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(TaskDescription taskDescription) {
        TaskInfo taskInfo;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#schedule Scheduling task : " + this.taskId(taskDescription)));
        }
        try {
            taskInfo = TaskBuilder.buildTaskInfo(taskDescription, this.properties);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("#schedule Could not build task info object of task : " + this.taskId(taskDescription) + ". Error: " + e.getLocalizedMessage()), (Throwable)e);
            }
            Object object = this.lock;
            synchronized (object) {
                this.queueTask(taskDescription);
            }
            return false;
        }
        if (!this.isInitialized()) {
            Object e = this.lock;
            synchronized (e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("#schedule Added pending task : " + this.taskId(taskDescription)));
                }
                this.queueTask(taskDescription);
            }
            return false;
        }
        try {
            Object e = this.lock;
            synchronized (e) {
                if (this.taskManager == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("#schedule Could not schedule task " + this.taskId(taskDescription) + ". Task manager is not available."));
                    }
                    this.queueTask(taskDescription);
                    return false;
                }
                this.taskManager.registerTask(taskInfo);
                if (NtaskService.getTaskService().isServerInit()) {
                    this.taskManager.scheduleTask(taskInfo.getName());
                }
                this.removeTask(taskDescription);
            }
            logger.info((Object)("Scheduled task " + this.taskId(taskDescription)));
        }
        catch (Exception e) {
            logger.error((Object)("Scheduling task [" + this.taskId(taskDescription) + "::" + taskDescription.getTaskGroup() + "] FAILED. Error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reschedule(String taskName, TaskDescription taskDescription) {
        if (!this.isInitialized()) {
            return false;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.taskManager == null) {
                    logger.warn((Object)("#reschedule Could not reschedule task [" + taskName + "]. Task manager is not available."));
                    return false;
                }
                TaskInfo taskInfo = this.taskManager.getTask(taskName);
                TaskDescription description = TaskBuilder.buildTaskDescription(taskInfo);
                taskInfo = TaskBuilder.buildTaskInfo(description, this.properties);
                this.taskManager.registerTask(taskInfo);
                TaskService taskService = NtaskService.getTaskService();
                if (taskService != null && taskService.isServerInit()) {
                    this.taskManager.rescheduleTask(taskInfo.getName());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String taskName) {
        if (!this.isInitialized()) {
            return false;
        }
        if (taskName == null) {
            return false;
        }
        String[] list = taskName.split("::");
        String name = list[0];
        if (name == null || "".equals(name)) {
            throw new SynapseTaskException("Task name is null. ", logger);
        }
        String group = null;
        if (list.length > 1) {
            group = list[1];
        }
        if (group == null || "".equals(group)) {
            group = "synapse.simple.quartz";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"#delete Task group is null or empty , using default group :synapse.simple.quartz");
            }
        }
        try {
            boolean deleted;
            Object object = this.lock;
            synchronized (object) {
                if (this.taskManager == null) {
                    logger.warn((Object)("#delete Could not delete task [" + taskName + "]. Task manager is not available."));
                    return false;
                }
                deleted = this.taskManager.deleteTask(name);
                NTaskAdapter.removeProperty(taskName);
            }
            logger.debug((Object)("Deleted task [" + name + "] [" + deleted + "]"));
            return deleted;
        }
        catch (Exception e) {
            logger.error((Object)("Cannot delete task [" + taskName + "::" + group + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause(String taskName) {
        if (!this.isInitialized()) {
            return false;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.taskManager == null) {
                    logger.warn((Object)("#pause Could not pause task [" + taskName + "]. Task manager is not available."));
                    return false;
                }
                this.taskManager.pauseTask(taskName);
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Cannot pause task [" + taskName + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseAll() {
        if (!this.isInitialized()) {
            return false;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.taskManager == null) {
                    logger.warn((Object)"#pauseAll Could not pause any task. Task manager is not available.");
                    return false;
                }
                List taskList = this.taskManager.getAllTasks();
                for (TaskInfo taskInfo : taskList) {
                    this.taskManager.pauseTask(taskInfo.getName());
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Cannot pause all tasks. Error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume(String taskName) {
        if (!this.isInitialized()) {
            return false;
        }
        if (taskName == null) {
            return false;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.taskManager == null) {
                    logger.warn((Object)("#resume Could not resume task [" + taskName + "]. Task manager is not available."));
                    return false;
                }
                this.taskManager.resumeTask(taskName);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Cannot resume task [" + taskName + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeAll() {
        if (!this.isInitialized()) {
            return false;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.taskManager == null) {
                    logger.warn((Object)"#resumeAll Could not resume any task. Task manager is not available.");
                    return false;
                }
                List taskList = this.taskManager.getAllTasks();
                for (TaskInfo taskInfo : taskList) {
                    this.taskManager.resumeTask(taskInfo.getName());
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Cannot resume all tasks. Error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDescription getTask(String taskName) {
        if (!this.isInitialized()) {
            return null;
        }
        try {
            TaskInfo taskInfo;
            Object object = this.lock;
            synchronized (object) {
                if (this.taskManager == null) {
                    logger.warn((Object)("#getTask Could not retrieve task [" + taskName + "]. Task manager is not available."));
                    return null;
                }
                taskInfo = this.taskManager.getTask(taskName);
            }
            return TaskBuilder.buildTaskDescription(taskInfo);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot return task [" + taskName + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTaskNames() {
        if (!this.isInitialized()) {
            return new String[0];
        }
        try {
            List taskList;
            Object object = this.lock;
            synchronized (object) {
                if (this.taskManager == null) {
                    logger.warn((Object)"#getTaskNames Could not query task names. Task manager is not available.");
                    return new String[0];
                }
                taskList = this.taskManager.getAllTasks();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (TaskInfo taskInfo : taskList) {
                result.add(taskInfo.getName());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot return task list. Error: " + e.getLocalizedMessage()), (Throwable)e);
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Properties properties) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Object[] taskDescriptions;
                TaskService taskService = NtaskService.getTaskService();
                if (taskService == null || NtaskService.getCcServiceInstance() == null) {
                    NtaskService.addObserver(this);
                    return false;
                }
                this.taskManager = this.getTaskManager(false);
                if (this.taskManager == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("#init Could not initialize task manager. " + this.managerId()));
                    }
                    return false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("#init Obtained Carbon task manager " + this.managerId()));
                }
                this.initialized = true;
                if (this.isTaskRunningNode()) {
                    taskService.registerTaskType("ESB_TASK");
                    this.updateAndCleanupObservers();
                }
                logger.info((Object)("Initialized task manager. Tenant [" + this.getCurrentTenantId() + "]"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("#init Initialized task manager : " + this.managerId()));
                    logger.debug((Object)("#init Scheduling existing tasks if any. : " + this.managerId()));
                }
                for (Object d : taskDescriptions = this.pendingTasks()) {
                    this.schedule((TaskDescription)d);
                }
                return true;
            }
            catch (Exception e) {
                logger.error((Object)("Cannot initialize task manager. Error: " + e.getLocalizedMessage()), (Throwable)e);
                this.initialized = false;
            }
        }
        return false;
    }

    private boolean isTaskRunningNode() {
        boolean isWorkerNode;
        boolean isStandaloneNode = NtaskService.getCcServiceInstance().getServerConfigContext().getAxisConfiguration().getClusteringAgent() == null;
        boolean bl = isWorkerNode = !isStandaloneNode && CarbonUtils.isWorkerNode();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#init standalone node: [" + isStandaloneNode + "] worker node: [" + isWorkerNode + "] " + this.managerId()));
        }
        if (isStandaloneNode || isWorkerNode) {
            return true;
        }
        Parameter parameter = NtaskService.getCcServiceInstance().getServerConfigContext().getAxisConfiguration().getClusteringAgent().getParameter("clusteringPattern");
        if (parameter == null || parameter.getValue() == null || parameter.getValue().toString().isEmpty()) {
            logger.warn((Object)"clusteringPattern parameter not configured correctly in clustering configuration, hence defaults to worker manager clustering pattern, and since this node is a manager node, skips running tasks in this node");
            return false;
        }
        if (parameter.getValue().toString().equals("WorkerManager")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"clustering pattern is worker manager clustering pattern, and this node is a manager node, hence skip running tasks");
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Non worker manager clustering pattern mentioned, hence running tasks in this node");
        }
        return true;
    }

    @Override
    public boolean update(Map<String, Object> parameters) {
        return this.init(parameters == null || !parameters.containsKey("init.properties") ? null : (Properties)parameters.get("init.properties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.lock;
        synchronized (object) {
            return this.initialized;
        }
    }

    public boolean start() {
        return this.isInitialized();
    }

    public boolean stop() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningTaskCount() {
        if (!this.isInitialized()) {
            return -1;
        }
        String[] names = this.getTaskNames();
        int count = 0;
        try {
            for (String name : names) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.taskManager == null) {
                        logger.warn((Object)"#getRunningTaskCount Could not determine the number of running tasks. Task manager is not available.");
                        return -1;
                    }
                    if (this.taskManager.getTaskState(name).equals((Object)TaskManager.TaskState.NORMAL)) {
                        ++count;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Cannot return running task count. Error: " + e.getLocalizedMessage()), (Throwable)e);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRunningTaskList() {
        if (!this.isInitialized()) {
            return null;
        }
        String[] names = this.getTaskNames();
        ArrayList<String> runningTaskList = new ArrayList<String>();
        try {
            for (String name : names) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.taskManager.getTaskState(name).equals((Object)TaskManager.TaskState.NORMAL)) {
                        runningTaskList.add(name);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Cannot return running task list. Error: " + e.getLocalizedMessage()), (Throwable)e);
        }
        return runningTaskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskRunning(Object o) {
        if (!this.isInitialized()) {
            return false;
        }
        if (!(o instanceof String)) {
            return false;
        }
        String taskName = (String)o;
        Object object = this.lock;
        synchronized (object) {
            if (this.taskManager == null) {
                logger.warn((Object)("#isTaskRunning Could not determine the state of the task [" + taskName + "]. Task manager is not available."));
                return false;
            }
            try {
                return this.taskManager.getTaskState(taskName).equals((Object)TaskManager.TaskState.NORMAL);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot return task status [" + taskName + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProperties(Map<String, Object> properties) {
        if (properties == null) {
            return false;
        }
        for (String key : properties.keySet()) {
            Object object = this.lock;
            synchronized (object) {
                this.properties.put(key, properties.get(key));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProperty(String name, Object property) {
        if (name == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            this.properties.put(name, property);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        if (name == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.properties.get(name);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderClass() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConfigurationProperties() {
        Object object = this.lock;
        synchronized (object) {
            return this.configProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.configProperties.putAll((Map<?, ?>)properties);
        }
    }

    private org.wso2.carbon.ntask.core.TaskManager getTaskManager(boolean system) throws Exception {
        TaskService taskService = NtaskService.getTaskService();
        if (taskService == null) {
            return null;
        }
        return taskService.getTaskManager("ESB_TASK");
    }

    private int getCurrentTenantId() {
        return CarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public static int tenantId() {
        return CarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public void invoke() {
        this.init(null);
    }

    private String taskId(TaskDescription description) {
        return "[NTask::" + this.getCurrentTenantId() + "::" + description.getName() + "]";
    }

    private String managerId() {
        return "[NTaskTaskManager::" + this.getCurrentTenantId() + " ::" + this.hashCode() + "]";
    }

    public void addObserver(TaskManagerObserver o) {
        if (this.observers.contains(o)) {
            return;
        }
        this.observers.add(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskDeactivated(String taskName) {
        if (!this.isInitialized()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.taskManager == null) {
                logger.warn((Object)("#isTaskRunning Could not determine the state of the task [" + taskName + "]. Task manager is not available."));
                return false;
            }
            try {
                return this.taskManager.getTaskState(taskName).equals((Object)TaskManager.TaskState.PAUSED);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cannot return task status [" + taskName + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskBlocked(String taskName) {
        if (!this.isInitialized()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.taskManager == null) {
                logger.warn((Object)("#isTaskRunning Could not determine the state of the task [" + taskName + "]. Task manager is not available."));
                return false;
            }
            try {
                return this.taskManager.getTaskState(taskName).equals((Object)TaskManager.TaskState.BLOCKED);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot return task status [" + taskName + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskRunning(String taskName) {
        if (!this.isInitialized()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.taskManager == null) {
                logger.warn((Object)("#isTaskRunning Could not determine the state of the task [" + taskName + "]. Task manager is not available."));
                return false;
            }
            try {
                return this.taskManager.getTaskState(taskName).equals((Object)TaskManager.TaskState.NORMAL);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot return task status [" + taskName + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskExist(String taskName) {
        if (!this.isInitialized()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.taskManager == null) {
                logger.warn((Object)("#isTaskExist Could not determine the state of the task [" + taskName + "]. Task manager is not available."));
                return false;
            }
            try {
                return !this.taskManager.getTaskState(taskName).equals((Object)TaskManager.TaskState.NONE);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot return task status [" + taskName + "]. Error: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return false;
    }

    private void updateAndCleanupObservers() {
        Iterator<TaskManagerObserver> i = this.observers.iterator();
        while (i.hasNext()) {
            TaskManagerObserver observer = i.next();
            observer.update();
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueTask(TaskDescription description) {
        Object object = this.taskQueueLock;
        synchronized (object) {
            logger.debug((Object)("#queueTask Queuing task " + this.taskId(description)));
            if (!this.taskQueue.contains(description)) {
                return this.taskQueue.add(description);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTask(TaskDescription description) {
        Object object = this.taskQueueLock;
        synchronized (object) {
            logger.debug((Object)("#removeTask removing task " + this.taskId(description)));
            return this.taskQueue.remove(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] pendingTasks() {
        Object object = this.taskQueueLock;
        synchronized (object) {
            return this.taskQueue.toArray();
        }
    }

    public void sendClusterMessage(Callable<Void> callable) {
        if (this.taskManager instanceof ClusteredTaskManager) {
            try {
                IExecutorService executorService = ((ClusteredTaskManager)this.taskManager).getClusterComm().getHazelcast().getExecutorService(NTASK_P2P_COMM_EXECUTOR);
                executorService.submitToAllMembers(callable);
            }
            catch (TaskException e) {
                logger.error((Object)"Can not submit a cluster message.", (Throwable)e);
            }
        }
    }

    public void registerListener(final LocalTaskActionListener listener, final String taskName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (NTaskTaskManager.this.taskManager == null) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                NTaskTaskManager.this.taskManager.registerLocalTaskActionListener(listener, taskName);
            }
        }).start();
    }
}

