/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.Helper;

abstract class CommandLine {
    protected String commandName;
    protected CmdLineNotificationHandler notificationHandler;
    protected Process process;

    protected CommandLine(String commandName, CmdLineNotificationHandler notificationHandler) {
        this.commandName = commandName;
        this.notificationHandler = notificationHandler;
    }

    String version() throws CmdLineException {
        CmdArguments args = new CmdArguments();
        args.add("--version");
        return this.execString(args, false);
    }

    private Process execProcess(CmdArguments svnArguments) throws CmdLineException {
        int svnArgsLen = svnArguments.size();
        String[] cmdline = new String[svnArgsLen + 1];
        cmdline[0] = this.commandName;
        StringBuffer svnCommand = new StringBuffer();
        boolean nextIsPassword = false;
        for (int i = 0; i < svnArgsLen; ++i) {
            Object arg;
            if (i != 0) {
                svnCommand.append(' ');
            }
            if ((arg = svnArguments.get(i)) != null) {
                arg = arg.toString();
            }
            if ("".equals(arg)) {
                arg = "\"\"";
            }
            if (nextIsPassword) {
                svnCommand.append("*******");
                nextIsPassword = false;
            } else {
                svnCommand.append(arg);
            }
            if ("--password".equals(arg)) {
                nextIsPassword = true;
            }
            cmdline[i + 1] = (String)arg;
        }
        this.notificationHandler.logCommandLine(svnCommand.toString());
        try {
            this.process = Runtime.getRuntime().exec(cmdline, this.getEnvironmentVariables());
            return this.process;
        }
        catch (IOException e) {
            throw new CmdLineException(e);
        }
    }

    protected String[] getEnvironmentVariables() {
        String path = CmdLineClientAdapter.getEnvironmentVariable("PATH");
        String systemRoot = CmdLineClientAdapter.getEnvironmentVariable("SystemRoot");
        String aprIconv = CmdLineClientAdapter.getEnvironmentVariable("APR_ICONV_PATH");
        int i = 3;
        if (path != null) {
            ++i;
        }
        if (systemRoot != null) {
            ++i;
        }
        if (aprIconv != null) {
            ++i;
        }
        String[] lcVars = this.getLocaleVariables();
        String[] env = new String[i + lcVars.length];
        i = 0;
        env[i] = "LC_ALL=";
        env[++i] = "LC_MESSAGES=C";
        env[++i] = "LC_TIME=C";
        ++i;
        if (path != null) {
            env[i] = "PATH=" + path;
            ++i;
        }
        if (systemRoot != null) {
            env[i] = "SystemRoot=" + systemRoot;
            ++i;
        }
        if (aprIconv != null) {
            env[i] = "APR_ICONV_PATH=" + aprIconv;
            ++i;
        }
        for (int j = 0; j < lcVars.length; ++j) {
            env[i] = lcVars[j];
            ++i;
        }
        return env;
    }

    private String[] getLocaleVariables() {
        String LC_ALL = CmdLineClientAdapter.getEnvironmentVariable("LC_ALL");
        if ((LC_ALL == null || LC_ALL.length() == 0) && (LC_ALL = CmdLineClientAdapter.getEnvironmentVariable("LANG")) == null) {
            LC_ALL = "";
        }
        String[] lcVarNames = new String[]{"LC_CTYPE", "LC_NUMERIC", "LC_COLLATE", "LC_MONETARY", "LC_PAPER", "LC_NAME", "LC_ADDRESS", "LC_TELEPHONE", "LC_MEASUREMENT", "LC_IDENTIFICATION"};
        ArrayList<String> variables = new ArrayList<String>(lcVarNames.length);
        for (int i = 0; i < lcVarNames.length; ++i) {
            String varValue = CmdLineClientAdapter.getEnvironmentVariable(lcVarNames[i]);
            variables.add(lcVarNames[i] + "=" + (varValue != null ? varValue : LC_ALL));
        }
        return variables.toArray(new String[variables.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpProcessStreams(Process proc, StreamPumper outPumper, StreamPumper errPumper) {
        new Thread(outPumper).start();
        new Thread(errPumper).start();
        try {
            outPumper.waitFor();
            errPumper.waitFor();
        }
        catch (InterruptedException ignored) {
            this.notificationHandler.logError("Command output processing interrupted !");
        }
        finally {
            try {
                proc.getInputStream().close();
                proc.getOutputStream().close();
                proc.getErrorStream().close();
            }
            catch (IOException ioex) {}
        }
    }

    protected String execString(CmdArguments svnArguments, boolean coalesceLines) throws CmdLineException {
        Process proc = this.execProcess(svnArguments);
        CharacterStreamPumper outPumper = new CharacterStreamPumper(proc.getInputStream(), coalesceLines);
        CharacterStreamPumper errPumper = new CharacterStreamPumper(proc.getErrorStream(), false);
        this.pumpProcessStreams(proc, outPumper, errPumper);
        try {
            String errMessage = ((Object)errPumper).toString();
            if (errMessage.length() > 0) {
                throw new CmdLineException(errMessage);
            }
            String outputString = ((Object)outPumper).toString();
            this.notifyFromSvnOutput(outputString);
            return outputString;
        }
        catch (CmdLineException e) {
            this.notificationHandler.logException(e);
            throw e;
        }
    }

    protected byte[] execBytes(CmdArguments svnArguments, boolean assumeUTF8) throws CmdLineException {
        Process proc = this.execProcess(svnArguments);
        ByteStreamPumper outPumper = new ByteStreamPumper(proc.getInputStream());
        CharacterStreamPumper errPumper = new CharacterStreamPumper(proc.getErrorStream(), false);
        this.pumpProcessStreams(proc, outPumper, errPumper);
        try {
            String errMessage = ((Object)errPumper).toString();
            if (errMessage.length() > 0) {
                throw new CmdLineException(errMessage);
            }
            byte[] bytes = outPumper.getBytes();
            String notifyMessage = "";
            if (assumeUTF8) {
                try {
                    notifyMessage = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {}
            } else {
                notifyMessage = new String(bytes);
            }
            this.notifyFromSvnOutput(notifyMessage);
            return bytes;
        }
        catch (CmdLineException e) {
            this.notificationHandler.logException(e);
            throw e;
        }
    }

    protected void execVoid(CmdArguments svnArguments) throws CmdLineException {
        this.execString(svnArguments, false);
    }

    protected InputStream execInputStream(CmdArguments svnArguments) throws CmdLineException {
        Process proc = this.execProcess(svnArguments);
        try {
            proc.getOutputStream().close();
            proc.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return proc.getInputStream();
    }

    protected void notifyFromSvnOutput(String svnOutput) {
        StringTokenizer st = new StringTokenizer(svnOutput, Helper.NEWLINE);
        int size = st.countTokens();
        for (int i = 1; i < size; ++i) {
            this.notificationHandler.logMessage(st.nextToken());
        }
        if (size > 0) {
            this.notificationHandler.logCompleted(st.nextToken());
        }
    }

    protected void stopProcess() {
        try {
            this.process.getInputStream().close();
            this.process.getOutputStream().close();
            this.process.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.process.destroy();
    }

    protected static class CmdArguments {
        private List args = new ArrayList();

        protected CmdArguments() {
        }

        protected void add(Object arg) {
            this.args.add(arg);
        }

        protected void addAuthInfo(String user, String pass) {
            if (user != null && user.length() > 0) {
                this.add("--username");
                this.add(user);
            }
            if (pass != null && pass.length() > 0) {
                this.add("--password");
                this.add(pass);
            }
            this.add("--non-interactive");
        }

        protected void addConfigInfo(String configDir) {
            if (configDir != null) {
                this.add("--config-dir");
                this.add(configDir);
            }
        }

        protected void addLogMessage(String message) {
            this.add("--force-log");
            this.add("-m");
            this.add(message != null ? message : "");
        }

        private int size() {
            return this.args.size();
        }

        private Object get(int index) {
            return this.args.get(index);
        }
    }

    private static class ByteStreamPumper
    extends StreamPumper {
        private InputStream bis;
        private ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private static final int BUFFER_LENGTH = 1024;
        private byte[] inputBuffer = new byte[1024];

        public ByteStreamPumper(InputStream is) {
            this.bis = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pumpStream() {
            try {
                int bytesRead;
                while ((bytesRead = this.bis.read(this.inputBuffer)) != -1) {
                    this.bytes.write(this.inputBuffer, 0, bytesRead);
                }
            }
            catch (IOException ex) {
                System.err.println("Problem occured during fetching the command output: " + ex.getMessage());
            }
            finally {
                try {
                    this.bytes.flush();
                    this.bytes.close();
                    this.bis.close();
                }
                catch (IOException iOException) {}
            }
        }

        public synchronized byte[] getBytes() {
            return this.bytes.toByteArray();
        }
    }

    private static class CharacterStreamPumper
    extends StreamPumper {
        private BufferedReader reader;
        private StringBuffer sb = new StringBuffer();
        private boolean coalesceLines = false;

        public CharacterStreamPumper(InputStream is, boolean coalesceLines) {
            this.reader = new BufferedReader(new InputStreamReader(is));
            this.coalesceLines = coalesceLines;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pumpStream() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    if (this.coalesceLines) {
                        this.sb.append(line);
                        continue;
                    }
                    this.sb.append(line).append(Helper.NEWLINE);
                }
            }
            catch (IOException ex) {
                System.err.println("Problem occured during fetching the command output: " + ex.getMessage());
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        public synchronized String toString() {
            return this.sb.toString();
        }
    }

    private static abstract class StreamPumper
    implements Runnable {
        private boolean finished;

        protected StreamPumper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.finished = false;
            }
            try {
                this.pumpStream();
            }
            finally {
                streamPumper = this;
                synchronized (streamPumper) {
                    this.finished = true;
                    this.notify();
                }
            }
        }

        protected abstract void pumpStream();

        public synchronized boolean isFinished() {
            return this.finished;
        }

        public synchronized void waitFor() throws InterruptedException {
            while (!this.isFinished()) {
                this.wait();
            }
        }
    }
}

