/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.module.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class CarbonContextCreatorHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(CarbonContextCreatorHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        if (carbonContext.getTenantDomain() != null || carbonContext.getTenantId() != -1) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (messageContext.getTransportIn() != null && messageContext.getTransportIn().getName() != null && !messageContext.getTransportIn().getName().contains("http")) {
            carbonContext.setTenantDomain("carbon.super");
            carbonContext.setTenantId(-1234);
            return Handler.InvocationResponse.CONTINUE;
        }
        EndpointReference epr = messageContext.getTo();
        if (epr != null && epr.getAddress() != null && epr.getAddress().contains("/t/")) {
            String tenantDomain = null;
            int tenantId = -1;
            try {
                String toAddress = epr.getAddress();
                String temp = toAddress.substring(toAddress.indexOf("/t/") + 3);
                tenantDomain = temp.substring(0, temp.indexOf("/"));
                carbonContext.setTenantDomain(tenantDomain, true);
            }
            catch (Exception e) {
                String msg = "Failed to populate the CarbonContext for tenant whose tenantDomain :" + tenantDomain + " and tenantID: " + tenantId;
                log.error((Object)msg, (Throwable)e);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

