/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.internal;

import java.sql.Connection;
import java.util.Hashtable;
import javax.sql.DataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.services.authentication.BasicAccessAuthenticator;
import org.wso2.carbon.core.services.authentication.CookieAuthenticator;
import org.wso2.carbon.core.services.authentication.ServerAuthenticator;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.server.admin.auth.AuthenticatorServerRegistry;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.internal.ServerAdminCommandProvider;
import org.wso2.carbon.server.admin.internal.ServerAdminDataHolder;
import org.wso2.carbon.server.admin.service.ServerAdmin;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.MBeanRegistrar;

@Component(name="serveradmin.service.component", immediate=true)
public class ServerAdminServiceComponent {
    private static final Log log = LogFactory.getLog(ServerAdminServiceComponent.class);
    private boolean registeredMBeans;
    public static final String SERVER_ADMIN_MODULE_NAME = "ServerAdminModule";
    private ConfigurationContext configContext;
    private ServerAdminDataHolder dataHolder = ServerAdminDataHolder.getInstance();

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            this.dataHolder.setRestartThreadContextClassloader(Thread.currentThread().getContextClassLoader());
            this.registerMBeans(this.dataHolder.getServerConfig());
            this.configContext.getAxisConfiguration().engageModule(SERVER_ADMIN_MODULE_NAME);
            this.setRegistryDriver(this.dataHolder.getRegistryService());
            BasicAccessAuthenticator basicAccessAuthenticator = new BasicAccessAuthenticator();
            Hashtable<String, String> basicAuthProps = new Hashtable<String, String>();
            basicAuthProps.put("authenticator.type", basicAccessAuthenticator.getAuthenticatorName());
            ctxt.getBundleContext().registerService(ServerAuthenticator.class.getName(), (Object)basicAccessAuthenticator, basicAuthProps);
            CookieAuthenticator cookieAuthenticator = new CookieAuthenticator();
            Hashtable cookieAuthProps = new Hashtable();
            basicAuthProps.put("authenticator.type", cookieAuthenticator.getAuthenticatorName());
            ctxt.getBundleContext().registerService(ServerAuthenticator.class.getName(), (Object)cookieAuthenticator, cookieAuthProps);
            AuthenticatorServerRegistry.init(ctxt.getBundleContext());
            ctxt.getBundleContext().registerService(IServerAdmin.class.getName(), (Object)new ServerAdmin(), null);
            ctxt.getBundleContext().registerService(CommandProvider.class.getName(), (Object)new ServerAdminCommandProvider(), null);
            log.debug((Object)"ServerAdmin bundle is activated");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate ServerAdmin bundle", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"ServerAdmin bundle is deactivated");
    }

    private void registerMBeans(ServerConfigurationService serverConfig) {
        if (this.registeredMBeans) {
            return;
        }
        MBeanRegistrar.registerMBean((Object)new ServerAdmin());
        this.registeredMBeans = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRegistryDriver(RegistryService registry) {
        block7: {
            try {
                if (registry.getConfigSystemRegistry().getRegistryContext() == null || registry.getConfigSystemRegistry().getRegistryContext().getDataAccessManager() == null) break block7;
                DataAccessManager dataAccessManager = registry.getConfigSystemRegistry().getRegistryContext().getDataAccessManager();
                if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
                    String msg = "Failed to obtain DB connection. Invalid data access manager.";
                    log.error((Object)msg);
                }
                try (Connection dbConnection = null;){
                    DataSource dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
                    dbConnection = dataSource.getConnection();
                    this.dataHolder.setRegistryDBDriver(dbConnection.getMetaData().getDriverName());
                }
            }
            catch (Exception e) {
                String msg = "Cannot get registry driver";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    @Reference(name="registry.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
        this.dataHolder.setRegistryDBDriver(null);
    }

    @Reference(name="user.realmservice.default", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        this.dataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        this.dataHolder.setRealmService(null);
        this.dataHolder.setUserManagerDBDriver(null);
    }

    @Reference(name="config.context.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.configContext = contextService.getServerConfigContext();
        this.dataHolder.setConfigContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        AxisModule statModule;
        AxisConfiguration axisConf = this.configContext.getAxisConfiguration();
        if (axisConf != null && (statModule = axisConf.getModule(SERVER_ADMIN_MODULE_NAME)) != null) {
            try {
                axisConf.disengageModule(statModule);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Failed disengage module: ServerAdminModule");
            }
        }
        this.configContext = null;
        this.dataHolder.setConfigContext(null);
    }

    @Reference(name="server.configuration", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfiguration) {
        this.dataHolder.setServerConfig(serverConfiguration);
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfiguration) {
        this.dataHolder.setServerConfig(null);
    }
}

