/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.server.admin.internal.ServerAdminDataHolder;
import org.wso2.carbon.server.admin.service.ServerAdmin;

public class ServerAdminCommandProvider
implements CommandProvider {
    private ServerAdmin serverAdmin = new ServerAdmin();

    public void _restartCarbon(CommandInterpreter ci) throws Exception {
        this.serverAdmin.restart();
    }

    public void _rcbn(CommandInterpreter ci) throws Exception {
        this._restartCarbon(ci);
    }

    public void _shutdownCarbon(CommandInterpreter ci) throws Exception {
        this.serverAdmin.shutdown();
    }

    public void _scbn(CommandInterpreter ci) throws Exception {
        this._shutdownCarbon(ci);
    }

    public void _restartCarbonGracefully(CommandInterpreter ci) throws Exception {
        this.serverAdmin.restartGracefully();
    }

    public void _rcbng(CommandInterpreter ci) throws Exception {
        this._restartCarbonGracefully(ci);
    }

    public void _shutdownCarbonGracefully(CommandInterpreter ci) throws Exception {
        this.serverAdmin.shutdownGracefully();
    }

    public void _scbng(CommandInterpreter ci) throws Exception {
        this._shutdownCarbonGracefully(ci);
    }

    public void _startCarbonMaintenance(CommandInterpreter ci) throws Exception {
        this.serverAdmin.startMaintenance();
    }

    public void _scbnm(CommandInterpreter ci) throws Exception {
        this._startCarbonMaintenance(ci);
    }

    public void _endCarbonMaintenance(CommandInterpreter ci) throws Exception {
        this.serverAdmin.endMaintenance();
    }

    public void _ecbnm(CommandInterpreter ci) throws Exception {
        this._endCarbonMaintenance(ci);
    }

    public void _listAdminServices(CommandInterpreter ci) throws Exception {
        HashMap services = ServerAdminDataHolder.getInstance().getConfigContext().getAxisConfiguration().getServices();
        System.out.println("Admin services deployed on this server:");
        int i = 1;
        for (AxisService axisService : services.values()) {
            if (!SystemFilter.isAdminService((AxisService)axisService)) continue;
            i = this.printServiceSummary(i, axisService);
        }
    }

    public void _listSystemServicesInfo(CommandInterpreter ci) throws Exception {
        HashMap services = ServerAdminDataHolder.getInstance().getConfigContext().getAxisConfiguration().getServices();
        System.out.println("\nAll System services deployed on this server.\n");
        AxisService[] axisServicesArray = services.values().toArray(new AxisService[services.size()]);
        for (int i = 0; i < axisServicesArray.length; ++i) {
            AxisService axisService = axisServicesArray[i];
            if (SystemFilter.isAdminService((AxisService)axisService) || SystemFilter.isHiddenService((AxisService)axisService)) {
                this.printServiceDetails(i + 1, axisService);
                Iterator itr = axisService.getOperations();
                while (itr.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)itr.next();
                    this.printOperationDetails(axisOperation);
                }
            }
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _dumpAdminServices(CommandInterpreter ci) throws Exception {
        HashMap services = ServerAdminDataHolder.getInstance().getConfigContext().getAxisConfiguration().getServices();
        boolean i = true;
        String adminServicesDir = System.getProperty("java.io.tmpdir") + File.separator + "adminServices";
        File file = new File(adminServicesDir);
        if (!file.exists() && !file.mkdirs()) {
            throw new Exception("Cannot create admin service dump");
        }
        for (AxisService axisService : services.values()) {
            if (!SystemFilter.isAdminService((AxisService)axisService)) continue;
            OutputStream op = null;
            try {
                File wsdl = new File(adminServicesDir + File.separator + axisService.getName() + ".wsdl");
                op = new FileOutputStream(wsdl);
                axisService.printWSDL(op);
            }
            finally {
                if (op == null) continue;
                op.close();
            }
        }
        System.out.println("Admin service info dump created at " + file.getAbsolutePath());
    }

    public void _listHiddenServices(CommandInterpreter ci) throws Exception {
        HashMap services = ServerAdminDataHolder.getInstance().getConfigContext().getAxisConfiguration().getServices();
        System.out.println("Hidden services deployed on this server:");
        int i = 1;
        for (AxisService axisService : services.values()) {
            i = this.printServiceSummary(i, axisService);
        }
    }

    private int printServiceSummary(int i, AxisService axisService) {
        System.out.print(i + ". " + axisService.getName() + ", " + axisService.getDocumentation() + ", ");
        for (String epr : axisService.getEPRs()) {
            System.out.print(epr + " ");
        }
        System.out.println();
        return ++i;
    }

    private void printServiceDetails(int i, AxisService axisService) {
        System.out.print(i + ". " + axisService.getName() + ", ");
        if (SystemFilter.isAdminService((AxisService)axisService)) {
            System.out.print("AdminService, ");
        }
        if (SystemFilter.isHiddenService((AxisService)axisService)) {
            System.out.print("HiddenService, ");
        }
        for (String epr : axisService.getEPRs()) {
            System.out.print(epr);
        }
        Parameter param = axisService.getParameter("AuthorizationAction");
        if (param != null) {
            System.out.println(", Permission - " + param.getValue().toString().trim());
        } else {
            System.out.println();
        }
    }

    private void printOperationDetails(AxisOperation axisOperation) {
        System.out.print("\t" + axisOperation.getName() + "()");
        Parameter param = axisOperation.getParameter("AuthorizationAction");
        if (param != null) {
            System.out.println(", Permission - " + param.getValue().toString().trim());
        } else {
            System.out.println();
        }
    }

    public String getHelp() {
        return "---Server Admin (WSO2 Carbon)---\n\tlistAdminServices - List admin services deployed on this Carbon instance\n\tlistHiddenServices - List hidden services deployed on this Carbon instance\n\tlistSystemServicesInfo - List all the systems services deployed on this Carbon instance\n\tdumpAdminServices - Dump all the wsdls of admin services on this Carbon instance\n\trestartCarbon - Forcefully restart this Carbon instance\n\trestartCarbonGracefully - Gracefully restart this Carbon instance. All client connections will be served before restarting the server\n\tshutdownCarbon - Forcefully shutdown this Carbon instance\n\tshutdownCarbonGracefully - Gracefully shutdown this Carbon instance. All client connections will be served before shutting down the server\n\tstartCarbonMaintenance - Switch a Carbon instance to maintenance mode.\n\tendCarbonMaintenance - Change the state of a Carbon instance from \"maintenance\" to \"normal\"\n";
    }
}

