/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.common;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.server.admin.common.ServerUpTime;

public class ServerData {
    private String javaRuntimeName;
    private String javaVMVersion;
    private String javaVMVendor;
    private String javaHome;
    private String javaVersion;
    private String osName;
    private String osVersion;
    private String userHome;
    private String userTimezone;
    private String userName;
    private String userCountry;
    private String axis2Location;
    private String serverName;
    private String repoLocation;
    private String carbonVersion = "undefined";
    private String serverStartTime;
    private String serverStartUpDuration;
    private ServerUpTime serverUpTime;
    private String serverIp;
    private String registryType;
    private String dbName;
    private String dbVersion;
    private String dbDriverName;
    private String dbDriverVersion;
    private String dbURL;
    private String remoteRegistryURL;
    private String remoteRegistryChroot;
    private boolean isTenantRequest;
    private boolean isRestricted = true;

    public ServerData(String serverName, String repoLocation, boolean isTenantRequest, boolean isRestricted) {
        this.isTenantRequest = isTenantRequest;
        this.isRestricted = isRestricted;
        this.init();
        this.serverName = serverName;
        if (!isTenantRequest) {
            this.repoLocation = repoLocation;
        }
    }

    public ServerData() {
    }

    private void init() {
        if (!this.isRestricted) {
            this.javaRuntimeName = System.getProperty("java.runtime.name");
            this.javaVMVersion = System.getProperty("java.vm.version");
            this.javaVMVendor = System.getProperty("java.vm.vendor");
            this.javaVersion = System.getProperty("java.version");
            this.carbonVersion = ServerConfiguration.getInstance().getFirstProperty("Version");
        } else {
            this.carbonVersion = null;
        }
        if (!this.isTenantRequest && !this.isRestricted) {
            this.userCountry = System.getProperty("user.country");
            this.userHome = System.getProperty("user.home");
            this.userTimezone = System.getProperty("user.timezone");
            this.userName = System.getProperty("user.name");
            this.osName = System.getProperty("os.name");
            this.osVersion = System.getProperty("os.version");
            this.javaHome = System.getProperty("java.home");
            this.axis2Location = this.axis2Location();
        }
    }

    private String axis2Location() {
        try {
            Class<?> clazz = Class.forName("org.apache.axis2.engine.AxisEngine");
            URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
            String location = url.toString();
            if (location.startsWith("jar")) {
                url = ((JarURLConnection)url.openConnection()).getJarFileURL();
                location = url.toString();
            }
            if (location.startsWith("file")) {
                File file = new File(url.getFile());
                return file.getAbsolutePath();
            }
            return url.toString();
        }
        catch (Throwable t) {
            return "an unknown location";
        }
    }

    public String getJavaRuntimeName() {
        return this.javaRuntimeName;
    }

    public void setJavaRuntimeName(String javaRuntimeName) {
        this.javaRuntimeName = javaRuntimeName;
    }

    public String getJavaVMVersion() {
        return this.javaVMVersion;
    }

    public void setJavaVMVersion(String javaVMVersion) {
        this.javaVMVersion = javaVMVersion;
    }

    public String getUserCountry() {
        return this.userCountry;
    }

    public void setUserCountry(String userCountry) {
        if (!this.isTenantRequest) {
            this.userCountry = userCountry;
        }
    }

    public String getJavaVMVendor() {
        return this.javaVMVendor;
    }

    public void setJavaVMVendor(String javaVMVendor) {
        this.javaVMVendor = javaVMVendor;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        if (!this.isTenantRequest) {
            this.osName = osName;
        }
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        if (!this.isTenantRequest) {
            this.osVersion = osVersion;
        }
    }

    public String getUserHome() {
        return this.userHome;
    }

    public void setUserHome(String userHome) {
        if (!this.isTenantRequest) {
            this.userHome = userHome;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        if (!this.isTenantRequest) {
            this.userName = userName;
        }
    }

    public String getUserTimezone() {
        return this.userTimezone;
    }

    public void setUserTimezone(String userTimezone) {
        if (!this.isTenantRequest) {
            this.userTimezone = userTimezone;
        }
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        if (!this.isTenantRequest) {
            this.javaHome = javaHome;
        }
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getAxis2Location() {
        return this.axis2Location;
    }

    public void setAxis2Location(String axis2Location) {
        if (!this.isTenantRequest) {
            this.axis2Location = axis2Location;
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getRepoLocation() {
        return this.repoLocation;
    }

    public void setRepoLocation(String repoLocation) {
        if (!this.isTenantRequest) {
            this.repoLocation = repoLocation;
        }
    }

    public String getCarbonVersion() {
        return this.carbonVersion;
    }

    public void setCarbonVersion(String carbonVersion) {
        this.carbonVersion = carbonVersion;
    }

    public String getServerStartTime() {
        return this.serverStartTime;
    }

    public void setServerStartTime(String serverStartTime) {
        if (!this.isTenantRequest) {
            this.serverStartTime = serverStartTime;
        }
    }

    public String getServerStartUpDuration() {
        return this.serverStartUpDuration;
    }

    public void setServerStartUpDuration(String serverStartUpDuration) {
        this.serverStartUpDuration = serverStartUpDuration;
    }

    public ServerUpTime getServerUpTime() {
        return this.serverUpTime;
    }

    public void setServerUpTime(ServerUpTime serverUpTime) {
        if (!this.isTenantRequest) {
            this.serverUpTime = serverUpTime;
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        if (!this.isTenantRequest) {
            this.serverIp = serverIp;
        }
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String db) {
        if (!this.isTenantRequest) {
            this.dbName = db;
        }
    }

    public String getDbURL() {
        return this.dbURL;
    }

    public void setDbURL(String dbURL) {
        if (!this.isTenantRequest) {
            this.dbURL = dbURL;
        }
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        if (!this.isTenantRequest) {
            this.dbVersion = dbVersion;
        }
    }

    public String getDbDriverName() {
        return this.dbDriverName;
    }

    public void setDbDriverName(String dbDriverName) {
        if (!this.isTenantRequest) {
            this.dbDriverName = dbDriverName;
        }
    }

    public String getDbDriverVersion() {
        return this.dbDriverVersion;
    }

    public void setDbDriverVersion(String dbDriverVersion) {
        if (!this.isTenantRequest) {
            this.dbDriverVersion = dbDriverVersion;
        }
    }

    public String getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(String registryType) {
        if (!this.isTenantRequest) {
            this.registryType = registryType;
        }
    }

    public String getRemoteRegistryURL() {
        return this.remoteRegistryURL;
    }

    public void setRemoteRegistryURL(String remoteRegistryURL) {
        if (!this.isTenantRequest) {
            this.remoteRegistryURL = remoteRegistryURL;
        }
    }

    public String getRemoteRegistryChroot() {
        return this.remoteRegistryChroot;
    }

    public void setRemoteRegistryChroot(String remoteRegistryChroot) {
        if (!this.isTenantRequest) {
            this.remoteRegistryChroot = remoteRegistryChroot;
        }
    }

    public String toString() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        return "JVM Name='" + this.javaRuntimeName + '\'' + ", JVM Version='" + this.javaVMVersion + '\'' + ", JVM Vendor='" + this.javaVMVendor + '\'' + ", Java Home='" + this.javaHome + '\'' + ", OS Name='" + this.osName + '\'' + ", OS Version='" + this.osVersion + '\'' + ", user.home='" + this.userHome + '\'' + ", user.timezone='" + this.userTimezone + '\'' + ", username='" + this.userName + '\'' + ", user.country='" + this.userCountry + '\'' + ", Axis2 Location='" + this.axis2Location + '\'' + ", Server Name='" + this.serverName + '\'' + ", Repository Location='" + this.repoLocation + '\'' + ", " + serverConfig.getFirstProperty("Name") + " version ='" + serverConfig.getFirstProperty("Version") + '\'';
    }
}

