/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication.internal.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.thrift.authentication.internal.generatedCode.AuthenticationException;
import org.wso2.carbon.identity.thrift.authentication.internal.persistance.ThriftAuthenticationJDBCPersistenceManager;

public class ThriftAuthenticationDatabaseUtil {
    private static final Log log = LogFactory.getLog(ThriftAuthenticationDatabaseUtil.class);

    private ThriftAuthenticationDatabaseUtil() {
    }

    @Deprecated
    public static Connection getDBConnection() throws AuthenticationException {
        return ThriftAuthenticationDatabaseUtil.getDBConnection(true);
    }

    public static Connection getDBConnection(Boolean shouldApplyTransaction) throws AuthenticationException {
        try {
            return ThriftAuthenticationJDBCPersistenceManager.getInstance().getDBConnection(shouldApplyTransaction);
        }
        catch (AuthenticationException e) {
            String errMsg = "Error when getting a database connection from the Thrift Identity Persistence Manager";
            log.error((Object)errMsg, (Throwable)((Object)e));
            throw e;
        }
    }

    public static void closeAllConnections(Connection dbConnection, ResultSet rs, PreparedStatement prepStmt) {
        ThriftAuthenticationDatabaseUtil.closeResultSet(rs);
        ThriftAuthenticationDatabaseUtil.closeStatement(prepStmt);
        ThriftAuthenticationDatabaseUtil.closeConnection(dbConnection);
    }

    public static void closeConnection(Connection dbConnection) {
        if (dbConnection != null) {
            try {
                dbConnection.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close statement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close result set  - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close statement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Deprecated
    public static void rollBack(Connection dbConnection) {
        ThriftAuthenticationDatabaseUtil.rollbackTransaction(dbConnection);
    }

    public static void rollbackTransaction(Connection dbConnection) {
        try {
            ThriftAuthenticationJDBCPersistenceManager.getInstance().rollbackTransaction(dbConnection);
        }
        catch (AuthenticationException e) {
            String errMsg = "Error when rollback from the Thrift Identity Persistence Manager";
            log.error((Object)errMsg, (Throwable)((Object)e));
        }
    }

    public static void commitTransaction(Connection dbConnection) {
        try {
            ThriftAuthenticationJDBCPersistenceManager.getInstance().commitTransaction(dbConnection);
        }
        catch (AuthenticationException e) {
            String errMsg = "Error when rollback from the Thrift Identity Persistence Manager";
            log.error((Object)errMsg, (Throwable)((Object)e));
        }
    }
}

