/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class ThriftAuthenticationConfigParser {
    public static final String IDENTITY_DEFAULT_NAMESPACE = "http://wso2.org/projects/carbon/carbon.xml";
    private static final String THRIFT_AUTHENTICATION_XML = "thrift-authentication.xml";
    private static Map<String, Object> configuration = new HashMap<String, Object>();
    private static ThriftAuthenticationConfigParser parser;
    private static SecretResolver secretResolver;
    private static Object lock;
    private static Log log;
    private static String configFilePath;
    private OMElement rootElement;

    private ThriftAuthenticationConfigParser() {
        this.buildConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThriftAuthenticationConfigParser getInstance() {
        if (parser == null) {
            Object object = lock;
            synchronized (object) {
                if (parser == null) {
                    parser = new ThriftAuthenticationConfigParser();
                }
            }
        }
        return parser;
    }

    public static ThriftAuthenticationConfigParser getInstance(String filePath) {
        configFilePath = filePath;
        return ThriftAuthenticationConfigParser.getInstance();
    }

    public Map<String, Object> getConfiguration() {
        return configuration;
    }

    private void buildConfiguration() {
        InputStream inStream = null;
        StAXOMBuilder builder = null;
        String warningMessage = "";
        try {
            File identityConfigXml;
            if (configFilePath != null) {
                identityConfigXml = new File(configFilePath);
                if (identityConfigXml.exists()) {
                    inStream = new FileInputStream(identityConfigXml);
                }
            } else {
                identityConfigXml = new File(CarbonUtils.getCarbonConfigDirPath() + File.separator + "identity" + File.separator + THRIFT_AUTHENTICATION_XML);
                if (identityConfigXml.exists()) {
                    inStream = new FileInputStream(identityConfigXml);
                }
            }
            if (inStream == null) {
                String message = "Thrift Authentication configuration not found. Cause - " + warningMessage;
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw new FileNotFoundException(message);
            }
            builder = new StAXOMBuilder(inStream);
            this.rootElement = builder.getDocumentElement();
            Stack<String> nameStack = new Stack<String>();
            secretResolver = SecretResolverFactory.create((OMElement)this.rootElement, (boolean)true);
            this.readChildElements(this.rootElement, nameStack);
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw IdentityRuntimeException.error((String)"Error occurred while reading thrift-authentication.xml", (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error closing the input stream after reading thrift-authentication.xml", (Throwable)e);
            }
        }
    }

    private void readChildElements(OMElement serverConfig, Stack<String> nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            if (this.elementHasText(element)) {
                String key = this.getKey(nameStack);
                Object currentObject = configuration.get(key);
                String resolvedValue = MiscellaneousUtil.resolve((OMElement)element, (SecretResolver)secretResolver);
                String value = StringUtils.isNotBlank((String)resolvedValue) ? resolvedValue : element.getText();
                value = this.replaceSystemProperty(value);
                if (currentObject == null) {
                    configuration.put(key, value);
                } else if (currentObject instanceof ArrayList) {
                    ArrayList list = (ArrayList)currentObject;
                    if (!list.contains(value)) {
                        list.add(value);
                    }
                } else if (!value.equals(currentObject)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(currentObject);
                    arrayList.add(value);
                    configuration.put(key, arrayList);
                }
            }
            this.readChildElements(element, nameStack);
            nameStack.pop();
        }
    }

    private String getKey(Stack<String> nameStack) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    private String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!sysProp.equals("carbon.home") || !".".equals(System.getProperty("carbon.home"))) continue;
            text = new File(".").getAbsolutePath() + File.separator + text;
        }
        return text;
    }

    public OMElement getConfigElement(String localPart) {
        return this.rootElement.getFirstChildWithName(new QName(IDENTITY_DEFAULT_NAMESPACE, localPart));
    }

    static {
        lock = new Object();
        log = LogFactory.getLog(ThriftAuthenticationConfigParser.class);
    }
}

