/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication.internal.persistance;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.thrift.authentication.internal.generatedCode.AuthenticationException;
import org.wso2.carbon.identity.thrift.authentication.internal.util.ThriftAuthenticationConfigParser;

public class ThriftAuthenticationJDBCPersistenceManager {
    private static Log log = LogFactory.getLog(ThriftAuthenticationJDBCPersistenceManager.class);
    private static ThriftAuthenticationJDBCPersistenceManager instance;
    private DataSource dataSource;

    private ThriftAuthenticationJDBCPersistenceManager() throws AuthenticationException {
        this.initDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThriftAuthenticationJDBCPersistenceManager getInstance() throws AuthenticationException {
        if (instance != null) return instance;
        Class<ThriftAuthenticationJDBCPersistenceManager> clazz = ThriftAuthenticationJDBCPersistenceManager.class;
        synchronized (ThriftAuthenticationJDBCPersistenceManager.class) {
            if (instance != null) return instance;
            instance = new ThriftAuthenticationJDBCPersistenceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initDataSource() throws AuthenticationException {
        OMElement persistenceManagerConfigElem = ThriftAuthenticationConfigParser.getInstance().getConfigElement("JDBCPersistenceManager");
        try {
            if (persistenceManagerConfigElem == null) {
                String errorMsg = "Thrift Authentication Persistence Manager configuration is not available in thrift-authentication.xml file. Terminating the JDBC Persistence Manager initialization. This may affect certain functionality.";
                log.error((Object)errorMsg);
                throw new AuthenticationException(errorMsg);
            }
            OMElement dataSourceElem = persistenceManagerConfigElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "DataSource"));
            if (dataSourceElem == null) {
                String errorMsg = "DataSource Element is not available for JDBC Persistence Manager in identity.xml file. Terminating the JDBC Persistence Manager initialization. This might affect certain features.";
                log.error((Object)errorMsg);
                throw new AuthenticationException(errorMsg);
            }
            OMElement dataSourceNameElem = dataSourceElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Name"));
            if (dataSourceNameElem != null) {
                String dataSourceName = dataSourceNameElem.getText();
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(dataSourceName);
            }
        }
        catch (NamingException e) {
            String errorMsg = "Error when looking up the Thrift Authentication Data Source.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new AuthenticationException(errorMsg);
        }
    }

    @Deprecated
    public Connection getDBConnection() throws AuthenticationException {
        return this.getDBConnection(true);
    }

    public Connection getDBConnection(Boolean shouldApplyTransaction) throws AuthenticationException {
        try {
            Connection dbConnection = this.dataSource.getConnection();
            if (shouldApplyTransaction.booleanValue()) {
                dbConnection.setAutoCommit(false);
                dbConnection.setTransactionIsolation(2);
            }
            return dbConnection;
        }
        catch (SQLException e) {
            String errMsg = "Error when getting a database connection object from the Thrift Authentication data source.";
            log.error((Object)errMsg, (Throwable)e);
            throw new AuthenticationException(errMsg);
        }
    }

    public void rollbackTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions. ", (Throwable)e1);
        }
    }

    public void commitTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.commit();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while commit transactions. ", (Throwable)e1);
        }
    }
}

