/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication.internal;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;
import org.wso2.carbon.identity.thrift.authentication.dao.ThriftSessionDAO;
import org.wso2.carbon.identity.thrift.authentication.internal.generatedCode.AuthenticationException;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ThriftSession;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ThriftAuthenticatorServiceImpl
implements ThriftAuthenticatorService {
    private static final Log log = LogFactory.getLog(ThriftAuthenticatorServiceImpl.class);
    private static long thriftSessionTimeOut;
    private RealmService realmService;
    private Map<String, ThriftSession> authenticatedSessions = new ConcurrentHashMap<String, ThriftSession>();
    private ThriftSessionDAO thriftSessionDAO;

    public ThriftAuthenticatorServiceImpl(RealmService realmService, ThriftSessionDAO thriftSessionDAO, long thriftSessionTimeOut) {
        this.realmService = realmService;
        ThriftAuthenticatorServiceImpl.setThriftSessionTimeOut(thriftSessionTimeOut);
        this.thriftSessionDAO = thriftSessionDAO.getInstance();
    }

    private void addThriftSession(ThriftSession thriftSession) throws IdentityException {
        this.authenticatedSessions.put(thriftSession.getSessionId(), thriftSession);
        ThriftSessionDAO sessionDAO = this.thriftSessionDAO.getInstance();
        sessionDAO.addSession(thriftSession);
    }

    private void removeThriftSession(String thriftSessionId) throws IdentityException {
        this.authenticatedSessions.remove(thriftSessionId);
        ThriftSessionDAO sessionDAO = this.thriftSessionDAO.getInstance();
        sessionDAO.removeSession(thriftSessionId);
    }

    @Override
    public String authenticate(String userName, String password) throws AuthenticationException {
        boolean isSuccessful;
        String domainName;
        if (userName == null) {
            this.logAndAuthenticationException("Authentication request was missing the user name ");
        }
        if (userName.indexOf("@") > 0 && ((domainName = userName.substring(userName.indexOf("@") + 1)) == null || "".equals(domainName.trim()))) {
            this.logAndAuthenticationException("Authentication request was missing the domain name of the user");
        }
        if (password == null) {
            this.logAndAuthenticationException("Authentication request was missing the required password");
        }
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        int tenantId = 0;
        try {
            tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            this.logAndAuthenticationException("Tenant domain tenantDomain does not exist");
        }
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantDomain(tenantDomain);
        carbonContext.setTenantId(tenantId);
        String tenantLessUsername = MultitenantUtils.getTenantAwareUsername((String)userName);
        try {
            UserRealm userRealm = this.realmService.getTenantUserRealm(tenantId);
            if (!userRealm.getUserStoreManager().isExistingUser(tenantLessUsername)) {
                throw new AuthenticationException("Invalid User : " + tenantLessUsername);
            }
            isSuccessful = userRealm.getUserStoreManager().authenticate(tenantLessUsername, (Object)password);
        }
        catch (UserStoreException e) {
            throw new AuthenticationException("User not authenticated for the given username : " + tenantLessUsername);
        }
        if (log.isDebugEnabled()) {
            if (isSuccessful) {
                log.debug((Object)("User: " + userName + " was successfully authenticated.."));
            } else {
                log.debug((Object)("Authentication failed for user: " + userName + " Hence, returning null for session id."));
            }
        }
        if (isSuccessful) {
            String sessionId = null;
            ThriftSession session = null;
            try {
                sessionId = UUID.randomUUID().toString();
                session = new ThriftSession();
                session.setSessionId(sessionId);
                session.setUserName(userName);
                session.setCreatedAt(System.currentTimeMillis());
                session.setLastAccess(System.currentTimeMillis());
                this.callOnSuccessAdminLogin(session);
                this.addThriftSession(session);
            }
            catch (Exception e) {
                String errorMsg = "Error occurred while authenticating the user: " + userName;
                log.error((Object)errorMsg, (Throwable)e);
                throw new AuthenticationException(errorMsg);
            }
            return sessionId;
        }
        throw new AuthenticationException("User '" + userName + "' not authenticated.");
    }

    @Override
    public boolean isAuthenticated(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        if (this.authenticatedSessions.isEmpty()) {
            String error;
            try {
                this.populateSessionsFromDB();
            }
            catch (IdentityException e) {
                error = "Error while populating thrift sessions from cache";
                log.error((Object)error, (Throwable)e);
            }
            catch (Exception e) {
                error = "Error while populating thrift sessions from cache";
                log.error((Object)error, (Throwable)e);
            }
        }
        if (!this.authenticatedSessions.isEmpty()) {
            ThriftSessionDAO sessionDAO = this.thriftSessionDAO.getInstance();
            if (this.authenticatedSessions.containsKey(sessionId)) {
                ThriftSession thriftSessionInCache = this.authenticatedSessions.get(sessionId);
                if (this.isSessionValid(thriftSessionInCache)) {
                    long lastAccessTime = System.currentTimeMillis();
                    this.authenticatedSessions.get(sessionId).setLastAccess(lastAccessTime);
                    try {
                        this.onSuccessLogin(thriftSessionInCache);
                        this.authenticatedSessions.put(sessionId, thriftSessionInCache);
                        sessionDAO.updateLastAccessTime(sessionId, lastAccessTime);
                    }
                    catch (IdentityException e) {
                        String error = "Error while updating last access time in DB";
                        log.error((Object)error, (Throwable)e);
                    }
                    catch (Exception e) {
                        String error = "Error in calling on success admin login for the thrift session.";
                        log.error((Object)error, (Throwable)e);
                    }
                    return true;
                }
                try {
                    ThriftSession thriftSession = sessionDAO.getSession(sessionId);
                    if (this.isSessionValid(thriftSession)) {
                        thriftSession.setLastAccess(System.currentTimeMillis());
                        this.onSuccessLogin(thriftSession);
                        this.authenticatedSessions.put(thriftSession.getSessionId(), thriftSession);
                        sessionDAO.updateLastAccessTime(sessionId, thriftSession.getLastAccess());
                        return true;
                    }
                    this.removeThriftSession(sessionId);
                    return false;
                }
                catch (IdentityException e) {
                    String error = "Error while obtaining thrift session from database.";
                    log.error((Object)error, (Throwable)e);
                }
                catch (Exception e) {
                    String error = "Error in calling on success admin login for the thrift session.";
                    log.error((Object)error, (Throwable)e);
                }
            } else {
                try {
                    if (sessionDAO.isSessionExisting(sessionId)) {
                        ThriftSession thriftSession = sessionDAO.getSession(sessionId);
                        if (this.isSessionValid(thriftSession)) {
                            thriftSession.setLastAccess(System.currentTimeMillis());
                            this.onSuccessLogin(thriftSession);
                            this.authenticatedSessions.put(thriftSession.getSessionId(), thriftSession);
                            sessionDAO.updateLastAccessTime(sessionId, thriftSession.getLastAccess());
                            return true;
                        }
                        sessionDAO.removeSession(sessionId);
                        return false;
                    }
                }
                catch (IdentityException e) {
                    String error = "Error while obtaining thrift session from database.";
                    log.error((Object)error, (Throwable)e);
                }
                catch (Exception e) {
                    String error = "Error in calling on success admin login for the thrift session obtained from DB.";
                    log.error((Object)error, (Throwable)e);
                }
            }
        }
        return false;
    }

    @Override
    public ThriftSession getSessionInfo(String sessionId) {
        return this.authenticatedSessions.get(sessionId);
    }

    private void logAndAuthenticationException(String msg) throws AuthenticationException {
        log.error((Object)msg);
        throw new AuthenticationException(msg);
    }

    private boolean isSessionValid(ThriftSession thriftSession) {
        return System.currentTimeMillis() - thriftSession.getLastAccess() < ThriftAuthenticatorServiceImpl.getThriftSessionTimeOut();
    }

    private void populateSessionsFromDB() throws Exception {
        ThriftSessionDAO sessionDAO;
        List<ThriftSession> thriftSessions;
        if (!this.authenticatedSessions.isEmpty()) {
            this.authenticatedSessions.clear();
        }
        if (CollectionUtils.isNotEmpty(thriftSessions = (sessionDAO = this.thriftSessionDAO.getInstance()).getAllSessions())) {
            for (ThriftSession thriftSession : thriftSessions) {
                this.authenticatedSessions.put(thriftSession.getSessionId(), thriftSession);
            }
        }
    }

    private void callOnSuccessAdminLogin(ThriftSession session) throws Exception {
        if (this.realmService != null) {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)session.getUserName());
            int tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
            CarbonAuthenticationUtil.onSuccessAdminLogin((ThriftSession)session, (String)session.getUserName(), (int)tenantId, (String)tenantDomain, (String)"");
        }
    }

    private void onSuccessLogin(ThriftSession authSession) throws IdentityException {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        try {
            carbonContext.setUsername((String)authSession.getAttribute("username"));
            carbonContext.setTenantDomain((String)authSession.getAttribute("tenantDomain"));
            carbonContext.setTenantId(((Integer)authSession.getAttribute("tenantId")).intValue());
        }
        catch (Exception e) {
            String authErrorMsg = "Error populating current carbon context from thrift auth session: " + e.getMessage();
            throw IdentityException.error((String)authErrorMsg);
        }
    }

    public static long getThriftSessionTimeOut() {
        return thriftSessionTimeOut;
    }

    public static void setThriftSessionTimeOut(long thriftSessionTimeOut) {
        ThriftAuthenticatorServiceImpl.thriftSessionTimeOut = thriftSessionTimeOut;
    }
}

