/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.identity.thrift.authentication.AuthenticatorServlet;
import org.wso2.carbon.identity.thrift.authentication.TCPThriftAuthenticationService;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;
import org.wso2.carbon.identity.thrift.authentication.dao.DBThriftSessionDAO;
import org.wso2.carbon.identity.thrift.authentication.dao.ThriftSessionDAO;
import org.wso2.carbon.identity.thrift.authentication.internal.AuthenticatorServiceImpl;
import org.wso2.carbon.identity.thrift.authentication.internal.ThriftAuthenticatorServiceImpl;
import org.wso2.carbon.identity.thrift.authentication.internal.generatedCode.AuthenticatorService;
import org.wso2.carbon.identity.thrift.authentication.internal.util.HostAddressFinder;
import org.wso2.carbon.identity.thrift.authentication.internal.util.ThriftAuthenticationConfigParser;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.identity.thrift.authentication.internal.ThriftAuthenticationServiceComponent", immediate=true)
public class ThriftAuthenticationServiceComponent {
    private static Log log = LogFactory.getLog(ThriftAuthenticationServiceComponent.class);
    private static HttpService httpServiceInstance;
    private static RealmService realmServiceInstance;
    private ServiceRegistration thriftAuthenticationService;
    private ConfigurationContextService configurationContext;
    private TCPThriftAuthenticationService TCPThriftAuthenticationService;

    public static int readPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }

    @Activate
    protected void activate(ComponentContext compCtx) {
        try {
            long thriftSessionTimeout;
            ThriftSessionDAO thriftSessionDAO;
            try {
                OMElement thriftSessionDAOElement = ThriftAuthenticationConfigParser.getInstance().getConfigElement("ThriftSessionDAO");
                thriftSessionDAO = ((ThriftSessionDAO)Class.forName(thriftSessionDAOElement.getText()).newInstance()).getInstance();
            }
            catch (Throwable throwable) {
                log.error((Object)"Error in loading ThriftSessionDAO hence using default org.wso2.carbon.identity.thrift.authentication.dao.DBThriftSessionDAO, ", throwable);
                thriftSessionDAO = new DBThriftSessionDAO();
            }
            try {
                OMElement thriftSessionTimeoutElement = ThriftAuthenticationConfigParser.getInstance().getConfigElement("ThriftSessionTimeout");
                thriftSessionTimeout = Long.parseLong(thriftSessionTimeoutElement.getText());
            }
            catch (Throwable throwable) {
                log.error((Object)"Error in loading ThriftSessionTimeout hence using the default: 30min, ", throwable);
                thriftSessionTimeout = 1800000L;
            }
            ThriftAuthenticatorServiceImpl thriftAuthenticatorServiceImpl = new ThriftAuthenticatorServiceImpl(ThriftAuthenticationServiceComponent.getRealmServiceInstance(), thriftSessionDAO, thriftSessionTimeout);
            this.thriftAuthenticationService = compCtx.getBundleContext().registerService(ThriftAuthenticatorService.class.getName(), (Object)thriftAuthenticatorServiceImpl, null);
            this.startThriftServices(thriftAuthenticatorServiceImpl);
        }
        catch (RuntimeException e) {
            log.error((Object)"Error in starting Thrift Authentication Service ", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error in starting Thrift Authentication Service ", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext compCtx) {
        if (this.TCPThriftAuthenticationService != null) {
            this.TCPThriftAuthenticationService.stop();
        }
        compCtx.getBundleContext().ungetService(this.thriftAuthenticationService.getReference());
    }

    public static HttpService getHttpServiceInstance() {
        return httpServiceInstance;
    }

    public static void setHttpServiceInstance(HttpService httpServiceInstance) {
        ThriftAuthenticationServiceComponent.httpServiceInstance = httpServiceInstance;
    }

    public static RealmService getRealmServiceInstance() {
        return realmServiceInstance;
    }

    public static void setRealmServiceInstance(RealmService realmServiceInstance) {
        ThriftAuthenticationServiceComponent.realmServiceInstance = realmServiceInstance;
    }

    @Reference(name="http.service", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        ThriftAuthenticationServiceComponent.setHttpServiceInstance(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        ThriftAuthenticationServiceComponent.setHttpServiceInstance(null);
    }

    @Reference(name="org.wso2.carbon.user.core", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        ThriftAuthenticationServiceComponent.setRealmServiceInstance(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        ThriftAuthenticationServiceComponent.setRealmServiceInstance(null);
    }

    @Reference(name="configuration.context", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContext")
    protected void setConfigurationContext(ConfigurationContextService configurationContext) {
        this.configurationContext = configurationContext;
    }

    protected void unsetConfigurationContext(ConfigurationContextService configurationContext) {
        this.configurationContext = null;
    }

    private void startThriftServices(ThriftAuthenticatorService thriftAuthenticatorService) throws Exception {
        this.startThriftHttpAuthenticatorService(thriftAuthenticatorService);
        this.startThriftTcpAuthenticatorService(thriftAuthenticatorService);
    }

    private void startThriftHttpAuthenticatorService(ThriftAuthenticatorService thriftAuthenticatorService) {
        try {
            AuthenticatorService.Processor<AuthenticatorServiceImpl> authServiceProcessor = new AuthenticatorService.Processor<AuthenticatorServiceImpl>(new AuthenticatorServiceImpl(thriftAuthenticatorService));
            TCompactProtocol.Factory inProtFactory = new TCompactProtocol.Factory();
            TCompactProtocol.Factory outProtFactory = new TCompactProtocol.Factory();
            ThriftAuthenticationServiceComponent.getHttpServiceInstance().registerServlet("/thriftAuthenticator", (Servlet)new AuthenticatorServlet(authServiceProcessor, (TProtocolFactory)inProtFactory, (TProtocolFactory)outProtFactory), new Hashtable(), ThriftAuthenticationServiceComponent.getHttpServiceInstance().createDefaultHttpContext());
        }
        catch (ServletException e) {
            log.error((Object)"Unable to start Thrift Authenticator Service.", (Throwable)e);
        }
        catch (NamespaceException e) {
            log.error((Object)"Unable to start Thrift Authenticator Service", (Throwable)e);
        }
    }

    private void startThriftTcpAuthenticatorService(ThriftAuthenticatorService thriftAuthenticatorService) throws Exception {
        int clientTimeout;
        OMElement portElement;
        String hostName;
        int portOffset = ThriftAuthenticationServiceComponent.readPortOffset();
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String serverUrl = CarbonUtils.getServerURL((ServerConfigurationService)serverConfig, (ConfigurationContext)this.configurationContext.getServerConfigContext());
        OMElement hostnameElement = ThriftAuthenticationConfigParser.getInstance().getConfigElement("Hostname");
        if (hostnameElement == null) {
            try {
                hostName = new URL(serverUrl).getHost();
            }
            catch (MalformedURLException e) {
                hostName = HostAddressFinder.findAddress("localhost");
                if (!serverUrl.matches("local:/.*/services/")) {
                    log.info((Object)("Thrift Authentication Service url :" + serverUrl + " is using local, hence hostname is assigned as '" + hostName + "'"));
                }
            }
        } else {
            hostName = hostnameElement.getText();
        }
        if ((portElement = ThriftAuthenticationConfigParser.getInstance().getConfigElement("Port")) == null) {
            throw new Exception("Error, Thrift Authentication Service config does not have a port defined!");
        }
        int port = Integer.parseInt(portElement.getText());
        port += portOffset;
        String keyStore = serverConfig.getFirstProperty("Security.KeyStore.Location");
        if (keyStore == null && (keyStore = System.getProperty("Security.KeyStore.Location")) == null) {
            throw new Exception("Cannot initialize Thrift Authentication Service, Security.KeyStore.Location is null");
        }
        String keyStorePassword = serverConfig.getFirstProperty("Security.KeyStore.Password");
        if (keyStorePassword == null && (keyStorePassword = System.getProperty("Security.KeyStore.Password")) == null) {
            throw new Exception("Cannot initialize Thrift Authentication Service, Security.KeyStore.Password is null ");
        }
        OMElement clientTimeoutElement = ThriftAuthenticationConfigParser.getInstance().getConfigElement("ClientTimeout");
        if (clientTimeoutElement != null) {
            try {
                clientTimeout = Integer.parseInt(clientTimeoutElement.getText());
            }
            catch (Throwable e) {
                String msg = "Error, in Thrift Auth Client Timeout, hence using the default timeout: 30000ms";
                log.error((Object)msg, e);
                clientTimeout = 30000;
            }
        } else {
            String msg = "Thrift Authentication Service Client Timeout is not set, hence using the default timeout: 30000ms";
            log.info((Object)msg);
            clientTimeout = 30000;
        }
        this.TCPThriftAuthenticationService = new TCPThriftAuthenticationService(hostName, port, keyStore, keyStorePassword, clientTimeout, thriftAuthenticatorService);
        this.TCPThriftAuthenticationService.start();
    }
}

