/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wso2.carbon.identity.thrift.authentication.dao.ThriftSessionDAO;
import org.wso2.carbon.utils.ThriftSession;

public class InMemoryThriftSessionDAO
implements ThriftSessionDAO {
    private ConcurrentMap<String, ThriftSession> thriftSessionMap = new ConcurrentHashMap<String, ThriftSession>();

    @Override
    public List<ThriftSession> getAllSessions() {
        return new ArrayList<ThriftSession>(this.thriftSessionMap.values());
    }

    @Override
    public boolean isSessionExisting(String sessionId) {
        return this.thriftSessionMap.containsKey(sessionId);
    }

    @Override
    public void addSession(ThriftSession session) {
        this.thriftSessionMap.put(session.getSessionId(), session);
    }

    @Override
    public void removeSession(String sessionId) {
        this.thriftSessionMap.remove(sessionId);
    }

    @Override
    public void updateLastAccessTime(String sessionId, long lastAccessTime) {
        ThriftSession thriftSession = (ThriftSession)this.thriftSessionMap.get(sessionId);
        if (thriftSession != null) {
            thriftSession.setLastAccess(lastAccessTime);
        }
    }

    @Override
    public ThriftSession getSession(String sessionId) {
        return (ThriftSession)this.thriftSessionMap.get(sessionId);
    }

    @Override
    public ThriftSessionDAO getInstance() {
        return this;
    }
}

