/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.thrift.authentication.dao.ThriftSessionDAO;
import org.wso2.carbon.identity.thrift.authentication.internal.generatedCode.AuthenticationException;
import org.wso2.carbon.identity.thrift.authentication.internal.util.ThriftAuthenticationDatabaseUtil;
import org.wso2.carbon.utils.ThriftSession;

public class DBThriftSessionDAO
implements ThriftSessionDAO {
    public static final String ERROR_WHEN_GETTING_AN_IDENTITY_PERSISTENCE_STORE_INSTANCE = "Error when getting an Identity Persistence Store instance.";
    public static final String ERROR_WHEN_EXECUTING_THE_SQL = "Error when executing the SQL :";
    public static final String THE_PERSISTENCE_STORE = "the persistence store.";
    public static final String THRIFT_SESSION_WITH_GIVEN_SESSION_ID_ALREADY_EXISTS = "Thrift session with given Session Id already exists.";
    private static Log log = LogFactory.getLog(DBThriftSessionDAO.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ThriftSession> getAllSessions() throws IdentityException {
        ArrayList<ThriftSession> thriftSessions;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rSet = null;
        try {
            connection = ThriftAuthenticationDatabaseUtil.getDBConnection(false);
            prepStmt = connection.prepareStatement("SELECT SESSION_ID, USER_NAME, CREATED_TIME, LAST_MODIFIED_TIME FROM IDN_THRIFT_SESSION");
            rSet = prepStmt.executeQuery();
            thriftSessions = new ArrayList<ThriftSession>();
            while (rSet.next()) {
                if (rSet.getString(1) == null || rSet.getString(1).length() <= 0) continue;
                ThriftSession thriftSession = new ThriftSession();
                thriftSession.setSessionId(rSet.getString(1));
                thriftSession.setUserName(rSet.getString(2));
                thriftSession.setCreatedAt(rSet.getLong(3));
                thriftSession.setLastAccess(rSet.getLong(4));
                thriftSessions.add(thriftSession);
            }
        }
        catch (AuthenticationException e) {
            try {
                String errorMsg = ERROR_WHEN_GETTING_AN_IDENTITY_PERSISTENCE_STORE_INSTANCE;
                log.error((Object)errorMsg, (Throwable)((Object)e));
                throw IdentityException.error((String)errorMsg, (Throwable)((Object)e));
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT SESSION_ID, USER_NAME, CREATED_TIME, LAST_MODIFIED_TIME FROM IDN_THRIFT_SESSION");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw IdentityException.error((String)"Error when reading the thrift session information from the persistence store.");
                }
            }
            catch (Throwable throwable) {
                ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, rSet, prepStmt);
                throw throwable;
            }
        }
        ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, rSet, prepStmt);
        return thriftSessions;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSessionExisting(String sessionId) throws IdentityException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rSet = null;
        boolean isExistingProvider = false;
        try {
            connection = ThriftAuthenticationDatabaseUtil.getDBConnection(false);
            prepStmt = connection.prepareStatement("SELECT SESSION_ID FROM IDN_THRIFT_SESSION WHERE SESSION_ID=?");
            prepStmt.setString(1, sessionId);
            rSet = prepStmt.executeQuery();
            if (rSet.next()) {
                isExistingProvider = true;
            }
        }
        catch (AuthenticationException e) {
            try {
                String errorMsg = ERROR_WHEN_GETTING_AN_IDENTITY_PERSISTENCE_STORE_INSTANCE;
                log.error((Object)errorMsg, (Throwable)((Object)e));
                throw IdentityException.error((String)errorMsg, (Throwable)((Object)e));
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT SESSION_ID FROM IDN_THRIFT_SESSION WHERE SESSION_ID=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw IdentityException.error((String)"Error when reading thrift session information from the persistence store.");
                }
            }
            catch (Throwable throwable) {
                ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, rSet, prepStmt);
                throw throwable;
            }
        }
        ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, rSet, prepStmt);
        return isExistingProvider;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addSession(ThriftSession session) throws IdentityException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        String sqlStmt = null;
        if (this.isSessionExisting(session.getSessionId())) {
            String errorMessage = THRIFT_SESSION_WITH_GIVEN_SESSION_ID_ALREADY_EXISTS;
            log.error((Object)errorMessage);
            throw IdentityException.error((String)errorMessage);
        }
        try {
            connection = ThriftAuthenticationDatabaseUtil.getDBConnection();
            sqlStmt = "INSERT INTO IDN_THRIFT_SESSION (SESSION_ID, USER_NAME, CREATED_TIME, LAST_MODIFIED_TIME) VALUES (?,?,?,?)";
            prepStmt = connection.prepareStatement(sqlStmt);
            prepStmt.setString(1, session.getSessionId());
            prepStmt.setString(2, session.getUserName());
            prepStmt.setLong(3, session.getCreatedAt());
            prepStmt.setLong(4, session.getLastAccess());
            prepStmt.execute();
            ThriftAuthenticationDatabaseUtil.commitTransaction(connection);
        }
        catch (AuthenticationException e) {
            try {
                String errorMsg = ERROR_WHEN_GETTING_AN_IDENTITY_PERSISTENCE_STORE_INSTANCE;
                log.error((Object)errorMsg, (Throwable)((Object)e));
                throw IdentityException.error((String)errorMsg, (Throwable)((Object)e));
                catch (SQLException e2) {
                    ThriftAuthenticationDatabaseUtil.rollbackTransaction(connection);
                    log.error((Object)("Error when executing the SQL : " + sqlStmt));
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw IdentityException.error((String)"Error when adding a new thrift session.");
                }
            }
            catch (Throwable throwable) {
                ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, null, prepStmt);
                throw throwable;
            }
        }
        ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, null, prepStmt);
    }

    @Override
    public void removeSession(String sessionId) throws IdentityException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        if (this.isSessionExisting(sessionId)) {
            try {
                connection = ThriftAuthenticationDatabaseUtil.getDBConnection();
                prepStmt = connection.prepareStatement("DELETE FROM IDN_THRIFT_SESSION WHERE SESSION_ID=?");
                prepStmt.setString(1, sessionId);
                prepStmt.execute();
                ThriftAuthenticationDatabaseUtil.commitTransaction(connection);
            }
            catch (AuthenticationException e) {
                String errorMsg = ERROR_WHEN_GETTING_AN_IDENTITY_PERSISTENCE_STORE_INSTANCE;
                log.error((Object)errorMsg, (Throwable)((Object)e));
                throw IdentityException.error((String)errorMsg, (Throwable)((Object)e));
            }
            catch (SQLException e) {
                ThriftAuthenticationDatabaseUtil.rollbackTransaction(connection);
                log.error((Object)"Error when executing the SQL : DELETE FROM IDN_THRIFT_SESSION WHERE SESSION_ID=?");
                log.error((Object)e.getMessage(), (Throwable)e);
                throw IdentityException.error((String)"Error deleting the Thrift Session.");
            }
            finally {
                ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, null, prepStmt);
            }
        } else {
            String errorMessage = THRIFT_SESSION_WITH_GIVEN_SESSION_ID_ALREADY_EXISTS;
            log.error((Object)errorMessage);
            throw IdentityException.error((String)errorMessage);
        }
    }

    @Override
    public void updateLastAccessTime(String sessionId, long lastAccessTime) throws IdentityException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        if (this.isSessionExisting(sessionId)) {
            try {
                connection = ThriftAuthenticationDatabaseUtil.getDBConnection();
                prepStmt = connection.prepareStatement("UPDATE IDN_THRIFT_SESSION SET LAST_MODIFIED_TIME=? WHERE SESSION_ID=?");
                prepStmt.setLong(1, lastAccessTime);
                prepStmt.setString(2, sessionId);
                int count = prepStmt.executeUpdate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No. of records updated for updating Thrift Session : " + count));
                }
                ThriftAuthenticationDatabaseUtil.commitTransaction(connection);
            }
            catch (AuthenticationException e) {
                String errorMsg = ERROR_WHEN_GETTING_AN_IDENTITY_PERSISTENCE_STORE_INSTANCE;
                log.error((Object)errorMsg, (Throwable)((Object)e));
                throw IdentityException.error((String)errorMsg, (Throwable)((Object)e));
            }
            catch (SQLException e) {
                ThriftAuthenticationDatabaseUtil.rollbackTransaction(connection);
                log.error((Object)"Error when executing the SQL : UPDATE IDN_THRIFT_SESSION SET LAST_MODIFIED_TIME=? WHERE SESSION_ID=?");
                log.error((Object)e.getMessage(), (Throwable)e);
                throw IdentityException.error((String)"Error updating the Thrift Session.");
            }
            finally {
                ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, null, prepStmt);
            }
        } else {
            String errorMessage = THRIFT_SESSION_WITH_GIVEN_SESSION_ID_ALREADY_EXISTS;
            log.error((Object)errorMessage);
            throw IdentityException.error((String)errorMessage);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ThriftSession getSession(String sessionId) throws IdentityException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rSet = null;
        ThriftSession thriftSession = new ThriftSession();
        try {
            connection = ThriftAuthenticationDatabaseUtil.getDBConnection(false);
            prepStmt = connection.prepareStatement("SELECT SESSION_ID, USER_NAME, CREATED_TIME, LAST_MODIFIED_TIME FROM IDN_THRIFT_SESSION WHERE SESSION_ID=?");
            prepStmt.setString(1, sessionId);
            rSet = prepStmt.executeQuery();
            while (rSet.next()) {
                if (rSet.getString(1) == null || rSet.getString(1).length() <= 0) continue;
                thriftSession.setSessionId(rSet.getString(1));
                thriftSession.setUserName(rSet.getString(2));
                thriftSession.setCreatedAt(rSet.getLong(3));
                thriftSession.setLastAccess(rSet.getLong(4));
            }
        }
        catch (AuthenticationException e) {
            try {
                String errorMsg = ERROR_WHEN_GETTING_AN_IDENTITY_PERSISTENCE_STORE_INSTANCE;
                log.error((Object)errorMsg, (Throwable)((Object)e));
                throw IdentityException.error((String)errorMsg, (Throwable)((Object)e));
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT SESSION_ID, USER_NAME, CREATED_TIME, LAST_MODIFIED_TIME FROM IDN_THRIFT_SESSION WHERE SESSION_ID=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw IdentityException.error((String)"Error when reading the Thrift session information from the persistence store.");
                }
            }
            catch (Throwable throwable) {
                ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, rSet, prepStmt);
                throw throwable;
            }
        }
        ThriftAuthenticationDatabaseUtil.closeAllConnections(connection, rSet, prepStmt);
        return thriftSession;
    }

    @Override
    public ThriftSessionDAO getInstance() {
        return new DBThriftSessionDAO();
    }
}

