/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLServerSocket;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;
import org.wso2.carbon.identity.thrift.authentication.dao.InMemoryThriftSessionDAO;
import org.wso2.carbon.identity.thrift.authentication.exception.ThriftAuthenticationException;
import org.wso2.carbon.identity.thrift.authentication.internal.AuthenticatorServiceImpl;
import org.wso2.carbon.identity.thrift.authentication.internal.ThriftAuthenticatorServiceImpl;
import org.wso2.carbon.identity.thrift.authentication.internal.generatedCode.AuthenticatorService;
import org.wso2.carbon.identity.thrift.authentication.internal.util.ThriftAuthenticationConfigParser;
import org.wso2.carbon.utils.ThriftSession;

public class TCPThriftAuthenticationService {
    private final String hostName;
    private final int port;
    private final String keyStore;
    private final String keyStorePassword;
    private final int clientTimeout;
    private ThriftAuthenticatorService thriftAuthenticatorService;
    private Log log = LogFactory.getLog(TCPThriftAuthenticationService.class);
    private TServer authenticationServer;

    public TCPThriftAuthenticationService(String hostName, int port, String keyStore, String keyStorePassword, int clientTimeout, ThriftAuthenticatorService thriftAuthenticatorService) {
        this.hostName = hostName;
        this.port = port;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.clientTimeout = clientTimeout;
        this.thriftAuthenticatorService = thriftAuthenticatorService;
    }

    public TCPThriftAuthenticationService(String hostName, int port, long thriftSessionTimeOut) throws ThriftAuthenticationException {
        this.hostName = hostName;
        this.port = port;
        String SecurityKeyStore = System.getProperty("Security.KeyStore.Location");
        if (SecurityKeyStore == null) {
            throw new ThriftAuthenticationException("Cannot start agent server, not valid Security.KeyStore.Location is null");
        }
        String SecurityKeyStorePassword = System.getProperty("Security.KeyStore.Password");
        if (SecurityKeyStorePassword == null) {
            throw new ThriftAuthenticationException("Cannot start agent server, not valid Security.KeyStore.Password is null ");
        }
        this.keyStore = SecurityKeyStore;
        this.keyStorePassword = SecurityKeyStorePassword;
        this.clientTimeout = 30000;
        this.thriftAuthenticatorService = new ThriftAuthenticatorServiceImpl(null, new InMemoryThriftSessionDAO(), thriftSessionTimeOut);
    }

    public void start() throws TTransportException, UnknownHostException {
        String ciphers;
        OMElement ciphersElement;
        String sslEnabledProtocols;
        InetAddress inetAddress = InetAddress.getByName(this.hostName);
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(this.keyStore, this.keyStorePassword);
        TServerSocket serverTransport = TSSLTransportFactory.getServerSocket((int)this.port, (int)this.clientTimeout, (InetAddress)inetAddress, (TSSLTransportFactory.TSSLTransportParameters)params);
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverTransport.getServerSocket();
        OMElement sslEnabledProtocolsElement = ThriftAuthenticationConfigParser.getInstance().getConfigElement("SSLEnabledProtocols");
        if (sslEnabledProtocolsElement != null && StringUtils.isNotBlank((String)(sslEnabledProtocols = sslEnabledProtocolsElement.getText()))) {
            String[] sslProtocolsArray = sslEnabledProtocols.split(",");
            sslServerSocket.setEnabledProtocols(sslProtocolsArray);
        }
        if ((ciphersElement = ThriftAuthenticationConfigParser.getInstance().getConfigElement("Ciphers")) != null && StringUtils.isNotBlank((String)(ciphers = ciphersElement.getText()))) {
            String[] ciphersArray = ciphers.split(",");
            sslServerSocket.setEnabledCipherSuites(ciphersArray);
        }
        AuthenticatorService.Processor<AuthenticatorServiceImpl> processor = new AuthenticatorService.Processor<AuthenticatorServiceImpl>(new AuthenticatorServiceImpl(this.thriftAuthenticatorService));
        this.authenticationServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor(processor));
        Thread thread = new Thread(new ServerRunnable(this.authenticationServer));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Thrift Authentication Service started at ssl://" + this.hostName + ":" + this.port));
        }
        thread.start();
    }

    public void stop() {
        this.authenticationServer.stop();
    }

    public boolean isAuthenticated(String sessionId) {
        return this.thriftAuthenticatorService.isAuthenticated(sessionId);
    }

    public ThriftSession getSessionInfo(String sessionId) {
        return this.thriftAuthenticatorService.getSessionInfo(sessionId);
    }

    private static class ServerRunnable
    implements Runnable {
        TServer server;

        public ServerRunnable(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }
}

