/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.mediator.config.xml;

import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.wso2.carbon.identity.entitlement.mediator.EntitlementConstants;
import org.wso2.carbon.identity.entitlement.mediator.EntitlementMediator;

public class EntitlementMediatorFactory
extends AbstractMediatorFactory {
    public static final String OBLIGATIONS = "obligations";
    public static final String ADVICE = "advice";

    public Mediator createSpecificMediator(OMElement element, Properties properties) {
        if (!EntitlementConstants.ELEMENT_ENTITLEMENT.equals(element.getQName())) {
            this.handleException("Unable to create the Entitlement mediator. Unexpected element as the Entitlement mediator configuration");
        }
        EntitlementMediator mediator = null;
        OMAttribute remoteServiceUrl = null;
        OMAttribute remoteServiceUserName = null;
        OMAttribute remoteServicePassword = null;
        OMAttribute remoteServiceUrlKey = null;
        OMAttribute remoteServiceUserNameKey = null;
        OMAttribute remoteServicePasswordKey = null;
        OMAttribute callbackClass = null;
        OMAttribute cacheType = null;
        OMAttribute invalidationInterval = null;
        OMAttribute maxCacheEntries = null;
        Object basicAuth = null;
        OMAttribute thriftHost = null;
        OMAttribute thriftPort = null;
        OMAttribute reuseSession = null;
        OMAttribute client = null;
        mediator = new EntitlementMediator();
        remoteServiceUrl = element.getAttribute(EntitlementConstants.ATTR_SERVER_URL);
        remoteServiceUrlKey = element.getAttribute(EntitlementConstants.ATTR_SERVER_URL_KEY);
        if (remoteServiceUrl != null && remoteServiceUrl.getAttributeValue() != null) {
            mediator.setRemoteServiceUrl(remoteServiceUrl.getAttributeValue());
        } else if (remoteServiceUrlKey != null && remoteServiceUrlKey.getAttributeValue() != null) {
            mediator.setRemoteServiceUrlKey(remoteServiceUrlKey.getAttributeValue());
        }
        remoteServiceUserName = element.getAttribute(EntitlementConstants.ATTR_USER_NAME);
        remoteServiceUserNameKey = element.getAttribute(EntitlementConstants.ATTR_USER_NAME_KEY);
        if (remoteServiceUserName != null && remoteServiceUserName.getAttributeValue() != null) {
            mediator.setRemoteServiceUserName(remoteServiceUserName.getAttributeValue());
        } else if (remoteServiceUserNameKey != null && remoteServiceUserNameKey.getAttributeValue() != null) {
            mediator.setRemoteServiceUserNameKey(remoteServiceUserNameKey.getAttributeValue());
        }
        remoteServicePassword = element.getAttribute(EntitlementConstants.ATTR_NAME_PASSWORD);
        remoteServicePasswordKey = element.getAttribute(EntitlementConstants.ATTR_NAME_PASSWORD_KEY);
        if (remoteServicePassword != null && remoteServicePassword.getAttributeValue() != null) {
            mediator.setRemoteServicePassword(remoteServicePassword.getAttributeValue());
        } else if (remoteServicePasswordKey != null && remoteServicePasswordKey.getAttributeValue() != null) {
            mediator.setRemoteServicePasswordKey(remoteServicePasswordKey.getAttributeValue());
        }
        callbackClass = element.getAttribute(EntitlementConstants.ATTR_CALLBACK_CLASS);
        if (callbackClass != null && callbackClass.getAttributeValue() != null) {
            mediator.setCallbackClass(callbackClass.getAttributeValue());
        }
        if ((cacheType = element.getAttribute(EntitlementConstants.ATTR_CACHE_TYPE)) != null && cacheType.getAttributeValue() != null) {
            mediator.setCacheType(cacheType.getAttributeValue());
        }
        if ((invalidationInterval = element.getAttribute(EntitlementConstants.ATTR_INVALIDATION_INTERVAL)) != null && invalidationInterval.getAttributeValue() != null) {
            mediator.setInvalidationInterval(Integer.parseInt(invalidationInterval.getAttributeValue()));
        }
        if ((maxCacheEntries = element.getAttribute(EntitlementConstants.ATTR_MAX_CACHE_ENTRIES)) != null && maxCacheEntries.getAttributeValue() != null) {
            mediator.setMaxCacheEntries(Integer.parseInt(maxCacheEntries.getAttributeValue()));
        }
        if ((client = element.getAttribute(EntitlementConstants.ATTR_CLIENT)) != null && client.getAttributeValue() != null) {
            mediator.setClient(client.getAttributeValue());
        }
        if ((thriftHost = element.getAttribute(EntitlementConstants.ATTR_THRIFT_HOST)) != null && thriftHost.getAttributeValue() != null) {
            mediator.setThriftHost(thriftHost.getAttributeValue());
        }
        if ((thriftPort = element.getAttribute(EntitlementConstants.ATTR_THRIFT_PORT)) != null && thriftPort.getAttributeValue() != null) {
            mediator.setThriftPort(thriftPort.getAttributeValue());
        }
        if ((reuseSession = element.getAttribute(EntitlementConstants.ATTR_REUSE_SESSION)) != null && reuseSession.getAttributeValue() != null) {
            mediator.setReuseSession(reuseSession.getAttributeValue());
        }
        SequenceMediatorFactory mediatorFactory = new SequenceMediatorFactory();
        OMAttribute onReject = element.getAttribute(new QName("", "onReject"));
        if (onReject != null) {
            String onRejectValue = onReject.getAttributeValue();
            if (onRejectValue != null) {
                mediator.setOnRejectSeqKey(onRejectValue.trim());
            }
        } else {
            OMElement onRejectMediatorElement = element.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "onReject"));
            if (onRejectMediatorElement != null) {
                mediator.setOnRejectMediator((Mediator)mediatorFactory.createAnonymousSequence(onRejectMediatorElement, properties));
            }
        }
        OMAttribute onAccept = element.getAttribute(new QName("", "onAccept"));
        if (onAccept != null) {
            String onAcceptValue = onAccept.getAttributeValue();
            if (onAcceptValue != null) {
                mediator.setOnAcceptSeqKey(onAcceptValue);
            }
        } else {
            OMElement onAcceptMediatorElement = element.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "onAccept"));
            if (onAcceptMediatorElement != null) {
                mediator.setOnAcceptMediator((Mediator)mediatorFactory.createAnonymousSequence(onAcceptMediatorElement, properties));
            }
        }
        OMAttribute obligations = element.getAttribute(new QName("", OBLIGATIONS));
        if (obligations != null) {
            String obligationsValue = obligations.getAttributeValue();
            if (obligationsValue != null) {
                mediator.setObligationsSeqKey(obligationsValue.trim());
            }
        } else {
            OMElement obligationsMediatorElement = element.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", OBLIGATIONS));
            if (obligationsMediatorElement != null) {
                mediator.setObligationsMediator((Mediator)mediatorFactory.createAnonymousSequence(obligationsMediatorElement, properties));
            }
        }
        OMAttribute advice = element.getAttribute(new QName("", ADVICE));
        if (advice != null) {
            String adviceValue = advice.getAttributeValue();
            if (adviceValue != null) {
                mediator.setAdviceSeqKey(adviceValue.trim());
            }
        } else {
            OMElement adviceMediatorElement = element.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", ADVICE));
            if (adviceMediatorElement != null) {
                mediator.setAdviceMediator((Mediator)mediatorFactory.createAnonymousSequence(adviceMediatorElement, properties));
            }
        }
        EntitlementMediatorFactory.addAllCommentChildrenToList((OMElement)element, (List)mediator.getCommentsList());
        return mediator;
    }

    public QName getTagQName() {
        return EntitlementConstants.ELEMENT_ENTITLEMENT;
    }
}

