/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.mediator.callback;

import java.security.cert.X509Certificate;
import org.apache.axis2.context.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.wso2.carbon.identity.entitlement.mediator.callback.EntitlementCallbackHandler;
import org.wso2.carbon.identity.entitlement.proxy.Attribute;

public class X509EntitlementCallbackHandler
extends EntitlementCallbackHandler {
    @Override
    public String getUserName(org.apache.synapse.MessageContext synCtx) {
        Axis2MessageContext axis2Msgcontext = null;
        axis2Msgcontext = (Axis2MessageContext)synCtx;
        MessageContext msgContext = axis2Msgcontext.getAxis2MessageContext();
        X509Certificate cert = (X509Certificate)msgContext.getProperty("X509Certificate");
        if (cert == null) {
            Object sslCertObject = msgContext.getProperty("ssl.client.auth.cert.X509");
            javax.security.cert.X509Certificate[] certs = (javax.security.cert.X509Certificate[])sslCertObject;
            if (certs != null && certs.length > 0) {
                return certs[0].getSubjectDN().getName();
            }
        } else {
            return cert.getSubjectDN().getName();
        }
        return null;
    }

    @Override
    public Attribute[] findOtherAttributes(org.apache.synapse.MessageContext synCtx) {
        Axis2MessageContext axis2Msgcontext = null;
        axis2Msgcontext = (Axis2MessageContext)synCtx;
        MessageContext msgContext = axis2Msgcontext.getAxis2MessageContext();
        String issuer = null;
        String signatureAlgo = null;
        X509Certificate cert = (X509Certificate)msgContext.getProperty("X509Certificate");
        if (cert == null) {
            Object sslCertObject = msgContext.getProperty("ssl.client.auth.cert.X509");
            javax.security.cert.X509Certificate[] certs = (javax.security.cert.X509Certificate[])sslCertObject;
            if (certs != null && certs.length > 0) {
                issuer = certs[0].getIssuerDN().getName();
                signatureAlgo = certs[0].getSigAlgName();
            }
        } else {
            issuer = cert.getIssuerDN().getName();
            signatureAlgo = cert.getSigAlgName();
        }
        if (issuer != null && signatureAlgo != null) {
            Attribute issuerAttr = new Attribute("urn:oasis:names:tc:xacml:3.0:attribute-category:environment", "IssuerDN", "string", issuer);
            Attribute signatureAlgoAttr = new Attribute("urn:oasis:names:tc:xacml:3.0:attribute-category:environment", "SignatureAlgorithm", "string", signatureAlgo);
            return new Attribute[]{issuerAttr, signatureAlgoAttr};
        }
        return null;
    }
}

