/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.mediator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.ReliantContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.debug.constructs.EnclosedInlinedSequence;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.AXIOMUtils;
import org.apache.synapse.util.MessageHelper;
import org.jaxen.JaxenException;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.entitlement.mediator.callback.EntitlementCallbackHandler;
import org.wso2.carbon.identity.entitlement.mediator.callback.UTEntitlementCallbackHandler;
import org.wso2.carbon.identity.entitlement.proxy.Attribute;
import org.wso2.carbon.identity.entitlement.proxy.PEPProxy;
import org.wso2.carbon.identity.entitlement.proxy.PEPProxyConfig;
import org.wso2.carbon.identity.entitlement.proxy.exception.EntitlementProxyException;
import org.wso2.carbon.utils.CarbonUtils;

public class EntitlementMediator
extends AbstractMediator
implements ManagedLifecycle,
FlowContinuableMediator,
EnclosedInlinedSequence {
    private static final Log log = LogFactory.getLog(EntitlementMediator.class);
    private String remoteServiceUserName;
    private String remoteServicePassword;
    private String remoteServiceUrl;
    private String remoteServiceUserNameKey;
    private String remoteServicePasswordKey;
    private String remoteServiceUrlKey;
    private String callbackClass;
    private String client;
    private String thriftPort;
    private String thriftHost;
    private String reuseSession;
    private String cacheType;
    private int invalidationInterval;
    private int maxCacheEntries;
    EntitlementCallbackHandler callback = null;
    private String onRejectSeqKey = null;
    private Mediator onRejectMediator = null;
    private String onAcceptSeqKey = null;
    private Mediator onAcceptMediator = null;
    private String obligationsSeqKey = null;
    private Mediator obligationsMediator = null;
    private String adviceSeqKey = null;
    private Mediator adviceMediator = null;
    private PEPProxy pepProxy;
    private PEPProxyConfig config;
    private boolean keyInvolved = false;
    private final String ORIGINAL_ENTITLEMENT_PAYLOAD = "ORIGINAL_ENTITLEMENT_PAYLOAD";
    private final String ENTITLEMENT_DECISION = "ENTITLEMENT_DECISION";
    private final String ENTITLEMENT_ADVICE = "ENTITLEMENT_ADVICE";

    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediation for Entitlement started");
        }
        PEPProxy resolvedPepProxy = this.pepProxy;
        if (this.keyInvolved) {
            try {
                resolvedPepProxy = this.resolveEntitlementServerDynamicConfigs(synCtx);
            }
            catch (EntitlementProxyException e) {
                log.error((Object)("Error while initializing the PEP Proxy" + (Object)((Object)e)));
                throw new SynapseException("Error while initializing the Entitlement PEP Proxy");
            }
        }
        try {
            OMElement advice;
            OMElement obligations;
            String simpleDecision;
            int i;
            String userName = this.callback.getUserName(synCtx);
            String serviceName = this.callback.findServiceName(synCtx);
            String operationName = this.callback.findOperationName(synCtx);
            String action = this.callback.findAction(synCtx);
            Attribute[] otherAttributes = this.callback.findOtherAttributes(synCtx);
            if (userName == null) {
                throw new SynapseException("User name not provided for the Entitlement mediator - can't proceed");
            }
            String resourceName = operationName != null ? serviceName + "/" + operationName : serviceName;
            if (otherAttributes == null) {
                otherAttributes = new Attribute[]{};
            }
            if (log.isDebugEnabled()) {
                StringBuilder debugOtherAttributes = new StringBuilder();
                debugOtherAttributes.append("Subject ID is : " + userName + " Resource ID is : " + resourceName + " Action ID is : " + action + ".");
                if (otherAttributes.length > 0) {
                    debugOtherAttributes.append("Other attributes are ");
                    for (i = 0; i < otherAttributes.length; ++i) {
                        debugOtherAttributes.append("Attribute ID : ").append(otherAttributes[i].getId()).append(" of Category : ").append(otherAttributes[i].getCategory()).append(" of Type : ").append(otherAttributes[i].getType()).append(" and Value : ").append(otherAttributes[i].getValue());
                        if (i < otherAttributes.length - 2) {
                            debugOtherAttributes.append(", ");
                            continue;
                        }
                        if (i == otherAttributes.length - 2) {
                            debugOtherAttributes.append(" and ");
                            continue;
                        }
                        debugOtherAttributes.append(".");
                    }
                }
                log.debug((Object)debugOtherAttributes);
            }
            Attribute[] tempArr = new Attribute[otherAttributes.length + 3];
            tempArr[0] = new Attribute("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", "urn:oasis:names:tc:xacml:1.0:subject:subject-id", "string", userName);
            tempArr[1] = new Attribute("urn:oasis:names:tc:xacml:3.0:attribute-category:action", "urn:oasis:names:tc:xacml:1.0:action:action-id", "string", action);
            tempArr[2] = new Attribute("urn:oasis:names:tc:xacml:3.0:attribute-category:resource", "urn:oasis:names:tc:xacml:1.0:resource:resource-id", "string", resourceName);
            for (i = 0; i < otherAttributes.length; ++i) {
                tempArr[3 + i] = otherAttributes[i];
            }
            String decisionString = resolvedPepProxy.getDecision(tempArr);
            if (decisionString != null) {
                String nameSpace = null;
                OMElement decisionElement = AXIOMUtil.stringToOM((String)decisionString);
                OMNamespace omNamespace = decisionElement.getDefaultNamespace();
                if (omNamespace != null) {
                    nameSpace = omNamespace.getNamespaceURI();
                }
                if (nameSpace == null) {
                    simpleDecision = decisionElement.getFirstChildWithName(new QName("Result")).getFirstChildWithName(new QName("Decision")).getText();
                    obligations = decisionElement.getFirstChildWithName(new QName("Result")).getFirstChildWithName(new QName("Obligations"));
                    advice = decisionElement.getFirstChildWithName(new QName("Result")).getFirstChildWithName(new QName("AssociatedAdvice"));
                } else {
                    simpleDecision = decisionElement.getFirstChildWithName(new QName(nameSpace, "Result")).getFirstChildWithName(new QName(nameSpace, "Decision")).getText();
                    obligations = decisionElement.getFirstChildWithName(new QName(nameSpace, "Result")).getFirstChildWithName(new QName(nameSpace, "Obligations"));
                    advice = decisionElement.getFirstChildWithName(new QName(nameSpace, "Result")).getFirstChildWithName(new QName(nameSpace, "AssociatedAdvice"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entitlement Decision is : " + simpleDecision));
                }
            } else {
                throw new SynapseException("Undefined Decision is received");
            }
            synCtx.setProperty("ORIGINAL_ENTITLEMENT_PAYLOAD", (Object)synCtx.getEnvelope());
            synCtx.setProperty("ENTITLEMENT_DECISION", (Object)simpleDecision);
            synCtx.setProperty("ENTITLEMENT_ADVICE", (Object)advice);
            if ("Permit".equals(simpleDecision) || "Deny".equals(simpleDecision)) {
                MessageContext obligationsSynCtx = null;
                MessageContext adviceSynCtx = null;
                if (advice != null) {
                    adviceSynCtx = this.getOMElementInserted(advice, this.getClonedMessageContext(synCtx));
                    if (this.adviceSeqKey != null) {
                        SequenceMediator sequence = (SequenceMediator)adviceSynCtx.getSequence(this.adviceSeqKey);
                        ContinuationStackManager.clearStack((MessageContext)adviceSynCtx);
                        adviceSynCtx.getEnvironment().injectAsync(adviceSynCtx, sequence);
                    } else if (this.adviceMediator != null) {
                        ContinuationStackManager.addReliantContinuationState((MessageContext)adviceSynCtx, (int)0, (int)this.getMediatorPosition());
                        adviceSynCtx.getEnvironment().injectAsync(adviceSynCtx, (SequenceMediator)this.adviceMediator);
                    }
                }
                if (obligations != null) {
                    boolean result;
                    obligationsSynCtx = this.getOMElementInserted(obligations, this.getClonedMessageContext(synCtx));
                    if (this.obligationsSeqKey != null) {
                        ContinuationStackManager.addReliantContinuationState((MessageContext)obligationsSynCtx, (int)1, (int)this.getMediatorPosition());
                        obligationsSynCtx.setProperty("SKIP_CONTINUATION_STATE", (Object)true);
                        result = obligationsSynCtx.getSequence(this.obligationsSeqKey).mediate(obligationsSynCtx);
                        Boolean isContinuationCall = (Boolean)obligationsSynCtx.getProperty("continuation.call");
                        if (result) {
                            ContinuationStackManager.removeReliantContinuationState((MessageContext)obligationsSynCtx);
                        } else if (!result && isContinuationCall != null && isContinuationCall.booleanValue()) {
                            return false;
                        }
                    } else {
                        ContinuationStackManager.addReliantContinuationState((MessageContext)obligationsSynCtx, (int)2, (int)this.getMediatorPosition());
                        result = this.obligationsMediator.mediate(obligationsSynCtx);
                        Boolean isContinuationCall = (Boolean)obligationsSynCtx.getProperty("continuation.call");
                        if (result) {
                            ContinuationStackManager.removeReliantContinuationState((MessageContext)obligationsSynCtx);
                        } else if (!result && isContinuationCall != null && isContinuationCall.booleanValue()) {
                            return false;
                        }
                    }
                    if (!result) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Obligations are not correctly performed");
                        }
                        simpleDecision = "Deny";
                    }
                }
            }
            return this.executeDecisionMessageFlow(synCtx, simpleDecision);
        }
        catch (SynapseException e) {
            log.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while evaluating the policy", (Throwable)e);
            throw new SynapseException("Error occurred while evaluating the policy");
        }
    }

    private boolean executeDecisionMessageFlow(MessageContext synCtx, String simpleDecision) {
        if ("Permit".equals(simpleDecision)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"User is authorized to perform the action");
            }
            if (this.onAcceptSeqKey != null) {
                ContinuationStackManager.updateSeqContinuationState((MessageContext)synCtx, (int)this.getMediatorPosition());
                return synCtx.getSequence(this.onAcceptSeqKey).mediate(synCtx);
            }
            if (this.onAcceptMediator != null) {
                ContinuationStackManager.addReliantContinuationState((MessageContext)synCtx, (int)3, (int)this.getMediatorPosition());
                boolean result = this.onAcceptMediator.mediate(synCtx);
                if (result) {
                    ContinuationStackManager.removeReliantContinuationState((MessageContext)synCtx);
                }
                return result;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"OnAccept sequence is not defined.");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"User is not authorized to perform the action");
        }
        if (this.onRejectSeqKey != null) {
            ContinuationStackManager.updateSeqContinuationState((MessageContext)synCtx, (int)this.getMediatorPosition());
            return synCtx.getSequence(this.onRejectSeqKey).mediate(synCtx);
        }
        if (this.onRejectMediator != null) {
            ContinuationStackManager.addReliantContinuationState((MessageContext)synCtx, (int)4, (int)this.getMediatorPosition());
            boolean result = this.onRejectMediator.mediate(synCtx);
            if (result) {
                ContinuationStackManager.removeReliantContinuationState((MessageContext)synCtx);
            }
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"OnReject sequence is not defined.");
        }
        throw new SynapseException("User is not authorized to perform the action");
    }

    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Entitlement mediator : Mediating from ContinuationState");
        }
        if (this.keyInvolved) {
            try {
                this.resolveEntitlementServerDynamicConfigs(synCtx);
            }
            catch (EntitlementProxyException e) {
                log.error((Object)("Error while initializing the PEP Proxy" + (Object)((Object)e)));
                throw new SynapseException("Error while initializing the Entitlement PEP Proxy");
            }
        }
        boolean result = false;
        int subBranch = ((ReliantContinuationState)continuationState).getSubBranch();
        if (subBranch == 0) {
            if (!continuationState.hasChild()) {
                result = ((SequenceMediator)this.adviceMediator).mediate(synCtx, continuationState.getPosition() + 1);
                if (result) {
                    ContinuationStackManager.clearStack((MessageContext)synCtx);
                    return false;
                }
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((SequenceMediator)this.adviceMediator).getChild(continuationState.getPosition());
                result = mediator.mediate(synCtx, continuationState.getChildContState());
            }
        } else if (subBranch == 1 || subBranch == 2) {
            SequenceMediator sequenceMediator = subBranch == 1 ? (SequenceMediator)synCtx.getSequence(this.obligationsSeqKey) : (SequenceMediator)this.obligationsMediator;
            if (!continuationState.hasChild()) {
                result = sequenceMediator.mediate(synCtx, continuationState.getPosition() + 1);
                Boolean isContinuationCall = (Boolean)synCtx.getProperty("continuation.call");
                if (!result && isContinuationCall != null && isContinuationCall.booleanValue()) {
                    return false;
                }
                ContinuationStackManager.removeReliantContinuationState((MessageContext)synCtx);
                String decision = (String)synCtx.getProperty("ENTITLEMENT_DECISION");
                if (!result) {
                    decision = "Deny";
                }
                OMElement originalEnv = (OMElement)synCtx.getProperty("ORIGINAL_ENTITLEMENT_PAYLOAD");
                try {
                    synCtx.setEnvelope(AXIOMUtils.getSOAPEnvFromOM((OMElement)originalEnv));
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error while setting the original envelope back", synCtx);
                }
                result = this.executeDecisionMessageFlow(synCtx, decision);
                if (result) {
                    ContinuationStackManager.addReliantContinuationState((MessageContext)synCtx, (int)1, (int)this.getMediatorPosition());
                }
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)sequenceMediator.getChild(continuationState.getPosition());
                result = mediator.mediate(synCtx, continuationState.getChildContState());
            }
        } else if (subBranch == 3) {
            if (!continuationState.hasChild()) {
                result = ((SequenceMediator)this.onAcceptMediator).mediate(synCtx, continuationState.getPosition() + 1);
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((SequenceMediator)this.onAcceptMediator).getChild(continuationState.getPosition());
                result = mediator.mediate(synCtx, continuationState.getChildContState());
            }
        } else if (subBranch == 4) {
            if (!continuationState.hasChild()) {
                result = ((SequenceMediator)this.onRejectMediator).mediate(synCtx, continuationState.getPosition() + 1);
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((SequenceMediator)this.onRejectMediator).getChild(continuationState.getPosition());
                result = mediator.mediate(synCtx, continuationState.getChildContState());
            }
        }
        return result;
    }

    private static String getServerURL(String url, ConfigurationContext config) {
        String httpsPort;
        if (url.indexOf("${carbon.https.port}") != -1) {
            httpsPort = CarbonUtils.getTransportPort((ConfigurationContext)config, (String)"https") + "";
            url = url.replace("${carbon.https.port}", httpsPort);
        }
        if (url.indexOf("${carbon.management.port}") != -1) {
            httpsPort = CarbonUtils.getTransportPort((ConfigurationContext)config, (String)"https") + "";
            url = url.replace("${carbon.management.port}", httpsPort);
        }
        if (url.indexOf("${carbon.context}") != -1) {
            url = url.replace("${carbon.context}", "");
        }
        return url;
    }

    private Object loadClass(String className) throws AxisFault {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while loading " + className), (Throwable)e);
            return null;
        }
    }

    public void init(SynapseEnvironment synEnv) {
        try {
            if (this.callbackClass != null && this.callbackClass.trim().length() > 0) {
                Object loadedClass = this.loadClass(this.callbackClass);
                if (loadedClass instanceof EntitlementCallbackHandler) {
                    this.callback = (EntitlementCallbackHandler)loadedClass;
                }
            } else {
                this.callback = new UTEntitlementCallbackHandler();
            }
            String remoteServiceUrlResolved = this.remoteServiceUrl;
            String remoteServiceUsernameResolved = this.remoteServiceUserName;
            String remoteServicePasswordResolved = this.remoteServicePassword;
            if (this.remoteServiceUrlKey != null && this.remoteServiceUrlKey.trim().length() > 0) {
                remoteServiceUrlResolved = this.resolveRegistryEntryText(synEnv, this.remoteServiceUrlKey);
                this.keyInvolved = true;
            }
            if (this.remoteServiceUserNameKey != null && this.remoteServiceUserNameKey.trim().length() > 0) {
                remoteServiceUsernameResolved = this.resolveRegistryEntryText(synEnv, this.remoteServiceUserNameKey);
                this.keyInvolved = true;
            }
            if (this.remoteServicePasswordKey != null && this.remoteServicePasswordKey.trim().length() > 0) {
                remoteServicePasswordResolved = this.resolveRegistryEntryText(synEnv, this.remoteServicePasswordKey);
                this.keyInvolved = true;
            }
            HashMap appToPDPClientConfigMap = new HashMap();
            HashMap<String, String> clientConfigMap = new HashMap<String, String>();
            if (this.client != null && this.client.equals("soap")) {
                clientConfigMap.put("client", this.client);
                clientConfigMap.put("serverUrl", remoteServiceUrlResolved);
                clientConfigMap.put("userName", remoteServiceUsernameResolved);
                clientConfigMap.put("password", remoteServicePasswordResolved);
                clientConfigMap.put("reuseSession", this.reuseSession);
            } else if (this.client != null && this.client.equals("basicAuth")) {
                clientConfigMap.put("client", this.client);
                clientConfigMap.put("serverUrl", remoteServiceUrlResolved);
                clientConfigMap.put("userName", remoteServiceUsernameResolved);
                clientConfigMap.put("password", remoteServicePasswordResolved);
            } else if (this.client != null && this.client.equals("thrift")) {
                clientConfigMap.put("client", this.client);
                clientConfigMap.put("serverUrl", remoteServiceUrlResolved);
                clientConfigMap.put("userName", remoteServiceUsernameResolved);
                clientConfigMap.put("password", remoteServicePasswordResolved);
                clientConfigMap.put("reuseSession", this.reuseSession);
                clientConfigMap.put("thriftHost", this.thriftHost);
                clientConfigMap.put("thriftPort", this.thriftPort);
            } else if (this.client != null && this.client.equals("wsXacml")) {
                clientConfigMap.put("client", this.client);
                clientConfigMap.put("serverUrl", remoteServiceUrlResolved);
                clientConfigMap.put("userName", remoteServiceUsernameResolved);
                clientConfigMap.put("password", remoteServicePasswordResolved);
            } else if (this.client == null) {
                clientConfigMap.put("serverUrl", remoteServiceUrlResolved);
                clientConfigMap.put("userName", remoteServiceUsernameResolved);
                clientConfigMap.put("password", remoteServicePasswordResolved);
            } else {
                log.error((Object)"EntitlementMediator initialization error: Unsupported client");
                throw new SynapseException("EntitlementMediator initialization error: Unsupported client");
            }
            appToPDPClientConfigMap.put("EntitlementMediator", clientConfigMap);
            this.config = new PEPProxyConfig(appToPDPClientConfigMap, "EntitlementMediator", this.cacheType, this.invalidationInterval, this.maxCacheEntries);
            try {
                this.pepProxy = new PEPProxy(this.config);
            }
            catch (EntitlementProxyException e) {
                log.error((Object)("Error while initializing the PEP Proxy" + (Object)((Object)e)));
                throw new SynapseException("Error while initializing the Entitlement PEP Proxy");
            }
            if (this.onAcceptMediator instanceof ManagedLifecycle) {
                ((ManagedLifecycle)this.onAcceptMediator).init(synEnv);
            }
            if (this.onRejectMediator instanceof ManagedLifecycle) {
                ((ManagedLifecycle)this.onRejectMediator).init(synEnv);
            }
            if (this.obligationsMediator instanceof ManagedLifecycle) {
                ((ManagedLifecycle)this.obligationsMediator).init(synEnv);
            }
            if (this.adviceMediator instanceof ManagedLifecycle) {
                ((ManagedLifecycle)this.adviceMediator).init(synEnv);
            }
        }
        catch (AxisFault e) {
            String msg = "Error initializing entitlement mediator : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, (Throwable)e);
        }
    }

    public void destroy() {
        this.remoteServiceUserName = null;
        this.remoteServicePassword = null;
        this.remoteServiceUrl = null;
        this.remoteServiceUserNameKey = null;
        this.remoteServicePasswordKey = null;
        this.remoteServiceUrlKey = null;
        this.callbackClass = null;
        this.client = null;
        this.thriftPort = null;
        this.thriftHost = null;
        this.reuseSession = null;
        this.cacheType = null;
        this.callback = null;
        this.onRejectSeqKey = null;
        this.onAcceptSeqKey = null;
        this.obligationsSeqKey = null;
        this.adviceSeqKey = null;
        this.pepProxy = null;
        if (this.onAcceptMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onAcceptMediator).destroy();
        }
        if (this.onRejectMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.onRejectMediator).destroy();
        }
        if (this.obligationsMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.obligationsMediator).destroy();
        }
        if (this.adviceMediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.adviceMediator).destroy();
        }
    }

    private MessageContext getClonedMessageContext(MessageContext synCtx) {
        MessageContext newCtx = null;
        try {
            newCtx = MessageHelper.cloneMessageContext((MessageContext)synCtx);
            ((Axis2MessageContext)newCtx).getAxis2MessageContext().setServerSide(((Axis2MessageContext)synCtx).getAxis2MessageContext().isServerSide());
        }
        catch (AxisFault axisFault) {
            this.handleException("Error cloning the message context", (Exception)((Object)axisFault), synCtx);
        }
        return newCtx;
    }

    private MessageContext getOMElementInserted(OMElement omElement, MessageContext synCtx) throws AxisFault, JaxenException {
        Iterator children = synCtx.getEnvelope().getBody().getChildren();
        while (children.hasNext()) {
            ((OMNode)children.next()).detach();
        }
        synCtx.getEnvelope().getBody().addChild((OMNode)omElement);
        return synCtx;
    }

    private SOAPEnvelope createDefaultSOAPEnvelope(MessageContext inMsgCtx) {
        String soapNamespace = inMsgCtx.getEnvelope().getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = null;
        if (soapNamespace.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            log.error((Object)"Unknown SOAP Envelope");
        }
        return soapFactory.getDefaultEnvelope();
    }

    private String resolveRegistryEntryText(SynapseEnvironment synEnv, String regEntryKey) {
        OMNode regEntry = synEnv.getSynapseConfiguration().getRegistry().lookup(regEntryKey);
        String resolvedValue = "";
        if (regEntry instanceof OMElement) {
            OMElement e = (OMElement)regEntry;
            resolvedValue = e.toString();
        } else if (regEntry instanceof OMText) {
            resolvedValue = ((OMText)regEntry).getText();
        } else if (regEntry instanceof String) {
            resolvedValue = (String)regEntry;
        }
        if (resolvedValue.startsWith("enc:")) {
            try {
                resolvedValue = new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(resolvedValue.substring(4)));
            }
            catch (CryptoException e) {
                log.error((Object)("Error decrypting key " + (Object)((Object)e)));
            }
        }
        return resolvedValue;
    }

    private String resolveRegistryEntryText(MessageContext synCtx, String regEntryKey) {
        Object regEntry = synCtx.getEntry(regEntryKey);
        String resolvedValue = "";
        if (regEntry instanceof OMElement) {
            OMElement e = (OMElement)regEntry;
            resolvedValue = e.toString();
        } else if (regEntry instanceof OMText) {
            resolvedValue = ((OMText)regEntry).getText();
        } else if (regEntry instanceof String) {
            resolvedValue = (String)regEntry;
        }
        if (resolvedValue.startsWith("enc:")) {
            try {
                resolvedValue = new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(resolvedValue.substring(4)));
            }
            catch (CryptoException e) {
                log.error((Object)("Error decrypting key " + (Object)((Object)e)));
            }
        }
        return resolvedValue;
    }

    private PEPProxy resolveEntitlementServerDynamicConfigs(MessageContext synCtx) throws EntitlementProxyException {
        if (this.remoteServiceUrlKey != null && this.remoteServiceUrlKey.trim().length() > 0) {
            ((Map)this.config.getAppToPDPClientConfigMap().get("EntitlementMediator")).put("serverUrl", this.resolveRegistryEntryText(synCtx, this.remoteServiceUrlKey));
        }
        if (this.remoteServiceUserNameKey != null && this.remoteServiceUserNameKey.trim().length() > 0) {
            ((Map)this.config.getAppToPDPClientConfigMap().get("EntitlementMediator")).put("userName", this.resolveRegistryEntryText(synCtx, this.remoteServiceUserNameKey));
        }
        if (this.remoteServicePasswordKey != null && this.remoteServicePasswordKey.trim().length() > 0) {
            ((Map)this.config.getAppToPDPClientConfigMap().get("EntitlementMediator")).put("password", this.resolveRegistryEntryText(synCtx, this.remoteServicePasswordKey));
        }
        return new PEPProxy(this.config);
    }

    public String getCallbackClass() {
        return this.callbackClass;
    }

    public void setCallbackClass(String callbackClass) {
        this.callbackClass = callbackClass;
    }

    public String getRemoteServiceUserName() {
        return this.remoteServiceUserName;
    }

    public void setRemoteServiceUserName(String remoteServiceUserName) {
        this.remoteServiceUserName = remoteServiceUserName;
    }

    public String getRemoteServiceUserNameKey() {
        return this.remoteServiceUserNameKey;
    }

    public void setRemoteServiceUserNameKey(String remoteServiceUserNameKey) {
        this.remoteServiceUserNameKey = remoteServiceUserNameKey;
    }

    public String getRemoteServicePasswordKey() {
        return this.remoteServicePasswordKey;
    }

    public void setRemoteServicePasswordKey(String remoteServicePasswordKey) {
        this.remoteServicePasswordKey = remoteServicePasswordKey;
    }

    public String getRemoteServicePassword() {
        if (this.remoteServicePassword != null && !this.remoteServicePassword.isEmpty() && !this.remoteServicePassword.startsWith("enc:")) {
            try {
                return "enc:" + CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(this.remoteServicePassword.getBytes());
            }
            catch (CryptoException e) {
                log.error((Object)e);
            }
        }
        return this.remoteServicePassword;
    }

    public void setRemoteServicePassword(String remoteServicePassword) {
        if (remoteServicePassword.startsWith("enc:")) {
            try {
                this.remoteServicePassword = new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(remoteServicePassword.substring(4)));
            }
            catch (CryptoException e) {
                log.error((Object)e);
            }
        } else {
            this.remoteServicePassword = remoteServicePassword;
        }
    }

    public String getRemoteServiceUrl() {
        return this.remoteServiceUrl;
    }

    public void setRemoteServiceUrl(String remoteServiceUrl) {
        this.remoteServiceUrl = remoteServiceUrl;
    }

    public String getRemoteServiceUrlKey() {
        return this.remoteServiceUrlKey;
    }

    public void setRemoteServiceUrlKey(String remoteServiceUrlKey) {
        this.remoteServiceUrlKey = remoteServiceUrlKey;
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(String cacheType) {
        this.cacheType = cacheType;
    }

    public int getInvalidationInterval() {
        return this.invalidationInterval;
    }

    public void setInvalidationInterval(int invalidationInterval) {
        this.invalidationInterval = invalidationInterval;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getThriftPort() {
        return this.thriftPort;
    }

    public void setThriftPort(String thriftPort) {
        this.thriftPort = thriftPort;
    }

    public String getThriftHost() {
        return this.thriftHost;
    }

    public void setThriftHost(String thriftHost) {
        this.thriftHost = thriftHost;
    }

    public String getReuseSession() {
        return this.reuseSession;
    }

    public void setReuseSession(String reuseSession) {
        this.reuseSession = reuseSession;
    }

    public String getOnRejectSeqKey() {
        return this.onRejectSeqKey;
    }

    public void setOnRejectMediator(Mediator onRejectMediator) {
        this.onRejectMediator = onRejectMediator;
    }

    public String getOnAcceptSeqKey() {
        return this.onAcceptSeqKey;
    }

    public void setOnAcceptMediator(Mediator onAcceptMediator) {
        this.onAcceptMediator = onAcceptMediator;
    }

    public Mediator getOnRejectMediator() {
        return this.onRejectMediator;
    }

    public void setOnRejectSeqKey(String onRejectSeqKey) {
        this.onRejectSeqKey = onRejectSeqKey;
    }

    public Mediator getOnAcceptMediator() {
        return this.onAcceptMediator;
    }

    public void setOnAcceptSeqKey(String onAcceptSeqKey) {
        this.onAcceptSeqKey = onAcceptSeqKey;
    }

    public String getObligationsSeqKey() {
        return this.obligationsSeqKey;
    }

    public void setObligationsMediator(Mediator obligationsMediator) {
        this.obligationsMediator = obligationsMediator;
    }

    public Mediator getObligationsMediator() {
        return this.obligationsMediator;
    }

    public void setObligationsSeqKey(String obligationsSeqKey) {
        this.obligationsSeqKey = obligationsSeqKey;
    }

    public Mediator getAdviceMediator() {
        return this.adviceMediator;
    }

    public void setAdviceMediator(Mediator adviceMediator) {
        this.adviceMediator = adviceMediator;
    }

    public String getAdviceSeqKey() {
        return this.adviceSeqKey;
    }

    public void setAdviceSeqKey(String adviceSeqKey) {
        this.adviceSeqKey = adviceSeqKey;
    }

    public Mediator getInlineSequence(SynapseConfiguration synCfg, int inlinedSeqIdentifier) {
        if (inlinedSeqIdentifier == 0) {
            if (this.onRejectMediator != null) {
                return this.onRejectMediator;
            }
            if (this.onRejectSeqKey != null) {
                return synCfg.getSequence(this.onRejectSeqKey);
            }
        } else if (inlinedSeqIdentifier == 1) {
            if (this.onAcceptMediator != null) {
                return this.onAcceptMediator;
            }
            if (this.onAcceptSeqKey != null) {
                return synCfg.getSequence(this.onAcceptSeqKey);
            }
        } else if (inlinedSeqIdentifier == 2) {
            if (this.obligationsMediator != null) {
                return this.obligationsMediator;
            }
            if (this.obligationsSeqKey != null) {
                return synCfg.getSequence(this.obligationsSeqKey);
            }
        } else if (inlinedSeqIdentifier == 3) {
            if (this.adviceMediator != null) {
                return this.adviceMediator;
            }
            if (this.adviceSeqKey != null) {
                return synCfg.getSequence(this.adviceSeqKey);
            }
        }
        return null;
    }
}

