/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.utils;

import java.io.File;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.service.exception.ConfigurationException;
import org.wso2.carbon.andes.utils.LocalDatabaseCreator;
import org.wso2.carbon.andes.utils.MBDatabaseConfig;
import org.wso2.carbon.utils.CarbonUtils;

public final class MessageBrokerDBUtil {
    private static final Log log = LogFactory.getLog(MessageBrokerDBUtil.class);
    private static final String DB_CHECK_SQL = "SELECT * FROM MB_QUEUE_COUNTER";
    private static volatile DataSource messageStoreDataSource = null;
    private static volatile DataSource contextStoreDataSource = null;
    private boolean isMessageStoreDataSourceSet;
    private boolean isContextStoreDataSourceSet;

    public void initialize() throws ConfigurationException {
        String dSetupValue = System.getProperty("setup");
        if (dSetupValue != null) {
            String brokerConfigFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "broker.xml";
            MBDatabaseConfig mbDatabaseConfig = new MBDatabaseConfig(brokerConfigFilePath);
            this.setMessageStoreDataSource(mbDatabaseConfig);
            if (this.isMessageStoreDataSourceSet) {
                this.setupMBStoreRdbmsDatabase(messageStoreDataSource);
            }
            this.setContextStoreDataSource(mbDatabaseConfig);
            if (this.isContextStoreDataSourceSet) {
                this.setupMBStoreRdbmsDatabase(contextStoreDataSource);
            }
        }
    }

    private void setMessageStoreDataSource(MBDatabaseConfig dbConfig) {
        try {
            InitialContext initContext = new InitialContext();
            messageStoreDataSource = (DataSource)initContext.lookup(dbConfig.getMessageStoreJndiName());
            this.isMessageStoreDataSourceSet = true;
        }
        catch (NamingException e) {
            log.error((Object)("Cannot lookup data source named " + dbConfig.getMessageStoreJndiName() + ". Cannot setup message store"), (Throwable)e);
        }
    }

    private void setContextStoreDataSource(MBDatabaseConfig dbConfig) {
        try {
            if (dbConfig.isContextStoreAvaliable()) {
                contextStoreDataSource = (DataSource)InitialContext.doLookup(dbConfig.getContextStoreJndiName());
                this.isContextStoreDataSourceSet = true;
            } else {
                this.isContextStoreDataSourceSet = false;
            }
        }
        catch (NamingException e) {
            log.info((Object)("Cannot lookup data source named " + dbConfig.getContextStoreJndiName() + ". It is optional to use this"));
        }
    }

    private void setupMBStoreRdbmsDatabase(DataSource dataSource) throws ConfigurationException {
        LocalDatabaseCreator databaseCreator = new LocalDatabaseCreator(dataSource);
        try {
            if (!databaseCreator.isDatabaseStructureCreated(DB_CHECK_SQL)) {
                databaseCreator.createRegistryDatabase();
            } else {
                log.info((Object)"Message Broker database store already exists. Not creating a new database.");
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)"Unexpected error occurred while creating database: ", (Throwable)e);
            throw new ConfigurationException("Unexpected error occurred while  creating database. ", e);
        }
        this.verifyRdbmsDatabase(databaseCreator);
    }

    private void verifyRdbmsDatabase(LocalDatabaseCreator databaseCreator) throws RuntimeException {
        if (!databaseCreator.isDatabaseStructureCreated(DB_CHECK_SQL)) {
            log.error((Object)"Unable to read sourced database tables. Database not  successfully created.");
            throw new RuntimeException("Unable to read sourced database tables. Database not  successfully created.");
        }
        log.info((Object)"Successfully sourced relevant sql files to database.");
    }
}

