/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.utils;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MBDatabaseConfig {
    private static final Log log = LogFactory.getLog(MBDatabaseConfig.class);
    private String messageStoreJndiName;
    private String contextStoreJndiName;

    public MBDatabaseConfig(String filePath) {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document dDoc = builder.parse(filePath);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String messageStoreXpath = "/broker/persistence/messageStore/property[@name='dataSource']";
            String contextStoreXpath = "/broker/persistence/contextStore/property[@name='dataSource']";
            this.messageStoreJndiName = (String)xPath.evaluate(messageStoreXpath, dDoc, XPathConstants.STRING);
            this.contextStoreJndiName = (String)xPath.evaluate(contextStoreXpath, dDoc, XPathConstants.STRING);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            log.error((Object)("Error when parsing file " + filePath + " to get MB data source JNDI names"), (Throwable)e);
        }
    }

    public String getMessageStoreJndiName() {
        return this.messageStoreJndiName;
    }

    public String getContextStoreJndiName() {
        return this.contextStoreJndiName;
    }

    public boolean isContextStoreAvaliable() {
        return !this.messageStoreJndiName.equals(this.contextStoreJndiName);
    }
}

