/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.utils;

import java.io.File;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.service.exception.ConfigurationException;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class LocalDatabaseCreator
extends DatabaseCreator {
    private static final Log log = LogFactory.getLog(LocalDatabaseCreator.class);
    private DataSource dataSource;

    public LocalDatabaseCreator(DataSource dataSource) {
        super(dataSource);
        this.dataSource = dataSource;
    }

    public void createRegistryDatabase() throws ConfigurationException {
        File scriptFile;
        try {
            String databaseType = DatabaseCreator.getDatabaseType((Connection)this.dataSource.getConnection());
            String scriptPath = this.getDbScriptLocation(databaseType);
            scriptFile = new File(scriptPath);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error occurred while connecting to the database.", (Throwable)e);
            throw new ConfigurationException("Unexpected error occurred while connecting to the database.", e);
        }
        if (scriptFile.canRead()) {
            try {
                super.createRegistryDatabase();
            }
            catch (Exception e) {
                log.error((Object)"Unexpected error occurred while creating the database tables.", (Throwable)e);
                throw new ConfigurationException("Unexpected error occurred while creating the database tables.", e);
            }
        } else {
            log.error((Object)("Unexpected error occurred while reading db script : " + scriptFile));
            throw new ConfigurationException("Unexpected error occurred while reading db script");
        }
    }

    protected String getDbScriptLocation(String databaseType) {
        String scriptName = databaseType + "-mb.sql";
        String carbonHome = System.getProperty("carbon.home");
        String databaseSqlScriptPath = carbonHome + File.separator + "dbscripts" + File.separator + "mb-store" + File.separator + scriptName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load database path : " + databaseSqlScriptPath));
        }
        return databaseSqlScriptPath;
    }
}

