/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.util.ConfigurationProperty;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.carbon.andes.commons.QueueDetails;
import org.wso2.carbon.andes.commons.SubscriptionDetails;
import org.wso2.carbon.andes.commons.registry.RegistryClient;
import org.wso2.carbon.andes.commons.registry.RegistryClientException;
import org.wso2.carbon.andes.internal.QpidServiceDataHolder;
import org.wso2.carbon.andes.listeners.BrokerLifecycleListener;
import org.wso2.carbon.andes.service.QpidService;
import org.wso2.carbon.andes.service.exception.ConfigurationException;

public class QpidServiceImpl
implements QpidService {
    private static final Log log = LogFactory.getLog(QpidServiceImpl.class);
    private static String CARBON_CLIENT_ID = "carbon";
    private static String CARBON_VIRTUAL_HOST_NAME = "carbon";
    private static String CARBON_DEFAULT_HOSTNAME = "localhost";
    public static final String QPID_CONF = "qpid.conf";
    private static String QPID_CONF_DIR = "/repository/conf/advanced/";
    private static final String DOMAIN_NAME_SEPARATOR = "@";
    private static final String DOMAIN_NAME_SEPARATOR_INTERNAL = "!";
    private String accessKey = "";
    private String hostname = CARBON_DEFAULT_HOSTNAME;
    private Integer amqpPort = 5672;
    private Integer amqpSSLPort = 8672;
    private Integer mqttPort = 1883;
    private Integer mqttSSLPort = 8883;

    public QpidServiceImpl(String accessKey) {
        this.accessKey = accessKey;
    }

    public void loadConfigurations() {
        String andesConfigHostAddress = String.valueOf(AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_BIND_ADDRESS));
        if (StringUtils.isNotBlank((String)andesConfigHostAddress)) {
            try {
                this.hostname = InetAddress.getByName(andesConfigHostAddress).getHostAddress();
            }
            catch (UnknownHostException e) {
                this.hostname = CARBON_DEFAULT_HOSTNAME;
            }
        }
        this.amqpPort = this.readPortFromConfig();
        this.amqpSSLPort = this.readSSLPortFromConfig();
        this.mqttPort = this.readMQTTPortFromConfig();
        this.mqttSSLPort = this.readMQTTSSLPortFromConfig();
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public String getClientID() {
        return CARBON_CLIENT_ID;
    }

    @Override
    public String getVirtualHostName() {
        return CARBON_VIRTUAL_HOST_NAME;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public Integer getAMQPPort() {
        return this.amqpPort;
    }

    @Override
    public void setAMQPPort(Integer amqpPort) {
        this.amqpPort = amqpPort;
    }

    @Override
    public Integer getAMQPSSLPort() {
        return this.amqpSSLPort;
    }

    @Override
    public void setAMQPSSLPort(Integer amqpSSLPort) {
        this.amqpSSLPort = amqpSSLPort;
    }

    @Override
    public Integer getMqttPort() {
        return this.mqttPort;
    }

    @Override
    public void setMqttPort(Integer mqttPort) {
        this.mqttPort = mqttPort;
    }

    @Override
    public Integer getMqttSSLPort() {
        return this.mqttSSLPort;
    }

    @Override
    public void setMqttSSLPort(Integer mqttSSLPort) {
        this.mqttSSLPort = mqttSSLPort;
    }

    @Override
    public String getInVMConnectionURL(String username) {
        username = this.getInternalTenantUsername(username);
        return "amqp://" + username + ":" + this.accessKey + DOMAIN_NAME_SEPARATOR + CARBON_CLIENT_ID + "/" + CARBON_VIRTUAL_HOST_NAME + "?brokerlist='vm://:1'";
    }

    @Override
    public String getTCPConnectionURL(String username, String password) {
        return "amqp://" + username + ":" + password + DOMAIN_NAME_SEPARATOR + CARBON_CLIENT_ID + "/" + CARBON_VIRTUAL_HOST_NAME + "?brokerlist='tcp://" + this.hostname + ":" + this.amqpPort + "'";
    }

    @Override
    public String getTCPConnectionURL(String username, String password, String clientID) {
        return "amqp://" + username + ":" + password + DOMAIN_NAME_SEPARATOR + clientID + "/" + CARBON_VIRTUAL_HOST_NAME + "?brokerlist='tcp://" + this.hostname + ":" + this.amqpPort + "'";
    }

    @Override
    public String getInternalTCPConnectionURL(String username, String password) {
        username = this.getInternalTenantUsername(username);
        return "amqp://" + username + ":" + password + DOMAIN_NAME_SEPARATOR + CARBON_CLIENT_ID + "/" + CARBON_VIRTUAL_HOST_NAME + "?brokerlist='tcp://" + this.hostname + ":" + this.amqpPort + "'";
    }

    @Override
    public String getInternalTCPConnectionURL(String username, String password, String clientID) {
        username = this.getInternalTenantUsername(username);
        return "amqp://" + username + ":" + password + DOMAIN_NAME_SEPARATOR + clientID + "/" + CARBON_VIRTUAL_HOST_NAME + "?brokerlist='tcp://" + this.hostname + ":" + this.amqpPort + "'";
    }

    @Override
    public String getQpidHome() {
        String qpidPath = System.getProperty(QPID_CONF);
        if (qpidPath != null) {
            QPID_CONF_DIR = Paths.get(qpidPath, new String[0]).toString();
        }
        return System.getProperty("carbon.home") + QPID_CONF_DIR;
    }

    @Override
    public QueueDetails[] getQueues(boolean isDurable) {
        QueueDetails[] queueDetails = null;
        try {
            queueDetails = RegistryClient.getQueues();
        }
        catch (RegistryClientException e) {
            log.error((Object)"Error while retrieving queue details.", (Throwable)e);
        }
        return queueDetails;
    }

    @Override
    public SubscriptionDetails[] getSubscriptions(String topic, boolean isDurable) {
        SubscriptionDetails[] subsDetails = null;
        try {
            subsDetails = RegistryClient.getSubscriptions((String)topic);
        }
        catch (RegistryClientException e) {
            log.error((Object)"Error while retrieving subscription details", (Throwable)e);
        }
        return subsDetails;
    }

    private Integer readPortFromConfig() {
        return (Integer)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_DEFAULT_CONNECTION_PORT);
    }

    private Integer readSSLPortFromConfig() {
        return (Integer)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_PORT);
    }

    private Integer readMQTTPortFromConfig() {
        return (Integer)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_MQTT_DEFAULT_CONNECTION_PORT);
    }

    private Integer readMQTTSSLPortFromConfig() {
        return (Integer)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_PORT);
    }

    private String getInternalTenantUsername(String username) {
        return username.replace(DOMAIN_NAME_SEPARATOR, DOMAIN_NAME_SEPARATOR_INTERNAL);
    }

    public boolean getMQTTSSLOnly() throws ConfigurationException {
        return ApplicationRegistry.getInstance().getConfiguration().getMQTTSSLOnly();
    }

    @Override
    public boolean getIfSSLOnly() throws ConfigurationException {
        return ApplicationRegistry.getInstance().getConfiguration().getSSLOnly();
    }

    @Override
    public void registerBrokerLifecycleListener(BrokerLifecycleListener brokerLifecycleListener) {
        QpidServiceDataHolder.getInstance().getBrokerLifecycleListeners().add(brokerLifecycleListener);
    }
}

