/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.listeners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesKernelBoot;
import org.wso2.carbon.core.ServerShutdownHandler;

public class AndesServerShutDownListener
implements ServerShutdownHandler {
    private static final Log log = LogFactory.getLog(AndesServerShutDownListener.class);
    private ServiceRegistration qpidService = null;

    public AndesServerShutDownListener(ServiceRegistration qpidService) {
        this.qpidService = qpidService;
    }

    public void invoke() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Shutting down all dependent services and threads before stopping all osgi components to allow graceful shutdown.");
        }
        if (null != this.qpidService) {
            this.qpidService.unregister();
        }
        try {
            AndesKernelBoot.shutDownAndesKernel();
        }
        catch (AndesException e) {
            log.error((Object)"Error while shutting down Andes kernel. ", (Throwable)e);
        }
    }
}

