/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.internal;

import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Set;
import java.util.Stack;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.util.ConfigurationProperty;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesKernelBoot;
import org.wso2.andes.server.Main;
import org.wso2.andes.server.cluster.coordination.hazelcast.HazelcastAgent;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.wso2.service.QpidNotificationService;
import org.wso2.carbon.andes.authentication.service.AuthenticationService;
import org.wso2.carbon.andes.event.core.EventBundleNotificationService;
import org.wso2.carbon.andes.event.core.qpid.QpidServerDetails;
import org.wso2.carbon.andes.internal.QpidServiceDataHolder;
import org.wso2.carbon.andes.listeners.BrokerLifecycleListener;
import org.wso2.carbon.andes.listeners.MessageBrokerTenantManagementListener;
import org.wso2.carbon.andes.service.QpidService;
import org.wso2.carbon.andes.service.QpidServiceImpl;
import org.wso2.carbon.andes.service.exception.ConfigurationException;
import org.wso2.carbon.andes.utils.MessageBrokerDBUtil;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.ServerRestartHandler;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.andes.internal.QpidServiceComponent", immediate=true)
public class QpidServiceComponent {
    private static final Log log = LogFactory.getLog(QpidServiceComponent.class);
    private static final String CARBON_CONFIG_PORT_OFFSET = "Ports.Offset";
    private static final int CARBON_DEFAULT_PORT_OFFSET = 0;
    protected static final String MODE_STANDALONE = "standalone";
    protected static final String MODE_DEFAULT = "default";
    private static BundleContext bundleContext;
    private static Stack<ServiceRegistration> registrations;
    private boolean brokerShouldBeStarted = false;
    private boolean registeredHazelcast = false;
    private QpidServiceImpl qpidServiceImpl;

    @Activate
    protected void activate(ComponentContext context) throws AndesException {
        try {
            AndesConfigurationManager.initialize((int)this.readPortOffset());
            this.qpidServiceImpl = new QpidServiceImpl(QpidServiceDataHolder.getInstance().getAccessKey());
            this.qpidServiceImpl.loadConfigurations();
            bundleContext = context.getBundleContext();
            MessageBrokerTenantManagementListener tenantManagementListener = new MessageBrokerTenantManagementListener();
            registrations.push(bundleContext.registerService(TenantMgtListener.class.getName(), (Object)tenantManagementListener, null));
            AndesContext.getInstance().constructStoreConfiguration();
            String mode = (String)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.DEPLOYMENT_MODE);
            if (mode.equalsIgnoreCase(MODE_STANDALONE)) {
                AndesContext.getInstance().setClusteringEnabled(false);
                this.startAndesBroker();
            } else if (mode.equalsIgnoreCase(MODE_DEFAULT)) {
                if (!AndesContext.getInstance().isClusteringEnabled()) {
                    this.startAndesBroker();
                } else if (this.registeredHazelcast) {
                    this.startAndesBroker();
                } else {
                    this.brokerShouldBeStarted = true;
                }
            } else {
                throw new ConfigurationException("Invalid value " + mode + " for deployment/mode in broker.xml");
            }
            MBShutdownHandler mbShutdownHandler = new MBShutdownHandler();
            registrations.push(bundleContext.registerService(ServerShutdownHandler.class.getName(), (Object)mbShutdownHandler, null));
            registrations.push(bundleContext.registerService(ServerRestartHandler.class.getName(), (Object)mbShutdownHandler, null));
        }
        catch (ConfigurationException e) {
            log.error((Object)"Invalid configuration found in a configuration file", (Throwable)e);
            this.shutdown();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        while (!registrations.empty()) {
            registrations.pop().unregister();
        }
        bundleContext = null;
    }

    @Reference(name="org.wso2.carbon.andes.authentication.service.AuthenticationService", service=AuthenticationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAccessKey")
    protected void setAccessKey(AuthenticationService authenticationService) {
        QpidServiceDataHolder.getInstance().setAccessKey(authenticationService.getAccessKey());
    }

    protected void unsetAccessKey(AuthenticationService authenticationService) {
        QpidServiceDataHolder.getInstance().setAccessKey(null);
    }

    @Reference(name="org.wso2.andes.wso2.service.QpidNotificationService", service=QpidNotificationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetQpidNotificationService")
    protected void setQpidNotificationService(QpidNotificationService qpidNotificationService) {
    }

    protected void unsetQpidNotificationService(QpidNotificationService qpidNotificationService) {
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfiguration")
    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        QpidServiceDataHolder.getInstance().setCarbonConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        QpidServiceDataHolder.getInstance().setCarbonConfiguration(null);
    }

    @Reference(name="event.broker", service=EventBundleNotificationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventBundleNotificationService")
    protected void setEventBundleNotificationService(EventBundleNotificationService eventBundleNotificationService) {
        QpidServiceDataHolder.getInstance().registerEventBundleNotificationService(eventBundleNotificationService);
    }

    protected void unsetEventBundleNotificationService(EventBundleNotificationService eventBundleNotificationService) {
    }

    @Reference(name="hazelcast.instance.service", service=HazelcastInstance.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetHazelcastInstance")
    protected void setHazelcastInstance(HazelcastInstance hazelcastInstance) throws AndesException {
        HazelcastAgent.getInstance().init(hazelcastInstance);
        this.registeredHazelcast = true;
        if (this.brokerShouldBeStarted) {
            try {
                this.startAndesBroker();
            }
            catch (ConfigurationException e) {
                log.error((Object)"Invalid configuration found in a configuration file", (Throwable)e);
                this.shutdown();
            }
        }
    }

    protected void unsetHazelcastInstance(HazelcastInstance hazelcastInstance) {
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        ClusteringAgent agent = configurationContextService.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
        AndesContext.getInstance().setClusteringEnabled(agent != null);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
    }

    @Reference(name="org.wso2.carbon.server.admin.common.IServerAdmin", service=IServerAdmin.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIServerAdmin")
    protected void setIServerAdmin(IServerAdmin iServerAdmin) {
        QpidServiceDataHolder.getInstance().setService(iServerAdmin);
    }

    protected void unsetIServerAdmin(IServerAdmin iServerAdmin) {
        QpidServiceDataHolder.getInstance().setService(null);
    }

    private void shutdown() throws AndesException {
        try {
            QpidServiceDataHolder.getInstance().getService().shutdownGracefully();
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while shutting down", (Throwable)e);
            throw new AndesException("Error occurred while shutting down", (Throwable)e);
        }
    }

    private boolean isBrokerRunning() {
        boolean response = false;
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> set = mBeanServer.queryNames(new ObjectName("org.wso2.andes:type=VirtualHost.VirtualHostManager,*"), null);
            if (set.size() > 0) {
                response = true;
            }
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"Error checking if broker is running.", (Throwable)e);
        }
        return response;
    }

    private int readPortOffset() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String portOffset = System.getProperty("portOffset", carbonConfig.getFirstProperty(CARBON_CONFIG_PORT_OFFSET));
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private String getTransportBindAddress() {
        return (String)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_BIND_ADDRESS);
    }

    private String getMQTTTransportBindAddress() {
        return (String)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_MQTT_BIND_ADDRESS);
    }

    private String getAMQPTransportBindAddress() {
        return (String)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_BIND_ADDRESS);
    }

    private void startAndesBroker() throws ConfigurationException, AndesException {
        this.brokerShouldBeStarted = false;
        String dSetupValue = System.getProperty("setup");
        if (dSetupValue != null) {
            MessageBrokerDBUtil messageBrokerDBUtil = new MessageBrokerDBUtil();
            messageBrokerDBUtil.initialize();
        }
        log.info((Object)"Activating Andes Message Broker Engine...");
        System.setProperty("ANDES_HOME", this.qpidServiceImpl.getQpidHome());
        String[] args = new String[]{"-p" + this.qpidServiceImpl.getAMQPPort(), "-s" + this.qpidServiceImpl.getAMQPSSLPort(), "-q" + this.qpidServiceImpl.getMqttPort()};
        Main.main((String[])args);
        Runtime.getRuntime().removeShutdownHook(ApplicationRegistry.getShutdownHook());
        while (!this.isBrokerRunning()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.startAMQPServer();
        this.startMQTTServer();
        log.info((Object)"WSO2 Message Broker is started.");
        registrations.push(bundleContext.registerService(QpidService.class.getName(), (Object)this.qpidServiceImpl, null));
        Integer brokerPort = this.qpidServiceImpl.getIfSSLOnly() ? this.qpidServiceImpl.getAMQPSSLPort() : this.qpidServiceImpl.getAMQPPort();
        QpidServerDetails qpidServerDetails = new QpidServerDetails(this.qpidServiceImpl.getAccessKey(), this.qpidServiceImpl.getClientID(), this.qpidServiceImpl.getVirtualHostName(), this.qpidServiceImpl.getHostname(), brokerPort.toString(), this.qpidServiceImpl.getIfSSLOnly());
        QpidServiceDataHolder.getInstance().getEventBundleNotificationService().notifyStart(qpidServerDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAMQPServer() throws ConfigurationException {
        boolean isServerStarted = false;
        int port = this.qpidServiceImpl.getIfSSLOnly() ? this.qpidServiceImpl.getAMQPSSLPort().intValue() : this.qpidServiceImpl.getAMQPPort().intValue();
        if (((Boolean)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_ENABLED)).booleanValue()) {
            while (!isServerStarted) {
                Socket socket = null;
                try {
                    InetAddress address = InetAddress.getByName(this.getAMQPTransportBindAddress());
                    socket = new Socket(address, port);
                    log.info((Object)("AMQP Host Address : " + address.getHostAddress() + " Port : " + port));
                    isServerStarted = socket.isConnected();
                    if (!isServerStarted) continue;
                    log.info((Object)("Successfully connected to AMQP server on port " + port));
                }
                catch (IOException e) {
                    log.error((Object)("Wait until Qpid server starts on port " + port), (Throwable)e);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        if (socket == null || !socket.isConnected()) continue;
                        socket.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Can not close the socket which is used to check the server status ", (Throwable)e);
                    }
                }
            }
        } else {
            log.warn((Object)"AMQP Transport is disabled as per configuration.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMQTTServer() throws ConfigurationException {
        boolean isServerStarted = false;
        int port = this.qpidServiceImpl.getMQTTSSLOnly() ? this.qpidServiceImpl.getMqttSSLPort().intValue() : this.qpidServiceImpl.getMqttPort().intValue();
        if (((Boolean)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_MQTT_ENABLED)).booleanValue()) {
            while (!isServerStarted) {
                Socket socket = null;
                try {
                    InetAddress address = InetAddress.getByName(this.getMQTTTransportBindAddress());
                    socket = new Socket(address, port);
                    log.info((Object)("MQTT Host Address : " + address.getHostAddress() + " Port : " + port));
                    isServerStarted = socket.isConnected();
                    if (!isServerStarted) continue;
                    log.info((Object)("Successfully connected to MQTT server on port " + port));
                }
                catch (IOException e) {
                    log.error((Object)("Wait until server starts on port " + port), (Throwable)e);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        if (socket == null || !socket.isConnected()) continue;
                        socket.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Can not close the socket which is used to check the server status ", (Throwable)e);
                    }
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"MQTT Transport is disabled as per configuration.");
        }
    }

    static {
        registrations = new Stack();
    }

    private static class MBShutdownHandler
    implements ServerShutdownHandler,
    ServerRestartHandler {
        private MBShutdownHandler() {
        }

        public void invoke() {
            try {
                for (BrokerLifecycleListener listener : QpidServiceDataHolder.getInstance().getBrokerLifecycleListeners()) {
                    listener.onShuttingdown();
                }
                AndesKernelBoot.shutDownAndesKernel();
                for (BrokerLifecycleListener listener : QpidServiceDataHolder.getInstance().getBrokerLifecycleListeners()) {
                    listener.onShutdown();
                }
            }
            catch (AndesException e) {
                log.error((Object)"Error while shutting down Andes kernel. ", (Throwable)e);
            }
        }
    }
}

