/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.theme.mgt.internal;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.theme.mgt.util.ThemeLoadingListener;
import org.wso2.carbon.theme.mgt.util.ThemeUtil;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.governance.theme.tenant", immediate=true)
public class TenantThemeMgtServiceComponent {
    private static Log log = LogFactory.getLog(TenantThemeMgtServiceComponent.class);
    private static ConfigurationContextService configContextService = null;

    @Activate
    protected void activate(ComponentContext context) {
        try {
            ThemeUtil.loadResourceThemes();
            BundleContext bundleContext = context.getBundleContext();
            bundleContext.registerService(TenantMgtListener.class.getName(), (Object)new ThemeLoadingListener(), new Hashtable());
            log.debug((Object)"******* Multitenancy Theme Config bundle is activated ******* ");
        }
        catch (Exception e) {
            log.error((Object)"******* Multitenancy Theme Config bundle failed activating ****", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Multitenancy Theme Config bundle is deactivated ******* ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        ThemeUtil.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ThemeUtil.setRegistryService(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        ThemeUtil.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        ThemeUtil.setRealmService(null);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the ConfigurationContext");
        }
        configContextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the ConfigurationContext");
        }
    }
}

