/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.uri.template.parser;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    protected String token;
    protected Node next;

    protected Node(String token) {
        this.token = token;
    }

    public void setNext(Node next) {
        this.next = next;
    }

    public String expandAll(Map<String, String> variables) {
        StringBuilder builder = new StringBuilder();
        Node currentNode = this;
        while (currentNode != null) {
            builder.append(currentNode.expand(variables));
            currentNode = currentNode.next;
        }
        return builder.toString();
    }

    public int matchAll(String uriFragment, Map<String, String> variables) {
        int matchLength = this.match(uriFragment, variables);
        if (matchLength < 0) {
            return -1;
        }
        if (matchLength < uriFragment.length()) {
            if (this.next != null) {
                uriFragment = uriFragment.substring(matchLength);
                return matchLength + this.next.matchAll(uriFragment, variables);
            }
            return matchLength;
        }
        if (matchLength == uriFragment.length() && this.next != null) {
            return -1;
        }
        return matchLength;
    }

    abstract String expand(Map<String, String> var1);

    abstract int match(String var1, Map<String, String> var2);

    abstract String getToken();

    abstract char getFirstCharacter();
}

