/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.mgt.listener;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityValidationUtil;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.user.profile.mgt.util.ServiceHodler;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ProfileMgtEventListener
extends AbstractIdentityUserOperationEventListener {
    private static final String ALPHANUMERICS_ONLY = "ALPHANUMERICS_ONLY";
    private static final String DIGITS_ONLY = "DIGITS_ONLY";
    private static final String WHITESPACE_EXISTS = "WHITESPACE_EXISTS";
    private static final String URI_RESERVED_EXISTS = "URI_RESERVED_EXISTS";
    private static final String HTML_META_EXISTS = "HTML_META_EXISTS";
    private static final String XML_META_EXISTS = "XML_META_EXISTS";
    private static final String REGEX_META_EXISTS = "REGEX_META_EXISTS";
    private static final String URL = "URL";
    private static final Log log = LogFactory.getLog(ProfileMgtEventListener.class);

    public int getExecutionOrderId() {
        return 110;
    }

    public boolean doPreSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            String userStoreDomain = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
            if (StringUtils.isBlank((String)userStoreDomain)) {
                userStoreDomain = "PRIMARY";
            }
            String tenantDomain = IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId());
            log.debug((Object)("doPreSetUserClaimValues method executed in ProfileMgtEventListener for user: " + this.getFullQualifiedUsername(userName, userStoreDomain, tenantDomain)));
        }
        String[] whiteListPatternKeys = new String[]{ALPHANUMERICS_ONLY, DIGITS_ONLY};
        String[] blackListPatternKeys = new String[]{WHITESPACE_EXISTS, URI_RESERVED_EXISTS, HTML_META_EXISTS, XML_META_EXISTS, REGEX_META_EXISTS, URL};
        if (!IdentityValidationUtil.isValid((String)profileName, (String[])whiteListPatternKeys, (String[])blackListPatternKeys)) {
            throw new UserStoreException("profile name contains invalid characters!");
        }
        return true;
    }

    public boolean doPreDeleteUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userStoreDomain = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        if (StringUtils.isBlank((String)userStoreDomain)) {
            userStoreDomain = "PRIMARY";
        }
        int tenantId = userStoreManager.getTenantId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPreDeleteUser method executed in ProfileMgtEventListener for user:" + this.getFullQualifiedUsername(userName, userStoreDomain, IdentityTenantUtil.getTenantDomain((int)tenantId))));
        }
        this.deleteFederatedIdpAccountAssociations(userName, userStoreDomain, tenantId);
        return true;
    }

    private void deleteFederatedIdpAccountAssociations(String tenantAwareUsername, String userStoreDomain, int tenantId) throws UserStoreException {
        if (!ServiceHodler.isIDNTableExist()) {
            return;
        }
        String sql = "DELETE FROM IDN_ASSOCIATED_ID WHERE USER_NAME=? AND DOMAIN_NAME=? AND TENANT_ID=?";
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantId);
        String fullyQualifiedUsername = this.getFullQualifiedUsername(tenantAwareUsername, userStoreDomain, tenantDomain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting federated IDP user account associations of user:" + fullyQualifiedUsername));
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement(sql);){
                prepStmt.setString(1, tenantAwareUsername);
                prepStmt.setString(2, userStoreDomain);
                prepStmt.setInt(3, tenantId);
                prepStmt.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new UserStoreException(String.format("Error when trying to delete the federated IDP user account associations of user:%s", fullyQualifiedUsername), (Throwable)e1);
            }
        }
        catch (SQLException e) {
            String msg = "Error when trying to delete the federated IDP user account associations of user:%s";
            throw new UserStoreException(String.format(msg, fullyQualifiedUsername), (Throwable)e);
        }
    }

    private String getFullQualifiedUsername(String tenantAwareUsername, String userStoreDomain, String tenantDomain) {
        String fullyQualifiedUsername = UserCoreUtil.addDomainToName((String)tenantAwareUsername, (String)userStoreDomain);
        fullyQualifiedUsername = UserCoreUtil.addTenantDomainToEntry((String)fullyQualifiedUsername, (String)tenantDomain);
        return fullyQualifiedUsername;
    }
}

