/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.mgt.internal;

import org.wso2.carbon.identity.user.profile.mgt.UserProfileException;
import org.wso2.carbon.identity.user.profile.mgt.dao.UserProfileMgtDAO;
import org.wso2.carbon.identity.user.store.configuration.listener.AbstractUserStoreConfigListener;
import org.wso2.carbon.user.api.UserStoreException;

public class UserStoreConfigListenerImpl
extends AbstractUserStoreConfigListener {
    public void onUserStoreNamePreUpdate(int tenantId, String currentUserStoreName, String newUserStoreName) throws UserStoreException {
        try {
            UserProfileMgtDAO.getInstance().updateDomainNameOfAssociations(tenantId, currentUserStoreName, newUserStoreName);
        }
        catch (UserProfileException e) {
            throw new UserStoreException(String.format("Error occurred while updating user domain of associated ids with domain '%s'", currentUserStoreName), (Throwable)((Object)e));
        }
    }

    public void onUserStorePreDelete(int tenantId, String userStoreName) throws UserStoreException {
        try {
            UserProfileMgtDAO.getInstance().deleteAssociationsFromDomain(tenantId, userStoreName);
        }
        catch (UserProfileException e) {
            throw new UserStoreException(String.format("Error occurred while deleting associated ids with domain '%s'", userStoreName), (Throwable)((Object)e));
        }
    }
}

