/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.mgt.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManagerImpl;
import org.wso2.carbon.identity.user.profile.mgt.internal.IdentityUserProfileServiceDataHolder;
import org.wso2.carbon.identity.user.profile.mgt.internal.UserStoreConfigListenerImpl;
import org.wso2.carbon.identity.user.profile.mgt.listener.ProfileMgtEventListener;
import org.wso2.carbon.identity.user.profile.mgt.util.ServiceHodler;
import org.wso2.carbon.identity.user.store.configuration.listener.UserStoreConfigListener;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.user.profile.mgt.component", immediate=true)
public class IdentityUserProfileServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityUserProfileServiceComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            ServiceRegistration userStoreConfigEventSR;
            if (log.isDebugEnabled()) {
                log.debug((Object)"User Profile Mgt bundle is activated ");
            }
            if ((userStoreConfigEventSR = ctxt.getBundleContext().registerService(UserStoreConfigListener.class.getName(), (Object)new UserStoreConfigListenerImpl(), null)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User profile management - UserStoreConfigListener registered.");
                }
            } else {
                log.error((Object)"User profile management - UserStoreConfigListener could not be registered.");
            }
            ServiceRegistration profileMgtEventSR = ctxt.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)new ProfileMgtEventListener(), null);
            ServiceHodler.setIsIDNTableExist(this.isIDNTablesExist());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Is IDN_ASSOCIATED_ID table exist: " + ServiceHodler.isIDNTableExist()));
            }
            if (profileMgtEventSR != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User profile management - ProfileMgtEventListener registered.");
                }
            } else {
                log.error((Object)"User profile management - ProfileMgtEventListener could not be registered.");
            }
            FederatedAssociationManagerImpl federatedAssociationManager = new FederatedAssociationManagerImpl();
            ServiceRegistration federatedAssociationManagerSR = ctxt.getBundleContext().registerService(FederatedAssociationManager.class.getName(), (Object)federatedAssociationManager, null);
            if (federatedAssociationManagerSR != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User profile management - FederatedAssociationManager registered.");
                }
                IdentityUserProfileServiceDataHolder.getInstance().setFederatedAssociationManager(federatedAssociationManager);
            } else {
                log.error((Object)"User profile management - FederatedAssociationManager could not be registered.");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate ProfileMgt bundle ", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        IdentityUserProfileServiceDataHolder.getInstance().setFederatedAssociationManager(null);
    }

    @Reference(name="user.realm.default", service=UserRealm.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserRealmDefault")
    protected void setUserRealmDefault(UserRealm userRealmDefault) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting DefaultRealm in User Profile Management");
        }
        ServiceHodler.setInternalUserStore(userRealmDefault);
    }

    protected void unsetUserRealmDefault(UserRealm userRealmDefault) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Un-setting DefaultRealm in User Profile Management");
        }
        ServiceHodler.setInternalUserStore(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        IdentityUserProfileServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        IdentityUserProfileServiceDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="idp.mgt.IdpManager", service=IdpManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdpManager")
    protected void setIdpManager(IdpManager idpManager) {
        IdentityUserProfileServiceDataHolder.getInstance().setIdpManager(idpManager);
    }

    protected void unsetIdpManager(IdpManager idpManager) {
        IdentityUserProfileServiceDataHolder.getInstance().setIdpManager(null);
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isIDNTablesExist() {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            Throwable throwable;
            ResultSet resultSet;
            block36: {
                DatabaseMetaData metaData = connection.getMetaData();
                String tableName = "IDN_ASSOCIATED_ID";
                if (metaData.storesLowerCaseIdentifiers()) {
                    tableName = tableName.toLowerCase();
                }
                try {
                    boolean bl;
                    block37: {
                        resultSet = metaData.getTables(null, null, tableName, new String[]{"TABLE"});
                        throwable = null;
                        try {
                            if (!resultSet.next()) break block36;
                            IdentityDatabaseUtil.commitTransaction((Connection)connection);
                            bl = true;
                            if (resultSet == null) return bl;
                            if (throwable == null) break block37;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (resultSet == null) throw throwable3;
                                if (throwable == null) {
                                    resultSet.close();
                                    throw throwable3;
                                }
                                try {
                                    resultSet.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            resultSet.close();
                            return bl;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            return bl;
                        }
                    }
                    resultSet.close();
                    return bl;
                }
                catch (SQLException e) {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                    boolean bl = false;
                    if (connection == null) return bl;
                    if (var2_3 != null) {
                        try {
                            connection.close();
                            return bl;
                        }
                        catch (Throwable throwable6) {
                            var2_3.addSuppressed(throwable6);
                            return bl;
                        }
                    }
                    connection.close();
                    return bl;
                }
            }
            if (resultSet == null) return false;
            if (throwable == null) {
                resultSet.close();
                return false;
            }
            try {
                resultSet.close();
                return false;
            }
            catch (Throwable throwable7) {
                throwable.addSuppressed(throwable7);
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
    }
}

