/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.mgt.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.user.profile.mgt.AssociatedAccountDTO;
import org.wso2.carbon.identity.user.profile.mgt.UserProfileException;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UserProfileMgtDAO {
    private UserProfileMgtDAO() {
    }

    public static UserProfileMgtDAO getInstance() {
        return LazyHolder.INSTANCE;
    }

    public void updateDomainNameOfAssociations(int tenantId, String currentDomainName, String newDomainName) throws UserProfileException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = dbConnection.prepareStatement("UPDATE IDN_ASSOCIATED_ID SET DOMAIN_NAME = ? WHERE DOMAIN_NAME = ? AND TENANT_ID = ?");
            preparedStatement.setString(1, newDomainName);
            preparedStatement.setString(2, currentDomainName);
            preparedStatement.setInt(3, tenantId);
            preparedStatement.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new UserProfileException(String.format("Database error occurred while updating user domain of associated ids with domain '%s'", currentDomainName), e);
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)preparedStatement);
            IdentityApplicationManagementUtil.closeConnection((Connection)dbConnection);
        }
    }

    public void deleteAssociationsFromDomain(int tenantId, String domainName) throws UserProfileException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = dbConnection.prepareStatement("DELETE FROM IDN_ASSOCIATED_ID WHERE TENANT_ID = ? AND DOMAIN_NAME = ?");
            preparedStatement.setInt(1, tenantId);
            preparedStatement.setString(2, domainName);
            preparedStatement.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new UserProfileException(String.format("Database error occurred while deleting associated ids with domain '%s'", domainName), e);
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)preparedStatement);
            IdentityApplicationManagementUtil.closeConnection((Connection)dbConnection);
        }
    }

    public void createAssociation(int tenantId, String userStoreDomain, String domainFreeUsername, String idpId, String federatedUserId) throws UserProfileException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement("INSERT INTO IDN_ASSOCIATED_ID (TENANT_ID, IDP_ID, IDP_USER_ID, DOMAIN_NAME, USER_NAME, ASSOCIATION_ID) VALUES (? , (SELECT ID FROM IDP WHERE NAME = ? AND TENANT_ID = ?), ? , ?, ?, ?)");){
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, idpId);
                prepStmt.setInt(3, tenantId);
                prepStmt.setString(4, federatedUserId);
                prepStmt.setString(5, userStoreDomain.toUpperCase());
                prepStmt.setString(6, domainFreeUsername);
                prepStmt.setString(7, this.generateUUID());
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new UserProfileException("Error occurred while persisting account association entry for user: " + domainFreeUsername + " of user store domain: " + userStoreDomain + " in tenant: " + tenantId + " for federated ID: " + federatedUserId + " of IdP: " + idpId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserProfileException("Error occurred while persisting account association entry for user: " + domainFreeUsername + " of user store domain: " + userStoreDomain + " in tenant: " + tenantId + " for federated ID: " + federatedUserId + " of IdP: " + idpId, e);
        }
    }

    public void deleteAssociation(int tenantId, String userStoreDomain, String domainFreeUsername, String idpId, String federatedUserId) throws UserProfileException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_ASSOCIATED_ID WHERE TENANT_ID = ? AND IDP_ID = (SELECT ID FROM IDP WHERE NAME = ? AND TENANT_ID = ? ) AND IDP_USER_ID = ? AND USER_NAME = ? AND DOMAIN_NAME = ?");){
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, idpId);
                prepStmt.setInt(3, tenantId);
                prepStmt.setString(4, federatedUserId);
                prepStmt.setString(5, domainFreeUsername);
                prepStmt.setString(6, userStoreDomain);
                prepStmt.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new UserProfileException("Error occurred while removing account association entry of user: " + domainFreeUsername + " of user store domain: " + userStoreDomain + " in tenant: " + tenantId + " with federated ID: " + federatedUserId + " of IdP: " + idpId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserProfileException("Error occurred while removing account association entry of user: " + domainFreeUsername + " of user store domain: " + userStoreDomain + " in tenant: " + tenantId + " with federated ID: " + federatedUserId + " of IdP: " + idpId, e);
        }
    }

    public void deleteFederatedAssociation(int tenantId, String userStoreDomain, String username) throws UserProfileException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_ASSOCIATED_ID WHERE TENANT_ID = ? AND DOMAIN_NAME = ? AND USER_NAME = ?");){
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, userStoreDomain);
                prepStmt.setString(3, username);
                prepStmt.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new UserProfileException("Error occurred while removing federated association entries of user: " + username + ", of user store domain: " + userStoreDomain + ", in tenant: " + tenantId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserProfileException("Error occurred while handling the database connection", e);
        }
    }

    public void deleteFederatedAssociation(String userStoreDomain, String username, String federatedAssociationId) throws UserProfileException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_ASSOCIATED_ID WHERE DOMAIN_NAME = ? AND USER_NAME = ? AND ASSOCIATION_ID = ?");){
                prepStmt.setString(1, userStoreDomain);
                prepStmt.setString(2, username);
                prepStmt.setString(3, federatedAssociationId);
                prepStmt.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new UserProfileException("Error occurred while removing federated association: " + federatedAssociationId + ", for the user: " + username + ", in the user store domain: " + userStoreDomain, e1);
            }
        }
        catch (SQLException e) {
            throw new UserProfileException("Error occurred while handling the database connection", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public String getUserAssociatedFor(int tenantId, String idpId, String federatedUserId) throws UserProfileException {
        String username;
        block56: {
            username = null;
            try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
                Throwable throwable;
                ResultSet resultSet;
                Throwable throwable2;
                PreparedStatement prepStmt;
                block51: {
                    String string;
                    block54: {
                        block55: {
                            block52: {
                                block53: {
                                    prepStmt = connection.prepareStatement("SELECT DOMAIN_NAME, USER_NAME FROM IDN_ASSOCIATED_ID WHERE TENANT_ID = ? AND IDP_ID = (SELECT ID FROM IDP WHERE NAME = ? AND TENANT_ID = ?) AND IDP_USER_ID = ?");
                                    throwable2 = null;
                                    prepStmt.setInt(1, tenantId);
                                    prepStmt.setString(2, idpId);
                                    prepStmt.setInt(3, tenantId);
                                    prepStmt.setString(4, federatedUserId);
                                    resultSet = prepStmt.executeQuery();
                                    throwable = null;
                                    if (!resultSet.next()) break block51;
                                    String domainName = resultSet.getString(1);
                                    username = resultSet.getString(2);
                                    if (!"PRIMARY".equals(domainName)) {
                                        username = UserCoreUtil.addDomainToName((String)username, (String)domainName);
                                    }
                                    string = username;
                                    if (resultSet == null) break block52;
                                    if (throwable == null) break block53;
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    break block52;
                                }
                                resultSet.close();
                            }
                            if (prepStmt == null) break block54;
                            if (throwable2 == null) break block55;
                            try {
                                prepStmt.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            break block54;
                        }
                        prepStmt.close();
                    }
                    return string;
                }
                try {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                    break block56;
                    {
                        catch (Throwable throwable6) {
                            try {
                                throwable = throwable6;
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                if (resultSet != null) {
                                    if (throwable != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable8) {
                                            throwable.addSuppressed(throwable8);
                                        }
                                    } else {
                                        resultSet.close();
                                    }
                                }
                                throw throwable7;
                            }
                        }
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                catch (Throwable throwable10) {
                    throw throwable10;
                }
                {
                    finally {
                        if (prepStmt != null) {
                            if (throwable2 != null) {
                                try {
                                    prepStmt.close();
                                }
                                catch (Throwable throwable11) {
                                    throwable2.addSuppressed(throwable11);
                                }
                            } else {
                                prepStmt.close();
                            }
                        }
                    }
                }
                catch (SQLException e1) {
                    throw new UserProfileException("Error occurred while retrieving user account associated for federated ID: " + federatedUserId + " of IdP: " + idpId + " for tenant: " + tenantId, e1);
                }
            }
            catch (SQLException e) {
                throw new UserProfileException("Error occurred while retrieving user account associated for federated ID: " + federatedUserId + " of IdP: " + idpId + " for tenant: " + tenantId, e);
            }
        }
        return username;
    }

    public List<AssociatedAccountDTO> getAssociatedFederatedAccountsForUser(int tenantId, String userStoreDomain, String domainFreeUsername) throws UserProfileException {
        ArrayList<AssociatedAccountDTO> associatedFederatedAccounts = new ArrayList<AssociatedAccountDTO>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement prepStmt = connection.prepareStatement("SELECT IDP.NAME, IDP_USER_ID, ASSOCIATION_ID FROM IDN_ASSOCIATED_ID JOIN IDP ON IDN_ASSOCIATED_ID.IDP_ID = IDP.ID WHERE IDN_ASSOCIATED_ID.TENANT_ID = ? AND USER_NAME = ? AND DOMAIN_NAME = ?");){
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, domainFreeUsername);
                prepStmt.setString(3, userStoreDomain);
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        associatedFederatedAccounts.add(new AssociatedAccountDTO(resultSet.getString("ASSOCIATION_ID"), resultSet.getString("NAME"), resultSet.getString("IDP_USER_ID")));
                    }
                }
            }
            catch (SQLException e1) {
                throw new UserProfileException("Error occurred while retrieving federated accounts associated for user: " + domainFreeUsername + " of user store domain: " + userStoreDomain + " in tenant: " + tenantId, e1);
            }
        }
        catch (SQLException e) {
            throw new UserProfileException("Error occurred while retrieving federated accounts associated for user: " + domainFreeUsername + " of user store domain: " + userStoreDomain + " in tenant: " + tenantId, e);
        }
        return associatedFederatedAccounts;
    }

    private String generateUUID() {
        return UUID.randomUUID().toString();
    }

    private static class LazyHolder {
        private static final UserProfileMgtDAO INSTANCE = new UserProfileMgtDAO();

        private LazyHolder() {
        }
    }
}

