/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.mgt.association.federation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.user.profile.mgt.AssociatedAccountDTO;
import org.wso2.carbon.identity.user.profile.mgt.UserProfileException;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.constant.FederatedAssociationConstants;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.exception.FederatedAssociationManagerClientException;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.exception.FederatedAssociationManagerException;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.exception.FederatedAssociationManagerServerException;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.model.AssociatedIdentityProvider;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.model.FederatedAssociation;
import org.wso2.carbon.identity.user.profile.mgt.dao.UserProfileMgtDAO;
import org.wso2.carbon.identity.user.profile.mgt.internal.IdentityUserProfileServiceDataHolder;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class FederatedAssociationManagerImpl
implements FederatedAssociationManager {
    private static final Log log = LogFactory.getLog(FederatedAssociationManagerImpl.class);

    @Override
    public void createFederatedAssociation(User user, String idpName, String federatedUserId) throws FederatedAssociationManagerException {
        this.validateUserObject(user);
        int tenantId = this.getValidatedTenantId(user);
        this.validateUserExistence(user, tenantId);
        this.validateIfFederatedUserAccountAlreadyAssociated(user.getTenantDomain(), idpName, federatedUserId);
        try {
            UserProfileMgtDAO.getInstance().createAssociation(tenantId, user.getUserStoreDomain(), user.getUserName(), idpName, federatedUserId);
        }
        catch (UserProfileException e) {
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_CREATING_FEDERATED_ASSOCIATION_OF_USER, (Throwable)((Object)e), false);
        }
    }

    @Override
    public String getUserForFederatedAssociation(String tenantDomain, String idpName, String federatedUserId) throws FederatedAssociationManagerException {
        int tenantId = this.getValidatedTenantIdFromDomain(tenantDomain);
        try {
            return UserProfileMgtDAO.getInstance().getUserAssociatedFor(tenantId, idpName, federatedUserId);
        }
        catch (UserProfileException e) {
            if (log.isDebugEnabled()) {
                String msg = "Error while retrieving user associated for federated IdP: " + idpName + ", with federation identifier: " + federatedUserId + ", in tenant: " + CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                log.debug((Object)msg);
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_GETTING_USER_FOR_FEDERATED_ASSOCIATION, (Throwable)((Object)e), true);
        }
    }

    @Override
    public FederatedAssociation[] getFederatedAssociationsOfUser(User user) throws FederatedAssociationManagerException {
        this.validateUserObject(user);
        int tenantId = this.getValidatedTenantId(user);
        this.validateUserExistence(user, tenantId);
        try {
            ArrayList<FederatedAssociation> federatedAssociations = new ArrayList<FederatedAssociation>();
            List<AssociatedAccountDTO> associatedAccountDTOS = UserProfileMgtDAO.getInstance().getAssociatedFederatedAccountsForUser(tenantId, user.getUserStoreDomain(), user.getUserName());
            for (AssociatedAccountDTO associatedAccount : associatedAccountDTOS) {
                AssociatedIdentityProvider idp = this.getAssociatedIdentityProvider(user.getTenantDomain(), associatedAccount.getIdentityProviderName());
                federatedAssociations.add(new FederatedAssociation(associatedAccount.getId(), idp, associatedAccount.getUsername()));
            }
            return federatedAssociations.toArray(new FederatedAssociation[0]);
        }
        catch (UserProfileException e) {
            if (log.isDebugEnabled()) {
                String msg = "Error while retrieving federated account associations of user: " + user.toFullQualifiedUsername();
                log.debug((Object)msg);
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_RETRIEVING_FEDERATED_ASSOCIATION_OF_USER, (Throwable)((Object)e), true);
        }
    }

    @Override
    public void deleteFederatedAssociation(User user, String idpName, String federatedUserId) throws FederatedAssociationManagerException {
        this.validateUserObject(user);
        int tenantId = this.getValidatedTenantId(user);
        this.validateFederatedAssociation(user, idpName, federatedUserId);
        try {
            UserProfileMgtDAO.getInstance().deleteAssociation(tenantId, user.getUserStoreDomain(), user.getUserName(), idpName, federatedUserId);
        }
        catch (UserProfileException e) {
            if (log.isDebugEnabled()) {
                String msg = "Error while removing the federated association with idpId: " + idpName + ", and federatedUserId: " + federatedUserId + ", for user: " + user.toFullQualifiedUsername();
                log.debug((Object)msg);
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_DELETING_FEDERATED_ASSOCIATION_OF_USER, (Throwable)((Object)e), true);
        }
    }

    @Override
    public void deleteFederatedAssociation(User user, String federatedAssociationId) throws FederatedAssociationManagerException {
        this.validateUserObject(user);
        this.validateFederatedAssociation(user, federatedAssociationId);
        try {
            UserProfileMgtDAO.getInstance().deleteFederatedAssociation(user.getUserStoreDomain(), user.getUserName(), federatedAssociationId);
        }
        catch (UserProfileException e) {
            if (log.isDebugEnabled()) {
                String msg = "Error while removing the federated association: " + federatedAssociationId + ", for user: " + user.toFullQualifiedUsername();
                log.debug((Object)msg, (Throwable)((Object)e));
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_DELETING_FEDERATED_ASSOCIATION_OF_USER, (Throwable)((Object)e), true);
        }
    }

    @Override
    public void deleteFederatedAssociation(User user) throws FederatedAssociationManagerException {
        this.validateUserObject(user);
        int tenantId = this.getValidatedTenantId(user);
        this.validateExistenceOfFederatedAssociations(user);
        try {
            UserProfileMgtDAO.getInstance().deleteFederatedAssociation(tenantId, user.getUserStoreDomain(), user.getUserName());
        }
        catch (UserProfileException e) {
            if (log.isDebugEnabled()) {
                String msg = "Error while removing the federated associations of user: " + user.toFullQualifiedUsername();
                log.debug((Object)msg, (Throwable)((Object)e));
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_DELETING_FEDERATED_ASSOCIATION_OF_USER, (Throwable)((Object)e), true);
        }
    }

    private void validateUserObject(User user) throws FederatedAssociationManagerException {
        boolean isValidUserObject;
        boolean bl = isValidUserObject = user != null && this.isRequiredUserParametersPresent(user);
        if (!isValidUserObject) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Either provided user is null or missing user parameters.");
            }
            throw this.handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages.INVALID_USER_IDENTIFIER_PROVIDED, null, true);
        }
    }

    private boolean isRequiredUserParametersPresent(User user) {
        return !StringUtils.isEmpty((String)user.getTenantDomain()) && !StringUtils.isEmpty((String)user.getUserStoreDomain()) && !StringUtils.isEmpty((String)user.getUserName());
    }

    private void validateExistenceOfFederatedAssociations(User user) throws FederatedAssociationManagerException {
        if (!this.isValidFederatedAssociationsExist(user)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Valid federated associations does not exist for the user: " + user.toFullQualifiedUsername()));
            }
            throw this.handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages.FEDERATED_ASSOCIATION_DOES_NOT_EXISTS, null, true);
        }
    }

    private boolean isValidFederatedAssociationsExist(User user) throws FederatedAssociationManagerException {
        Object[] federatedUserAccountAssociationDTOS = this.getFederatedAssociationsOfUser(user);
        return !ArrayUtils.isEmpty((Object[])federatedUserAccountAssociationDTOS);
    }

    private void validateFederatedAssociation(User user, String federatedAssociationId) throws FederatedAssociationManagerException {
        if (StringUtils.isEmpty((String)federatedAssociationId) || !this.isValidFederatedAssociation(user, federatedAssociationId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A valid federated association does not exist for the Id: " + federatedAssociationId + ", of the user: " + user.toFullQualifiedUsername()));
            }
            throw this.handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages.INVALID_FEDERATED_ASSOCIATION, null, true);
        }
    }

    private boolean isValidFederatedAssociation(User user, String federatedAssociationId) throws FederatedAssociationManagerException {
        FederatedAssociation[] federatedUserAccountAssociationDTOS = this.getFederatedAssociationsOfUser(user);
        if (federatedUserAccountAssociationDTOS != null) {
            for (FederatedAssociation federatedUserAccountAssociationDTO : federatedUserAccountAssociationDTOS) {
                if (!federatedAssociationId.equals(federatedUserAccountAssociationDTO.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private int getValidatedTenantId(User user) throws FederatedAssociationManagerException {
        int tenantId;
        try {
            RealmService realmService = IdentityUserProfileServiceDataHolder.getInstance().getRealmService();
            tenantId = realmService.getTenantManager().getTenantId(user.getTenantDomain());
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while getting the tenant Id for the tenant domain: " + user.getTenantDomain()));
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_WORKING_WITH_FEDERATED_ASSOCIATIONS, e, false);
        }
        if (-1 == tenantId) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid tenant id is resolved for the tenant domain: " + user.getTenantDomain()));
            }
            throw this.handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages.INVALID_TENANT_DOMAIN_PROVIDED, null, true);
        }
        return tenantId;
    }

    private int getValidatedTenantIdFromDomain(String tenantDomain) throws FederatedAssociationManagerException {
        int tenantId;
        try {
            RealmService realmService = IdentityUserProfileServiceDataHolder.getInstance().getRealmService();
            tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while getting the tenant Id for the tenant domain: " + tenantDomain));
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_WORKING_WITH_FEDERATED_ASSOCIATIONS, e, false);
        }
        if (-1 == tenantId) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid tenant id is resolved for the tenant domain: " + tenantDomain));
            }
            throw this.handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages.INVALID_TENANT_DOMAIN_PROVIDED, null, true);
        }
        return tenantId;
    }

    private void validateIfFederatedUserAccountAlreadyAssociated(String tenantDomain, String idpId, String federatedUserId) throws FederatedAssociationManagerException {
        String userAssociated = this.getUserForFederatedAssociation(tenantDomain, idpId, federatedUserId);
        if (userAssociated != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Federated ID: " + federatedUserId + ", for IdP: " + idpId + ", is already associated with the local user account: " + userAssociated + "@" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() + "."));
            }
            throw this.handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages.FEDERATED_ASSOCIATION_ALREADY_EXISTS, null, true);
        }
    }

    private void validateFederatedAssociation(User user, String idpName, String federatedUserId) throws FederatedAssociationManagerException {
        if (StringUtils.isEmpty((String)idpName) || StringUtils.isEmpty((String)federatedUserId) || !this.isValidFederatedAssociation(user, idpName, federatedUserId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A valid federated association does not exist for the idpName: " + idpName + ", and federatedUserId: " + federatedUserId + ", of the user: " + user.toFullQualifiedUsername()));
            }
            throw this.handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages.INVALID_FEDERATED_ASSOCIATION, null, true);
        }
    }

    private boolean isValidFederatedAssociation(User user, String idpName, String federatedUserId) throws FederatedAssociationManagerException {
        FederatedAssociation[] federatedUserAccountAssociationDTOS = this.getFederatedAssociationsOfUser(user);
        if (federatedUserAccountAssociationDTOS != null) {
            for (FederatedAssociation eachFederatedAssociation : federatedUserAccountAssociationDTOS) {
                if (!idpName.equals(this.getResolvedIdPName(user, eachFederatedAssociation.getIdp().getId())) || !federatedUserId.equals(eachFederatedAssociation.getFederatedUserId())) continue;
                return true;
            }
        }
        return false;
    }

    private String getResolvedIdPName(User user, String idpId) throws FederatedAssociationManagerException {
        return this.getIdentityProviderName(user.getTenantDomain(), idpId);
    }

    private void validateUserExistence(User user, int tenantId) throws FederatedAssociationManagerException {
        try {
            UserStoreManager userStoreManager = IdentityUserProfileServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            if (!userStoreManager.isExistingUser(UserCoreUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()))) {
                if (log.isDebugEnabled()) {
                    log.error((Object)("UserNotFound: userName: " + user.getUserName() + ", in the domain: " + user.getUserStoreDomain() + ", and in the tenant: " + user.getTenantDomain()));
                }
                throw this.handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages.INVALID_USER_IDENTIFIER_PROVIDED, null, true);
            }
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                String msg = "Error occurred while verifying the existence of the userName: " + user.getUserName() + ", in the domain: " + user.getUserStoreDomain() + ", and in the tenant: " + user.getTenantDomain();
                log.debug((Object)msg);
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_GETTING_THE_USER, e, true);
        }
    }

    private FederatedAssociationManagerClientException handleFederatedAssociationManagerClientException(FederatedAssociationConstants.ErrorMessages errorMessages, Throwable throwable, boolean messageWithCode) {
        String message = messageWithCode ? errorMessages.toString() : errorMessages.getDescription();
        if (throwable == null) {
            return new FederatedAssociationManagerClientException(String.valueOf(errorMessages.getCode()), message);
        }
        return new FederatedAssociationManagerClientException(String.valueOf(errorMessages.getCode()), message, throwable);
    }

    private FederatedAssociationManagerServerException handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages errorMessages, Throwable throwable, boolean messageWithCode) {
        String message = messageWithCode ? errorMessages.toString() : errorMessages.getDescription();
        if (throwable == null) {
            return new FederatedAssociationManagerServerException(String.valueOf(errorMessages.getCode()), message);
        }
        return new FederatedAssociationManagerServerException(String.valueOf(errorMessages.getCode()), message, throwable);
    }

    private AssociatedIdentityProvider getAssociatedIdentityProvider(String tenantDomain, String identityProviderName) throws FederatedAssociationManagerServerException {
        try {
            IdpManager idpManager = IdentityUserProfileServiceDataHolder.getInstance().getIdpManager();
            if (idpManager != null) {
                IdentityProvider idp = idpManager.getIdPByName(identityProviderName, tenantDomain);
                return new AssociatedIdentityProvider(idp.getResourceId(), idp.getIdentityProviderName(), idp.getDisplayName(), idp.getImageUrl());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"The IdpManager service is not available in the runtime");
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_RESOLVING_IDENTITY_PROVIDERS, null, true);
        }
        catch (IdentityProviderManagementException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not resolve the identity provider for the name: " + identityProviderName + ", in the tenant domain: " + tenantDomain));
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_RESOLVING_IDENTITY_PROVIDERS, null, true);
        }
    }

    private String getIdentityProviderName(String tenantDomain, String idpId) throws FederatedAssociationManagerException {
        try {
            IdpManager idpManager = IdentityUserProfileServiceDataHolder.getInstance().getIdpManager();
            if (idpManager != null) {
                IdentityProvider identityProvider = idpManager.getIdPByResourceId(idpId, tenantDomain, false);
                return identityProvider.getIdentityProviderName();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"The IdpManager service is not available in the runtime");
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_RESOLVING_IDENTITY_PROVIDERS, null, true);
        }
        catch (IdentityProviderManagementException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not resolve the identity provider for the id: " + idpId + ", in the tenant domain: " + tenantDomain));
            }
            throw this.handleFederatedAssociationManagerServerException(FederatedAssociationConstants.ErrorMessages.ERROR_WHILE_RESOLVING_IDENTITY_PROVIDERS, null, true);
        }
    }
}

