/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.mgt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.user.profile.mgt.AssociatedAccountDTO;
import org.wso2.carbon.identity.user.profile.mgt.UserFieldDTO;
import org.wso2.carbon.identity.user.profile.mgt.UserProfileDTO;
import org.wso2.carbon.identity.user.profile.mgt.UserProfileException;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.constant.FederatedAssociationConstants;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.exception.FederatedAssociationManagerException;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.model.FederatedAssociation;
import org.wso2.carbon.identity.user.profile.mgt.internal.IdentityUserProfileServiceDataHolder;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class UserProfileAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(UserProfileAdmin.class);
    private static final Log audit_log = CarbonConstants.AUDIT_LOG;
    private static final String AUDIT_SUCCESS = "Success";
    private static final String AUDIT_FAIL = "Fail";
    private static String AUDIT_MESSAGE = "Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ";
    private static String auditActionForCreateAssociation = "Associate local user account with federated account";
    private static String auditActionForDeleteAssociation = "Remove local user account association with federated account";
    private static UserProfileAdmin userProfileAdmin = new UserProfileAdmin();
    private String authorizationFailureMessage = "You are not authorized to perform this action.";
    private static final String USER_PROFILE_DELETE_PERMISSION = "/manage/identity/userprofile/delete";
    private static final String USER_PROFILE_VIEW_PERMISSION = "/manage/identity/userprofile/view";
    private static final String USER_PROFILE_MANAGE_PERMISSION = "/manage/identity/userprofile";
    private static final String TRANSPORT_HTTP_SERVLET_REQUEST = "transport.http.servletRequest";
    private static final String LOGGED_IN_DOMAIN = "logged_in_domain";

    public static UserProfileAdmin getInstance() {
        return userProfileAdmin;
    }

    public boolean isReadOnlyUserStore() throws UserProfileException {
        try {
            UserRealm realm = this.getUserRealm();
            return "true".equals(realm.getRealmConfiguration().getUserStoreProperty("ReadOnly"));
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserProfileException(e.getMessage(), e);
        }
    }

    public void setUserProfile(String username, UserProfileDTO profile) throws UserProfileException {
        UserRealm realm = null;
        try {
            MessageContext messageContext;
            HttpServletRequest request;
            String string;
            if (!this.isAuthorized(username, USER_PROFILE_MANAGE_PERMISSION)) {
                throw new UserProfileException(this.authorizationFailureMessage);
            }
            if (this.isAdminProfileSpoof(username)) {
                log.warn((Object)("Unauthorized attempt. User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " is trying to modify the profile of the admin user."));
                throw new UserProfileException(this.authorizationFailureMessage);
            }
            int indexOne = username.indexOf("/");
            if (indexOne < 0 && (string = (String)(request = (HttpServletRequest)(messageContext = MessageContext.getCurrentMessageContext()).getProperty(TRANSPORT_HTTP_SERVLET_REQUEST)).getSession().getAttribute(LOGGED_IN_DOMAIN)) != null) {
                username = string + "/" + username;
            }
            realm = this.getUserRealm();
            UserFieldDTO[] udatas = profile.getFieldValues();
            HashMap<String, String> map = new HashMap<String, String>();
            for (UserFieldDTO data : udatas) {
                String claimURI = data.getClaimUri();
                String value = data.getFieldValue();
                if (data.isReadOnly()) continue;
                if (value == "" && "http://wso2.org/claims/identity/otp".equals(claimURI)) {
                    value = "false";
                }
                map.put(claimURI, value);
            }
            if (profile.getProfileConifuration() != null) {
                map.put("profileConfiguration", profile.getProfileConifuration());
            } else {
                map.put("profileConfiguration", "default");
            }
            UserStoreManager userStoreManager = realm.getUserStoreManager();
            userStoreManager.setUserClaimValues(username, map, profile.getProfileName());
        }
        catch (UserStoreException e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserProfileException(e.getMessage(), e);
        }
    }

    public void deleteUserProfile(String username, String profileName) throws UserProfileException {
        UserRealm realm = null;
        try {
            if (!this.isAuthorized(username, USER_PROFILE_DELETE_PERMISSION)) {
                throw new UserProfileException(this.authorizationFailureMessage);
            }
            if (this.isAdminProfileSpoof(username)) {
                log.warn((Object)("Unauthorized attempt. User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " is trying to delete the profile of the admin user."));
                throw new UserProfileException(this.authorizationFailureMessage);
            }
            if ("default".equals(profileName)) {
                throw new UserProfileException("Cannot delete default profile");
            }
            realm = this.getUserRealm();
            ClaimManager claimManager = realm.getClaimManager();
            String[] claims = claimManager.getAllClaimUris();
            UserStoreManager admin = realm.getUserStoreManager();
            admin.deleteUserClaimValues(username, claims, profileName);
            admin.deleteUserClaimValue(username, "profileConfiguration", profileName);
        }
        catch (UserStoreException e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserProfileException(e.getMessage(), e);
        }
    }

    public UserProfileDTO[] getUserProfiles(String username) throws UserProfileException {
        UserProfileDTO[] profiles;
        String[] availableProfileConfigurations = new String[]{};
        String profileConfig = null;
        try {
            int i;
            ProfileConfigurationManager profileAdmin;
            if (!this.isAuthorized(username, USER_PROFILE_VIEW_PERMISSION)) {
                throw new UserProfileException(this.authorizationFailureMessage);
            }
            if (this.isAdminProfileSpoof(username)) {
                log.warn((Object)("Unauthorized attempt. User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " is trying to view the profile of the admin user."));
                throw new UserProfileException(this.authorizationFailureMessage);
            }
            UserRealm realm = this.getUserRealm();
            UserStoreManager userStoreManager = realm.getUserStoreManager();
            boolean isReadOnly = userStoreManager.isReadOnly();
            int index = username.indexOf("/");
            UserStoreManager secUserStoreManager = null;
            if (index > 0) {
                String domain = username.substring(0, index);
                if (userStoreManager instanceof AbstractUserStoreManager && (secUserStoreManager = ((AbstractUserStoreManager)userStoreManager).getSecondaryUserStoreManager(domain)) != null) {
                    isReadOnly = secUserStoreManager.isReadOnly();
                }
            }
            if ((profileAdmin = realm.getProfileConfigurationManager()) != null) {
                availableProfileConfigurations = this.getAvailableProfileConfiguration(profileAdmin);
            }
            String[] profileNames = null;
            profileNames = secUserStoreManager != null ? secUserStoreManager.getProfileNames(username) : userStoreManager.getProfileNames(username);
            profiles = new UserProfileDTO[profileNames.length];
            Claim[] claims = this.getAllSupportedClaims(realm, "http://wso2.org/claims");
            String[] claimUris = new String[claims.length + 1];
            for (i = 0; i < claims.length; ++i) {
                claimUris[i] = claims[i].getClaimUri();
            }
            claimUris[claims.length] = "profileConfiguration";
            for (i = 0; i < profileNames.length; ++i) {
                String profile = profileNames[i];
                Map valueMap = userStoreManager.getUserClaimValues(username, claimUris, profile);
                ArrayList<UserFieldDTO> userFields = new ArrayList<UserFieldDTO>();
                for (int j = 0; j < claims.length; ++j) {
                    UserFieldDTO data = new UserFieldDTO();
                    Claim claim = claims[j];
                    String claimUri = claim.getClaimUri();
                    if ("profileConfiguration".equals(claimUri)) continue;
                    data.setClaimUri(claimUri);
                    data.setFieldValue((String)valueMap.get(claimUri));
                    data.setDisplayName(claim.getDisplayTag());
                    data.setRegEx(claim.getRegEx());
                    data.setRequired(claim.isRequired());
                    data.setDisplayOrder(claim.getDisplayOrder());
                    data.setCheckedAttribute(claim.isCheckedAttribute());
                    data.setReadOnly(claim.isReadOnly());
                    userFields.add(data);
                }
                UserProfileDTO temp = new UserProfileDTO();
                temp.setProfileName(profile);
                temp.setFieldValues(userFields.toArray(new UserFieldDTO[userFields.size()]));
                temp.setProfileConfigurations(availableProfileConfigurations);
                profileConfig = (String)valueMap.get("profileConfiguration");
                if (profileConfig == null) {
                    profileConfig = "default";
                }
                if (isReadOnly) {
                    profileConfig = "readonly";
                }
                temp.setProfileConifuration(profileConfig);
                profiles[i] = temp;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        return profiles;
    }

    public UserProfileDTO getProfileFieldsForInternalStore() throws UserProfileException {
        UserFieldDTO[] datas;
        UserProfileDTO profile = new UserProfileDTO();
        String[] availableProfileConfigurations = new String[]{};
        try {
            UserRealm realm = this.getUserRealm();
            Claim[] claims = this.getClaimsToEnterData(realm);
            ProfileConfigurationManager profileAdmin = realm.getProfileConfigurationManager();
            if (profileAdmin != null) {
                availableProfileConfigurations = this.getAvailableProfileConfiguration(profileAdmin);
            }
            String[] claimUris = new String[claims.length];
            for (int i = 0; i < claims.length; ++i) {
                claimUris[i] = claims[i].getClaimUri();
            }
            datas = new UserFieldDTO[claims.length];
            for (int j = 0; j < claims.length; ++j) {
                UserFieldDTO data = new UserFieldDTO();
                Claim claim = claims[j];
                String claimUri = claim.getClaimUri();
                data.setClaimUri(claimUri);
                data.setDisplayName(claim.getDisplayTag());
                data.setRegEx(claim.getRegEx());
                data.setRequired(claim.isRequired());
                data.setDisplayOrder(claim.getDisplayOrder());
                data.setRegEx(claim.getRegEx());
                data.setCheckedAttribute(claim.isCheckedAttribute());
                data.setReadOnly(claim.isReadOnly());
                datas[j] = data;
            }
        }
        catch (Exception e) {
            throw new UserProfileException(e.getMessage(), e);
        }
        profile.setFieldValues(datas);
        profile.setProfileConfigurations(availableProfileConfigurations);
        return profile;
    }

    public UserProfileDTO getUserProfile(String username, String profileName) throws UserProfileException {
        UserProfileDTO profile = new UserProfileDTO();
        String[] availableProfileConfigurations = new String[]{};
        String profileConfig = null;
        try {
            MessageContext messageContext;
            HttpServletRequest request;
            String domainName;
            if (username == null || profileName == null) {
                throw new UserProfileException("Invalid input parameters");
            }
            if (!this.isAuthorized(username, USER_PROFILE_VIEW_PERMISSION)) {
                throw new UserProfileException(this.authorizationFailureMessage);
            }
            if (this.isAdminProfileSpoof(username)) {
                log.warn((Object)("Unauthorized attempt. User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " is trying to view the profile of the admin user."));
                throw new UserProfileException(this.authorizationFailureMessage);
            }
            UserRealm realm = this.getUserRealm();
            UserStoreManager userStoreManager = realm.getUserStoreManager();
            boolean isReadOnly = userStoreManager.isReadOnly();
            int indexOne = username.indexOf("/");
            if (indexOne < 0 && (domainName = (String)(request = (HttpServletRequest)(messageContext = MessageContext.getCurrentMessageContext()).getProperty(TRANSPORT_HTTP_SERVLET_REQUEST)).getSession().getAttribute(LOGGED_IN_DOMAIN)) != null) {
                username = domainName + "/" + username;
            }
            int index = username.indexOf("/");
            UserStoreManager secUserStoreManager = null;
            if (index > 0) {
                String domain = username.substring(0, index);
                if (userStoreManager instanceof AbstractUserStoreManager && (secUserStoreManager = ((AbstractUserStoreManager)userStoreManager).getSecondaryUserStoreManager(domain)) != null) {
                    isReadOnly = secUserStoreManager.isReadOnly();
                }
            }
            ProfileConfigurationManager profileAdmin = realm.getProfileConfigurationManager();
            String[] profileNames = null;
            profileNames = secUserStoreManager != null ? secUserStoreManager.getProfileNames(username) : userStoreManager.getProfileNames(username);
            boolean found = false;
            if (profileNames != null && profileNames.length > 0) {
                for (int i = 0; i < profileNames.length; ++i) {
                    if (!profileName.equals(profileNames[i])) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return null;
            }
            if (profileAdmin != null) {
                availableProfileConfigurations = this.getAvailableProfileConfiguration(profileAdmin);
            }
            Claim[] claims = this.getClaimsToEnterData(realm);
            String[] claimUris = new String[claims.length + 1];
            for (int i = 0; i < claims.length; ++i) {
                claimUris[i] = claims[i].getClaimUri();
            }
            claimUris[claims.length] = "profileConfiguration";
            Map valueMap = userStoreManager.getUserClaimValues(username, claimUris, profileName);
            ArrayList<UserFieldDTO> userFields = new ArrayList<UserFieldDTO>();
            for (int j = 0; j < claims.length; ++j) {
                UserFieldDTO data = new UserFieldDTO();
                Claim claim = claims[j];
                String claimUri = claim.getClaimUri();
                if ("profileConfiguration".equals(claimUri)) continue;
                data.setClaimUri(claimUri);
                data.setFieldValue((String)valueMap.get(claimUri));
                data.setDisplayName(claim.getDisplayTag());
                data.setRegEx(claim.getRegEx());
                data.setRequired(claim.isRequired());
                data.setDisplayOrder(claim.getDisplayOrder());
                data.setReadOnly(claim.isReadOnly());
                data.setCheckedAttribute(claim.isCheckedAttribute());
                userFields.add(data);
            }
            profile.setProfileName(profileName);
            profile.setProfileConfigurations(availableProfileConfigurations);
            profileConfig = (String)valueMap.get("profileConfiguration");
            if (profileConfig == null) {
                profileConfig = "default";
            }
            if (isReadOnly) {
                profileConfig = "readonly";
            }
            profile.setProfileConifuration(profileConfig);
            profile.setFieldValues(userFields.toArray(new UserFieldDTO[userFields.size()]));
        }
        catch (Exception e) {
            log.error((Object)String.format("An error occurred while getting the user profile '%s' of the user '%s'", profileName, username), (Throwable)e);
            throw new UserProfileException(e.getMessage(), e);
        }
        return profile;
    }

    public boolean isAddProfileEnabled() throws UserProfileException {
        UserRealm realm = this.getUserRealm();
        UserStoreManager userStoreManager = null;
        try {
            userStoreManager = realm.getUserStoreManager();
        }
        catch (UserStoreException e) {
            String errorMessage = "Error in obtaining UserStoreManager.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new UserProfileException(errorMessage, e);
        }
        return userStoreManager.isMultipleProfilesAllowed();
    }

    public boolean isAddProfileEnabledForDomain(String domain) throws UserProfileException {
        UserStoreManager userStoreManager = null;
        UserRealm realm = this.getUserRealm();
        boolean isAddProfileEnabled = false;
        try {
            userStoreManager = StringUtils.isBlank((String)domain) || StringUtils.equals((String)domain, (String)"PRIMARY") ? realm.getUserStoreManager() : realm.getUserStoreManager().getSecondaryUserStoreManager(domain);
        }
        catch (UserStoreException e) {
            String errorMessage = "Error in obtaining SecondaryUserStoreManager.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new UserProfileException(errorMessage, e);
        }
        if (userStoreManager != null) {
            isAddProfileEnabled = userStoreManager.isMultipleProfilesAllowed();
        }
        return isAddProfileEnabled;
    }

    private Claim[] getClaimsToEnterData(UserRealm realm) throws UserStoreException {
        try {
            return this.getAllSupportedClaims(realm, "http://wso2.org/claims");
        }
        catch (UserStoreException e) {
            throw new UserStoreException((Throwable)e);
        }
    }

    private boolean isAuthorized(String targetUser, String permissionString) throws UserStoreException, CarbonException {
        boolean isAuthrized = false;
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
            isAuthrized = UserProfileAdmin.isUserAuthorizedToConfigureProfile(this.getUserRealm(), userName, targetUser, permissionString);
        }
        return isAuthrized;
    }

    private static boolean isUserAuthorizedToConfigureProfile(UserRealm realm, String currentUserName, String targetUser, String permission) throws UserStoreException {
        boolean isAuthrized = false;
        if (currentUserName != null) {
            if (currentUserName.equals(targetUser)) {
                isAuthrized = true;
            } else {
                AuthorizationManager authorizer = realm.getAuthorizationManager();
                isAuthrized = authorizer.isUserAuthorized(currentUserName, "/permission/admin" + permission, "ui.execute");
            }
        }
        return isAuthrized;
    }

    private Claim[] getAllSupportedClaims(UserRealm realm, String dialectUri) throws UserStoreException {
        ClaimMapping[] claims = null;
        ArrayList<Claim> reqClaims = null;
        claims = realm.getClaimManager().getAllSupportClaimMappingsByDefault();
        reqClaims = new ArrayList<Claim>();
        for (int i = 0; i < claims.length; ++i) {
            if (!dialectUri.equals(claims[i].getClaim().getDialectURI()) || claims[i] == null || claims[i].getClaim().getDisplayTag() == null || claims[i].getClaim().getClaimUri().equals("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier")) continue;
            reqClaims.add(claims[i].getClaim());
        }
        return reqClaims.toArray(new Claim[reqClaims.size()]);
    }

    private String[] getAvailableProfileConfiguration(ProfileConfigurationManager profileAdmin) throws UserStoreException {
        ProfileConfiguration[] configurations;
        String[] profileNames = new String[]{};
        try {
            configurations = (ProfileConfiguration[])profileAdmin.getAllProfiles();
        }
        catch (UserStoreException e) {
            throw new UserStoreException((Throwable)e);
        }
        if (configurations != null) {
            profileNames = new String[configurations.length];
            for (int i = 0; i < configurations.length; ++i) {
                profileNames[i] = configurations[i].getProfileName();
            }
        }
        return profileNames;
    }

    public void associateID(String idpID, String associatedID) throws UserProfileException {
        String tenantAwareUsername = CarbonContext.getThreadLocalCarbonContext().getUsername();
        User user = this.getUser(tenantAwareUsername);
        try {
            this.getFederatedAssociationManager().createFederatedAssociation(user, idpID, associatedID);
        }
        catch (FederatedAssociationManagerException e) {
            String msg = "Error while creating association for user: " + tenantAwareUsername + ", with federated IdP: " + idpID + ", in tenant: " + this.getTenantDomain();
            throw new UserProfileException(msg, (Throwable)((Object)e));
        }
    }

    public String getNameAssociatedWith(String idpID, String associatedID) throws UserProfileException {
        try {
            return this.getFederatedAssociationManager().getUserForFederatedAssociation(CarbonContext.getThreadLocalCarbonContext().getTenantDomain(), idpID, associatedID);
        }
        catch (FederatedAssociationManagerException e) {
            String msg = "Error while retrieving user associated for federated IdP: " + idpID + " with federated identifier:" + associatedID + " in tenant: " + this.getTenantDomain();
            throw new UserProfileException(msg, (Throwable)((Object)e));
        }
    }

    public AssociatedAccountDTO[] getAssociatedIDs() throws UserProfileException {
        String tenantAwareUsername = CarbonContext.getThreadLocalCarbonContext().getUsername();
        User user = this.getUser(tenantAwareUsername);
        try {
            return this.getAssociatedAccounts(user);
        }
        catch (FederatedAssociationManagerException e) {
            String msg = "Error while retrieving federated identifiers associated for user: " + tenantAwareUsername + " in tenant: " + this.getTenantDomain();
            throw new UserProfileException(msg, (Throwable)((Object)e));
        }
    }

    public void removeAssociateID(String idpID, String associatedID) throws UserProfileException {
        String tenantAwareUsername = CarbonContext.getThreadLocalCarbonContext().getUsername();
        User user = this.getUser(tenantAwareUsername);
        try {
            this.getFederatedAssociationManager().deleteFederatedAssociation(user, idpID, associatedID);
        }
        catch (FederatedAssociationManagerException e) {
            String msg = "Error while removing association with federated IdP: " + idpID + " for user: " + tenantAwareUsername + " in tenant: " + this.getTenantDomain();
            throw new UserProfileException(msg, (Throwable)((Object)e));
        }
    }

    public void associateIDForUser(String username, String idpID, String associatedID) throws UserProfileException {
        User user = this.getUser(username);
        String auditData = this.getAuditData(username, idpID, associatedID);
        try {
            this.getFederatedAssociationManager().createFederatedAssociation(user, idpID, associatedID);
            this.audit(auditActionForCreateAssociation, username, auditData, AUDIT_SUCCESS);
        }
        catch (FederatedAssociationManagerException e) {
            this.audit(auditActionForCreateAssociation, username, auditData, AUDIT_FAIL);
            String msg = "Error while creating association for user: " + username + " with federated IdP: " + idpID + " in tenant: " + this.getTenantDomain();
            throw new UserProfileException(msg, (Throwable)((Object)e));
        }
    }

    public void removeAssociateIDForUser(String username, String idpID, String associatedID) throws UserProfileException {
        block2: {
            String auditData = this.getAuditData(username, idpID, associatedID);
            this.validateFederatedAssociationParameters(username, idpID, associatedID, auditData);
            User user = this.getUser(username);
            try {
                this.getFederatedAssociationManager().deleteFederatedAssociation(user, idpID, associatedID);
                this.audit(auditActionForDeleteAssociation, username, auditData, AUDIT_SUCCESS);
            }
            catch (FederatedAssociationManagerException e) {
                if (this.isFederatedAssociationDoesNotExistsError(e)) break block2;
                this.audit(auditActionForDeleteAssociation, username, auditData, AUDIT_FAIL);
                String msg = "Error while removing association with federated IdP: " + idpID + " for user: " + username + " in tenant: " + this.getTenantDomain();
                throw new UserProfileException(msg, (Throwable)((Object)e));
            }
        }
    }

    public AssociatedAccountDTO[] getAssociatedIDsForUser(String username) throws UserProfileException {
        User user = this.getUser(username);
        try {
            return this.getAssociatedAccounts(user);
        }
        catch (FederatedAssociationManagerException e) {
            String msg = "Error while retrieving federated identifiers associated for user: " + username + " in tenant: " + this.getTenantDomain();
            throw new UserProfileException(msg, (Throwable)((Object)e));
        }
    }

    public String getUserClaim(String claimUri, String profileName) throws UserProfileException {
        if (StringUtils.isBlank((String)claimUri)) {
            throw new UserProfileException("Invalid input parameter. Claim URI cannot be null.");
        }
        if (StringUtils.isBlank((String)profileName)) {
            throw new UserProfileException("Invalid input parameter. Profile name cannot be null.");
        }
        String loggedInUsername = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (StringUtils.isBlank((String)loggedInUsername)) {
            throw new UserProfileException("Could not find a logged in user in the current carbon context.");
        }
        String claimValue = null;
        try {
            Map claimValues;
            UserStoreManager userStoreManager = this.getUserRealm().getUserStoreManager();
            int index = loggedInUsername.indexOf(UserCoreConstants.DOMAIN_SEPARATOR);
            if (index < 0) {
                MessageContext messageContext;
                HttpServletRequest request;
                String domainName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Logged in username : '" + loggedInUsername + "' does not contain domain name."));
                }
                if (StringUtils.isNotBlank((String)(domainName = (String)(request = (HttpServletRequest)(messageContext = MessageContext.getCurrentMessageContext()).getProperty(TRANSPORT_HTTP_SERVLET_REQUEST)).getSession().getAttribute(LOGGED_IN_DOMAIN)))) {
                    loggedInUsername = domainName + UserCoreConstants.DOMAIN_SEPARATOR + loggedInUsername;
                }
            }
            index = loggedInUsername.indexOf(UserCoreConstants.DOMAIN_SEPARATOR);
            UserStoreManager secUserStoreManager = null;
            if (index > 0) {
                String domain = loggedInUsername.substring(0, index);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Domain name found in the logged in username. Domain name: " + domain));
                }
                if (userStoreManager instanceof AbstractUserStoreManager) {
                    secUserStoreManager = ((AbstractUserStoreManager)userStoreManager).getSecondaryUserStoreManager(domain);
                }
            }
            if ((claimValues = secUserStoreManager != null ? secUserStoreManager.getUserClaimValues(loggedInUsername, new String[]{claimUri}, profileName) : userStoreManager.getUserClaimValues(loggedInUsername, new String[]{claimUri}, profileName)) != null) {
                claimValue = (String)claimValues.get(claimUri);
            }
        }
        catch (UserStoreException e) {
            String message = String.format("An error occurred while getting the user claim '%s' in '%s' profile of the user '%s'", claimUri, profileName, loggedInUsername);
            log.error((Object)message, (Throwable)e);
            throw new UserProfileException(message, e);
        }
        return claimValue;
    }

    private AssociatedAccountDTO[] getAssociatedAccounts(User user) throws FederatedAssociationManagerException, UserProfileException {
        FederatedAssociation[] federatedAssociations = this.getFederatedAssociationManager().getFederatedAssociationsOfUser(user);
        ArrayList<AssociatedAccountDTO> associatedAccountDTOS = new ArrayList<AssociatedAccountDTO>();
        for (FederatedAssociation federatedAssociation : federatedAssociations) {
            String identityProviderName = this.getIdentityProviderName(this.getTenantDomain(), federatedAssociation.getIdp().getId());
            associatedAccountDTOS.add(new AssociatedAccountDTO(federatedAssociation.getId(), identityProviderName, federatedAssociation.getFederatedUserId()));
        }
        return associatedAccountDTOS.toArray(new AssociatedAccountDTO[0]);
    }

    private boolean isAdminProfileSpoof(String username) throws UserStoreException {
        if (StringUtils.isEmpty((String)username)) {
            return false;
        }
        RealmConfiguration realmConfiguration = this.getUserRealm().getRealmConfiguration();
        String adminUsername = IdentityUtil.addDomainToName((String)realmConfiguration.getAdminUserName(), (String)IdentityUtil.getPrimaryDomainName());
        String targetUsername = IdentityUtil.addDomainToName((String)username, (String)IdentityUtil.getPrimaryDomainName());
        if (!StringUtils.equalsIgnoreCase((String)targetUsername, (String)adminUsername)) {
            return false;
        }
        String loggedInUsername = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (loggedInUsername != null) {
            loggedInUsername = IdentityUtil.addDomainToName((String)loggedInUsername, (String)IdentityUtil.getPrimaryDomainName());
        }
        return !StringUtils.equalsIgnoreCase((String)loggedInUsername, (String)adminUsername);
    }

    private void audit(String action, String target, String data, String result) {
        audit_log.info((Object)String.format(AUDIT_MESSAGE, this.getUsername() + "@" + this.getTenantDomain(), action, target, data, result));
    }

    private String getAuditData(String username, String idpID, String federatedUserID) {
        return "\"Username\" : \"" + username + "\", \"IdP\" : \"" + idpID + "\", \"FederatedID\" : \"" + federatedUserID + "\"";
    }

    private FederatedAssociationManager getFederatedAssociationManager() throws UserProfileException {
        FederatedAssociationManager federatedAssociationManager = IdentityUserProfileServiceDataHolder.getInstance().getFederatedAssociationManager();
        if (federatedAssociationManager == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"FederatedAssociationManager is not available in the OSGi framework");
            }
            String msg = "Error while working with federated associations";
            throw new UserProfileException(msg);
        }
        return federatedAssociationManager;
    }

    private User getUser(String domainAwareUserName) {
        User user = new User();
        user.setTenantDomain(CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
        user.setUserStoreDomain(UserCoreUtil.extractDomainFromName((String)domainAwareUserName));
        user.setUserName(MultitenantUtils.getTenantAwareUsername((String)UserCoreUtil.removeDomainFromName((String)domainAwareUserName)));
        return user;
    }

    private boolean isFederatedAssociationDoesNotExistsError(FederatedAssociationManagerException e) {
        return e.getErrorCode().contains(String.valueOf(FederatedAssociationConstants.ErrorMessages.INVALID_FEDERATED_ASSOCIATION.getCode()));
    }

    private void validateFederatedAssociationParameters(String username, String idpID, String associatedID, String auditData) throws UserProfileException {
        if (StringUtils.isEmpty((String)idpID) || StringUtils.isEmpty((String)associatedID)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Required parameters, idpId or the associatedId are empty.");
            }
            this.audit(auditActionForDeleteAssociation, username, auditData, AUDIT_FAIL);
            String msg = "Error while removing association with federated IdP: " + idpID + " for user: " + username + " in tenant: " + this.getTenantDomain();
            throw new UserProfileException(msg);
        }
    }

    private String getIdentityProviderName(String tenantDomain, String idpId) throws UserProfileException {
        try {
            IdpManager idpManager = IdentityUserProfileServiceDataHolder.getInstance().getIdpManager();
            if (idpManager != null) {
                IdentityProvider identityProvider = idpManager.getIdPById(idpId, tenantDomain);
                return identityProvider.getIdentityProviderName();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"The IdpManager service is not available in the runtime");
            }
            String msg = "Error while retrieving identity provider for the federated association";
            throw new UserProfileException(msg);
        }
        catch (IdentityProviderManagementException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not resolve the identity provider for the id: " + idpId + ", in the tenant domain: " + tenantDomain));
            }
            String msg = "Error while resolving identity provider";
            throw new UserProfileException(msg);
        }
    }
}

