/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.hubspot.jinjava.interpret.InterpretException;

public final class WhitespaceUtils {
    public static boolean startsWith(String s, String prefix) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.regionMatches(i, prefix, 0, prefix.length());
        }
        return false;
    }

    public static boolean endsWith(String s, String suffix) {
        if (s == null) {
            return false;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.regionMatches(i - suffix.length() + 1, suffix, 0, suffix.length());
        }
        return false;
    }

    public static boolean isWrappedWith(String s, String prefix, String suffix) {
        return WhitespaceUtils.startsWith(s, prefix) && WhitespaceUtils.endsWith(s, suffix);
    }

    public static boolean isQuoted(String s) {
        if (WhitespaceUtils.startsWith(s, "'")) {
            if (!WhitespaceUtils.endsWith(s, "'")) {
                throw new InterpretException("Unbalanced quotes: " + s);
            }
            return true;
        }
        if (WhitespaceUtils.startsWith(s, "\"")) {
            if (!WhitespaceUtils.endsWith(s, "\"")) {
                throw new InterpretException("Unbalanced quotes: " + s);
            }
            return true;
        }
        return false;
    }

    public static String unquote(String s) {
        if (s == null) {
            return "";
        }
        if (WhitespaceUtils.startsWith(s, "'")) {
            return WhitespaceUtils.unwrap(s, "'", "'");
        }
        if (WhitespaceUtils.startsWith(s, "\"")) {
            return WhitespaceUtils.unwrap(s, "\"", "\"");
        }
        return s.trim();
    }

    public static String unwrap(String s, String prefix, String suffix) {
        int start;
        int end = s.length() - 1;
        for (start = 0; start < s.length() && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        while (end >= 0 && Character.isWhitespace(s.charAt(end))) {
            --end;
        }
        return s.substring(start + prefix.length(), end - suffix.length() + 1);
    }

    private WhitespaceUtils() {
    }
}

