/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.fn;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.el.ext.AstDict;
import com.hubspot.jinjava.el.ext.AstList;
import com.hubspot.jinjava.el.ext.AstTuple;
import com.hubspot.jinjava.objects.date.PyishDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

@JinjavaDoc(value="Get a string that describes the type of the object, similar to Python's type()")
public class TypeFunction {
    private static Map<Class<?>, String> CLASS_TYPE_TO_NAME = ImmutableMap.builder().put(AstDict.class, (Object)"dict").put(AstList.class, (Object)"list").put(AstTuple.class, (Object)"tuple").put(Boolean.class, (Object)"bool").put(PyishDate.class, (Object)"datetime").put(ZonedDateTime.class, (Object)"datetime").build();
    private static Map<Class<?>, String> ASSIGNABLE_TYPE_TO_NAME = ImmutableMap.builder().put(Boolean.class, (Object)"bool").put(Double.class, (Object)"float").put(Float.class, (Object)"float").put(Integer.class, (Object)"int").put(List.class, (Object)"list").put(Long.class, (Object)"long").put(Map.class, (Object)"dict").put(String.class, (Object)"str").build();

    public static String type(Object var) {
        if (var == null) {
            return "null";
        }
        for (Map.Entry<Class<?>, String> entry : CLASS_TYPE_TO_NAME.entrySet()) {
            if (var.getClass() != entry.getKey()) continue;
            return entry.getValue();
        }
        for (Map.Entry<Class<?>, String> entry : ASSIGNABLE_TYPE_TO_NAME.entrySet()) {
            if (!entry.getKey().isAssignableFrom(var.getClass())) continue;
            return entry.getValue();
        }
        return "unknown";
    }
}

