/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.verification.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.email.verification.util.ConfirmationBean;
import org.wso2.carbon.email.verification.util.EmailSender;
import org.wso2.carbon.email.verification.util.EmailVerifierConfig;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static RegistryService registryService;
    private static final String EMAIL_VERIFICATION_COLLECTION = "/repository/components/org.wso2.carbon.email-verification/email-verifications-map";
    private static final String VERIFIED_EMAIL_RESOURCE_PATH = "/repository/components/org.wso2.carbon.email-verification/emailIndex";
    private static final String PASSWORD_RESET = "passwordReset";

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static UserRegistry getConfigSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }

    public static EmailVerifierConfig loadeMailVerificationConfig(String configFilename) {
        EmailVerifierConfig config = new EmailVerifierConfig();
        File configfile = new File(configFilename);
        if (!configfile.exists()) {
            log.error((Object)("Email Configuration File is not present at: " + configFilename));
            return null;
        }
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(configfile));
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator it = documentElement.getChildrenWithLocalName("configuration");
            if (!it.hasNext()) {
                config = Util.fillConfig(documentElement.getChildElements());
            } else {
                while (it.hasNext()) {
                    OMElement element = (OMElement)it.next();
                    String configType = element.getAttributeValue(new QName("type"));
                    if (!configType.trim().equalsIgnoreCase(PASSWORD_RESET)) continue;
                    Iterator configValues = element.getChildElements();
                    config = Util.fillConfig(configValues);
                }
            }
            return config;
        }
        catch (Exception e) {
            String msg = "Error in loading configuration for email verification: " + configFilename + ".";
            log.error((Object)msg, (Throwable)e);
            return null;
        }
    }

    private static EmailVerifierConfig fillConfig(Iterator configValues) {
        EmailVerifierConfig config = new EmailVerifierConfig();
        while (configValues.hasNext()) {
            OMElement configValue = (OMElement)configValues.next();
            if ("subject".equals(configValue.getLocalName())) {
                config.setSubject(configValue.getText());
                continue;
            }
            if ("body".equals(configValue.getLocalName())) {
                config.setEmailBody(configValue.getText());
                continue;
            }
            if ("footer".equals(configValue.getLocalName())) {
                config.setEmailFooter(configValue.getText());
                continue;
            }
            if ("targetEpr".equals(configValue.getLocalName())) {
                config.setTargetEpr(configValue.getText());
                continue;
            }
            if (!"redirectPath".equals(configValue.getLocalName())) continue;
            config.setRedirectPath(configValue.getText());
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfirmationBean confirmUser(String secretKey) throws Exception {
        ConfirmationBean confirmationBean = new ConfirmationBean();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement data = fac.createOMElement("configuration", null);
        UserRegistry registry = Util.getConfigSystemRegistry(-1234);
        boolean success = false;
        try {
            String key;
            registry.beginTransaction();
            String secretKeyPath = "/repository/components/org.wso2.carbon.email-verification/email-verifications-map/" + secretKey;
            if (!registry.resourceExists(secretKeyPath)) {
                String msg = "Email verification failed.";
                log.error((Object)msg);
                throw new Exception(msg);
            }
            Resource resource = registry.get(secretKeyPath);
            Properties props = resource.getProperties();
            for (Object o : props.keySet()) {
                key = (String)o;
                OMElement internal = fac.createOMElement(key, null);
                internal.setText(resource.getProperty(key));
                data.addChild((OMNode)internal);
                if (!key.equals("redirectPath")) continue;
                confirmationBean.setRedirectPath(resource.getProperty(key));
            }
            registry.delete(resource.getPath());
            confirmationBean.setData(data.toString());
            success = true;
            if (Boolean.parseBoolean(System.getProperty("onetime.email.verification", Boolean.toString(false))) && registry.resourceExists(VERIFIED_EMAIL_RESOURCE_PATH)) {
                String verifyingEmail = data.getFirstChildWithName(new QName("email")).getText();
                key = UUIDGenerator.generateUUID();
                Resource tempResource = registry.get(VERIFIED_EMAIL_RESOURCE_PATH);
                if (tempResource != null) {
                    tempResource.setProperty(key, verifyingEmail);
                }
                registry.put(VERIFIED_EMAIL_RESOURCE_PATH, tempResource);
            }
        }
        finally {
            if (success) {
                registry.commitTransaction();
            } else {
                registry.rollbackTransaction();
            }
        }
        return confirmationBean;
    }

    public static void requestUserVerification(Map<String, String> data, EmailVerifierConfig serviceConfig) throws Exception {
        String emailAddress = data.get("email");
        emailAddress = emailAddress.trim();
        try {
            String secretKey = UUID.randomUUID().toString();
            UserRegistry registry = Util.getConfigSystemRegistry(-1234);
            Resource resource = registry.newResource();
            resource.setProperty("redirectPath", serviceConfig.getRedirectPath());
            for (String s : data.keySet()) {
                resource.setProperty(s, data.get(s));
            }
            resource.setVersionableChange(false);
            String secretKeyPath = "/repository/components/org.wso2.carbon.email-verification/email-verifications-map/" + secretKey;
            registry.put(secretKeyPath, resource);
            EmailSender sender = new EmailSender(serviceConfig, emailAddress, secretKey, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true), data);
            sender.sendEmail();
        }
        catch (Exception e) {
            String msg = "Error in sending the email to validation.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }
}

