/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.utils.component.xml.config.ManagementPermission;

public class GovernanceArtifactConfiguration {
    private String mediaType;
    private String extension;
    private boolean hasNamespace;
    private int iconSet = 0;
    private String key;
    private String singularLabel;
    private String pluralLabel;
    private String pathExpression;
    private String lifecycle;
    private String taxonomy;
    private Map<String, Map<String, Boolean>> taxonomies;
    private String groupingAttribute;
    private OMElement uiConfigurations;
    private List<Association> relationships = new LinkedList<Association>();
    private OMElement contentDefinition;
    private String contentURL;
    private List<ManagementPermission> uiPermissions = new LinkedList<ManagementPermission>();
    private UIListConfiguration[] listConfigurations;
    private String artifactNameAttribute = "overview_name";
    private String artifactNamespaceAttribute = "overview_namespace";
    private String artifactElementRoot = "metadata";
    private String artifactElementNamespace = "http://www.wso2.org/governance/metadata";
    List<String> uniqueAttributes = new ArrayList<String>();
    private static final String WIDGET_ELEMENT = "table";
    private static final String ARGUMENT_ELMENT = "field";
    private static final String ARGUMENT_NAME = "name";
    private static final String WIDGET_NAME = "name";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MANDETORY_ATTRIBUTE = "required";
    private static final String VALIDATE_ATTRIBUTE = "validate";
    private static final String MAXOCCUR_UNBOUNDED = "unbounded";
    private static final String OPTION_TEXT_FIELD = "option-text";
    private static final String MAXOCCUR_ELEMENT = "maxoccurs";
    public static final String TEXT_FIELD = "text";
    public static final String ENTRY_FIELD = "entry";
    private Map<String, String> contextToLifeCycleMap = new HashMap<String, String>();

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getContentURL() {
        return this.contentURL;
    }

    public void setContentURL(String contentURL) {
        this.contentURL = contentURL;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean hasNamespace() {
        return this.hasNamespace;
    }

    public void setHasNamespace(boolean hasNamespace) {
        this.hasNamespace = hasNamespace;
    }

    public int getIconSet() {
        return this.iconSet;
    }

    public void setIconSet(int iconSet) {
        this.iconSet = iconSet;
    }

    public String getGroupingAttribute() {
        return this.groupingAttribute;
    }

    public void setGroupingAttribute(String groupingAttribute) {
        this.groupingAttribute = groupingAttribute;
    }

    public String getArtifactNameAttribute() {
        return this.artifactNameAttribute;
    }

    public void setArtifactNameAttribute(String artifactNameAttribute) {
        this.artifactNameAttribute = artifactNameAttribute;
    }

    public String getArtifactNamespaceAttribute() {
        return this.artifactNamespaceAttribute;
    }

    public void setArtifactNamespaceAttribute(String artifactNamespaceAttribute) {
        this.artifactNamespaceAttribute = artifactNamespaceAttribute;
    }

    public List<String> getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    public void setUniqueAttributes(List<String> uniqueAttributes) {
        this.uniqueAttributes = uniqueAttributes;
    }

    public String getArtifactElementRoot() {
        return this.artifactElementRoot;
    }

    public void setArtifactElementRoot(String artifactElementRoot) {
        this.artifactElementRoot = artifactElementRoot;
    }

    public String getArtifactElementNamespace() {
        return this.artifactElementNamespace;
    }

    public void setArtifactElementNamespace(String artifactElementNamespace) {
        this.artifactElementNamespace = artifactElementNamespace;
    }

    public Association[] getRelationshipDefinitions() {
        return this.relationships.toArray(new Association[this.relationships.size()]);
    }

    public void setRelationshipDefinitions(Association[] relationships) {
        this.relationships = Arrays.asList(relationships);
    }

    public OMElement getContentDefinition() {
        return this.contentDefinition;
    }

    public void setContentDefinition(OMElement contentDefinition) {
        this.contentDefinition = contentDefinition;
    }

    public OMElement getUIConfigurations() {
        return this.uiConfigurations;
    }

    public void setUIConfigurations(OMElement uiConfigurations) {
        this.uiConfigurations = uiConfigurations;
    }

    public ManagementPermission[] getUIPermissions() {
        return this.uiPermissions.toArray(new ManagementPermission[this.uiPermissions.size()]);
    }

    public void setUIPermissions(ManagementPermission[] uiPermissions) {
        this.uiPermissions = Arrays.asList(uiPermissions);
    }

    public void setUIListConfigurations(OMElement listConfigurations) {
        Iterator iterator = listConfigurations.getChildrenWithName(new QName("column"));
        LinkedList<UIListConfiguration> configurations = new LinkedList<UIListConfiguration>();
        while (iterator.hasNext()) {
            OMElement configurationElement = (OMElement)iterator.next();
            OMElement dataElement = configurationElement.getFirstChildWithName(new QName("data"));
            if (dataElement == null) continue;
            String name = configurationElement.getAttributeValue(new QName("name"));
            String key = dataElement.getAttributeValue(new QName("value"));
            String type = dataElement.getAttributeValue(new QName(TYPE_ATTRIBUTE));
            String expression = dataElement.getAttributeValue(new QName("href"));
            if (key == null || name == null) continue;
            configurations.add(new UIListConfiguration(key, type, name, expression));
        }
        this.listConfigurations = configurations.toArray(new UIListConfiguration[configurations.size()]);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSingularLabel() {
        return this.singularLabel;
    }

    public void setSingularLabel(String singularLabel) {
        this.singularLabel = singularLabel;
    }

    public String getPluralLabel() {
        return this.pluralLabel;
    }

    public void setPluralLabel(String pluralLabel) {
        this.pluralLabel = pluralLabel;
    }

    public String getPathExpression() {
        return this.pathExpression;
    }

    public void setPathExpression(String pathExpression) {
        this.pathExpression = pathExpression;
        this.setUniqueAttributes();
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public Map<String, Map<String, Boolean>> getTaxonomy() {
        return this.taxonomies;
    }

    public String getLifeCycleOfContext(String context) {
        String lc = this.contextToLifeCycleMap.get(context);
        if (lc == null) {
            lc = this.getLifecycle();
        }
        return lc;
    }

    public void addLifeCycleToContext(String context, String lcName) {
        this.contextToLifeCycleMap.put(context, lcName);
    }

    public void setLifecycle(String lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setTaxonomy(String taxonomyName, Boolean disable, Boolean isGlobal) {
        HashMap<String, Boolean> metaData = new HashMap<String, Boolean>();
        metaData.put("isDisable", disable);
        metaData.put("isGlobal", isGlobal);
        if (this.taxonomies == null) {
            this.taxonomies = new HashMap<String, Map<String, Boolean>>();
        }
        this.taxonomies.put(taxonomyName, metaData);
    }

    public String[] getKeysOnListUI() {
        String[] keysOnListUI = new String[this.listConfigurations.length];
        for (int i = 0; i < this.listConfigurations.length; ++i) {
            keysOnListUI[i] = this.listConfigurations[i].getKey();
        }
        return keysOnListUI;
    }

    public String[] getNamesOnListUI() {
        String[] namesOnListUI = new String[this.listConfigurations.length];
        for (int i = 0; i < this.listConfigurations.length; ++i) {
            namesOnListUI[i] = this.listConfigurations[i].getName();
        }
        return namesOnListUI;
    }

    public String[] getTypesOnListUI() {
        String[] typesOnListUI = new String[this.listConfigurations.length];
        for (int i = 0; i < this.listConfigurations.length; ++i) {
            typesOnListUI[i] = this.listConfigurations[i].getType();
        }
        return typesOnListUI;
    }

    public String[] getExpressionsOnListUI() {
        String[] expressionsOnListUI = new String[this.listConfigurations.length];
        for (int i = 0; i < this.listConfigurations.length; ++i) {
            expressionsOnListUI[i] = this.listConfigurations[i].getExpression();
        }
        return expressionsOnListUI;
    }

    private String getDataElementName(String widgetName) {
        if (widgetName == null || widgetName.length() == 0) {
            return null;
        }
        String[] nameParts = widgetName.split("_");
        String convertedName = null;
        for (String namePart : nameParts) {
            char c;
            int i;
            for (i = 0; i < namePart.length() && Character.isLetter(c = namePart.charAt(i)) && !Character.isLowerCase(c); ++i) {
            }
            namePart = namePart.substring(0, i).toLowerCase() + namePart.substring(i);
            convertedName = convertedName == null ? namePart : convertedName + "_" + namePart;
        }
        if (convertedName == null) {
            return null;
        }
        return convertedName.replaceAll(" ", "").replaceAll("-", "");
    }

    public List<Map> getValidationAttributes() {
        ArrayList<Map> res = new ArrayList<Map>();
        ArrayList id = new ArrayList();
        Iterator it = this.contentDefinition.getChildrenWithName(new QName(WIDGET_ELEMENT));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            Iterator arguments = widget.getChildrenWithLocalName(ARGUMENT_ELMENT);
            OMElement arg = null;
            while (arguments.hasNext()) {
                HashMap<String, Object> map;
                arg = (OMElement)arguments.next();
                if (!ARGUMENT_ELMENT.equals(arg.getLocalName())) continue;
                String value = arg.getAttributeValue(new QName(null, VALIDATE_ATTRIBUTE));
                String isMandatory = arg.getAttributeValue(new QName(null, MANDETORY_ATTRIBUTE));
                if ((value == null || "".equals(value)) && (isMandatory == null || !"true".equals(isMandatory))) continue;
                String elementType = arg.getAttributeValue(new QName(null, TYPE_ATTRIBUTE));
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                ArrayList<String> keys = new ArrayList<String>();
                if (OPTION_TEXT_FIELD.equals(elementType)) {
                    if (MAXOCCUR_UNBOUNDED.equals(arg.getAttributeValue(new QName(null, MAXOCCUR_ELEMENT)))) {
                        map = new HashMap();
                        keys.add(this.getDataElementName(widgetName + "_" + ENTRY_FIELD));
                        map.put("keys", keys);
                        map.put("name", name);
                        if (value != null && !"".equals(value)) {
                            map.put("regexp", value);
                        }
                        if (isMandatory != null && "true".equals(isMandatory)) {
                            map.put("isMandatory", true);
                        }
                        map.put("properties", MAXOCCUR_UNBOUNDED);
                        res.add(map);
                        continue;
                    }
                    map = new HashMap();
                    keys.add(this.getDataElementName(widgetName + "_" + name));
                    keys.add(this.getDataElementName(widgetName + "_" + TEXT_FIELD + name));
                    map.put("keys", keys);
                    map.put("name", name);
                    if (value != null && !"".equals(value)) {
                        map.put("regexp", value);
                    }
                    if (isMandatory != null && "true".equals(isMandatory)) {
                        map.put("isMandatory", true);
                    }
                    res.add(map);
                    continue;
                }
                map = new HashMap<String, Object>();
                keys.add(this.getDataElementName(widgetName + "_" + name));
                map.put("keys", keys);
                map.put("name", name);
                if (value != null && !"".equals(value)) {
                    map.put("regexp", value);
                }
                if (isMandatory != null && "true".equals(isMandatory)) {
                    map.put("isMandatory", true);
                }
                res.add(map);
            }
        }
        return res;
    }

    public List<Map> getMandatoryAttributes() {
        ArrayList<Map> res = new ArrayList<Map>();
        Iterator it = this.contentDefinition.getChildrenWithName(new QName(WIDGET_ELEMENT));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            Iterator arguments = widget.getChildrenWithLocalName(ARGUMENT_ELMENT);
            OMElement arg = null;
            while (arguments.hasNext()) {
                HashMap<String, Object> map;
                String value;
                arg = (OMElement)arguments.next();
                if (!ARGUMENT_ELMENT.equals(arg.getLocalName()) || (value = arg.getAttributeValue(new QName(null, MANDETORY_ATTRIBUTE))) == null || !"true".equals(value)) continue;
                String elementType = arg.getAttributeValue(new QName(null, TYPE_ATTRIBUTE));
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                ArrayList<String> keys = new ArrayList<String>();
                if (OPTION_TEXT_FIELD.equals(elementType)) {
                    if (MAXOCCUR_UNBOUNDED.equals(arg.getAttributeValue(new QName(null, MAXOCCUR_ELEMENT)))) {
                        map = new HashMap();
                        keys.add(this.getDataElementName(widgetName + "_" + ENTRY_FIELD));
                        map.put("keys", keys);
                        map.put("name", name);
                        map.put("properties", MAXOCCUR_UNBOUNDED);
                        res.add(map);
                        continue;
                    }
                    map = new HashMap();
                    keys.add(this.getDataElementName(widgetName + "_" + name));
                    keys.add(this.getDataElementName(widgetName + "_" + TEXT_FIELD + name));
                    map.put("keys", keys);
                    map.put("name", name);
                    res.add(map);
                    continue;
                }
                map = new HashMap<String, Object>();
                keys.add(this.getDataElementName(widgetName + "_" + name));
                map.put("keys", keys);
                map.put("name", name);
                res.add(map);
            }
        }
        return res;
    }

    protected void setUniqueAttributes() {
        if (this.pathExpression != null && !this.pathExpression.isEmpty()) {
            String[] pathSegments;
            for (String pathSegment : pathSegments = this.pathExpression.split("/")) {
                if (!pathSegment.startsWith("@")) continue;
                String attribute = pathSegment.substring(1);
                if ((attribute = attribute.replace("{", "").replace("}", "")).indexOf("_") == -1) {
                    attribute = "overview_".concat(attribute);
                }
                this.uniqueAttributes.add(attribute);
            }
        }
    }

    private static class UIListConfiguration {
        private String key;
        private String type;
        private String name;
        private String expression;

        private UIListConfiguration(String key, String type, String name, String expression) {
            this.key = key;
            this.type = type;
            this.name = name;
            this.expression = expression;
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

