/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.policies.dataobjects;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class PolicyImpl
extends GovernanceArtifactImpl
implements Policy {
    private static final Log log = LogFactory.getLog(PolicyImpl.class);
    private String name;
    private String url;
    private String policyContent;

    public PolicyImpl(String id, Registry registry) throws GovernanceException {
        super(id);
        this.associateRegistry(registry);
        this.loadPolicyDetails();
    }

    public PolicyImpl(String id, String url) {
        super(id);
        this.url = url;
    }

    @Override
    public QName getQName() {
        if (this.name == null) {
            return null;
        }
        return new QName(this.name);
    }

    @Override
    public String getPolicyContent() {
        return this.policyContent;
    }

    @Override
    public void setPolicyContent(String policyContent) {
        this.policyContent = policyContent;
    }

    public String getUrl() {
        return this.url;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void loadPolicyDetails() throws GovernanceException {
        Set<Object> keySet;
        Resource resource;
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        String id = this.getId();
        try {
            resource = registry.get(path);
            byte[] content = (byte[])resource.getContent();
            this.policyContent = RegistryUtils.decodeBytes((byte[])content);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the content for the artifact. artifact id: " + id + ", path: " + path + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg, e);
        }
        this.name = RegistryUtils.getResourceName((String)path);
        Properties properties = resource.getProperties();
        if (properties != null && (keySet = properties.keySet()) != null) {
            for (Object keyObj : keySet) {
                String key = (String)keyObj;
                List values = (List)properties.get(key);
                if (values == null) continue;
                for (Object valueObj : values) {
                    String value = (String)valueObj;
                    this.addAttribute(key, value);
                }
            }
        }
    }

    @Override
    public void setQName(QName qName) throws GovernanceException {
        this.name = qName.getLocalPart();
    }
}

