/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.common.dataobjects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.common.util.ApproveItemBean;
import org.wso2.carbon.governance.api.common.util.CheckListItemBean;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.CheckpointTimeUtils;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public abstract class GovernanceArtifactImpl
implements GovernanceArtifact {
    private static final Log log = LogFactory.getLog(GovernanceArtifactImpl.class);
    private String id;
    private String path;
    private Registry registry;
    private String lcName;
    private String lcState;
    private String artifactPath;
    private List<String> uniqueAttributes;
    protected Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    protected Map<String, List<String>> properties = new HashMap<String, List<String>>();

    public List<String> getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    public void setUniqueAttributes(List<String> uniqueAttributes) {
        this.uniqueAttributes = uniqueAttributes;
    }

    public String getLcName() {
        return this.lcName;
    }

    public void setLcName(String lcName) {
        this.lcName = lcName;
    }

    public String getLcState() {
        return this.lcState;
    }

    public void setLcState(String lcState) {
        this.lcState = lcState;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public void setArtifactPath(String artifactPath) {
        this.artifactPath = artifactPath;
    }

    public GovernanceArtifactImpl(String id) {
        this.id = id;
    }

    public GovernanceArtifactImpl() {
    }

    protected GovernanceArtifactImpl(GovernanceArtifactImpl artifact) {
        if (artifact != null) {
            this.attributes = artifact.attributes;
            this.properties = artifact.properties;
            this.lcName = artifact.lcName;
            this.lcState = artifact.lcState;
            this.uniqueAttributes = artifact.uniqueAttributes;
            this.artifactPath = artifact.artifactPath;
            try {
                this.associateRegistry(artifact.getAssociatedRegistry());
            }
            catch (GovernanceException governanceException) {
                // empty catch block
            }
            this.setId(artifact.getId());
        }
    }

    protected GovernanceArtifactImpl(GovernanceArtifactImpl artifact, List<String> uniqueAttributes) {
        this(artifact);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public GovernanceArtifactImpl(String id, OMElement contentElement) throws GovernanceException {
        this(id);
        this.serializeToAttributes(contentElement, null);
    }

    public GovernanceArtifactImpl(String id, OMElement contentElement, List<String> uniqueAttributes) throws GovernanceException {
        this(id, contentElement);
        this.setUniqueAttributes(uniqueAttributes);
    }

    private void serializeToAttributes(OMElement contentElement, String parentAttributeName) throws GovernanceException {
        Iterator childIt = contentElement.getChildren();
        if (childIt.hasNext()) {
            while (childIt.hasNext()) {
                OMText childText;
                Object childObj = childIt.next();
                if (childObj instanceof OMElement) {
                    OMElement childElement = (OMElement)childObj;
                    String elementName = childElement.getLocalName();
                    String attributeName = (parentAttributeName == null ? "" : parentAttributeName + "_") + elementName;
                    this.serializeToAttributes(childElement, attributeName);
                    continue;
                }
                if (!(childObj instanceof OMText) || (childText = (OMText)childObj).getNextOMSibling() != null || childText.getPreviousOMSibling() != null) continue;
                String textValue = childText.getText();
                this.addAttribute(parentAttributeName, textValue);
            }
        } else if (!contentElement.getChildElements().hasNext()) {
            this.addAttribute(parentAttributeName, null);
        }
    }

    public static GovernanceArtifactImpl create(final Registry registry, String artifactId) throws GovernanceException {
        return new GovernanceArtifactImpl(artifactId){
            {
                super(id);
                this.associateRegistry(registry);
            }

            @Override
            public QName getQName() {
                return null;
            }

            @Override
            public void setQName(QName qName) throws GovernanceException {
            }
        };
    }

    public static GovernanceArtifactImpl create(final Registry registry, String artifactId, OMElement content) throws GovernanceException {
        return new GovernanceArtifactImpl(artifactId, content){
            {
                super(id, contentElement);
                this.associateRegistry(registry);
            }

            @Override
            public QName getQName() {
                return null;
            }

            @Override
            public void setQName(QName qName) throws GovernanceException {
            }
        };
    }

    public static GovernanceArtifactImpl create(Registry registry, String artifactId, List<String> uniqueAttributes) throws GovernanceException {
        GovernanceArtifactImpl artifact = GovernanceArtifactImpl.create(registry, artifactId);
        artifact.setUniqueAttributes(uniqueAttributes);
        return artifact;
    }

    public static GovernanceArtifactImpl create(Registry registry, String artifactId, OMElement content, List<String> uniqueAttributes) throws GovernanceException {
        GovernanceArtifactImpl artifact = GovernanceArtifactImpl.create(registry, artifactId, content);
        artifact.setUniqueAttributes(uniqueAttributes);
        return artifact;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getPath() throws GovernanceException {
        if (this.path == null) {
            this.path = GovernanceUtils.getArtifactPath(this.registry, this.id);
        }
        return this.path;
    }

    @Override
    public String getMediaType() {
        if (this.path == null) {
            try {
                this.path = this.getPath();
            }
            catch (GovernanceException ex) {
                log.error((Object)("An error occurred while obtaining the path of artifact " + (Object)((Object)ex)));
                return null;
            }
        }
        if (this.path != null) {
            try {
                if (this.registry.resourceExists(this.path)) {
                    return this.registry.get(this.path).getMediaType();
                }
            }
            catch (RegistryException ex) {
                log.error((Object)("An error occurred obtaining the media type of the artifact " + (Object)((Object)ex)));
            }
        }
        return null;
    }

    @Override
    public String getLifecycleName() throws GovernanceException {
        String path = this.getPath();
        if (path != null) {
            try {
                if (!this.registry.resourceExists(path)) {
                    String msg = "The artifact is not added to the registry. Please add the artifact before reading lifecycle information.";
                    log.error((Object)msg);
                    throw new GovernanceException(msg);
                }
                return this.registry.get(path).getProperty("registry.LC.name");
            }
            catch (RegistryException e) {
                String msg = "Error in obtaining lifecycle name for the artifact. id: " + this.id + ", path: " + path + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        return null;
    }

    @Override
    public String[] getLifecycleNames() throws GovernanceException {
        String path = this.getPath();
        if (path != null) {
            try {
                if (!this.registry.resourceExists(path)) {
                    String msg = "The artifact is not added to the registry. Please add the artifact before reading lifecycle information.";
                    log.error((Object)msg);
                    throw new GovernanceException(msg);
                }
                ArrayList<String> lifeCycleNames = new ArrayList<String>();
                Resource resource = this.registry.get(path);
                for (Object object : resource.getProperties().keySet()) {
                    String property = (String)object;
                    if (!property.startsWith("registry.LC.name.")) continue;
                    lifeCycleNames.add(resource.getProperty(property));
                }
                return lifeCycleNames.toArray(new String[lifeCycleNames.size()]);
            }
            catch (RegistryException e) {
                String msg = "Error in obtaining lifecycle names for the artifact. id: " + this.id + ", path: " + path + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        return null;
    }

    @Override
    public void attachLifecycle(String name) throws GovernanceException {
        try {
            String path = this.getPath();
            if (name != null && path != null) {
                this.registry.associateAspect(path, name);
                Resource resource = this.registry.get(path);
                if (resource.getAspects().size() == 1) {
                    resource.setProperty("registry.LC.name", name);
                    this.registry.put(path, resource);
                }
            }
        }
        catch (RegistryException e) {
            String msg = "Error in associating lifecycle for the artifact. id: " + this.id + ", path: " + this.path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public void detachLifecycle(String lifecycleName) throws GovernanceException {
        try {
            GovernanceUtils.removeAspect(this.path, lifecycleName, this.registry);
        }
        catch (RegistryException e) {
            String msg = "Error in de-associating lifecycle for the artifact. id: " + this.id + ", path: " + this.path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public String getLifecycleState() throws GovernanceException {
        String path = this.getPath();
        if (path != null) {
            try {
                if (!this.registry.resourceExists(path)) {
                    String msg = "The artifact is not added to the registry. Please add the artifact before reading lifecycle information.";
                    log.error((Object)msg);
                    throw new GovernanceException(msg);
                }
                Resource resource = this.registry.get(path);
                for (Object object : resource.getProperties().keySet()) {
                    String property = (String)object;
                    if (!property.startsWith("registry.lifecycle.") || !property.endsWith(".state") || this.getLifecycleName() == null || !property.contains(this.getLifecycleName())) continue;
                    this.lcState = resource.getProperty(property);
                    return this.lcState;
                }
            }
            catch (RegistryException e) {
                String msg = "Error in obtaining lifecycle state for the artifact. id: " + this.id + ", path: " + path + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        return null;
    }

    @Override
    public String getLifecycleState(String lifeCycleName) throws GovernanceException {
        String path = this.getPath();
        if (path != null) {
            try {
                if (!this.registry.resourceExists(path)) {
                    String msg = "The artifact is not added to the registry. Please add the artifact before reading lifecycle information.";
                    log.error((Object)msg);
                    throw new GovernanceException(msg);
                }
                Resource resource = this.registry.get(path);
                for (Object object : resource.getProperties().keySet()) {
                    String property = (String)object;
                    if (!property.startsWith("registry.lifecycle.") || !property.endsWith(".state") || !property.substring(0, property.lastIndexOf(".")).endsWith(lifeCycleName)) continue;
                    return resource.getProperty(property);
                }
            }
            catch (RegistryException e) {
                String msg = "Error in obtaining lifecycle state for the artifact. id: " + this.id + ", path: " + path + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        return null;
    }

    public void updatePath() throws GovernanceException {
        this.path = GovernanceUtils.getArtifactPath(this.registry, this.id);
    }

    public void updatePath(String artifactId) throws GovernanceException {
        this.path = GovernanceUtils.getArtifactPath(this.registry, artifactId);
    }

    public void createVersion() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        try {
            if (!this.registry.resourceExists(this.path)) {
                String msg = "The artifact is not added to the registry. Please add the artifact before creating versions.";
                log.error((Object)msg);
                throw new GovernanceException(msg);
            }
            this.registry.createVersion(this.path);
        }
        catch (RegistryException e) {
            String msg = "Error in creating a version for the artifact. id: " + this.id + ", path: " + this.path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public void associateRegistry(Registry registry) throws GovernanceException {
        this.registry = registry;
    }

    @Override
    public void addAttribute(String key, String value) throws GovernanceException {
        boolean isAttribute = key.contains(".");
        if (!isAttribute) {
            List<String> values = this.attributes.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.attributes.put(key, values);
            }
            values.add(value);
        } else {
            List<String> values = this.properties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.properties.put(key, values);
            }
            values.add(value);
        }
    }

    @Override
    public void setAttributes(String key, String[] newValues) throws GovernanceException {
        boolean isAttribute = key.contains(".");
        if (!isAttribute) {
            ArrayList<String> values = new ArrayList<String>();
            values.addAll(Arrays.asList(newValues));
            this.attributes.put(key, values);
        } else {
            List<String> values = this.properties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.properties.put(key, values);
            }
            values.addAll(Arrays.asList(newValues));
        }
    }

    @Override
    public void setAttribute(String key, String newValue) throws GovernanceException {
        boolean isAttribute = key.contains(".");
        if (!isAttribute) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(newValue);
            this.attributes.put(key, values);
        } else {
            List<String> values = this.properties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.properties.put(key, values);
            }
            values.add(newValue);
        }
    }

    @Override
    public String getAttribute(String key) throws GovernanceException {
        boolean isAttribute = key.contains(".");
        if (!isAttribute) {
            List<String> values = this.attributes.get(key);
            if (values == null || values.size() == 0) {
                return null;
            }
            return values.get(0);
        }
        List<String> values = this.properties.get(key);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public String[] getAttributeKeys() throws GovernanceException {
        Set<String> attributeKeys = this.attributes.keySet();
        return attributeKeys.toArray(new String[attributeKeys.size()]);
    }

    @Override
    public String[] getAttributes(String key) throws GovernanceException {
        boolean isAttribute = key.contains(".");
        if (!isAttribute) {
            List<String> values = this.attributes.get(key);
            if (values == null) {
                return null;
            }
            return values.toArray(new String[values.size()]);
        }
        List<String> values = this.properties.get(key);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public void removeAttribute(String key) throws GovernanceException {
        boolean isAttribute = key.contains(".");
        if (!isAttribute) {
            this.attributes.remove(key);
        } else {
            this.properties.remove(key);
        }
    }

    @Override
    public GovernanceArtifact[] getDependencies() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        ArrayList<GovernanceArtifact> governanceArtifacts = new ArrayList<GovernanceArtifact>();
        try {
            Association[] associations;
            for (Association association : associations = this.registry.getAssociations(path, "depends")) {
                GovernanceArtifact governanceArtifact;
                String destinationPath = association.getDestinationPath();
                if (destinationPath.equals(path) || (governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, destinationPath)) == null) continue;
                governanceArtifacts.add(governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting dependencies from the artifact. id: " + this.id + ", path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return governanceArtifacts.toArray(new GovernanceArtifact[governanceArtifacts.size()]);
    }

    @Override
    public GovernanceArtifact[] getDependents() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        ArrayList<GovernanceArtifact> governanceArtifacts = new ArrayList<GovernanceArtifact>();
        try {
            Association[] associations;
            for (Association association : associations = this.registry.getAssociations(path, "usedBy")) {
                GovernanceArtifact governanceArtifact;
                String destinationPath = association.getDestinationPath();
                if (destinationPath.equals(path) || (governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, destinationPath)) == null) continue;
                governanceArtifacts.add(governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting dependents from the artifact. id: " + this.id + ", path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return governanceArtifacts.toArray(new GovernanceArtifact[governanceArtifacts.size()]);
    }

    @Override
    public String[] getAllLifecycleActions(String lifeCycleName) throws GovernanceException {
        String path = this.getPath();
        try {
            return this.registry.getAspectActions(path, lifeCycleName);
        }
        catch (RegistryException e) {
            String lifecycleState = this.getLifecycleState(lifeCycleName);
            String msg = "Error while retrieving the lifecycle actions for lifecycle: " + lifeCycleName + " in lifecycle state: " + lifecycleState;
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public void invokeAction(String action, String aspectName) throws GovernanceException {
        this.invokeAction(action, new HashMap<String, String>(), aspectName);
    }

    @Override
    public void invokeAction(String action, Map<String, String> parameters, String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        CheckListItemBean[] checkListItemBeans = GovernanceUtils.getAllCheckListItemBeans(artifactResource, this, aspectName);
        try {
            if (checkListItemBeans != null) {
                for (CheckListItemBean checkListItemBean : checkListItemBeans) {
                    parameters.put(checkListItemBean.getOrder() + ".item", checkListItemBean.getValue().toString());
                }
            }
            this.registry.invokeAspect(this.getArtifactPath(), aspectName, action, parameters);
        }
        catch (RegistryException e) {
            String msg = "Invoking lifecycle action \"" + action + "\" failed. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(e.getMessage(), e);
        }
    }

    @Override
    public String[] getAllCheckListItemNames(String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        CheckListItemBean[] checkListItemBeans = GovernanceUtils.getAllCheckListItemBeans(artifactResource, this, aspectName);
        if (checkListItemBeans == null) {
            return null;
        }
        String[] checkListItemNames = new String[checkListItemBeans.length];
        for (CheckListItemBean checkListItemBean : checkListItemBeans) {
            checkListItemNames[checkListItemBean.getOrder()] = checkListItemBean.getName();
        }
        return checkListItemNames;
    }

    @Override
    public void checkLCItem(int order, String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        CheckListItemBean[] checkListItemBeans = GovernanceUtils.getAllCheckListItemBeans(artifactResource, this, aspectName);
        if (checkListItemBeans == null || order < 0 || order >= checkListItemBeans.length) {
            throw new GovernanceException("Invalid check list item.");
        }
        if (checkListItemBeans[order].getValue().booleanValue()) {
            throw new GovernanceException("lifecycle checklist item \"" + checkListItemBeans[order].getName() + "\" already checked");
        }
        try {
            this.setCheckListItemValue(order, true, checkListItemBeans, aspectName);
        }
        catch (RegistryException e) {
            String msg = "Checking LC item failed for check list item " + checkListItemBeans[order].getName();
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public boolean isLCItemChecked(int order, String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        CheckListItemBean[] checkListItemBeans = GovernanceUtils.getAllCheckListItemBeans(artifactResource, this, aspectName);
        if (checkListItemBeans == null || order < 0 || order >= checkListItemBeans.length) {
            throw new GovernanceException("Invalid check list item.");
        }
        return checkListItemBeans[order].getValue();
    }

    @Override
    public void uncheckLCItem(int order, String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        CheckListItemBean[] checkListItemBeans = GovernanceUtils.getAllCheckListItemBeans(artifactResource, this, aspectName);
        if (checkListItemBeans == null || order < 0 || order >= checkListItemBeans.length) {
            throw new GovernanceException("Invalid check list item.");
        }
        if (!checkListItemBeans[order].getValue().booleanValue()) {
            throw new GovernanceException("lifecycle checklist item \"" + checkListItemBeans[order].getName() + "\" not checked");
        }
        try {
            this.setCheckListItemValue(order, false, checkListItemBeans, aspectName);
        }
        catch (RegistryException e) {
            String msg = "Unchecking LC item failed for check list item: " + checkListItemBeans[order].getName();
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    private void setCheckListItemValue(int order, boolean value, CheckListItemBean[] checkListItemBeans, String aspectName) throws RegistryException {
        checkListItemBeans[order].setValue(value);
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (CheckListItemBean checkListItemBean : checkListItemBeans) {
            parameters.put(checkListItemBean.getOrder() + ".item", checkListItemBean.getValue().toString());
        }
        this.registry.invokeAspect(this.getArtifactPath(), aspectName, "itemClick", parameters);
    }

    @Override
    public String[] getAllVotingItems(String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        ApproveItemBean[] approveItemBeans = GovernanceUtils.getAllApproveItemBeans(((UserRegistry)this.registry).getUserName(), artifactResource, this, aspectName);
        if (approveItemBeans == null) {
            throw new GovernanceException("No voting event found for the lifecycle: " + this.getLcName() + " in lifecycle state: " + this.getLcState() + " of the artifact " + this.getQName().getLocalPart());
        }
        String[] votingItems = new String[approveItemBeans.length];
        for (ApproveItemBean approveItemBean : approveItemBeans) {
            votingItems[approveItemBean.getOrder()] = approveItemBean.getName();
        }
        return votingItems;
    }

    @Override
    public String[] getAllVotingItems() throws GovernanceException {
        return this.getAllVotingItems(this.getLifecycleName());
    }

    @Override
    public void vote(int order, String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        ApproveItemBean[] approveItemBeans = GovernanceUtils.getAllApproveItemBeans(((UserRegistry)this.registry).getUserName(), artifactResource, this, aspectName);
        if (approveItemBeans == null || order < 0 || order >= approveItemBeans.length) {
            throw new GovernanceException("Invalid voting action selected");
        }
        if (approveItemBeans[order].getValue().booleanValue()) {
            throw new GovernanceException("Already voted for the action " + approveItemBeans[order].getName());
        }
        try {
            this.setVotingItemValue(order, true, approveItemBeans, aspectName);
        }
        catch (RegistryException e) {
            String msg = "Voting failed for action " + approveItemBeans[order].getName();
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public void vote(int order) throws GovernanceException {
        this.vote(order, this.getLifecycleName());
    }

    @Override
    public boolean isVoted(int order, String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        ApproveItemBean[] approveItemBeans = GovernanceUtils.getAllApproveItemBeans(((UserRegistry)this.registry).getUserName(), artifactResource, this, aspectName);
        if (approveItemBeans == null || order < 0 || order >= approveItemBeans.length) {
            throw new GovernanceException("Invalid voting action selected");
        }
        return approveItemBeans[order].getValue();
    }

    @Override
    public boolean isVoted(int order) throws GovernanceException {
        return this.isVoted(order, this.getLifecycleName());
    }

    @Override
    public void unvote(int order, String aspectName) throws GovernanceException {
        Resource artifactResource = this.getArtifactResource();
        ApproveItemBean[] approveItemBeans = GovernanceUtils.getAllApproveItemBeans(((UserRegistry)this.registry).getUserName(), artifactResource, this, aspectName);
        if (approveItemBeans == null || order < 0 || order >= approveItemBeans.length) {
            throw new GovernanceException("Invalid voting action selected");
        }
        if (!approveItemBeans[order].getValue().booleanValue()) {
            throw new GovernanceException("Not voted for the action \"" + approveItemBeans[order].getName() + "\"");
        }
        try {
            this.setVotingItemValue(order, false, approveItemBeans, aspectName);
        }
        catch (RegistryException e) {
            String msg = "Unvoting failed for action \"" + approveItemBeans[order].getName() + "\"";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public void unvote(int order) throws GovernanceException {
        this.unvote(order, this.getLifecycleName());
    }

    private void setVotingItemValue(int order, boolean value, ApproveItemBean[] approveItemBeans, String aspectName) throws RegistryException {
        approveItemBeans[order].setValue(value);
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (ApproveItemBean approveItemBean : approveItemBeans) {
            parameters.put(approveItemBean.getOrder() + ".vote", approveItemBean.getValue().toString());
        }
        this.registry.invokeAspect(this.getArtifactPath(), aspectName, "voteClick", parameters);
    }

    @Override
    public void attach(GovernanceArtifact attachedToArtifact) throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        String attachedToArtifactPath = attachedToArtifact.getPath();
        if (attachedToArtifactPath == null) {
            String msg = "'Attached to artifact' is not associated with a registry path.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        try {
            this.registry.addAssociation(attachedToArtifactPath, path, "usedBy");
            this.registry.addAssociation(path, attachedToArtifactPath, "depends");
        }
        catch (RegistryException e) {
            String msg = "Error in attaching the artifact. source id: " + this.id + ", path: " + path + ", target id: " + attachedToArtifact.getId() + ", path:" + attachedToArtifactPath + ", attachment type: " + attachedToArtifact.getClass().getName() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    @Override
    public void detach(String artifactId) throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        String artifactPath = GovernanceUtils.getArtifactPath(this.registry, artifactId);
        if (artifactPath == null) {
            String msg = "Attached to artifact is not associated with a registry path.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        try {
            this.registry.removeAssociation(path, artifactPath, "depends");
            this.registry.removeAssociation(artifactPath, path, "usedBy");
        }
        catch (RegistryException e) {
            String msg = "Error in detaching the artifact. source id: " + this.id + ", path: " + path + ", target id: " + artifactId + ", target path:" + artifactPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    protected void checkRegistryResourceAssociation() throws GovernanceException {
        String path = this.getPath();
        if (this.registry == null) {
            String msg = "A registry is not associated with the artifact.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        if (path == null) {
            String msg = "A path is not associated with the artifact.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        if (this.id == null) {
            String msg = "An id is not associated with the artifact.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
    }

    protected Registry getAssociatedRegistry() {
        return this.registry;
    }

    private Resource getArtifactResource() throws GovernanceException {
        try {
            return this.registry.get(this.artifactPath);
        }
        catch (RegistryException e) {
            String msg = "Artifact resource \"" + this.getQName().getLocalPart() + "\" not found in the registry";
            throw new GovernanceException();
        }
    }

    @Override
    public String[] getPropertyKeys() throws GovernanceException {
        Set<String> attributeKeys = this.properties.keySet();
        return attributeKeys.toArray(new String[attributeKeys.size()]);
    }

    public boolean equals(Object artifact) {
        if (!(artifact instanceof GovernanceArtifact)) {
            return false;
        }
        GovernanceArtifact governanceArtifact = (GovernanceArtifact)artifact;
        return governanceArtifact.getId().equals(this.getId());
    }

    @Override
    public void attach(String artifactId) throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public void addAssociation(String associationType, GovernanceArtifact attachedToArtifact) throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        String attachedToArtifactPath = attachedToArtifact.getPath();
        if (attachedToArtifactPath == null) {
            String msg = "'Attached to artifact' is not associated with a registry path.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        try {
            this.registry.addAssociation(path, attachedToArtifactPath, associationType);
        }
        catch (RegistryException e) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error in attaching the artifact. source id: ").append(this.id).append(", path: ").append(path).append(", target id: ").append(attachedToArtifact.getId()).append(", path:").append(attachedToArtifactPath).append(", attachment type: ").append(attachedToArtifact.getClass().getName());
            throw new GovernanceException(stringBuilder.toString(), e);
        }
    }

    @Override
    public void addAssociation(String associationType, String artifactId) throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public void addBidirectionalAssociation(String forwardType, String backwardType, GovernanceArtifact attachedToArtifact) throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        String attachedToArtifactPath = attachedToArtifact.getPath();
        if (attachedToArtifactPath == null) {
            String msg = "'Attached to artifact' is not associated with a registry path.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        try {
            this.registry.addAssociation(path, attachedToArtifactPath, forwardType);
            this.registry.addAssociation(attachedToArtifactPath, path, backwardType);
        }
        catch (RegistryException e) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error in attaching the artifact. source id: ").append(this.id).append(", path: ").append(path).append(", target id: ").append(attachedToArtifact.getId()).append(", path:").append(attachedToArtifactPath).append(", attachment type: ").append(attachedToArtifact.getClass().getName());
            throw new GovernanceException(stringBuilder.toString(), e);
        }
    }

    @Override
    public void removeAssociation(String associationType, String artifactId) throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public void removeAssociation(String artifactId) throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public Map<String, List<GovernanceArtifact>> getAssociations() throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public Map<String, List<String>> getAssociatedArtifactIds() throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public boolean isRegistryAwareArtifact() {
        try {
            this.checkRegistryResourceAssociation();
            return true;
        }
        catch (GovernanceException e) {
            return false;
        }
    }

    @Override
    public void addTag(String tag) throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public void addTags(List<String> tags) throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public List<String> listTags() throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public void removeTag(String tag) throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    @Override
    public void removeTags(List<String> tags) throws GovernanceException {
        throw new UnsupportedOperationException("Not yet Implemented");
    }

    public String toString() {
        return "GovernanceArtifactImpl{attributes=" + this.attributes + ", id='" + this.id + '\'' + '}';
    }

    @Override
    public boolean uniqueTo(GovernanceArtifact artifact) {
        if (artifact != null) {
            List<String> uAttributes = this.getUniqueAttributes(artifact);
            if (this == artifact || this.equals(artifact)) {
                return true;
            }
            if (uAttributes != null && uAttributes.size() > 0) {
                try {
                    for (String attributeName : uAttributes) {
                        if (this.getAttribute(attributeName) == null || artifact.getAttribute(attributeName) == null || this.getAttribute(attributeName).equals(artifact.getAttribute(attributeName))) continue;
                        return false;
                    }
                    return true;
                }
                catch (GovernanceException e) {
                    log.error((Object)e);
                }
            }
        }
        return false;
    }

    private List<String> getUniqueAttributes(GovernanceArtifact artifact) {
        if (this.uniqueAttributes != null) {
            return this.uniqueAttributes;
        }
        if (artifact instanceof GovernanceArtifactImpl) {
            return ((GovernanceArtifactImpl)artifact).getUniqueAttributes();
        }
        return null;
    }

    @Override
    public boolean compareTo(GovernanceArtifact artifact) {
        if (artifact != null) {
            if (this == artifact || this.equals(artifact)) {
                return true;
            }
            try {
                for (String key : this.getAttributeKeys()) {
                    if (this.getAttribute(key).equals(artifact.getAttribute(key))) continue;
                    return false;
                }
                return true;
            }
            catch (GovernanceException e) {
                log.error((Object)e);
            }
        }
        return false;
    }

    @Override
    public Map<String, String> getCurrentStateDuration(String artifactID, String lcName) throws GovernanceException {
        HashMap<String, String> currentLCStateDurationInfo;
        block10: {
            if (this.artifactPath == null || lcName == null) {
                return null;
            }
            Object durationColour = null;
            Object currentStateDuration = null;
            currentLCStateDurationInfo = new HashMap<String, String>();
            if (lcName.isEmpty()) {
                lcName = this.getLifecycleName();
            }
            String artifactPath = GovernanceUtils.getArtifactPath(this.registry, artifactID);
            try {
                String lastUpdateTIme;
                if (!this.registry.resourceExists(artifactPath)) break block10;
                Resource resource = this.registry.get(artifactPath);
                List checkpoints = resource.getPropertyValues("registry.lifecycle." + lcName + ".checkpoint");
                if (checkpoints != null) {
                    for (String checkpoint : checkpoints) {
                        List checkpointValues = resource.getPropertyValues("registry.lifecycle." + lcName + ".checkpoint" + "." + checkpoint);
                        if (checkpointValues == null) continue;
                        String checkpointName = (String)checkpointValues.get(0);
                        String checkpointMin = (String)checkpointValues.get(1);
                        String checkpointMax = (String)checkpointValues.get(2);
                        String checkpointLastUpdatedTime = (String)checkpointValues.get(3);
                        String checkpointColour = (String)checkpointValues.get(4);
                        long duration = CheckpointTimeUtils.calculateTimeDifference(CheckpointTimeUtils.getCurrentTime(), checkpointLastUpdatedTime);
                        if (!CheckpointTimeUtils.isDurationBetweenTimestamps(duration, checkpointMin, checkpointMax)) continue;
                        currentLCStateDurationInfo.put("durationColour", checkpointColour);
                        currentLCStateDurationInfo.put("currentStateDuration", CheckpointTimeUtils.formatTimeDuration(duration));
                        break;
                    }
                } else {
                    lastUpdateTIme = resource.getProperty("registry.lifecycle." + lcName + ".lastStateUpdatedTime");
                    if (lastUpdateTIme != null) {
                        long duration = CheckpointTimeUtils.calculateTimeDifferenceToPresent(lastUpdateTIme);
                        currentLCStateDurationInfo.put("durationColour", null);
                        currentLCStateDurationInfo.put("currentStateDuration", CheckpointTimeUtils.formatTimeDuration(duration));
                    } else {
                        return null;
                    }
                }
                if (!currentLCStateDurationInfo.isEmpty()) break block10;
                lastUpdateTIme = resource.getProperty("registry.lifecycle." + lcName + ".lastStateUpdatedTime");
                if (lastUpdateTIme != null) {
                    long duration = CheckpointTimeUtils.calculateTimeDifferenceToPresent(lastUpdateTIme);
                    currentLCStateDurationInfo.put("durationColour", null);
                    currentLCStateDurationInfo.put("currentStateDuration", CheckpointTimeUtils.formatTimeDuration(duration));
                    break block10;
                }
                return null;
            }
            catch (RegistryException e) {
                throw new GovernanceException("Error occurred while getting current lifecycle state duration info. ", e);
            }
        }
        return currentLCStateDurationInfo;
    }
}

