/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.GovernanceArtifactFilter;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.common.TermData;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.Paginate;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GovernanceArtifactManager {
    private static final Log log = LogFactory.getLog(GovernanceArtifactManager.class);
    private Registry registry;
    private String mediaType;
    private String artifactNameAttribute;
    private String artifactNamespaceAttribute;
    private String artifactElementRoot;
    private String artifactElementNamespace;
    private String pathExpression;
    private String lifecycle;
    private List<Association> relationshipDefinitions;
    private List<Map> validationAttributes;

    public GovernanceArtifactManager(Registry registry, String mediaType, String artifactNameAttribute, String artifactNamespaceAttribute, String artifactElementRoot, String artifactElementNamespace, String pathExpression, Association[] relationshipDefinitions) {
        this.registry = registry;
        this.mediaType = mediaType;
        this.artifactNameAttribute = artifactNameAttribute;
        this.artifactNamespaceAttribute = artifactNamespaceAttribute;
        this.artifactElementRoot = artifactElementRoot;
        this.artifactElementNamespace = artifactElementNamespace;
        this.pathExpression = pathExpression;
        this.relationshipDefinitions = Arrays.asList(relationshipDefinitions);
    }

    public GovernanceArtifactManager(Registry registry, String mediaType, String artifactNameAttribute, String artifactNamespaceAttribute, String artifactElementRoot, String artifactElementNamespace, String pathExpression, String lifecycle, List<Map> validationAttributes, Association[] relationshipDefinitions) {
        this.registry = registry;
        this.mediaType = mediaType;
        this.artifactNameAttribute = artifactNameAttribute;
        this.artifactNamespaceAttribute = artifactNamespaceAttribute;
        this.artifactElementRoot = artifactElementRoot;
        this.artifactElementNamespace = artifactElementNamespace;
        this.pathExpression = pathExpression;
        this.lifecycle = lifecycle;
        this.validationAttributes = validationAttributes;
        this.relationshipDefinitions = Arrays.asList(relationshipDefinitions);
    }

    public GovernanceArtifact newGovernanceArtifact() throws GovernanceException {
        List<String> uniqueAttributes = GovernanceUtils.getUniqueAttributesNames(this.registry, this.mediaType);
        return GovernanceArtifactImpl.create(this.registry, UUID.randomUUID().toString(), uniqueAttributes);
    }

    public GovernanceArtifact newGovernanceArtifact(OMElement content) throws GovernanceException {
        List<String> uniqueAttributes = GovernanceUtils.getUniqueAttributesNames(this.registry, this.mediaType);
        return GovernanceArtifactImpl.create(this.registry, UUID.randomUUID().toString(), content, uniqueAttributes);
    }

    public void addGovernanceArtifact(GovernanceArtifact artifact) throws GovernanceException {
        if (artifact.getQName() == null || artifact.getQName().getLocalPart() == null) {
            String msg = "A valid qualified name was not set for this artifact";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        String artifactName = artifact.getQName().getLocalPart();
        if (this.artifactNameAttribute != null && StringUtils.isNotEmpty((String)artifactName)) {
            artifact.setAttributes(this.artifactNameAttribute, new String[]{artifactName});
        }
        String namespace = artifact.getQName().getNamespaceURI();
        if (this.artifactNamespaceAttribute != null && StringUtils.isNotEmpty((String)namespace)) {
            artifact.setAttributes(this.artifactNamespaceAttribute, new String[]{namespace});
        } else if (this.artifactNamespaceAttribute != null) {
            namespace = artifact.getAttribute(this.artifactNamespaceAttribute);
        }
        this.setQName(artifact, artifactName, namespace);
        this.validateArtifact(artifact);
        ((GovernanceArtifactImpl)artifact).associateRegistry(this.registry);
        boolean succeeded = false;
        Resource resource = null;
        String path = null;
        try {
            this.registry.beginTransaction();
            resource = this.registry.newResource();
            resource.setMediaType(this.mediaType);
            this.setContent(artifact, resource);
            path = GovernanceUtils.getPathFromPathExpression(this.pathExpression, artifact);
            if (this.registry.resourceExists(path)) {
                throw new GovernanceException("Governance artifact " + artifactName + " already exists at " + path);
            }
            String artifactId = artifact.getId();
            resource.setUUID(artifactId);
            this.registry.put(path, resource);
            String updatedPath = GovernanceUtils.getArtifactPath(this.registry, artifactId);
            if (updatedPath != null && !path.equals(updatedPath)) {
                path = updatedPath;
            }
            if (this.lifecycle != null) {
                Object[] lifeCycles = this.lifecycle.split(",");
                ArrayUtils.reverse((Object[])lifeCycles);
                for (Object attachingLifeCycle : lifeCycles) {
                    if (!StringUtils.isNotEmpty((String)attachingLifeCycle)) continue;
                    this.registry.associateAspect(path, (String)attachingLifeCycle);
                }
            }
            ((GovernanceArtifactImpl)artifact).updatePath();
            this.addRelationships(path, artifact);
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = artifact.getPath() != null ? "Failed to add artifact: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + ". " + e.getMessage() : "Failed to add artifact: artifact id: " + artifact.getId() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = artifact.getPath() != null ? "Error in committing transactions. Failed to add artifact: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + "." : "Error in committing transactions. Failed to add artifact: artifact id: " + artifact.getId() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Failed to add artifact: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    private void setQName(GovernanceArtifact artifact, String artifactName, String namespace) throws GovernanceException {
        if (StringUtils.isNotEmpty((String)this.artifactNamespaceAttribute) && StringUtils.isNotEmpty((String)this.artifactNameAttribute)) {
            QName qname = new QName(namespace, artifactName);
            artifact.setQName(qname);
        } else if (StringUtils.isNotEmpty((String)this.artifactNameAttribute)) {
            QName qname = new QName(artifactName);
            artifact.setQName(qname);
        }
    }

    private void addRelationships(String path, GovernanceArtifact artifact) throws RegistryException {
        LinkedHashMap<String, AssociationInteger> typeMap = new LinkedHashMap<String, AssociationInteger>();
        for (Association association : this.relationshipDefinitions) {
            AssociationInteger associationInteger;
            String type = association.getAssociationType();
            String source = association.getSourcePath();
            String target = association.getDestinationPath();
            if (typeMap.containsKey(type)) {
                associationInteger = (AssociationInteger)typeMap.get(type);
                if (source == null) {
                    if (associationInteger.getInteger() < 0) {
                        associationInteger.setInteger(0);
                    }
                    for (String targetPath : GovernanceUtils.getPathsFromPathExpression(target, artifact)) {
                        if (this.registry.resourceExists(targetPath)) {
                            associationInteger.getAssociations().add(new Association(path, targetPath, type));
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Can not add association. Resource does not exist at" + targetPath));
                    }
                    continue;
                }
                if (target != null) continue;
                if (associationInteger.getInteger() > 0) {
                    associationInteger.setInteger(0);
                }
                for (String sourcePath : GovernanceUtils.getPathsFromPathExpression(source, artifact)) {
                    if (this.registry.resourceExists(sourcePath)) {
                        associationInteger.getAssociations().add(new Association(sourcePath, path, type));
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Can not add association. Resource does not exist at" + sourcePath));
                }
                continue;
            }
            associationInteger = new AssociationInteger();
            if (source == null) {
                associationInteger.setInteger(1);
                for (String targetPath : GovernanceUtils.getPathsFromPathExpression(target, artifact)) {
                    if (this.registry.resourceExists(targetPath)) {
                        associationInteger.getAssociations().add(new Association(path, targetPath, type));
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Can not add association. Resource does not exist at" + targetPath));
                }
            } else if (target == null) {
                associationInteger.setInteger(-1);
                for (String sourcePath : GovernanceUtils.getPathsFromPathExpression(source, artifact)) {
                    if (this.registry.resourceExists(sourcePath)) {
                        associationInteger.getAssociations().add(new Association(sourcePath, path, type));
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Can not add association. Resource does not exist at" + sourcePath));
                }
            }
            typeMap.put(type, associationInteger);
        }
        for (Map.Entry entry : typeMap.entrySet()) {
            AssociationInteger value = (AssociationInteger)entry.getValue();
            List<Association> associations = value.getAssociations();
            this.fixAssociations(path, (String)entry.getKey(), value.getInteger() >= 0, value.getInteger() <= 0, associations.toArray(new Association[associations.size()]));
        }
    }

    private void fixAssociations(String path, String type, boolean isSource, boolean isTarget, Association[] toAdd) throws RegistryException {
        String[] params;
        String SEPARATOR = ":";
        HashSet<String> existingSet = new HashSet<String>();
        for (Association association : this.registry.getAllAssociations(path)) {
            if (!type.equals(association.getAssociationType()) || (!isSource || !association.getSourcePath().equals(path)) && (!isTarget || !association.getDestinationPath().equals(path))) continue;
            existingSet.add(association.getSourcePath() + ":" + association.getDestinationPath() + ":" + association.getAssociationType());
        }
        HashSet<String> updatedSet = new HashSet<String>();
        for (Association association : toAdd) {
            updatedSet.add(association.getSourcePath() + ":" + association.getDestinationPath() + ":" + association.getAssociationType());
        }
        HashSet removedAssociations = new HashSet(existingSet);
        removedAssociations.removeAll(updatedSet);
        HashSet newAssociations = new HashSet(updatedSet);
        newAssociations.removeAll(existingSet);
        for (String removedAssociation : removedAssociations) {
            params = removedAssociation.split(":");
            this.registry.removeAssociation(params[0], params[1], params[2]);
        }
        for (String newAssociation : newAssociations) {
            params = newAssociation.split(":");
            this.registry.addAssociation(params[0], params[1], params[2]);
        }
    }

    public void updateGovernanceArtifact(GovernanceArtifact artifact) throws GovernanceException {
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            String artifactName = artifact.getQName().getLocalPart();
            if (this.artifactNameAttribute != null) {
                if (StringUtils.isNotEmpty((String)artifactName)) {
                    artifact.setAttributes(this.artifactNameAttribute, new String[]{artifactName});
                } else {
                    artifactName = artifact.getAttribute(this.artifactNameAttribute);
                }
            }
            String namespace = artifact.getQName().getNamespaceURI();
            if (this.artifactNamespaceAttribute != null && StringUtils.isNotEmpty((String)namespace)) {
                artifact.setAttributes(this.artifactNamespaceAttribute, new String[]{namespace});
            } else if (this.artifactNamespaceAttribute != null) {
                namespace = artifact.getAttribute(this.artifactNamespaceAttribute);
            }
            this.setQName(artifact, artifactName, namespace);
            this.validateArtifact(artifact);
            GovernanceArtifact oldArtifact = this.getGovernanceArtifact(artifact.getId());
            String oldPath = null;
            boolean needsToMove = false;
            if (oldArtifact != null) {
                QName oldName = oldArtifact.getQName();
                if (!oldName.equals(artifact.getQName())) {
                    String temp = oldArtifact.getPath();
                    needsToMove = true;
                } else {
                    oldPath = oldArtifact.getPath();
                }
            } else {
                throw new GovernanceException("No artifact found for the artifact id :" + artifact.getId() + ".");
            }
            String artifactId = artifact.getId();
            Resource resource = this.registry.newResource();
            resource.setMediaType(this.mediaType);
            this.setContent(artifact, resource);
            String path = oldPath != null ? oldPath : GovernanceUtils.getPathFromPathExpression(this.pathExpression, artifact);
            if (needsToMove) {
                if (this.isInbuiltMediatype()) {
                    this.registry.delete(oldArtifact.getPath());
                } else if (!oldArtifact.getPath().equals(path)) {
                    this.registry.move(oldArtifact.getPath(), path);
                }
            }
            if (this.registry.resourceExists(path)) {
                Object content;
                Resource oldResource = this.registry.get(path);
                Properties properties = (Properties)oldResource.getProperties().clone();
                resource.setProperties(properties);
                String description = oldResource.getDescription();
                if (description != null) {
                    resource.setDescription(description);
                }
                String oldContent = (content = oldResource.getContent()) instanceof String ? (String)content : new String((byte[])content);
                content = resource.getContent();
                String newContent = content instanceof String ? (String)content : new String((byte[])content);
                if (newContent.equals(oldContent)) {
                    artifact.setId(oldResource.getUUID());
                    this.addRelationships(path, artifact);
                    succeeded = true;
                    return;
                }
            }
            resource.setUUID(artifactId);
            this.registry.put(path, resource);
            this.addRelationships(path, artifact);
            ((GovernanceArtifactImpl)artifact).updatePath(artifactId);
            succeeded = true;
        }
        catch (RegistryException e) {
            if (e instanceof GovernanceException) {
                throw (GovernanceException)e;
            }
            String msg = artifact.getPath() != null ? "Error in updating the artifact, artifact id: " + artifact.getId() + ", artifact path: " + artifact.getPath() + "." + e.getMessage() + "." : "Error in updating the artifact, artifact id: " + artifact.getId() + "." + e.getMessage() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = artifact.getPath() != null ? "Error in committing transactions. Update artifact failed: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + "." : "Error in committing transactions. Update artifact failed: artifact id: " + artifact.getId() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Update artifact failed: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    private boolean isInbuiltMediatype() {
        return "application/vnd.wso2-restservice+xml".equals(this.mediaType) || "application/vnd.wso2-soap-service+xml".equals(this.mediaType) || "application/vnd.wso2-service+xml".equals(this.mediaType);
    }

    public GovernanceArtifact getGovernanceArtifact(String artifactId) throws GovernanceException {
        return GovernanceUtils.retrieveGovernanceArtifactById(this.registry, artifactId);
    }

    public void removeGovernanceArtifact(String artifactId) throws GovernanceException {
        GovernanceUtils.removeArtifact(this.registry, artifactId);
    }

    public void setContent(Resource resource, GovernanceArtifact artifact) throws GovernanceException {
        this.setContent(artifact, resource);
    }

    protected void setContent(GovernanceArtifact artifact, Resource resource) throws GovernanceException {
        try {
            byte[] content;
            if (artifact instanceof GenericArtifact && (content = ((GenericArtifact)artifact).getContent()) != null) {
                this.setContentAndProperties(artifact, resource, content);
                return;
            }
            OMNamespace namespace = OMAbstractFactory.getOMFactory().createOMNamespace(this.artifactElementNamespace, "");
            HashMap mainElementMap = new HashMap();
            String defaultUUID = UUID.randomUUID().toString();
            String[] attributeKeys = artifact.getAttributeKeys();
            if (attributeKeys != null) {
                for (String aggregatedKey : attributeKeys) {
                    String[] keys = aggregatedKey.split("_");
                    String key = null;
                    for (int i = 0; i < keys.length; ++i) {
                        key = keys[i];
                        if (mainElementMap.get(key) == null) {
                            mainElementMap.put(key, new HashMap());
                        }
                        if (keys.length > 1) break;
                    }
                    String[] attributeValues = artifact.getAttributes(aggregatedKey);
                    String elementName = keys[keys.length - 1];
                    if (keys.length > 1) {
                        ((HashMap)mainElementMap.get(key)).put(elementName, attributeValues);
                        continue;
                    }
                    ((HashMap)mainElementMap.get(key)).put(defaultUUID, attributeValues);
                }
            }
            OMElement contentElement = OMAbstractFactory.getOMFactory().createOMElement(this.artifactElementRoot, namespace);
            for (Map.Entry pairs : mainElementMap.entrySet()) {
                Map subElementMap = (Map)pairs.getValue();
                Iterator subit = subElementMap.entrySet().iterator();
                int size = 0;
                boolean isOptionText = false;
                while (subit.hasNext()) {
                    Map.Entry subpairs = subit.next();
                    if (size < ((String[])subpairs.getValue()).length) {
                        size = ((String[])subpairs.getValue()).length;
                    }
                    if (!((String)subpairs.getKey()).endsWith("entry")) continue;
                    isOptionText = true;
                }
                if (isOptionText) {
                    OMElement keyElement = OMAbstractFactory.getOMFactory().createOMElement((String)pairs.getKey(), namespace);
                    for (int i = 0; i < size; ++i) {
                        keyElement = this.getSubElementContent(subElementMap, namespace, defaultUUID, keyElement, i);
                    }
                    contentElement.addChild((OMNode)keyElement);
                    continue;
                }
                for (int i = 0; i < size; ++i) {
                    OMElement keyElement = OMAbstractFactory.getOMFactory().createOMElement((String)pairs.getKey(), namespace);
                    keyElement = this.getSubElementContent(subElementMap, namespace, defaultUUID, keyElement, i);
                    contentElement.addChild((OMNode)keyElement);
                }
            }
            String updatedContent = GovernanceUtils.serializeOMElement(contentElement);
            this.setContentAndProperties(artifact, resource, updatedContent);
        }
        catch (RegistryException e) {
            String msg = artifact.getPath() != null ? "Error in saving attributes for the artifact. id: " + artifact.getId() + ", path: " + artifact.getPath() + "." : "Error in saving attributes for the artifact. id: " + artifact.getId() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    private void setContentAndProperties(GovernanceArtifact artifact, Resource resource, Object content) throws RegistryException {
        resource.setContent(content);
        String[] propertyKeys = artifact.getPropertyKeys();
        boolean hasSourceProperty = false;
        if (propertyKeys != null) {
            for (String propertyKey : propertyKeys) {
                if ("resource.source".equals(propertyKey)) {
                    hasSourceProperty = true;
                }
                String[] propertyValues = artifact.getAttributes(propertyKey);
                resource.setProperty(propertyKey, Arrays.asList(propertyValues));
            }
        }
        if (!hasSourceProperty) {
            resource.setProperty("resource.source", "remote");
        }
    }

    public GovernanceArtifact[] findGovernanceArtifacts(Map<String, List<String>> criteria) throws GovernanceException {
        List<GovernanceArtifact> artifacts = GovernanceUtils.findGovernanceArtifacts(criteria != null ? criteria : Collections.emptyMap(), this.registry, this.mediaType);
        if (artifacts != null) {
            return artifacts.toArray(new GovernanceArtifact[artifacts.size()]);
        }
        return new GovernanceArtifact[0];
    }

    public TermData[] getTermData(Map<String, List<String>> criteria, String facetField, boolean authRequired) throws GovernanceException {
        List<TermData> termsList = GovernanceUtils.getTermDataList(criteria != null ? criteria : Collections.emptyMap(), facetField, this.mediaType, authRequired);
        if (termsList != null) {
            return termsList.toArray(new TermData[termsList.size()]);
        }
        return new TermData[0];
    }

    public GovernanceArtifact[] findGovernanceArtifacts(String query) throws GovernanceException {
        List<GovernanceArtifact> artifacts = GovernanceUtils.findGovernanceArtifacts(query, this.registry, this.mediaType);
        if (artifacts != null) {
            return artifacts.toArray(new GovernanceArtifact[artifacts.size()]);
        }
        return new GovernanceArtifact[0];
    }

    public GovernanceArtifact[] findGovernanceArtifacts(GovernanceArtifactFilter criteria) throws GovernanceException {
        ArrayList<GovernanceArtifact> artifacts = new ArrayList<GovernanceArtifact>();
        for (GovernanceArtifact artifact : this.getAllGovernanceArtifacts()) {
            if (artifact == null || !criteria.matches(artifact)) continue;
            artifacts.add(artifact);
        }
        return artifacts.toArray(new GovernanceArtifact[artifacts.size()]);
    }

    public GovernanceArtifact[] getAllGovernanceArtifacts() throws GovernanceException {
        List<String> paths = this.getPaginatedGovernanceArtifacts();
        return this.getGovernanceArtifacts(paths.toArray(new String[paths.size()]));
    }

    @Paginate(value="getPaginatedGovernanceArtifacts")
    public List<String> getPaginatedGovernanceArtifacts() throws GovernanceException {
        List<String> paths = Arrays.asList(GovernanceUtils.getResultPaths(this.registry, this.mediaType));
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Long l1 = -1L;
                Long l2 = -1L;
                String temp1 = RegistryUtils.getParentPath((String)o1);
                String temp2 = RegistryUtils.getParentPath((String)o2);
                try {
                    l1 = Long.parseLong(RegistryUtils.getResourceName((String)temp1));
                    l2 = Long.parseLong(RegistryUtils.getResourceName((String)temp2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int result = RegistryUtils.getResourceName((String)temp1).compareToIgnoreCase(RegistryUtils.getResourceName((String)temp2));
                if (result != 0) {
                    return result;
                }
                result = temp1.compareToIgnoreCase(temp2);
                if (result != 0) {
                    return result;
                }
                return l2.compareTo(l1);
            }
        });
        return paths;
    }

    public String[] getAllGovernanceArtifactIds() throws GovernanceException {
        GovernanceArtifact[] artifacts = this.getAllGovernanceArtifacts();
        String[] artifactIds = new String[artifacts.length];
        for (int i = 0; i < artifacts.length; ++i) {
            artifactIds[i] = artifacts[i].getId();
        }
        return artifactIds;
    }

    public GovernanceArtifact[] getAllGovernanceArtifactsByLifecycle(String lcName) throws GovernanceException {
        String[] paths = GovernanceUtils.getAllArtifactPathsByLifecycle(this.registry, lcName, this.mediaType);
        if (paths == null) {
            return new GovernanceArtifact[0];
        }
        return this.getGovernanceArtifacts(paths);
    }

    public GovernanceArtifact[] getAllGovernanceArtifactsByLIfecycleStatus(String lcName, String lcState) throws GovernanceException {
        String[] paths = GovernanceUtils.getAllArtifactPathsByLifecycleState(this.registry, lcName, lcState, this.mediaType);
        if (paths == null) {
            return new GovernanceArtifact[0];
        }
        return this.getGovernanceArtifacts(paths);
    }

    private void validateArtifact(GovernanceArtifact artifact) throws GovernanceException {
        if (this.validationAttributes == null) {
            return;
        }
        for (int i = 0; i < this.validationAttributes.size(); ++i) {
            Map map = this.validationAttributes.get(i);
            String value = "";
            String prop = (String)map.get("properties");
            List keys = (List)map.get("keys");
            if (prop != null && "unbounded".equals(prop)) {
                String[] values = artifact.getAttributes((String)keys.get(0));
                if (values == null) continue;
                for (int j = 0; j < values.length; ++j) {
                    if (map.containsKey("isMandatory") && ((Boolean)map.get("isMandatory")).booleanValue() && (values[j] == null || "".equals(values[j]))) {
                        throw new GovernanceException((String)map.get("name") + " is a required field, Please provide a value for this parameter.");
                    }
                    if (!map.containsKey("regexp") || values[j].matches((String)map.get("regexp"))) continue;
                    throw new GovernanceException((String)map.get("name") + " doesn't match regex: " + (String)map.get("regexp"));
                }
                continue;
            }
            for (int j = 0; j < keys.size(); ++j) {
                String v = artifact.getAttribute((String)keys.get(j));
                if (j != 0) {
                    value = value + ":";
                }
                value = value + (v == null ? "" : v);
            }
            if (map.containsKey("isMandatory") && ((Boolean)map.get("isMandatory")).booleanValue() && (value == null || "".equals(value))) {
                throw new GovernanceException((String)map.get("name") + " is a required field, Please provide a value for this parameter.");
            }
            if (!map.containsKey("regexp") || value == null || value.equals("") || value.matches((String)map.get("regexp"))) continue;
            throw new GovernanceException((String)map.get("name") + " doesn't match regex: " + (String)map.get("regexp"));
        }
    }

    private OMElement getSubElementContent(Map<String, Map> subElementMap, OMNamespace namespace, String defaultUUID, OMElement keyElement, int posotion) {
        for (Map.Entry<String, Map> subpairs : subElementMap.entrySet()) {
            String value;
            try {
                value = ((String[])subpairs.getValue())[posotion];
            }
            catch (Exception ex) {
                value = null;
            }
            if (subpairs.getKey().equals(defaultUUID)) {
                OMText textElement = OMAbstractFactory.getOMFactory().createOMText(value);
                keyElement.addChild((OMNode)textElement);
                continue;
            }
            OMElement subkeyElement = OMAbstractFactory.getOMFactory().createOMElement(subpairs.getKey(), namespace);
            OMText textElement = OMAbstractFactory.getOMFactory().createOMText(value);
            subkeyElement.addChild((OMNode)textElement);
            keyElement.addChild((OMNode)subkeyElement);
        }
        return keyElement;
    }

    private GovernanceArtifact[] getGovernanceArtifacts(String[] paths) throws GovernanceException {
        int errorCount = 0;
        ArrayList<GovernanceArtifact> artifactList = new ArrayList<GovernanceArtifact>();
        for (String path : paths) {
            try {
                artifactList.add(GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, path));
            }
            catch (GovernanceException e) {
                ++errorCount;
                log.error((Object)("Error occurred while retrieving governance artifact by path : " + path), (Throwable)((Object)e));
            }
        }
        if (errorCount != 0 && errorCount == paths.length) {
            throw new GovernanceException("Error occurred while retrieving all the governance artifacts");
        }
        return artifactList.toArray(new GovernanceArtifact[artifactList.size()]);
    }

    private boolean addDefaultAttributeIfNotExists(GovernanceArtifact artifact, Resource resource, String artifactName) throws GovernanceException {
        GovernanceArtifact[] governanceArtifacts = this.searchArtifactsByGroupingAttribute(artifact, this.mediaType, artifactName);
        if (governanceArtifacts != null && governanceArtifacts.length == 0) {
            resource.addProperty("default", "true");
            return true;
        }
        return false;
    }

    private void addDefaultAttributeToAssociations(GovernanceArtifact artifact) throws GovernanceException {
        try {
            if (this.mediaType.equals("application/vnd.wso2-soap-service+xml")) {
                Association[] associations;
                for (Association association : associations = this.registry.getAllAssociations(artifact.getPath())) {
                    String[] subPaths;
                    String artifactName;
                    GovernanceArtifact[] governanceArtifacts;
                    String destinationPath = association.getDestinationPath();
                    if (!destinationPath.contains("wsdl") || (governanceArtifacts = this.searchArtifactsByGroupingAttribute(artifact, "application/wsdl+xml", artifactName = (subPaths = destinationPath.split("/"))[subPaths.length - 1])) == null || governanceArtifacts.length != 0) continue;
                    Resource wsdlResource = this.registry.get(destinationPath);
                    wsdlResource.addProperty("default", "true");
                    this.registry.put(destinationPath, wsdlResource);
                }
            }
        }
        catch (RegistryException ex) {
            log.error((Object)("An error occurred while retrieving association of the resource " + artifact.getPath()), (Throwable)ex);
        }
    }

    private GovernanceArtifact[] searchArtifactsByGroupingAttribute(final GovernanceArtifact artifact, String mediaType, final String artifactName) throws GovernanceException {
        if (GovernanceUtils.getAttributeSearchService() == null) {
            return null;
        }
        HashMap<String, List<String>> listMap = new HashMap<String, List<String>>();
        String groupingAttribute = null;
        try {
            GovernanceArtifactConfiguration artifactConfiguration = GovernanceUtils.getArtifactConfigurationByMediaType(this.registry, mediaType);
            if (artifactConfiguration != null) {
                groupingAttribute = artifactConfiguration.getGroupingAttribute();
            } else {
                log.debug((Object)("Artifact type with media type " + mediaType + " doesn't exist"));
            }
        }
        catch (RegistryException ex) {
            log.error((Object)"An error occurred while retrieving the artifact configuration ", (Throwable)ex);
            return null;
        }
        if (groupingAttribute != null) {
            if (groupingAttribute.equals("overview_name")) {
                listMap.put(groupingAttribute, (List<String>)new ArrayList<String>(){
                    {
                        this.add(artifactName);
                    }
                });
            } else if (groupingAttribute.equals("overview_version")) {
                listMap.put(groupingAttribute, (List<String>)new ArrayList<String>(){
                    {
                        this.add(artifact.getAttribute("overview_version"));
                    }
                });
            }
        } else {
            listMap.put("overview_name", new ArrayList<String>(){
                {
                    this.add(artifactName);
                }
            });
        }
        return this.findGovernanceArtifacts(listMap);
    }

    public boolean isExists(GovernanceArtifact artifact) throws GovernanceException {
        String path = GovernanceUtils.getPathFromPathExpression(this.pathExpression, artifact);
        try {
            return this.registry.resourceExists(path);
        }
        catch (RegistryException e) {
            throw new GovernanceException(e);
        }
    }

    public void removeGenericArtifact(GenericArtifact artifact) throws GovernanceException {
        String path = GovernanceUtils.getPathFromPathExpression(this.pathExpression, artifact);
        if (path != null) {
            try {
                GovernanceUtils.removeArtifactFromPath(this.registry, path);
            }
            catch (RegistryException e) {
                throw new GovernanceException(e);
            }
        }
    }

    private static class AssociationInteger {
        private List<Association> associations = new LinkedList<Association>();
        private Integer integer;

        private AssociationInteger() {
        }

        public List<Association> getAssociations() {
            return this.associations;
        }

        public Integer getInteger() {
            return this.integer;
        }

        public void setInteger(Integer integer) {
            this.integer = integer;
        }
    }
}

