/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.cache;

import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RXTConfigCacheEntryCreatedListener<K, V>
implements CacheEntryCreatedListener<K, V> {
    private static final Log log = LogFactory.getLog(RXTConfigCacheEntryCreatedListener.class);

    public void entryCreated(CacheEntryEvent<? extends K, ? extends V> cacheEntryEvent) throws CacheEntryListenerException {
        try {
            UserRegistry registry = RegistryCoreServiceComponent.getRegistryService().getGovernanceSystemRegistry();
            GovernanceUtils.registerArtifactConfigurationByPath((Registry)registry, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(), cacheEntryEvent.getKey().toString());
        }
        catch (RegistryException e) {
            log.error((Object)"Error while adding artifact configurations", (Throwable)e);
        }
    }
}

