/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.cache;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.governance.api.cache.ArtifactCache;

public class ArtifactCacheManager {
    private static Map<Integer, ArtifactCache> cacheMap;
    private static ArtifactCacheManager thisInstance;
    private static final Object lock;
    private static ArtifactCache clientCache;

    public static void enableClientCache() {
        clientCache = new ArtifactCache();
    }

    public static ArtifactCacheManager getCacheManager() {
        return thisInstance;
    }

    private ArtifactCacheManager() {
        cacheMap = new HashMap<Integer, ArtifactCache>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTenantArtifactCache(ArtifactCache cache, int tenantId) {
        Object object = lock;
        synchronized (object) {
            cacheMap.put(tenantId, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactCache getTenantArtifactCache(int tenantId) {
        if (clientCache != null) {
            return clientCache;
        }
        Object object = lock;
        synchronized (object) {
            return cacheMap.get(tenantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTenantArtifactCache(int tenantId) {
        Object object = lock;
        synchronized (object) {
            cacheMap.get(tenantId).invalidateCache();
            cacheMap.remove(tenantId);
        }
    }

    static {
        thisInstance = new ArtifactCacheManager();
        lock = new Object();
        clientCache = null;
    }
}

