/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.core.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.template.TemplateContext;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.connector.core.pool.Configuration;

public class ConnectorUtils {
    public static Object lookupTemplateParamater(MessageContext ctxt, String paramName) {
        Stack funcStack = (Stack)ctxt.getProperty("_SYNAPSE_FUNCTION_STACK");
        TemplateContext currentFuncHolder = (TemplateContext)funcStack.peek();
        Object paramValue = currentFuncHolder.getParameterValue(paramName);
        return paramValue;
    }

    public static Object lookupTemplateParamater(MessageContext ctxt, int index) {
        Stack funcStack = (Stack)ctxt.getProperty("_SYNAPSE_FUNCTION_STACK");
        TemplateContext currentFuncHolder = (TemplateContext)funcStack.peek();
        Collection paramList = currentFuncHolder.getParameters();
        Iterator it = paramList.iterator();
        int i = 0;
        while (it.hasNext()) {
            String param = (String)it.next();
            if (i == index) {
                return param;
            }
            ++i;
        }
        return null;
    }

    public static Configuration getPoolConfiguration(MessageContext messageContext) {
        Configuration configuration = new Configuration();
        String maxActiveConnections = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "maxActiveConnections");
        String maxIdleConnections = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "maxIdleConnections");
        String maxWaitTime = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "maxWaitTime");
        String minEvictionTime = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "minEvictionTime");
        String evictionCheckInterval = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "evictionCheckInterval");
        String exhaustedAction = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "exhaustedAction");
        if (!StringUtils.isEmpty((String)maxActiveConnections)) {
            configuration.setMaxActiveConnections(Integer.parseInt(maxActiveConnections));
        }
        if (!StringUtils.isEmpty((String)maxWaitTime)) {
            configuration.setMaxWaitTime(Long.parseLong(maxWaitTime));
        }
        if (!StringUtils.isEmpty((String)maxIdleConnections)) {
            configuration.setMaxIdleConnections(Integer.parseInt(maxIdleConnections));
        }
        if (!StringUtils.isEmpty((String)minEvictionTime)) {
            configuration.setMinEvictionTime(Long.parseLong(minEvictionTime));
        }
        if (!StringUtils.isEmpty((String)evictionCheckInterval)) {
            configuration.setEvictionCheckInterval(Long.parseLong(evictionCheckInterval));
        }
        if (!StringUtils.isEmpty((String)exhaustedAction)) {
            configuration.setExhaustedAction(exhaustedAction);
        }
        return configuration;
    }

    /*
     * Loose catch block
     */
    public static String sendPost(String postData, Charset charset, MessageContext messageContext) throws IOException, ConnectException {
        String PROPERTY_PREFIX = "uri.var.";
        byte[] byteData = postData.getBytes(charset);
        String tokenEndpoint = messageContext.getProperty(PROPERTY_PREFIX + "tokenEndpointUrl").toString();
        URL tokenEndpointUrl = new URL(tokenEndpoint);
        HttpURLConnection connection = (HttpURLConnection)tokenEndpointUrl.openConnection();
        try {
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.write(byteData);
            }
            if (Pattern.matches("4[0-9][0-9]", String.valueOf(connection.getResponseCode()))) {
                throw new ConnectException("Access token generation call returned HTTP Status code " + connection.getResponseCode() + ". " + connection.getResponseMessage());
            }
            if (connection.getResponseMessage() == null) {
                throw new ConnectException("Empty response received for access token generation call");
            }
            var9_9 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    content.append(line);
                    content.append(System.lineSeparator());
                }
                String string = content.toString();
                return string;
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }
}

