/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMSourcedElementImpl
extends OMElementImpl
implements OMSourcedElement {
    private OMDataSource dataSource;
    private OMNamespace definedNamespace = null;
    private boolean isExpanded = false;
    private static Log log = LogFactory.getLog(OMSourcedElementImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static Log forceExpandLog = LogFactory.getLog((String)(OMSourcedElementImpl.class.toString() + ".forceExpand"));
    private XMLStreamReader readerFromDS = null;

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMFactory factory, OMDataSource source) {
        super(localName, null, factory);
        this.dataSource = source;
        boolean bl = this.isExpanded = this.dataSource == null;
        this.definedNamespace = !this.isExpanded ? (!this.isLossyPrefix(this.dataSource) ? ns : new DeferredNamespace(ns.getNamespaceURI())) : ns;
    }

    public OMSourcedElementImpl(QName qName, OMFactory factory, OMDataSource source) {
        super(qName.getLocalPart(), null, factory);
        this.dataSource = source;
        boolean bl = this.isExpanded = this.dataSource == null;
        this.definedNamespace = !this.isExpanded ? (!this.isLossyPrefix(this.dataSource) ? new OMNamespaceImpl(qName.getNamespaceURI(), qName.getPrefix()) : new DeferredNamespace(qName.getNamespaceURI())) : new OMNamespaceImpl(qName.getNamespaceURI(), qName.getPrefix());
    }

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMContainer parent, OMFactory factory) {
        super(localName, null, parent, factory);
        this.dataSource = null;
        this.definedNamespace = ns;
        this.isExpanded = true;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super(localName, null, parent, builder, factory);
        this.dataSource = null;
        this.definedNamespace = ns;
        this.isExpanded = true;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMFactory factory) {
        super(localName, null, factory);
        this.dataSource = null;
        this.definedNamespace = ns;
        this.isExpanded = true;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    private boolean isLossyPrefix(OMDataSource source) {
        Object lossyPrefix = null;
        if (source instanceof OMDataSourceExt) {
            lossyPrefix = ((OMDataSourceExt)source).getProperty("lossyPrefix");
        }
        return lossyPrefix == Boolean.TRUE;
    }

    private void setDeferredNamespace(OMDataSource source, String uri, String prefix) {
        Object lossyPrefix = null;
        if (source instanceof OMDataSourceExt) {
            lossyPrefix = ((OMDataSourceExt)source).getProperty("lossyPrefix");
        }
        this.definedNamespace = lossyPrefix != Boolean.TRUE ? new OMNamespaceImpl(uri, prefix) : new DeferredNamespace(uri);
    }

    private String getPrintableName() {
        String uri = null;
        if (this.getNamespace() != null) {
            uri = this.getNamespace().getNamespaceURI();
        }
        if (uri == null || uri.isEmpty()) {
            return this.getLocalName();
        }
        return "{" + uri + '}' + this.getLocalName();
    }

    private XMLStreamReader getDirectReader() {
        try {
            if (this.isExpanded()) {
                return super.getXMLStreamReader();
            }
            return this.dataSource.getReader();
        }
        catch (XMLStreamException e) {
            log.error((Object)("Could not get parser from data source for element " + this.getPrintableName()), (Throwable)e);
            throw new RuntimeException("Error obtaining parser from data source:" + e.getMessage(), e);
        }
    }

    private void forceExpand() {
        if (!this.isExpanded) {
            String uri;
            if (isDebugEnabled) {
                log.debug((Object)("forceExpand: expanding element " + this.getPrintableName()));
                if (forceExpandLog.isDebugEnabled()) {
                    Exception e = new Exception("Debug Stack Trace");
                    forceExpandLog.debug((Object)"forceExpand stack", (Throwable)e);
                }
            }
            this.readerFromDS = this.getDirectReader();
            String characterEncoding = this.readerFromDS.getCharacterEncodingScheme();
            if (characterEncoding != null) {
                characterEncoding = this.readerFromDS.getEncoding();
            }
            try {
                if (this.readerFromDS.getEventType() != 1) {
                    while (this.readerFromDS.next() != 1) {
                    }
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)("forceExpand: error parsing data soruce document for element " + this.getLocalName()), (Throwable)e);
                throw new RuntimeException("Error parsing data source document:" + e.getMessage(), e);
            }
            if (!this.readerFromDS.getLocalName().equals(this.getLocalName())) {
                log.error((Object)("forceExpand: expected element name " + this.getLocalName() + ", found " + this.readerFromDS.getLocalName()));
                throw new RuntimeException("Element name from data source is " + this.readerFromDS.getLocalName() + ", not the expected " + this.getLocalName());
            }
            String readerURI = this.readerFromDS.getNamespaceURI();
            String string = readerURI = readerURI == null ? "" : readerURI;
            String string2 = this.getNamespace() == null ? "" : (uri = this.getNamespace().getNamespaceURI() == null ? "" : this.getNamespace().getNamespaceURI());
            if (!readerURI.equals(uri)) {
                log.error((Object)("forceExpand: expected element namespace " + this.getLocalName() + ", found " + uri));
                throw new RuntimeException("Element namespace from data source is " + readerURI + ", not the expected " + uri);
            }
            String readerPrefix = this.readerFromDS.getPrefix();
            readerPrefix = readerPrefix == null ? "" : readerPrefix;
            String prefix = null;
            OMNamespace ns = this.getNamespace();
            if (ns != null && !(ns instanceof DeferredNamespace)) {
                prefix = ns.getPrefix();
            }
            this.isExpanded = true;
            super.setBuilder(new StAXOMBuilder(this.getOMFactory(), this.readerFromDS, this, characterEncoding));
            this.setComplete(false);
            if (!readerPrefix.equals(prefix) || this.getNamespace() == null || ns instanceof DeferredNamespace) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("forceExpand: changing prefix from " + prefix + " to " + readerPrefix));
                }
                this.setNamespace(new OMNamespaceImpl(readerURI, readerPrefix));
            }
        }
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public Iterator getChildElements() {
        this.forceExpand();
        return super.getChildElements();
    }

    @Override
    public OMNamespace declareNamespace(String uri, String prefix) {
        this.forceExpand();
        return super.declareNamespace(uri, prefix);
    }

    @Override
    public OMNamespace declareDefaultNamespace(String uri) {
        this.forceExpand();
        return super.declareDefaultNamespace(uri);
    }

    @Override
    public OMNamespace getDefaultNamespace() {
        this.forceExpand();
        return super.getDefaultNamespace();
    }

    @Override
    public OMNamespace declareNamespace(OMNamespace namespace) {
        this.forceExpand();
        return super.declareNamespace(namespace);
    }

    @Override
    public OMNamespace findNamespace(String uri, String prefix) {
        this.forceExpand();
        return super.findNamespace(uri, prefix);
    }

    @Override
    public OMNamespace findNamespaceURI(String prefix) {
        this.forceExpand();
        return super.findNamespaceURI(prefix);
    }

    @Override
    public Iterator getAllDeclaredNamespaces() throws OMException {
        this.forceExpand();
        return super.getAllDeclaredNamespaces();
    }

    @Override
    public Iterator getAllAttributes() {
        this.forceExpand();
        return super.getAllAttributes();
    }

    @Override
    public OMAttribute getAttribute(QName qname) {
        this.forceExpand();
        return super.getAttribute(qname);
    }

    @Override
    public String getAttributeValue(QName qname) {
        this.forceExpand();
        return super.getAttributeValue(qname);
    }

    @Override
    public OMAttribute addAttribute(OMAttribute attr) {
        this.forceExpand();
        return super.addAttribute(attr);
    }

    @Override
    public OMAttribute addAttribute(String attributeName, String value, OMNamespace namespace) {
        this.forceExpand();
        return super.addAttribute(attributeName, value, namespace);
    }

    @Override
    public void removeAttribute(OMAttribute attr) {
        this.forceExpand();
        super.removeAttribute(attr);
    }

    @Override
    public void setBuilder(OMXMLParserWrapper wrapper) {
        throw new UnsupportedOperationException("Builder cannot be set for element backed by data source");
    }

    @Override
    public OMXMLParserWrapper getBuilder() {
        this.forceExpand();
        return super.getBuilder();
    }

    @Override
    public void setFirstChild(OMNode node) {
        this.forceExpand();
        super.setFirstChild(node);
    }

    @Override
    public void setLastChild(OMNode omNode) {
        this.forceExpand();
        super.setLastChild(omNode);
    }

    @Override
    public OMElement getFirstElement() {
        this.forceExpand();
        return super.getFirstElement();
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean cache) {
        return this.getXMLStreamReader(cache, false);
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean cache, boolean preserveNamespaceContext) {
        if (isDebugEnabled) {
            log.debug((Object)("getting XMLStreamReader for " + this.getPrintableName() + " with cache=" + cache));
        }
        if (this.isExpanded) {
            return super.getXMLStreamReader(cache, preserveNamespaceContext);
        }
        if (cache && this.isDestructiveRead()) {
            this.forceExpand();
            return super.getXMLStreamReader(true, preserveNamespaceContext);
        }
        return this.getDirectReader();
    }

    @Override
    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    @Override
    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    @Override
    public void setText(String text) {
        this.forceExpand();
        super.setText(text);
    }

    @Override
    public void setText(QName text) {
        this.forceExpand();
        super.setText(text);
    }

    @Override
    public String getText() {
        this.forceExpand();
        return super.getText();
    }

    @Override
    public QName getTextAsQName() {
        this.forceExpand();
        return super.getTextAsQName();
    }

    @Override
    public String getLocalName() {
        return super.getLocalName();
    }

    @Override
    public void setLocalName(String localName) {
        super.setLocalName(localName);
    }

    @Override
    public OMNamespace getNamespace() throws OMException {
        if (this.isExpanded()) {
            return super.getNamespace();
        }
        return this.definedNamespace;
    }

    @Override
    public void setNamespace(OMNamespace namespace) {
        this.forceExpand();
        super.setNamespace(namespace);
    }

    @Override
    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.forceExpand();
        super.setNamespaceWithNoFindInCurrentScope(namespace);
    }

    @Override
    public QName getQName() {
        if (this.isExpanded()) {
            return super.getQName();
        }
        if (this.getNamespace() != null) {
            return new QName(this.getNamespace().getNamespaceURI(), this.getLocalName());
        }
        return new QName(this.getLocalName());
    }

    @Override
    public String toStringWithConsume() throws XMLStreamException {
        if (this.isExpanded()) {
            return super.toStringWithConsume();
        }
        StringWriter writer = new StringWriter();
        XMLStreamWriter writer2 = StAXUtils.createXMLStreamWriter(writer);
        this.dataSource.serialize(writer2);
        writer2.flush();
        return writer.toString();
    }

    private boolean isDestructiveWrite() {
        if (this.dataSource instanceof OMDataSourceExt) {
            return ((OMDataSourceExt)this.dataSource).isDestructiveWrite();
        }
        return true;
    }

    private boolean isDestructiveRead() {
        if (this.dataSource instanceof OMDataSourceExt) {
            return ((OMDataSourceExt)this.dataSource).isDestructiveRead();
        }
        return false;
    }

    @Override
    public QName resolveQName(String qname) {
        this.forceExpand();
        return super.resolveQName(qname);
    }

    @Override
    public OMElement cloneOMElement() {
        this.forceExpand();
        return super.cloneOMElement();
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public void discard() throws OMException {
        this.setComplete(true);
        super.detach();
    }

    @Override
    public int getType() {
        return super.getType();
    }

    @Override
    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (this.isExpanded()) {
            super.internalSerialize(writer, cache);
        } else if (cache) {
            if (this.isDestructiveWrite()) {
                this.forceExpand();
                super.internalSerialize(writer, true);
            } else {
                this.dataSource.serialize(writer);
            }
        } else {
            this.dataSource.serialize(writer);
        }
    }

    @Override
    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.internalSerialize(xmlWriter, true);
    }

    @Override
    public void serialize(OutputStream output) throws XMLStreamException {
        OMOutputFormat format = new OMOutputFormat();
        this.serialize(output, format);
    }

    @Override
    public void serialize(Writer writer) throws XMLStreamException {
        OMOutputFormat format = new OMOutputFormat();
        this.serialize(writer, format);
    }

    @Override
    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        if (this.isExpanded) {
            super.serialize(output, format);
        } else if (this.isDestructiveWrite()) {
            this.forceExpand();
            super.serialize(output, format);
        } else {
            this.dataSource.serialize(output, format);
        }
    }

    @Override
    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        if (this.isExpanded) {
            super.serialize(writer, format);
        } else if (this.isDestructiveWrite()) {
            this.forceExpand();
            super.serialize(writer, format);
        } else {
            this.dataSource.serialize(writer, format);
        }
    }

    @Override
    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.internalSerialize(xmlWriter, false);
    }

    @Override
    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug((Object)("serialize " + this.getPrintableName() + " to output stream"));
        }
        OMOutputFormat format = new OMOutputFormat();
        if (this.isExpanded()) {
            super.serializeAndConsume(output, format);
        } else {
            this.dataSource.serialize(output, format);
        }
    }

    @Override
    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug((Object)("serialize " + this.getPrintableName() + " to writer"));
        }
        if (this.isExpanded()) {
            super.serializeAndConsume(writer);
        } else {
            OMOutputFormat format = new OMOutputFormat();
            this.dataSource.serialize(writer, format);
        }
    }

    @Override
    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug((Object)("serialize formatted " + this.getPrintableName() + " to output stream"));
        }
        if (this.isExpanded()) {
            super.serializeAndConsume(output, format);
        } else {
            this.dataSource.serialize(output, format);
        }
    }

    @Override
    public void serializeAndConsume(Writer writer, OMOutputFormat format) throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug((Object)("serialize formatted " + this.getPrintableName() + " to writer"));
        }
        if (this.isExpanded()) {
            super.serializeAndConsume(writer, format);
        } else {
            this.dataSource.serialize(writer, format);
        }
    }

    @Override
    public void addChild(OMNode omNode) {
        this.forceExpand();
        super.addChild(omNode);
    }

    @Override
    public Iterator getChildrenWithName(QName elementQName) {
        this.forceExpand();
        return super.getChildrenWithName(elementQName);
    }

    @Override
    public Iterator getChildrenWithLocalName(String localName) {
        this.forceExpand();
        return super.getChildrenWithLocalName(localName);
    }

    @Override
    public Iterator getChildrenWithNamespaceURI(String uri) {
        this.forceExpand();
        return super.getChildrenWithNamespaceURI(uri);
    }

    @Override
    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        this.forceExpand();
        return super.getFirstChildWithName(elementQName);
    }

    @Override
    public Iterator getChildren() {
        this.forceExpand();
        return super.getChildren();
    }

    @Override
    public OMNode getFirstOMChild() {
        this.forceExpand();
        return super.getFirstOMChild();
    }

    @Override
    public OMNode getFirstOMChildIfAvailable() {
        return super.getFirstOMChildIfAvailable();
    }

    @Override
    public void buildNext() {
        this.forceExpand();
        super.buildNext();
    }

    @Override
    public OMNode detach() throws OMException {
        boolean complete = this.isComplete();
        this.setComplete(true);
        OMNode result = super.detach();
        this.setComplete(complete);
        return result;
    }

    @Override
    public OMNode getNextOMSibling() throws OMException {
        return super.getNextOMSibling();
    }

    @Override
    public OMNode getNextOMSiblingIfAvailable() {
        return super.getNextOMSiblingIfAvailable();
    }

    @Override
    public String getTrimmedText() {
        this.forceExpand();
        return super.getTrimmedText();
    }

    @Override
    OMNamespace handleNamespace(QName qname) {
        this.forceExpand();
        return super.handleNamespace(qname);
    }

    @Override
    public boolean isComplete() {
        if (this.isExpanded) {
            return super.isComplete();
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.isExpanded) {
            return super.toString();
        }
        if (this.isDestructiveWrite()) {
            this.forceExpand();
            return super.toString();
        }
        try {
            StringWriter writer = new StringWriter();
            OMOutputFormat format = new OMOutputFormat();
            this.dataSource.serialize(writer, format);
            String text = writer.toString();
            writer.close();
            return text;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cannot serialize OM Element " + this.getLocalName(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize OM Element " + this.getLocalName(), e);
        }
    }

    @Override
    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        if (this.isExpanded()) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                node.buildWithAttachments();
            }
        }
    }

    @Override
    public void build() throws OMException {
        super.build();
    }

    @Override
    protected void notifyChildComplete() {
        super.notifyChildComplete();
    }

    @Override
    OMNamespace handleNamespace(String namespaceURI, String prefix) {
        return super.handleNamespace(namespaceURI, prefix);
    }

    @Override
    public OMDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public OMDataSource setDataSource(OMDataSource dataSource) {
        if (!this.isExpanded()) {
            OMDataSource oldDS = this.dataSource;
            this.dataSource = dataSource;
            return oldDS;
        }
        OMDataSource oldDS = this.dataSource;
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            OMNode node = (OMNode)it.next();
            node.detach();
        }
        this.dataSource = dataSource;
        this.setComplete(false);
        this.isExpanded = false;
        super.setBuilder(null);
        if (this.isLossyPrefix(dataSource)) {
            this.definedNamespace = new DeferredNamespace(this.definedNamespace.getNamespaceURI());
        }
        return oldDS;
    }

    @Override
    public void setComplete(boolean value) {
        this.done = value;
        if (this.done) {
            if (this.readerFromDS != null) {
                try {
                    this.readerFromDS.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
                this.readerFromDS = null;
            }
            if (this.dataSource != null) {
                if (this.dataSource instanceof OMDataSourceExt) {
                    ((OMDataSourceExt)this.dataSource).close();
                }
                this.dataSource = null;
            }
        }
        if (this.done && this.readerFromDS != null) {
            try {
                this.readerFromDS.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            this.readerFromDS = null;
        }
    }

    class DeferredNamespace
    implements OMNamespace {
        final String uri;

        DeferredNamespace(String ns) {
            this.uri = ns;
        }

        @Override
        public boolean equals(String uri, String prefix) {
            String thisPrefix = this.getPrefix();
            return this.uri.equals(uri) && (thisPrefix == null ? prefix == null : thisPrefix.equals(prefix));
        }

        @Override
        public String getName() {
            return this.uri;
        }

        @Override
        public String getNamespaceURI() {
            return this.uri;
        }

        @Override
        public String getPrefix() {
            if (!OMSourcedElementImpl.this.isExpanded()) {
                OMSourcedElementImpl.this.forceExpand();
            }
            return OMSourcedElementImpl.this.getNamespace().getPrefix();
        }

        public int hashCode() {
            String thisPrefix = this.getPrefix();
            return this.uri.hashCode() ^ (thisPrefix != null ? thisPrefix.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OMNamespace)) {
                return false;
            }
            OMNamespace other = (OMNamespace)obj;
            String otherPrefix = other.getPrefix();
            String thisPrefix = this.getPrefix();
            return this.uri.equals(other.getNamespaceURI()) && (thisPrefix == null ? otherPrefix == null : thisPrefix.equals(otherPrefix));
        }
    }
}

