/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.publishevent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.publishevent.Property;
import org.wso2.carbon.mediator.publishevent.PublishEventMediator;

public class PublishEventMediatorFactory
extends AbstractMediatorFactory {
    private static final Log log = LogFactory.getLog(PublishEventMediatorFactory.class);
    public static final QName PUBLISH_EVENT_QNAME = new QName("http://ws.apache.org/ns/synapse", PublishEventMediatorFactory.getTagName());
    public static final QName EVENT_SINK_QNAME = new QName("http://ws.apache.org/ns/synapse", "eventSink");
    public static final QName STREAM_NAME_QNAME = new QName("http://ws.apache.org/ns/synapse", "streamName");
    public static final QName STREAM_VERSION_QNAME = new QName("http://ws.apache.org/ns/synapse", "streamVersion");
    public static final QName ATTRIBUTES_QNAME = new QName("http://ws.apache.org/ns/synapse", "attributes");
    public static final QName ATTRIBUTE_QNAME = new QName("http://ws.apache.org/ns/synapse", "attribute");
    public static final QName META_QNAME = new QName("http://ws.apache.org/ns/synapse", "meta");
    public static final QName CORRELATION_QNAME = new QName("http://ws.apache.org/ns/synapse", "correlation");
    public static final QName PAYLOAD_QNAME = new QName("http://ws.apache.org/ns/synapse", "payload");
    public static final QName ARBITRARY_QNAME = new QName("http://ws.apache.org/ns/synapse", "arbitrary");
    public static final QName TYPE_QNAME = new QName("type");
    public static final QName DEFAULT_QNAME = new QName("defaultValue");
    public static final QName ATT_ASYNC = new QName("async");
    public static final QName ATT_ASYNC_TIMEOUT = new QName("timeout");

    public static String getTagName() {
        return "publishEvent";
    }

    public QName getTagQName() {
        return PUBLISH_EVENT_QNAME;
    }

    public Mediator createSpecificMediator(OMElement omElement, Properties properties) {
        PublishEventMediator mediator = new PublishEventMediator();
        OMAttribute isAsync = omElement.getAttribute(ATT_ASYNC);
        if (isAsync != null && !Boolean.parseBoolean(isAsync.getAttributeValue())) {
            mediator.setAsync(false);
        } else {
            OMAttribute asyncTimeout = omElement.getAttribute(ATT_ASYNC_TIMEOUT);
            if (asyncTimeout != null) {
                try {
                    long timeout = Long.parseLong(asyncTimeout.getAttributeValue());
                    if (timeout > 0L) {
                        mediator.setAsyncTimeout(timeout);
                    } else {
                        log.warn((Object)("Provided timeout value - " + asyncTimeout.getAttributeValue() + " is negative. Expecting a positive whole numerical value. Hence ignoring the provided timeout property."));
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Provided timeout value - " + asyncTimeout.getAttributeValue() + " is invalid. Expecting a positive whole numerical value. Hence ignoring the provided timeout property."));
                }
            }
        }
        OMElement streamName = omElement.getFirstChildWithName(STREAM_NAME_QNAME);
        if (streamName == null) {
            throw new SynapseException(STREAM_NAME_QNAME.getLocalPart() + " element missing");
        }
        mediator.setStreamName(streamName.getText());
        OMElement streamVersion = omElement.getFirstChildWithName(STREAM_VERSION_QNAME);
        if (streamVersion == null) {
            throw new SynapseException(STREAM_VERSION_QNAME.getLocalPart() + " element missing");
        }
        mediator.setStreamVersion(streamVersion.getText());
        OMElement attributes = omElement.getFirstChildWithName(ATTRIBUTES_QNAME);
        if (attributes != null) {
            OMElement arbitrary;
            OMElement payload;
            OMElement correlation;
            OMElement meta = attributes.getFirstChildWithName(META_QNAME);
            if (meta != null) {
                Iterator iterator = meta.getChildrenWithName(ATTRIBUTE_QNAME);
                List<Property> propertyList = this.generatePropertyList(iterator);
                mediator.setMetaProperties(propertyList);
            }
            if ((correlation = attributes.getFirstChildWithName(CORRELATION_QNAME)) != null) {
                Iterator iterator = correlation.getChildrenWithName(ATTRIBUTE_QNAME);
                List<Property> propertyList = this.generatePropertyList(iterator);
                mediator.setCorrelationProperties(propertyList);
            }
            if ((payload = attributes.getFirstChildWithName(PAYLOAD_QNAME)) != null) {
                Iterator iterator = payload.getChildrenWithName(ATTRIBUTE_QNAME);
                List<Property> propertyList = this.generatePropertyList(iterator);
                mediator.setPayloadProperties(propertyList);
            }
            if ((arbitrary = attributes.getFirstChildWithName(ARBITRARY_QNAME)) != null) {
                Iterator iterator = arbitrary.getChildrenWithName(ATTRIBUTE_QNAME);
                List<Property> propertyList = this.generatePropertyList(iterator);
                for (Property property : propertyList) {
                    if (property.getType().equals("STRING")) continue;
                    throw new SynapseException("Invalid type " + property.getType() + " for arbitrary property " + property.getKey() + ". Type of arbitrary attributes must be " + "STRING");
                }
                mediator.setArbitraryProperties(propertyList);
            }
        } else {
            throw new SynapseException(ATTRIBUTES_QNAME.getLocalPart() + " attribute missing");
        }
        OMElement eventSinkElement = omElement.getFirstChildWithName(EVENT_SINK_QNAME);
        if (eventSinkElement == null) {
            throw new SynapseException(EVENT_SINK_QNAME.getLocalPart() + " element missing");
        }
        mediator.setEventSinkName(eventSinkElement.getText());
        PublishEventMediatorFactory.addAllCommentChildrenToList((OMElement)omElement, (List)mediator.getCommentsList());
        return mediator;
    }

    private List<Property> generatePropertyList(Iterator<OMElement> iterator) {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        while (iterator.hasNext()) {
            OMElement element = iterator.next();
            OMAttribute nameAttr = element.getAttribute(ATT_NAME);
            if (nameAttr == null) {
                throw new SynapseException(ATT_NAME.getLocalPart() + " attribute missing in " + element.getLocalName());
            }
            OMAttribute typeAttr = element.getAttribute(TYPE_QNAME);
            if (typeAttr == null) {
                throw new SynapseException(TYPE_QNAME.getLocalPart() + " attribute missing in " + element.getLocalName());
            }
            OMAttribute valueAttr = element.getAttribute(ATT_VALUE);
            OMAttribute expressionAttr = element.getAttribute(ATT_EXPRN);
            if (valueAttr != null && expressionAttr != null) {
                throw new SynapseException(element.getLocalName() + " element can either have \"" + ATT_VALUE.getLocalPart() + "\" or \"" + ATT_EXPRN.getLocalPart() + "\" attribute but not both");
            }
            if (valueAttr == null && expressionAttr == null) {
                throw new SynapseException(element.getLocalName() + " element must have either \"" + ATT_VALUE.getLocalPart() + "\" or \"" + ATT_EXPRN.getLocalPart() + "\" attribute");
            }
            Property property = new Property();
            property.setKey(nameAttr.getAttributeValue());
            property.setType(typeAttr.getAttributeValue());
            if (valueAttr != null) {
                property.setValue(valueAttr.getAttributeValue());
            } else {
                try {
                    property.setExpression(SynapseXPathFactory.getSynapseXPath((OMElement)element, (QName)ATT_EXPRN));
                }
                catch (JaxenException e) {
                    throw new SynapseException("Invalid expression attribute in " + element.getLocalName(), (Throwable)e);
                }
            }
            OMAttribute defaultAtr = element.getAttribute(DEFAULT_QNAME);
            if (defaultAtr != null) {
                property.setDefaultValue(defaultAtr.getAttributeValue());
            }
            propertyList.add(property);
        }
        return propertyList;
    }

    public static QName getNameAttributeQ() {
        return ATT_NAME;
    }

    public static QName getValueAttributeQ() {
        return ATT_VALUE;
    }

    public static QName getExpressionAttributeQ() {
        return ATT_EXPRN;
    }
}

